/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.swingclient.worklist;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.enhydra.shark.api.client.timebase.UtcT;
import org.enhydra.shark.api.client.wfmodel.CannotAcceptSuspended;
import org.enhydra.shark.api.client.wfmodel.WfActivity;
import org.enhydra.shark.api.client.wfmodel.WfAssignment;
import org.enhydra.shark.api.client.wfmodel.WfProcess;
import org.enhydra.shark.api.client.wfmodel.WfResource;
import org.enhydra.shark.swingclient.ActionPanel;
import org.enhydra.shark.swingclient.ResourceManager;
import org.enhydra.shark.swingclient.SharkClient;
import org.enhydra.shark.swingclient.Utils;
import org.enhydra.shark.swingclient.WorkflowUtilities;
import org.enhydra.shark.swingclient.worklist.actions.CompleteWorkitem;
import org.enhydra.shark.swingclient.worklist.actions.UpdateActivityVariables;
import org.enhydra.shark.swingclient.worklist.actions.WorkitemDescription;

public class Worklist
extends ActionPanel {
    private Map workitems = new HashMap();
    private Map procVariables = new HashMap();
    private JTable worklistTable;
    private WorklistTableModel worklistTableModel;
    SharkClient workflowClient;
    WfResource myResource;
    static /* synthetic */ Class class$org$enhydra$shark$swingclient$worklist$actions$CompleteWorkitem;

    public Worklist(SharkClient wc, boolean disableButtons) {
        this.workflowClient = wc;
        this.setButtonPanelEnabled(!disableButtons);
    }

    protected void createActions() {
        this.defaultActions = new Action[]{new CompleteWorkitem(this), new UpdateActivityVariables(this), new WorkitemDescription(this)};
    }

    protected Component createCenterComponent() {
        JScrollPane tablePane = new JScrollPane();
        this.worklistTableModel = new WorklistTableModel();
        this.worklistTable = new JTable(this.worklistTableModel);
        this.worklistTable.setColumnSelectionAllowed(false);
        this.worklistTable.setRowSelectionAllowed(true);
        this.worklistTable.setSelectionMode(0);
        this.worklistTable.getTableHeader().setReorderingAllowed(false);
        this.worklistTable.setPreferredScrollableViewportSize(new Dimension(500, 300));
        TableColumn column = this.worklistTable.getColumnModel().getColumn(0);
        column.setMinWidth(0);
        column.setMaxWidth(0);
        column.setPreferredWidth(0);
        column.setResizable(false);
        this.worklistTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() > 1) {
                    Worklist.this.getAction(Utils.getUnqualifiedClassName(class$org$enhydra$shark$swingclient$worklist$actions$CompleteWorkitem == null ? (class$org$enhydra$shark$swingclient$worklist$actions$CompleteWorkitem = Worklist.class$("org.enhydra.shark.swingclient.worklist.actions.CompleteWorkitem")) : class$org$enhydra$shark$swingclient$worklist$actions$CompleteWorkitem)).actionPerformed(null);
                }
            }
        });
        this.worklistTable.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0, false), "edit");
        this.worklistTable.getActionMap().put("edit", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Worklist.this.getAction(Utils.getUnqualifiedClassName(class$org$enhydra$shark$swingclient$worklist$actions$CompleteWorkitem == null ? (class$org$enhydra$shark$swingclient$worklist$actions$CompleteWorkitem = Worklist.class$("org.enhydra.shark.swingclient.worklist.actions.CompleteWorkitem")) : class$org$enhydra$shark$swingclient$worklist$actions$CompleteWorkitem)).actionPerformed(null);
            }
        });
        tablePane.setViewportView(this.worklistTable);
        return tablePane;
    }

    public void setResource(WfResource newResource) {
        try {
            if (!newResource.resource_key().equals(this.myResource.resource_key())) {
                this.clear();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.myResource = newResource;
        this.refresh();
    }

    public void setButtonPanelEnabled(boolean enabled) {
        for (int i = 0; i < this.buttonPanel.getComponentCount() - 1; ++i) {
            this.buttonPanel.getComponent(i).setEnabled(enabled);
        }
    }

    public WfResource getResource() {
        return this.myResource;
    }

    public WfAssignment getSelectedAssignment() {
        int selRow = this.worklistTable.getSelectedRow();
        if (selRow >= 0) {
            String id = (String)this.worklistTableModel.getValueAt(selRow, 0);
            return (WfAssignment)this.workitems.get(id);
        }
        return null;
    }

    public boolean isWorkitemContextUpdated(String workitemKey) {
        return this.procVariables.containsKey(workitemKey);
    }

    public Map getWorkitemContext(String workitemKey) {
        return (Map)this.procVariables.get(workitemKey);
    }

    public void putWorkitemContext(String workitemKey, Map context) {
        this.procVariables.put(workitemKey, context);
    }

    public void clear() {
        this.myResource = null;
        this.workitems.clear();
        this.procVariables.clear();
        this.worklistTableModel.clearTable();
    }

    public void releaseAllAssignments() {
        Iterator it = this.workitems.values().iterator();
        while (it.hasNext()) {
            WfAssignment ass = (WfAssignment)it.next();
            try {
                ass.set_accepted_status(false);
            }
            catch (Exception exception) {}
        }
        this.workitems.clear();
    }

    public synchronized void refresh() {
        WfActivity wa;
        long t1 = System.currentTimeMillis();
        WfAssignment[] ass = null;
        try {
            ass = this.myResource.get_sequence_work_item(0);
        }
        catch (Exception ex) {
            return;
        }
        long t2 = System.currentTimeMillis();
        ArrayList toAdd = new ArrayList();
        ArrayList toRemove = new ArrayList();
        ArrayList toRetain = new ArrayList();
        this.createWorkitemLists(ass, toAdd, toRemove, toRetain);
        long t3 = System.currentTimeMillis();
        Iterator it = toRemove.iterator();
        while (it.hasNext()) {
            try {
                this.worklistTableModel.removeRow(it.next());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        long t4 = System.currentTimeMillis();
        it = toAdd.iterator();
        while (it.hasNext()) {
            wa = (WfActivity)it.next();
            try {
                String procId;
                int ind_;
                if (!wa.state().startsWith("open")) continue;
                Vector<Object> vRow = new Vector<Object>();
                vRow.add(wa.key());
                if (wa.state().equals("open.running")) {
                    vRow.add(new Boolean(true));
                } else {
                    vRow.add(new Boolean(false));
                }
                WfProcess proc = wa.container();
                String name = proc.name();
                String pDefName = SharkClient.getAdminMiscUtilities().getProcessMgrProcDefName(proc.manager().name());
                if ((pDefName.equals("") || pDefName.equals(name)) && (ind_ = (procId = proc.key()).indexOf("_")) > 0) {
                    name = name + "-" + procId.substring(0, ind_);
                }
                vRow.add(name);
                vRow.add(wa.name());
                vRow.add(new Integer(wa.priority()));
                String date = "";
                String duration = "";
                if (wa.state().startsWith("open.running")) {
                    try {
                        UtcT lastStateT = wa.last_state_time();
                        date = WorkflowUtilities.getDateFromUTC(lastStateT);
                        duration = WorkflowUtilities.getDuration(lastStateT);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                vRow.add(date);
                vRow.add(duration);
                this.worklistTableModel.addRow(vRow);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        long t5 = System.currentTimeMillis();
        it = toRetain.iterator();
        while (it.hasNext()) {
            wa = (WfActivity)it.next();
            try {
                String id = wa.key();
                boolean accepted = ((WfAssignment)this.workitems.get(id)).get_accepted_status();
                String date = "";
                String duration = "";
                if (accepted) {
                    try {
                        UtcT lastStateT = wa.last_state_time();
                        date = WorkflowUtilities.getDateFromUTC(lastStateT);
                        duration = WorkflowUtilities.getDuration(lastStateT);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                this.worklistTableModel.updateWorkitemProperties(wa.key(), accepted, date, duration);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        long t6 = System.currentTimeMillis();
    }

    private void createWorkitemLists(WfAssignment[] ass, ArrayList toAdd, ArrayList toRemove, ArrayList toRetain) {
        HashMap<String, WfAssignment> newWorkitems = new HashMap<String, WfAssignment>();
        if (ass != null) {
            for (int i = 0; i < ass.length; ++i) {
                try {
                    WfActivity wa = ass[i].activity();
                    newWorkitems.put(wa.key(), ass[i]);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        ArrayList toAddIds = new ArrayList(newWorkitems.keySet());
        toAddIds.removeAll(this.workitems.keySet());
        ArrayList toRemoveIds = new ArrayList(this.workitems.keySet());
        toRemoveIds.removeAll(newWorkitems.keySet());
        ArrayList toRetainIds = new ArrayList(this.workitems.keySet());
        toRetainIds.retainAll(newWorkitems.keySet());
        Iterator addIt = toAddIds.iterator();
        while (addIt.hasNext()) {
            try {
                toAdd.add(((WfAssignment)newWorkitems.get(addIt.next())).activity());
            }
            catch (Exception ex) {}
        }
        Iterator removeIt = toRemoveIds.iterator();
        while (removeIt.hasNext()) {
            try {
                Object nextId = removeIt.next();
                toRemove.add(nextId);
                this.procVariables.remove(nextId);
            }
            catch (Exception ex) {}
        }
        Iterator retIt = toRetainIds.iterator();
        while (retIt.hasNext()) {
            try {
                toRetain.add(((WfAssignment)newWorkitems.get(retIt.next())).activity());
            }
            catch (Exception ex) {}
        }
        this.workitems.clear();
        this.workitems = newWorkitems;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class WorklistTableModel
    extends DefaultTableModel {
        WorklistTableModel() {
            super(new String[]{ResourceManager.getLanguageDependentString("IdKey"), ResourceManager.getLanguageDependentString("AcceptedKey"), ResourceManager.getLanguageDependentString("ProcessNameKey"), ResourceManager.getLanguageDependentString("WorkitemKey"), ResourceManager.getLanguageDependentString("PriorityKey"), ResourceManager.getLanguageDependentString("StartedKey"), ResourceManager.getLanguageDependentString("DurationKey")}, 0);
        }

        public void removeRow(Object workitemKey) {
            int rowCnt = this.getRowCount();
            for (int row = 0; row < rowCnt; ++row) {
                if (!this.getValueAt(row, 0).equals(workitemKey)) continue;
                this.removeRow(row);
                break;
            }
        }

        public void clearTable() {
            int rowCnt = this.getRowCount();
            for (int row = rowCnt - 1; row >= 0; --row) {
                this.removeRow(row);
            }
        }

        public void updateWorkitemProperties(String workitemKey, boolean accept, String newDate, String newDuration) {
            int rowCnt = this.getRowCount();
            for (int row = 0; row < rowCnt; ++row) {
                if (!this.getValueAt(row, 0).equals(workitemKey)) continue;
                super.setValueAt(new Boolean(accept), row, 1);
                super.setValueAt(newDate, row, 5);
                super.setValueAt(newDuration, row, 6);
                break;
            }
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }

        public void setValueAt(Object value, int row, int col) {
            super.setValueAt(value, row, col);
            if (col == 1) {
                boolean accepted = (Boolean)value;
                try {
                    WfAssignment ass = (WfAssignment)Worklist.this.workitems.get(this.getValueAt(row, 0));
                    ass.set_accepted_status(accepted);
                    if (accepted) {
                        UtcT lastStateT = ass.activity().last_state_time();
                        String newDate = WorkflowUtilities.getDateFromUTC(lastStateT);
                        String newDuration = WorkflowUtilities.getDuration(lastStateT);
                        super.setValueAt(newDate, row, 5);
                        super.setValueAt(newDuration, row, 6);
                    } else {
                        super.setValueAt("", row, 5);
                        super.setValueAt("", row, 6);
                    }
                }
                catch (CannotAcceptSuspended cas) {
                    Worklist worklist = Worklist.this;
                    JOptionPane.showMessageDialog(Worklist.this.workflowClient.getFrame(), ResourceManager.getLanguageDependentString("WarningCannotAcceptSuspendedWorkitem"), worklist.workflowClient.getAppTitle(), 2);
                    Worklist.this.refresh();
                }
                catch (Exception ex) {
                    Worklist worklist = Worklist.this;
                    JOptionPane.showMessageDialog(Worklist.this.workflowClient.getFrame(), ResourceManager.getLanguageDependentString("WarningTheWorkitemIsPerformedByAnotherUser"), worklist.workflowClient.getAppTitle(), 2);
                    Worklist.this.refresh();
                }
            }
        }
    }
}

