/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.swingclient;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.enhydra.shark.swingclient.ActionPanel;
import org.enhydra.shark.swingclient.BarFactory;
import org.enhydra.shark.swingclient.ItemView;
import org.enhydra.shark.swingclient.NTVDPanel;
import org.enhydra.shark.swingclient.ResourceManager;
import org.enhydra.shark.swingclient.WorkflowUtilities;

public class MapPanel
extends ActionPanel {
    private static Dimension labelFieldDimension = new Dimension(250, 20);
    private static Dimension textFieldDimension = new Dimension(250, 20);
    private static Dimension buttonFieldDimension = new Dimension(50, 25);
    private String varId;
    private String varName;
    private HashMap val;
    private JLabel name = new JLabel();
    private JLabel type = new JLabel();
    private JTextField value;
    private JComboBox choices;
    private JTextField vDay;
    private JTextField vMonth;
    private JTextField vYear;
    private JButton description;
    private String typeKey;
    private String desc;
    private boolean isReadOnly;
    private JPanel mainPanel;
    private Set ntvdpanels = new HashSet();

    public MapPanel(String varId, HashMap val, String nm, String d, String typeKey, boolean isReadOnly) {
        this.varId = varId;
        this.val = val;
        this.varName = nm;
        this.desc = d;
        this.typeKey = typeKey;
        this.isReadOnly = isReadOnly;
    }

    protected void createActions() {
    }

    protected Component createCenterComponent() {
        JScrollPane jsp = new JScrollPane();
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(Box.createHorizontalStrut(5));
        if (this.varName != null && this.varName.trim().length() > 0) {
            this.name.setText(this.varName);
        } else {
            this.name.setText(this.varId);
        }
        this.name.setMinimumSize(new Dimension(labelFieldDimension));
        this.name.setPreferredSize(new Dimension(labelFieldDimension));
        this.name.setMaximumSize(new Dimension(labelFieldDimension));
        p.add(this.name);
        p.add(Box.createHorizontalStrut(5));
        this.type.setText(ResourceManager.getLanguageDependentString(this.typeKey));
        this.type.setMinimumSize(new Dimension(labelFieldDimension));
        this.type.setPreferredSize(new Dimension(labelFieldDimension));
        this.type.setMaximumSize(new Dimension(labelFieldDimension));
        p.add(this.type);
        p.add(Box.createHorizontalStrut(5));
        this.description = (JButton)BarFactory.createButton("VariableDescription", null, false);
        this.description.setMinimumSize(new Dimension(buttonFieldDimension));
        this.description.setPreferredSize(new Dimension(buttonFieldDimension));
        this.description.setMaximumSize(new Dimension(buttonFieldDimension));
        this.description.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String dk = ResourceManager.getLanguageDependentString("DescriptionKey");
                ItemView iv = new ItemView(MapPanel.this.getWindow(), dk + " - " + (MapPanel.this.varName == null || MapPanel.this.varName.trim().length() == 0 ? MapPanel.this.varId : MapPanel.this.varName), dk, MapPanel.this.desc);
                iv.showDialog();
            }
        });
        this.description.setEnabled(true);
        p.add(this.description);
        p.add(Box.createHorizontalGlue());
        panel.add(p);
        if (this.val != null) {
            int i = 0;
            Iterator it = this.val.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                String varId = (String)me.getKey();
                Object varVal = me.getValue();
                try {
                    String varType = varVal != null ? WorkflowUtilities.getTypeKeyOfAnyObject(varVal) : "UnknownKey";
                    ActionPanel ntvdPanel = !varType.equals("MapKey") ? new NTVDPanel(varId, varVal, varId, "", varType, this.isReadOnly) : new MapPanel(varId, (HashMap)varVal, varId, "", varType, this.isReadOnly);
                    panel.add(ntvdPanel);
                    panel.add(Box.createVerticalStrut(5));
                    this.ntvdpanels.add(ntvdPanel);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                ++i;
            }
        }
        panel.add(Box.createVerticalGlue());
        jsp.setViewportView(panel);
        return jsp;
    }

    public void requestFocus() {
        super.requestFocus();
        if (this.value != null) {
            this.value.requestFocus();
        } else if (this.choices != null) {
            this.choices.requestFocus();
        }
    }

    public boolean updateFields() {
        MapPanel mp;
        NTVDPanel ntvdp;
        Object p;
        Iterator nvs = this.ntvdpanels.iterator();
        while (nvs.hasNext()) {
            p = nvs.next();
            if (p instanceof NTVDPanel) {
                ntvdp = (NTVDPanel)p;
                if (ntvdp.updateField() || ntvdp.isReadOnly()) continue;
                JOptionPane.showMessageDialog(this, ResourceManager.getLanguageDependentString("ErrorUncorrectType"), ResourceManager.getLanguageDependentString("DialogUpdateProcessVariables"), 0);
                ntvdp.requestFocus();
                return false;
            }
            if (!(p instanceof MapPanel) || (mp = (MapPanel)p).updateFields() || mp.isReadOnly()) continue;
            return false;
        }
        nvs = this.ntvdpanels.iterator();
        while (nvs.hasNext()) {
            p = nvs.next();
            if (p instanceof NTVDPanel) {
                ntvdp = (NTVDPanel)p;
                if (ntvdp.isReadOnly()) continue;
                this.val.put(ntvdp.getVariableId(), ntvdp.getVariableValue());
                continue;
            }
            if (!(p instanceof MapPanel) || (mp = (MapPanel)p).isReadOnly()) continue;
            this.val.put(mp.getVariableId(), mp.getVariableValue());
        }
        return true;
    }

    public String getTypeKey() {
        return this.typeKey;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public String getVariableId() {
        return this.varId;
    }

    public Object getVariableValue() {
        return this.val;
    }
}

