/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.swingclient;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.enhydra.shark.swingclient.BarFactory;
import org.enhydra.shark.swingclient.Utils;

public abstract class ActionPanel
extends JPanel {
    public static final String BUTTONS_SUFFIX = "Buttons";
    public static final String TOOLBAR_SUFFIX = "Toolbar";
    protected Hashtable commands;
    protected Action[] defaultActions;
    JToolBar toolbar;
    protected JPanel buttonPanel;
    protected JDialog myDialog;
    protected JButton dialogOKButton;
    protected JButton dialogCancelButton;

    public ActionPanel() {
        super(true);
    }

    protected void init() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        this.commands = new Hashtable();
        this.createActions();
        Action[] actions = this.getActions();
        if (actions != null) {
            for (int i = 0; i < actions.length; ++i) {
                Action a = actions[i];
                this.commands.put(a.getValue("Name"), a);
            }
            this.toolbar = (JToolBar)BarFactory.createToolbar(Utils.getUnqualifiedClassName(this.getClass()) + TOOLBAR_SUFFIX, this.commands);
            this.add((Component)this.toolbar, "North");
            this.buttonPanel = (JPanel)BarFactory.createButtonPanel(Utils.getUnqualifiedClassName(this.getClass()) + BUTTONS_SUFFIX, this.commands);
            this.add((Component)this.buttonPanel, "South");
        }
        this.add(this.createCenterComponent(), "Center");
    }

    protected void initDialog(Window parent, String title, boolean hasButtons, boolean hasCancelButton) {
        this.myDialog = parent instanceof JDialog ? new JDialog((JDialog)parent, title, true) : new JDialog((JFrame)parent, title, true);
        JPanel btnPanel = new JPanel();
        this.dialogOKButton = (JButton)BarFactory.createButton("OK", null, true);
        this.dialogOKButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActionPanel.this.applyChanges();
            }
        });
        btnPanel.add(this.dialogOKButton);
        this.dialogCancelButton = (JButton)BarFactory.createButton("Cancel", null, true);
        this.dialogCancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActionPanel.this.cancelChanges();
            }
        });
        if (hasCancelButton) {
            btnPanel.add(this.dialogCancelButton);
        }
        Container cp = this.myDialog.getContentPane();
        cp.setLayout(new BorderLayout());
        cp.add((Component)this, "Center");
        if (hasButtons) {
            cp.add((Component)btnPanel, "South");
        }
        this.myDialog.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(10, 0, false), "Apply");
        this.myDialog.getRootPane().getActionMap().put("Apply", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ActionPanel.this.applyChanges();
            }
        });
        this.myDialog.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0, false), "Cancel");
        this.myDialog.getRootPane().getActionMap().put("Cancel", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ActionPanel.this.myDialog.dispose();
            }
        });
        this.myDialog.pack();
        Dimension screenSize = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds().getSize();
        Dimension windowSize = this.myDialog.getPreferredSize();
        if (windowSize.width > screenSize.width - 25) {
            windowSize.width = screenSize.width - 25;
        }
        if (windowSize.height > screenSize.height - 25) {
            windowSize.height = screenSize.height - 25;
        }
        this.myDialog.setSize(windowSize);
        this.myDialog.setLocation(screenSize.width / 2 - windowSize.width / 2, screenSize.height / 2 - windowSize.height / 2);
        this.myDialog.setLocationRelativeTo(parent);
        this.myDialog.setResizable(true);
    }

    public void showDialog() {
        if (this.myDialog != null) {
            this.myDialog.setVisible(true);
        }
    }

    public Action[] getActions() {
        return this.defaultActions;
    }

    public Window getWindow() {
        for (Container p = this.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof Window)) continue;
            return (Window)p;
        }
        return null;
    }

    public Action getAction(String cmd) {
        return (Action)this.commands.get(cmd);
    }

    protected abstract void createActions();

    protected abstract Component createCenterComponent();

    protected void applyChanges() {
    }

    protected void cancelChanges() {
    }
}

