/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.swingclient;

import java.awt.Component;
import java.awt.Window;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.enhydra.shark.api.client.wfservice.AdminMisc;
import org.enhydra.shark.swingclient.ActionPanel;
import org.enhydra.shark.swingclient.MapPanel;
import org.enhydra.shark.swingclient.NTVDPanel;
import org.enhydra.shark.swingclient.ResourceManager;
import org.enhydra.shark.swingclient.SharkClient;
import org.enhydra.shark.swingclient.WorkflowUtilities;

public class UpdateVariables
extends ActionPanel {
    private String procId;
    private Map context;
    private Map readOnlyContext = new LinkedHashMap();
    private JPanel mainPanel;
    private Set ntvdpanels = new HashSet();
    private boolean isCanceled = false;

    public UpdateVariables(Window parent, String dialogName, String procId, Map context, Map readOnlyContext) {
        this.procId = procId;
        this.context = context;
        if (readOnlyContext != null) {
            this.readOnlyContext.putAll(readOnlyContext);
        }
        super.initDialog(parent, dialogName, true, true);
    }

    protected void createActions() {
    }

    protected Component createCenterComponent() {
        JScrollPane jsp = new JScrollPane();
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.setLayout(new BoxLayout(panel, 1));
        if (this.context != null) {
            int i = 0;
            AdminMisc am = SharkClient.getAdminMiscUtilities();
            Iterator it = this.context.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                String varId = (String)me.getKey();
                Object varVal = me.getValue();
                try {
                    String varType = varVal != null ? WorkflowUtilities.getTypeKeyOfAnyObject(varVal) : WorkflowUtilities.getTypeKeyOfAnyObject(am.getVariableJavaClassName(this.procId, varId));
                    ActionPanel ntvdPanel = !varType.equals("MapKey") ? new NTVDPanel(varId, varVal, am.getVariableName(this.procId, varId), am.getVariableDescription(this.procId, varId), varType, this.readOnlyContext.containsKey(varId)) : new MapPanel(varId, (HashMap)varVal, am.getVariableName(this.procId, varId), am.getVariableDescription(this.procId, varId), varType, this.readOnlyContext.containsKey(varId));
                    panel.add(ntvdPanel);
                    panel.add(Box.createVerticalStrut(5));
                    this.ntvdpanels.add(ntvdPanel);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                ++i;
            }
        }
        panel.add(Box.createVerticalGlue());
        jsp.setViewportView(panel);
        return jsp;
    }

    private boolean updateFields() {
        MapPanel mp;
        NTVDPanel ntvdp;
        Object p;
        Iterator nvs = this.ntvdpanels.iterator();
        while (nvs.hasNext()) {
            p = nvs.next();
            if (p instanceof NTVDPanel) {
                ntvdp = (NTVDPanel)p;
                if (ntvdp.updateField() || ntvdp.isReadOnly()) continue;
                JOptionPane.showMessageDialog(this, ResourceManager.getLanguageDependentString("ErrorUncorrectType"), ResourceManager.getLanguageDependentString("DialogUpdateProcessVariables"), 0);
                ntvdp.requestFocus();
                return false;
            }
            if (!(p instanceof MapPanel) || (mp = (MapPanel)p).updateFields() || mp.isReadOnly()) continue;
            return false;
        }
        nvs = this.ntvdpanels.iterator();
        while (nvs.hasNext()) {
            p = nvs.next();
            if (p instanceof NTVDPanel) {
                ntvdp = (NTVDPanel)p;
                if (ntvdp.isReadOnly()) continue;
                this.context.put(ntvdp.getVariableId(), ntvdp.getVariableValue());
                continue;
            }
            if (!(p instanceof MapPanel) || (mp = (MapPanel)p).isReadOnly()) continue;
            this.context.put(mp.getVariableId(), mp.getVariableValue());
        }
        return true;
    }

    protected void applyChanges() {
        if (this.updateFields()) {
            this.myDialog.dispose();
        }
    }

    protected void cancelChanges() {
        this.isCanceled = true;
        this.myDialog.dispose();
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }
}

