/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.swingclient;

import java.awt.Color;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TablePanel
extends JPanel {
    private JTable allItems;

    public TablePanel(Vector columnNames, boolean isFirstColumnVisible) {
        int emptyBorderHSize = 10;
        int emptyBorderVSize = 10;
        Border emptyb = BorderFactory.createEmptyBorder(emptyBorderVSize, emptyBorderHSize, emptyBorderVSize, emptyBorderHSize);
        AbstractBorder inb = BorderFactory.createMatteBorder(1, 1, 1, 1, Color.darkGray);
        inb = BorderFactory.createTitledBorder(inb, "");
        this.setBorder(BorderFactory.createCompoundBorder(emptyb, inb));
        this.setLayout(new BoxLayout(this, 1));
        this.allItems = new JTable(new Vector(), columnNames){

            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        if (!isFirstColumnVisible) {
            TableColumnModel tcm = this.allItems.getColumnModel();
            TableColumn column = this.allItems.getColumnModel().getColumn(0);
            column.setMinWidth(0);
            column.setMaxWidth(0);
            column.setPreferredWidth(0);
            column.setResizable(false);
        }
        this.allItems.setColumnSelectionAllowed(false);
        this.allItems.setRowSelectionAllowed(true);
        this.allItems.setSelectionMode(0);
        this.allItems.getTableHeader().setReorderingAllowed(false);
        JScrollPane allItemsPane = new JScrollPane();
        allItemsPane.setViewportView(this.allItems);
        this.add(allItemsPane);
        this.add(Box.createVerticalGlue());
    }

    public JTable getTable() {
        return this.allItems;
    }

    public Object getColumnValueOfSelectedRow(int columnNo) {
        int row = this.allItems.getSelectedRow();
        Object frw = null;
        if (row >= 0) {
            try {
                frw = this.allItems.getValueAt(row, columnNo);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return frw;
    }

    public void setColumnValueOfSelectedRow(int columnNo, Object val) {
        int row = this.allItems.getSelectedRow();
        if (row >= 0) {
            try {
                this.allItems.setValueAt(val, row, columnNo);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public void addElement(Vector v) throws Exception {
        DefaultTableModel dtm = (DefaultTableModel)this.allItems.getModel();
        try {
            dtm.addRow(v);
        }
        catch (Exception ex) {
            System.out.println("Cannot add row to the table");
        }
    }

    public void removeElement(Object[] columnValues) {
        if (columnValues == null || columnValues.length == 0) {
            return;
        }
        int rowCnt = this.allItems.getRowCount();
        DefaultTableModel dtm = (DefaultTableModel)this.allItems.getModel();
        for (int row = 0; row < rowCnt; ++row) {
            boolean canRemove = true;
            for (int col = 0; col < columnValues.length; ++col) {
                boolean bl = canRemove = canRemove && this.allItems.getValueAt(row, col).equals(columnValues[col]);
                if (!canRemove) break;
            }
            if (!canRemove) continue;
            dtm.removeRow(row);
            break;
        }
    }

    public void removeAll() {
        DefaultTableModel dtm = (DefaultTableModel)this.allItems.getModel();
        try {
            while (true) {
                dtm.removeRow(0);
            }
        }
        catch (Exception ex) {
            return;
        }
    }
}

