/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.swingclient;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.UIManager;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.client.wfservice.AdminMisc;
import org.enhydra.shark.api.client.wfservice.ApplicationMappingAdministration;
import org.enhydra.shark.api.client.wfservice.CacheAdministration;
import org.enhydra.shark.api.client.wfservice.DeadlineAdministration;
import org.enhydra.shark.api.client.wfservice.ExecutionAdministration;
import org.enhydra.shark.api.client.wfservice.LimitAdministration;
import org.enhydra.shark.api.client.wfservice.PackageAdministration;
import org.enhydra.shark.api.client.wfservice.ParticipantMappingAdministration;
import org.enhydra.shark.api.client.wfservice.RepositoryMgr;
import org.enhydra.shark.api.client.wfservice.ScriptMappingAdministration;
import org.enhydra.shark.api.client.wfservice.SharkConnection;
import org.enhydra.shark.api.client.wfservice.SharkInterface;
import org.enhydra.shark.api.client.wfservice.UserGroupAdministration;
import org.enhydra.shark.swingclient.ActionPanel;
import org.enhydra.shark.swingclient.BarFactory;
import org.enhydra.shark.swingclient.CommonExpressionBuilder;
import org.enhydra.shark.swingclient.RefreshingRate;
import org.enhydra.shark.swingclient.ResourceManager;
import org.enhydra.shark.swingclient.SplashScreen;
import org.enhydra.shark.swingclient.Utils;
import org.enhydra.shark.swingclient.actions.Connect;
import org.enhydra.shark.swingclient.actions.Disconnect;
import org.enhydra.shark.swingclient.actions.Exit;
import org.enhydra.shark.swingclient.actions.Refresh;
import org.enhydra.shark.swingclient.actions.SetRefreshingRate;
import org.enhydra.shark.swingclient.actions.ShutdownEngine;

public abstract class SharkClient
extends ActionPanel {
    protected static ImageIcon appIcon;
    protected static ImageIcon logoIcon;
    protected static String appTitle;
    protected JFrame myFrame;
    protected JMenuBar menubar;
    protected SplashScreen splashScreen;
    protected RefreshingRate refreshingRateInSeconds;
    protected boolean isRefresherActive = false;
    protected boolean isRefresherEnabled = true;
    protected Thread refresher = new Thread(){

        public void run() {
            while (true) {
                try {
                    if (SharkClient.this.isRefresherEnabled && username != null) {
                        SharkClient.this.isRefresherActive = true;
                        SharkClient.this.refresh(true);
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                SharkClient.this.isRefresherActive = false;
                try {
                    Thread.sleep(SharkClient.this.refreshingRateInSeconds.getRefreshingRate() * 1000);
                    continue;
                }
                catch (Exception ex) {
                    SharkClient.this.isRefresherActive = false;
                    continue;
                }
                break;
            }
        }
    };
    protected static SharkInterface workflowServer;
    protected static SharkConnection workflowService;
    protected static AdminMisc adminMiscUtilities;
    protected static CacheAdministration cacheAdmin;
    protected static DeadlineAdministration deadlineAdmin;
    protected static ExecutionAdministration execAdmin;
    protected static LimitAdministration limitAdmin;
    protected static ApplicationMappingAdministration applicationMappingAdmin;
    protected static ParticipantMappingAdministration participantMappingAdmin;
    protected static ScriptMappingAdministration scriptMappingAdmin;
    protected static PackageAdministration pkgAdmin;
    protected static RepositoryMgr repositoryMgr;
    protected static UserGroupAdministration userGroupAdmin;
    protected static CommonExpressionBuilder commonExpressionBuilder;
    protected static String username;
    protected static String pwd;
    protected static String configFileName;
    static /* synthetic */ Class class$org$enhydra$shark$swingclient$actions$Connect;
    static /* synthetic */ Class class$org$enhydra$shark$swingclient$actions$Exit;

    public static SharkInterface findWorkflowServer() {
        if (workflowServer == null) {
            try {
                File f = new File(configFileName);
                if (f.exists()) {
                    Shark.configure((File)f);
                } else {
                    Shark.configure();
                }
                workflowServer = Shark.getInstance();
                return workflowServer;
            }
            catch (Exception e) {
                return null;
            }
        }
        return workflowServer;
    }

    public static AdminMisc getAdminMiscUtilities() {
        if (adminMiscUtilities == null) {
            adminMiscUtilities = SharkClient.findWorkflowServer().getAdminInterface().getAdminMisc();
            adminMiscUtilities.connect(username);
        }
        return adminMiscUtilities;
    }

    public static CacheAdministration getCacheAdmin() {
        if (cacheAdmin == null) {
            cacheAdmin = SharkClient.findWorkflowServer().getAdminInterface().getCacheAdministration();
            try {
                cacheAdmin.connect(username);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return cacheAdmin;
    }

    public static DeadlineAdministration getDeadlineAdmin() {
        if (deadlineAdmin == null) {
            deadlineAdmin = SharkClient.findWorkflowServer().getAdminInterface().getDeadlineAdministration();
            try {
                deadlineAdmin.connect(username);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return deadlineAdmin;
    }

    public static ExecutionAdministration getExecAmin() {
        if (execAdmin == null) {
            execAdmin = SharkClient.findWorkflowServer().getAdminInterface().getExecutionAdministration();
            try {
                execAdmin.connect(username, pwd, "", "");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return execAdmin;
    }

    public static LimitAdministration getLimitAdmin() {
        if (limitAdmin == null) {
            limitAdmin = SharkClient.findWorkflowServer().getAdminInterface().getLimitAdministration();
            try {
                limitAdmin.connect(username);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return limitAdmin;
    }

    public static ParticipantMappingAdministration getParticipantMappingsAdmin() {
        if (participantMappingAdmin == null) {
            participantMappingAdmin = SharkClient.findWorkflowServer().getAdminInterface().getParticipantMappingAdministration();
            participantMappingAdmin.connect(username);
        }
        return participantMappingAdmin;
    }

    public static ApplicationMappingAdministration getApplicationMappingsAdmin() {
        if (applicationMappingAdmin == null) {
            applicationMappingAdmin = SharkClient.findWorkflowServer().getAdminInterface().getApplicationMappingAdministration();
            applicationMappingAdmin.connect(username);
        }
        return applicationMappingAdmin;
    }

    public static ScriptMappingAdministration getScriptMappingsAdmin() {
        if (scriptMappingAdmin == null) {
            scriptMappingAdmin = SharkClient.findWorkflowServer().getAdminInterface().getScriptMappingAdministration();
            scriptMappingAdmin.connect(username);
        }
        return scriptMappingAdmin;
    }

    public static PackageAdministration getPackageAmin() {
        if (pkgAdmin == null) {
            pkgAdmin = SharkClient.findWorkflowServer().getAdminInterface().getPackageAdministration();
            pkgAdmin.connect(username);
        }
        return pkgAdmin;
    }

    public static RepositoryMgr getRepositoryManager() {
        if (repositoryMgr == null) {
            repositoryMgr = SharkClient.findWorkflowServer().getRepositoryManager();
            repositoryMgr.connect(username);
        }
        return repositoryMgr;
    }

    public static UserGroupAdministration getUserGroupAmin() {
        if (userGroupAdmin == null) {
            userGroupAdmin = SharkClient.findWorkflowServer().getAdminInterface().getUserGroupAdministration();
            userGroupAdmin.connect(username);
        }
        return userGroupAdmin;
    }

    public static CommonExpressionBuilder getCommonExpressionBuilder() {
        if (commonExpressionBuilder == null) {
            ExecutionAdministration ea = SharkClient.getExecAmin();
            commonExpressionBuilder = new CommonExpressionBuilder(ea, SharkClient.findWorkflowServer().getExpressionBuilderManager());
        }
        return commonExpressionBuilder;
    }

    public boolean isRefresherActive() {
        return this.isRefresherActive;
    }

    public void startRefresher() {
        this.isRefresherEnabled = true;
    }

    public void stopRefresher() {
        this.isRefresherEnabled = false;
    }

    private void initResources() {
        try {
            String vers = System.getProperty("java.version");
            if (vers.compareTo("1.4") < 0) {
                System.out.println("!!!WARNING: application must be run with a 1.4 or higher version VM!!!");
            }
            appTitle = ResourceManager.getLanguageDependentString(this.getAppTitleResourceString());
            URL url = ResourceManager.getResource(this.getLogoResourceString());
            if (url != null) {
                logoIcon = new ImageIcon(url);
            }
            if ((url = ResourceManager.getResource(this.getIconResourceString())) != null) {
                appIcon = new ImageIcon(url);
            }
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exc) {
                System.err.println("Error loading L&F: " + exc);
            }
        }
        catch (Throwable t) {
            System.err.println("uncaught exception: " + t);
            t.printStackTrace();
        }
    }

    public SharkClient(JFrame frame) {
        int rris;
        this.myFrame = frame;
        this.splashScreen = new SplashScreen((Window)frame);
        this.initResources();
        try {
            rris = Integer.parseInt(ResourceManager.getLanguageDependentString(this.getRefreshingRateString()));
        }
        catch (Exception ex) {
            rris = 50;
        }
        this.refreshingRateInSeconds = new RefreshingRate(frame, rris);
        this.menubar = BarFactory.createMenubar(this.getMenubarResourceString(), this.commands);
        this.add((Component)this.menubar, "North");
        this.add(this.createCenterComponent(), "Center");
        this.myFrame.setBackground(Color.lightGray);
        this.myFrame.getContentPane().setLayout(new BorderLayout());
        this.myFrame.getContentPane().add((Component)this, "Center");
        this.myFrame.setDefaultCloseOperation(0);
        this.myFrame.addWindowListener(new AppCloser());
        this.myFrame.pack();
        Rectangle screenSize = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        int xMinus = 50;
        int yMinus = 100;
        this.myFrame.setBounds(xMinus / 2, yMinus / 2, screenSize.width - xMinus, screenSize.height - yMinus);
        if (appIcon != null) {
            this.myFrame.setIconImage(appIcon.getImage());
        }
        this.myFrame.setTitle(appTitle + " - " + ResourceManager.getLanguageDependentString("NoneKey"));
        this.myFrame.setVisible(true);
        this.refresher.start();
        this.getAction(Utils.getUnqualifiedClassName(class$org$enhydra$shark$swingclient$actions$Connect == null ? (class$org$enhydra$shark$swingclient$actions$Connect = SharkClient.class$("org.enhydra.shark.swingclient.actions.Connect")) : class$org$enhydra$shark$swingclient$actions$Connect)).actionPerformed(null);
        if (username == null) {
            System.exit(0);
        }
        this.requestFocus();
    }

    protected void createActions() {
        this.defaultActions = new Action[]{new Connect(this), new Disconnect(this), new ShutdownEngine(this), new Refresh(this), new SetRefreshingRate(this), new Exit(this)};
        this.defaultActions[2].setEnabled(false);
    }

    public void setTitle() {
        this.myFrame.setTitle(appTitle + " - " + this.getFullUserName());
    }

    public String getFullUserName() {
        String name = ResourceManager.getLanguageDependentString("NoneKey");
        if (username != null) {
            try {
                name = SharkClient.getUserGroupAmin().getUserRealName(username);
                if (name == null || name.trim().length() == 0) {
                    name = username;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return name;
    }

    public JFrame getFrame() {
        return this.myFrame;
    }

    public SplashScreen getSplashScreen() {
        return this.splashScreen;
    }

    public static String getAppTitle() {
        return appTitle;
    }

    public static SharkConnection getService() {
        return workflowService;
    }

    public static void setService(SharkConnection wcs) {
        workflowService = wcs;
        if (wcs == null) {
            execAdmin = null;
            commonExpressionBuilder = null;
        }
    }

    public static String getUsername() {
        return username;
    }

    public static void setUsername(String username) {
        SharkClient.username = username;
    }

    public static void setPassword(String pwd) {
        SharkClient.pwd = pwd;
    }

    public void enableControls(boolean enable) {
        for (int i = 0; i < this.menubar.getComponentCount(); ++i) {
            this.menubar.getComponent(i).setEnabled(enable);
        }
    }

    public RefreshingRate getRefreshingRate() {
        return this.refreshingRateInSeconds;
    }

    protected abstract String getAppTitleResourceString();

    protected abstract String getLogoResourceString();

    protected abstract String getIconResourceString();

    protected abstract String getMenubarResourceString();

    protected abstract String getRefreshingRateString();

    public abstract void clearComponents();

    public abstract void refresh(boolean var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        username = null;
        pwd = null;
        configFileName = "conf/Shark.conf";
    }

    protected final class AppCloser
    extends WindowAdapter {
        protected AppCloser() {
        }

        public void windowClosing(WindowEvent e) {
            SharkClient.this.getAction(Utils.getUnqualifiedClassName(class$org$enhydra$shark$swingclient$actions$Exit == null ? (class$org$enhydra$shark$swingclient$actions$Exit = SharkClient.class$("org.enhydra.shark.swingclient.actions.Exit")) : class$org$enhydra$shark$swingclient$actions$Exit)).actionPerformed(null);
        }
    }
}

