/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.swingclient;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.enhydra.shark.swingclient.ActionPanel;
import org.enhydra.shark.swingclient.BarFactory;
import org.enhydra.shark.swingclient.ItemView;
import org.enhydra.shark.swingclient.ResourceManager;
import org.enhydra.shark.swingclient.WorkflowUtilities;

public class NTVDPanel
extends ActionPanel {
    private static Dimension labelFieldDimension = new Dimension(250, 20);
    private static Dimension textFieldDimension = new Dimension(250, 20);
    private static Dimension buttonFieldDimension = new Dimension(50, 25);
    private String varId;
    private String varName;
    private Object val;
    private JLabel name = new JLabel();
    private JLabel type = new JLabel();
    private JTextField value;
    private JComboBox choices;
    private JTextField vDay;
    private JTextField vMonth;
    private JTextField vYear;
    private JTextField vHour;
    private JTextField vMinute;
    private JTextField vSecond;
    private JButton description;
    private String typeKey;
    private String desc;
    private boolean isReadOnly;

    public NTVDPanel(String varId, Object val, String nm, String d, String typeKey, boolean isReadOnly) {
        this.varId = varId;
        this.val = val;
        this.varName = nm;
        this.desc = d;
        this.typeKey = typeKey;
        this.isReadOnly = isReadOnly;
    }

    protected void createActions() {
    }

    protected Component createCenterComponent() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(Box.createHorizontalStrut(5));
        p.add(Box.createHorizontalGlue());
        if (this.varName != null && this.varName.trim().length() > 0) {
            this.name.setText(this.varName);
        } else {
            this.name.setText(this.varId);
        }
        this.name.setMinimumSize(new Dimension(labelFieldDimension));
        this.name.setPreferredSize(new Dimension(labelFieldDimension));
        this.name.setMaximumSize(new Dimension(labelFieldDimension));
        p.add(this.name);
        p.add(Box.createHorizontalStrut(5));
        this.type.setText(ResourceManager.getLanguageDependentString(this.typeKey));
        this.type.setMinimumSize(new Dimension(labelFieldDimension));
        this.type.setPreferredSize(new Dimension(labelFieldDimension));
        this.type.setMaximumSize(new Dimension(labelFieldDimension));
        p.add(this.type);
        p.add(Box.createHorizontalStrut(5));
        if (this.typeKey.equals("UnknownKey")) {
            this.value = new JTextField();
            this.value.setText(ResourceManager.getLanguageDependentString("UnknownKey"));
            this.value.setEnabled(false);
            this.value.setMinimumSize(new Dimension(textFieldDimension));
            this.value.setPreferredSize(new Dimension(textFieldDimension));
            this.value.setMaximumSize(new Dimension(textFieldDimension));
            p.add(this.value);
        } else if (this.typeKey.equals("BooleanKey")) {
            Vector<String> vChc = new Vector<String>();
            vChc.add("true");
            vChc.add("false");
            this.choices = new JComboBox(vChc);
            this.choices.setSelectedItem(this.val.toString());
            this.choices.setMinimumSize(new Dimension(textFieldDimension));
            this.choices.setPreferredSize(new Dimension(textFieldDimension));
            this.choices.setMaximumSize(new Dimension(textFieldDimension));
            this.choices.setEnabled(!this.isReadOnly);
            p.add(this.choices);
        } else if (this.val != null && this.val instanceof Date) {
            this.vDay = new JTextField();
            this.vMonth = new JTextField();
            this.vYear = new JTextField();
            this.vHour = new JTextField();
            this.vMinute = new JTextField();
            this.vSecond = new JTextField();
            Date dte = (Date)this.val;
            Calendar c = Calendar.getInstance();
            c.setTime(dte);
            this.vYear.setText(String.valueOf(c.get(1)));
            this.vMonth.setText(String.valueOf(c.get(2) + 1));
            this.vDay.setText(String.valueOf(c.get(5)));
            this.vHour.setText(String.valueOf(c.get(11)));
            this.vMinute.setText(String.valueOf(c.get(12)));
            this.vSecond.setText(String.valueOf(c.get(13)));
            this.vYear.setMinimumSize(new Dimension(2 * (NTVDPanel.textFieldDimension.width - 10) / 8, NTVDPanel.textFieldDimension.height));
            this.vYear.setPreferredSize(new Dimension(2 * (NTVDPanel.textFieldDimension.width - 10) / 8, NTVDPanel.textFieldDimension.height));
            this.vYear.setMaximumSize(new Dimension(2 * (NTVDPanel.textFieldDimension.width - 10) / 8, NTVDPanel.textFieldDimension.height));
            this.vYear.setEnabled(!this.isReadOnly);
            this.vMonth.setMinimumSize(new Dimension(1 * (NTVDPanel.textFieldDimension.width - 10) / 8, NTVDPanel.textFieldDimension.height));
            this.vMonth.setPreferredSize(new Dimension(1 * (NTVDPanel.textFieldDimension.width - 10) / 8, NTVDPanel.textFieldDimension.height));
            this.vMonth.setMaximumSize(new Dimension(1 * (NTVDPanel.textFieldDimension.width - 10) / 8, NTVDPanel.textFieldDimension.height));
            this.vMonth.setEnabled(!this.isReadOnly);
            this.vDay.setMinimumSize(new Dimension(1 * (NTVDPanel.textFieldDimension.width - 10) / 8, NTVDPanel.textFieldDimension.height));
            this.vDay.setPreferredSize(new Dimension(1 * (NTVDPanel.textFieldDimension.width - 10) / 8, NTVDPanel.textFieldDimension.height));
            this.vDay.setMaximumSize(new Dimension(1 * (NTVDPanel.textFieldDimension.width - 10) / 8, NTVDPanel.textFieldDimension.height));
            this.vDay.setEnabled(!this.isReadOnly);
            this.vHour.setMinimumSize(new Dimension(1 * (NTVDPanel.textFieldDimension.width - 10) / 8, NTVDPanel.textFieldDimension.height));
            this.vHour.setPreferredSize(new Dimension(1 * (NTVDPanel.textFieldDimension.width - 10) / 8, NTVDPanel.textFieldDimension.height));
            this.vHour.setMaximumSize(new Dimension(1 * (NTVDPanel.textFieldDimension.width - 10) / 8, NTVDPanel.textFieldDimension.height));
            this.vHour.setEnabled(!this.isReadOnly);
            this.vMinute.setMinimumSize(new Dimension(1 * (NTVDPanel.textFieldDimension.width - 10) / 8, NTVDPanel.textFieldDimension.height));
            this.vMinute.setPreferredSize(new Dimension(1 * (NTVDPanel.textFieldDimension.width - 10) / 8, NTVDPanel.textFieldDimension.height));
            this.vMinute.setMaximumSize(new Dimension(1 * (NTVDPanel.textFieldDimension.width - 10) / 8, NTVDPanel.textFieldDimension.height));
            this.vMinute.setEnabled(!this.isReadOnly);
            this.vSecond.setMinimumSize(new Dimension(1 * (NTVDPanel.textFieldDimension.width - 10) / 8, NTVDPanel.textFieldDimension.height));
            this.vSecond.setPreferredSize(new Dimension(1 * (NTVDPanel.textFieldDimension.width - 10) / 8, NTVDPanel.textFieldDimension.height));
            this.vSecond.setMaximumSize(new Dimension(1 * (NTVDPanel.textFieldDimension.width - 10) / 8, NTVDPanel.textFieldDimension.height));
            this.vSecond.setEnabled(!this.isReadOnly);
            int ss = 2;
            p.add(this.vYear);
            p.add(Box.createHorizontalStrut(ss));
            p.add(new JLabel("-"));
            p.add(Box.createHorizontalStrut(ss));
            p.add(this.vMonth);
            p.add(Box.createHorizontalStrut(ss));
            p.add(new JLabel("-"));
            p.add(Box.createHorizontalStrut(ss));
            p.add(this.vDay);
            p.add(Box.createHorizontalStrut(10));
            p.add(this.vHour);
            p.add(Box.createHorizontalStrut(ss));
            p.add(new JLabel(":"));
            p.add(Box.createHorizontalStrut(ss));
            p.add(this.vMinute);
            p.add(Box.createHorizontalStrut(ss));
            p.add(new JLabel(":"));
            p.add(Box.createHorizontalStrut(ss));
            p.add(this.vSecond);
        } else {
            this.value = new JTextField();
            if (this.val == null) {
                this.value.setText("");
            } else {
                this.value.setText(this.val.toString());
            }
            this.value.setMinimumSize(new Dimension(textFieldDimension));
            this.value.setPreferredSize(new Dimension(textFieldDimension));
            this.value.setMaximumSize(new Dimension(textFieldDimension));
            this.value.setEnabled(!this.isReadOnly);
            p.add(this.value);
        }
        p.add(Box.createHorizontalStrut(5));
        this.description = (JButton)BarFactory.createButton("VariableDescription", null, false);
        this.description.setMinimumSize(new Dimension(buttonFieldDimension));
        this.description.setPreferredSize(new Dimension(buttonFieldDimension));
        this.description.setMaximumSize(new Dimension(buttonFieldDimension));
        this.description.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String dk = ResourceManager.getLanguageDependentString("DescriptionKey");
                ItemView iv = new ItemView(NTVDPanel.this.getWindow(), dk + " - " + (NTVDPanel.this.varName == null || NTVDPanel.this.varName.trim().length() == 0 ? NTVDPanel.this.varId : NTVDPanel.this.varName), dk, NTVDPanel.this.desc);
                iv.showDialog();
            }
        });
        this.description.setEnabled(true);
        p.add(this.description);
        p.add(Box.createHorizontalStrut(5));
        return p;
    }

    public void requestFocus() {
        super.requestFocus();
        if (this.value != null) {
            this.value.requestFocus();
        } else if (this.choices != null) {
            this.choices.requestFocus();
        }
    }

    public boolean updateField() {
        String dte;
        Object a;
        boolean updated = false;
        if (this.isReadOnly) {
            return false;
        }
        if (this.value != null) {
            Object a2 = WorkflowUtilities.insertValueIntoAnyObject(this.val, this.value.getText(), this.typeKey);
            if (a2 != null) {
                updated = true;
                this.val = a2;
            }
        } else if (this.choices != null) {
            Object a3 = WorkflowUtilities.insertValueIntoAnyObject(this.val, this.choices.getSelectedItem().toString(), this.typeKey);
            if (a3 != null) {
                updated = true;
                this.val = a3;
            }
        } else if (this.vYear != null && (a = WorkflowUtilities.insertValueIntoAnyObject(this.val, dte = this.vYear.getText() + "-" + this.vMonth.getText() + "-" + this.vDay.getText() + " " + this.vHour.getText() + ":" + this.vMinute.getText() + ":" + this.vSecond.getText(), this.typeKey)) != null) {
            updated = true;
            this.val = a;
        }
        return updated || this.typeKey.equals("UnknownKey");
    }

    public String getTypeKey() {
        return this.typeKey;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public String getVariableId() {
        return this.varId;
    }

    public Object getVariableValue() {
        return this.val;
    }
}

