/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.swingclient;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.enhydra.shark.api.client.wfservice.ConnectFailed;
import org.enhydra.shark.api.client.wfservice.SharkConnection;
import org.enhydra.shark.api.client.wfservice.UserGroupAdministration;
import org.enhydra.shark.swingclient.ActionPanel;
import org.enhydra.shark.swingclient.ResourceManager;
import org.enhydra.shark.swingclient.SharkClient;

public class Connection
extends ActionPanel {
    private static Dimension textFieldDimension = new Dimension(200, 20);
    private String username = null;
    private String pwd = null;
    private JTextField usernameField;
    private JPasswordField passwordField;
    private SharkConnection workflowService;
    private SharkClient workflowClient;

    public Connection(JFrame parent, SharkClient workflowClient) {
        this.workflowClient = workflowClient;
        super.initDialog(parent, ResourceManager.getLanguageDependentString("DialogConnectToWorkflowServer"), true, true);
    }

    protected void createActions() {
    }

    protected Component createCenterComponent() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel unPanel = new JPanel();
        unPanel.setLayout(new BoxLayout(unPanel, 0));
        JLabel unl = new JLabel(ResourceManager.getLanguageDependentString("UsernameKey") + ":");
        unPanel.add(Box.createHorizontalGlue());
        unPanel.add(unl);
        this.usernameField = new JTextField();
        this.usernameField.setMinimumSize(new Dimension(textFieldDimension));
        this.usernameField.setMaximumSize(new Dimension(textFieldDimension));
        this.usernameField.setPreferredSize(new Dimension(textFieldDimension));
        unPanel.add(this.usernameField);
        JPanel pwdPanel = new JPanel();
        pwdPanel.setLayout(new BoxLayout(pwdPanel, 0));
        JLabel pwdl = new JLabel(ResourceManager.getLanguageDependentString("PasswordKey") + ":");
        pwdPanel.add(Box.createHorizontalGlue());
        pwdPanel.add(pwdl);
        this.passwordField = new JPasswordField();
        this.passwordField.setMinimumSize(new Dimension(textFieldDimension));
        this.passwordField.setMaximumSize(new Dimension(textFieldDimension));
        this.passwordField.setPreferredSize(new Dimension(textFieldDimension));
        pwdPanel.add(this.passwordField);
        panel.add(unPanel);
        panel.add(pwdPanel);
        return panel;
    }

    protected void applyChanges() {
        try {
            block9: {
                this.connectToServer();
                UserGroupAdministration uga = SharkClient.getUserGroupAmin();
                try {
                    if (uga.doesUserExist(this.usernameField.getText())) break block9;
                    String defGName = "SharkGroup";
                    try {
                        if (!uga.doesGroupExist(defGName)) {
                            uga.createGroup(defGName, "");
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    uga.createUser(defGName, this.usernameField.getText(), new String(this.passwordField.getPassword()), "Default User", "", "");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.workflowService.connect(this.usernameField.getText(), new String(this.passwordField.getPassword()), "", "");
            this.username = this.usernameField.getText();
            this.pwd = new String(this.passwordField.getPassword());
        }
        catch (ConnectFailed cf) {
            this.workflowService = null;
            this.username = null;
            this.pwd = null;
            JOptionPane.showMessageDialog(this, ResourceManager.getLanguageDependentString("ErrorUncorrectLogin"), ResourceManager.getLanguageDependentString("DialogConnectToWorkflowServer"), 0);
        }
        catch (Exception ex) {
            throw new Error("Something went wrong with Shark initialization");
        }
        this.updateClient();
        if (this.username != null) {
            this.myDialog.hide();
        }
    }

    private void connectToServer() {
        try {
            this.workflowService = SharkClient.findWorkflowServer().getSharkConnection();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void cancelChanges() {
        this.workflowService = null;
        this.username = null;
        this.pwd = null;
        this.myDialog.hide();
        this.updateClient();
    }

    private void updateClient() {
        SharkClient.setUsername(this.username);
        SharkClient.setPassword(this.pwd);
        SharkClient.setService(this.workflowService);
        this.workflowClient.setTitle();
    }

    public void showDialog() {
        this.passwordField.setText("");
        super.showDialog();
    }
}

