/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.swingclient;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.enhydra.shark.swingclient.ResourceManager;
import org.enhydra.shark.swingclient.Utils;

public class BarFactory {
    public static final String imageSuffix = "Image";
    public static final String labelSuffix = "Label";
    public static final String actionSuffix = "Action";
    public static final String menuSuffix = "Menu";
    public static final String accelSuffix = "Accel";
    public static final String mnemonicSuffix = "Mnemonic";
    public static final String tipSuffix = "Tooltip";
    static /* synthetic */ Class class$java$awt$event$KeyEvent;

    public static Component createToolBars(String toolbarToLoad, Map actions) {
        int i;
        String[] toolBars = Utils.tokenize(ResourceManager.getLanguageDependentString(toolbarToLoad), " ");
        JPanel lastPanel = new JPanel();
        lastPanel.setLayout(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        for (i = 0; i < toolBars.length && !toolBars[i].equals("-"); ++i) {
            String label = ResourceManager.getLanguageDependentString(toolBars[i] + labelSuffix);
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            Component c = BarFactory.createToolbar(toolBars[i], actions);
            panel.add("West", c);
            panel.add(c);
            ImageIcon icon = null;
            URL url = ResourceManager.getResource(toolBars[i] + imageSuffix);
            if (url != null) {
                icon = new ImageIcon(url);
            }
            tabbedPane.addTab(label, icon, panel, label);
        }
        tabbedPane.setPreferredSize(new Dimension(500, 60));
        tabbedPane.setSelectedIndex(i - 1);
        lastPanel.add("West", tabbedPane);
        if (i < toolBars.length - 1) {
            Component c = BarFactory.createButton(toolBars[i + 1], actions, false);
            lastPanel.add("East", c);
        }
        return lastPanel;
    }

    public static Component createToolbar(String key, Map actions) {
        String label = ResourceManager.getLanguageDependentString(key + labelSuffix);
        JToolBar toolbar = new JToolBar(label);
        toolbar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        toolbar.setFloatable(false);
        String[] toolKeys = Utils.tokenize(ResourceManager.getLanguageDependentString(key), " ");
        for (int i = 0; i < toolKeys.length; ++i) {
            if (toolKeys[i].equals("-")) {
                toolbar.add(Box.createHorizontalStrut(10));
                continue;
            }
            toolbar.add(BarFactory.createButton(toolKeys[i], actions, false));
        }
        toolbar.add(Box.createHorizontalGlue());
        return toolbar;
    }

    public static Component createButton(String key, Map actions, boolean setText) {
        String tip;
        JButton b = null;
        URL url = ResourceManager.getResource(key + imageSuffix);
        if (url != null) {
            b = new JButton(new ImageIcon(url)){

                public float getAlignmentY() {
                    return 0.5f;
                }
            };
            if (setText) {
                b.setText(ResourceManager.getLanguageDependentString(key + labelSuffix));
            }
        } else {
            b = new JButton(ResourceManager.getLanguageDependentString(key + labelSuffix)){

                public float getAlignmentY() {
                    return 0.5f;
                }
            };
        }
        b.setMargin(new Insets(1, 1, 1, 1));
        b.setRequestFocusEnabled(false);
        String astr = ResourceManager.getLanguageDependentString(key + actionSuffix);
        if (astr == null) {
            astr = key;
        }
        if (actions != null) {
            Action a = (Action)actions.get(astr);
            if (a != null) {
                b.setActionCommand(astr);
                b.addActionListener(a);
                a.addPropertyChangeListener(BarFactory.createActionChangeListener(b));
                b.setEnabled(a.isEnabled());
            } else {
                b.setEnabled(false);
            }
        }
        if ((tip = ResourceManager.getLanguageDependentString(key + tipSuffix)) != null) {
            b.setToolTipText(tip);
        }
        return b;
    }

    public static JMenuBar createMenubar(String menubarToLoad, Map actions) {
        JMenuBar mb = new JMenuBar();
        String[] menuKeys = Utils.tokenize(ResourceManager.getLanguageDependentString(menubarToLoad), " ");
        for (int i = 0; i < menuKeys.length; ++i) {
            String[] itemKeys = Utils.tokenize(ResourceManager.getLanguageDependentString(menuKeys[i]), " ");
            JMenu m = BarFactory.createMenu(menuKeys[i], itemKeys, actions);
            if (m == null) continue;
            mb.add(m);
        }
        return mb;
    }

    public static JMenu createMenu(String key, String[] itemKeys, Map actions) {
        JMenu menu = new JMenu(ResourceManager.getLanguageDependentString(key + labelSuffix));
        for (int i = 0; i < itemKeys.length; ++i) {
            if (itemKeys[i].equals("-")) {
                menu.addSeparator();
                continue;
            }
            JMenuItem mi = BarFactory.createMenuItem(itemKeys[i], actions);
            menu.add(mi);
        }
        URL url = ResourceManager.getResource(key + imageSuffix);
        if (url != null) {
            menu.setHorizontalTextPosition(4);
            menu.setIcon(new ImageIcon(url));
        }
        BarFactory.setMnemonic(menu, ResourceManager.getLanguageDependentString(key + mnemonicSuffix));
        menu.setActionCommand(key);
        return menu;
    }

    public static JMenuItem createMenuItem(String cmd, Map actions) {
        String subMenu = ResourceManager.getLanguageDependentString(cmd + menuSuffix);
        if (subMenu != null) {
            String[] itemKeys = Utils.tokenize(subMenu, " ");
            JMenu mn = BarFactory.createMenu(cmd, itemKeys, actions);
            return mn;
        }
        JMenuItem mi = cmd.equals("ShowHideFinishedProcesses") || cmd.equals("AutomaticallyCheckDeadlines") || cmd.equals("AutomaticallyCheckLimits") ? new JCheckBoxMenuItem(ResourceManager.getLanguageDependentString(cmd + labelSuffix)) : new JMenuItem(ResourceManager.getLanguageDependentString(cmd + labelSuffix));
        URL url = ResourceManager.getResource(cmd + imageSuffix);
        if (url != null) {
            mi.setHorizontalTextPosition(4);
            mi.setIcon(new ImageIcon(url));
        }
        BarFactory.setAccelerator(mi, ResourceManager.getLanguageDependentString(cmd + accelSuffix));
        BarFactory.setMnemonic(mi, ResourceManager.getLanguageDependentString(cmd + mnemonicSuffix));
        String astr = ResourceManager.getLanguageDependentString(cmd + actionSuffix);
        if (astr == null) {
            astr = cmd;
        }
        mi.setActionCommand(astr);
        Action a = (Action)actions.get(astr);
        if (a != null) {
            mi.addActionListener(a);
            a.addPropertyChangeListener(BarFactory.createActionChangeListener(mi));
            mi.setEnabled(a.isEnabled());
        }
        return mi;
    }

    public static void setMnemonic(JMenuItem mi, String mnemonic) {
        if (mnemonic != null && mnemonic.length() > 0) {
            mi.setMnemonic(mnemonic.charAt(0));
        }
    }

    public static void setAccelerator(JMenuItem mi, String accel) {
        if (accel != null) {
            try {
                int mask = 0;
                if (accel.startsWith("CTRL")) {
                    mask += 2;
                    accel = accel.substring(5);
                }
                if (accel.startsWith("SHIFT")) {
                    ++mask;
                    accel = accel.substring(6);
                }
                if (accel.startsWith("ALT")) {
                    mask += 8;
                    accel = accel.substring(4);
                }
                int key = (class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = BarFactory.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent).getField("VK_" + accel).getInt(null);
                mi.setAccelerator(KeyStroke.getKeyStroke(key, mask));
            }
            catch (Exception e) {
                System.err.println("Error while assigning accelerator !!!");
            }
        }
    }

    public static Component createButtonPanel(String key, Map actions) {
        String label = ResourceManager.getLanguageDependentString(key + labelSuffix);
        JPanel groupPanel = new JPanel();
        groupPanel.setLayout(new BoxLayout(groupPanel, 1));
        JPanel p = new JPanel();
        String[] buttonKeys = Utils.tokenize(ResourceManager.getLanguageDependentString(key), " ");
        for (int i = 0; i < buttonKeys.length; ++i) {
            if (buttonKeys[i].equals("-")) {
                p.add(Box.createHorizontalStrut(5));
                continue;
            }
            if (buttonKeys[i].equals("+")) {
                groupPanel.add(p);
                p = new JPanel();
                continue;
            }
            p.add(BarFactory.createButton(buttonKeys[i], actions, true));
        }
        groupPanel.add(p);
        return groupPanel;
    }

    private static PropertyChangeListener createActionChangeListener(AbstractButton b) {
        return new ActionChangedListener(b);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ActionChangedListener
    implements PropertyChangeListener {
        AbstractButton button;

        ActionChangedListener(AbstractButton b) {
            this.button = b;
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (e.getPropertyName().equals("Name") && this.button instanceof JMenuItem) {
                String text = (String)e.getNewValue();
                this.button.setText(text);
            } else if (propertyName.equals("enabled")) {
                Boolean enabledState = (Boolean)e.getNewValue();
                this.button.setEnabled(enabledState);
            }
        }
    }
}

