/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.scripting;

import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.internal.scripting.Evaluator;
import org.enhydra.shark.api.internal.scripting.ScriptingManager;
import org.enhydra.shark.api.internal.working.CallbackUtilities;
import org.enhydra.shark.scripting.BshEvaluator;
import org.enhydra.shark.scripting.JavaScriptEvaluator;
import org.enhydra.shark.scripting.PythonEvaluator;

public class StandardScriptingManager
implements ScriptingManager {
    public static final String PYTHON_SCRIPT = "text/pythonscript";
    public static final String JAVA_LANGUAGE_SCRIPT = "text/java";
    public static final String JAVA_SCRIPT = "text/javascript";
    private BshEvaluator bshEvaluator;
    private PythonEvaluator pythonEvaluator;
    private JavaScriptEvaluator jsEvaluator;
    private static CallbackUtilities cus;

    public void configure(CallbackUtilities cus) throws RootException {
        StandardScriptingManager.cus = cus;
        this.bshEvaluator = new BshEvaluator();
        this.bshEvaluator.configure(cus);
        this.pythonEvaluator = new PythonEvaluator();
        this.pythonEvaluator.configure(cus);
        this.jsEvaluator = new JavaScriptEvaluator();
        this.jsEvaluator.configure(cus);
    }

    public Evaluator getEvaluator(SharkTransaction t, String name) throws RootException {
        if (name == null) {
            return null;
        }
        Object eval = null;
        if (name.equals(PYTHON_SCRIPT)) {
            eval = this.pythonEvaluator;
        } else if (name.equals(JAVA_LANGUAGE_SCRIPT)) {
            eval = this.bshEvaluator;
        } else if (name.equals(JAVA_SCRIPT)) {
            eval = this.jsEvaluator;
        }
        return eval;
    }
}

