/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.scripting;

import java.util.Map;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.internal.scripting.Evaluator;
import org.enhydra.shark.api.internal.working.CallbackUtilities;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class JavaScriptEvaluator
implements Evaluator {
    private static final String LOG_CHANNEL = "Scripting";
    private CallbackUtilities cus;

    public void configure(CallbackUtilities cus) throws RootException {
        this.cus = cus;
    }

    public boolean evaluateCondition(SharkTransaction t, String condition, Map context) throws RootException {
        if (condition == null || condition.trim().length() == 0) {
            return true;
        }
        Object eval = this.evaluateExpression(t, condition, context, Boolean.class);
        try {
            return (Boolean)eval;
        }
        catch (Exception ex) {
            this.cus.error(LOG_CHANNEL, "JavaScriptEvaluator -> The result of condition " + condition + " cannot be converted to boolean");
            this.cus.error("JavaScriptEvaluator -> The result of condition " + condition + " cannot be converted to boolean");
            throw new RootException("Result cannot be converted to boolean", (Throwable)ex);
        }
    }

    public Object evaluateExpression(SharkTransaction t, String expr, Map context, Class resultClass) throws RootException {
        Context cx = Context.enter();
        Scriptable scope = cx.initStandardObjects(null);
        cx.setOptimizationLevel(-1);
        try {
            this.prepareContext(scope, context);
            Object eval = resultClass != null ? Context.toType((Object)cx.evaluateString(scope, expr, "", 1, null), (Class)resultClass) : cx.evaluateString(scope, expr, "", 1, null);
            this.cus.debug(LOG_CHANNEL, "JavaScriptEvaluator -> Javascript expression " + expr + " is evaluated to " + eval);
            Object object = eval;
            return object;
        }
        catch (Exception jse) {
            this.cus.error(LOG_CHANNEL, "JavaScriptEvaluator -> The result of expression " + expr + " can't be evaluated - error message=" + jse.getMessage());
            this.cus.error("JavaScriptEvaluator -> The result of expression " + expr + " can't be evaluated - error message=" + jse.getMessage());
            throw new RootException("Result cannot be evaluated", (Throwable)jse);
        }
        finally {
            Context.exit();
        }
    }

    private void prepareContext(Scriptable scope, Map context) throws Exception {
        for (Map.Entry me : context.entrySet()) {
            String key = me.getKey().toString();
            Object value = me.getValue();
            scope.put(key, scope, value);
        }
    }
}

