/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.repositorypersistence;

import com.lutris.appserver.server.sql.DBTransaction;
import com.lutris.appserver.server.sql.DatabaseManagerException;
import com.lutris.appserver.server.sql.LogicalDatabase;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.enhydra.dods.DODS;
import org.enhydra.shark.api.RepositoryTransaction;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.TransactionException;
import org.enhydra.shark.api.internal.repositorypersistence.RepositoryException;
import org.enhydra.shark.api.internal.repositorypersistence.RepositoryPersistenceManager;
import org.enhydra.shark.api.internal.working.CallbackUtilities;
import org.enhydra.shark.repositorypersistence.DODSRepositoryTransaction;
import org.enhydra.shark.repositorypersistence.data.NextXPDLVersionDO;
import org.enhydra.shark.repositorypersistence.data.NextXPDLVersionQuery;
import org.enhydra.shark.repositorypersistence.data.XPDLDO;
import org.enhydra.shark.repositorypersistence.data.XPDLDataDO;
import org.enhydra.shark.repositorypersistence.data.XPDLHistoryDO;
import org.enhydra.shark.repositorypersistence.data.XPDLHistoryDataDO;
import org.enhydra.shark.repositorypersistence.data.XPDLHistoryQuery;
import org.enhydra.shark.repositorypersistence.data.XPDLQuery;
import org.enhydra.shark.repositorypersistence.data.XPDLReferenceDO;
import org.enhydra.shark.repositorypersistence.data.XPDLReferenceQuery;
import org.enhydra.shark.utilities.dods.DODSUtilities;

public class DODSRepositoryPersistenceManager
implements RepositoryPersistenceManager {
    static boolean _debug_ = false;
    private static final String DBG_PARAM_NAME = "DODSRepositoryPersistenceManager.debug";
    private static final String INITIAL_VERSION = "1";
    private static final String LDB_PARAM_NAME = "DODSRepositoryPersistenceManager.DatabaseName";
    private CallbackUtilities cus;
    private LogicalDatabase db = null;

    public void configure(CallbackUtilities cus) throws RootException {
        if (null == cus) {
            throw new RootException("Cannot configure without call back impl.");
        }
        this.cus = cus;
        _debug_ = Boolean.valueOf(cus.getProperty(DBG_PARAM_NAME, "false"));
        DODSUtilities.init((Properties)cus.getProperties());
        String dbName = cus.getProperty(LDB_PARAM_NAME, DODS.getDatabaseManager().getDefaultDB());
        try {
            this.db = DODS.getDatabaseManager().findLogicalDatabase(dbName);
        }
        catch (DatabaseManagerException e) {
            throw new RootException("Couldn't find logical database.", (Throwable)e);
        }
        cus.debug("DODSRepositoryPersistenceManager configured");
    }

    public void uploadXPDL(RepositoryTransaction t, String xpdlId, byte[] xpdl, byte[] serializedPkg, long xpdlClassVer) throws RepositoryException {
        this.cus.info("DODSRepositoryPersistenceManager -> Storing XPDL " + xpdlId + ", BLOB1 size=" + xpdl.length + ", BLOB2 size=" + serializedPkg.length);
        try {
            DBTransaction dbt = ((DODSRepositoryTransaction)t).getDODSTransaction();
            String xpdlVer = this.updateNextVersion(dbt, xpdlId);
            XPDLDO newXPDLDO = XPDLDO.createVirgin(dbt);
            newXPDLDO.setXPDLId(xpdlId);
            newXPDLDO.setXPDLVersion(xpdlVer);
            newXPDLDO.setXPDLClassVersion(xpdlClassVer);
            newXPDLDO.setXPDLUploadTime(new Timestamp(System.currentTimeMillis()));
            XPDLDataDO cont = XPDLDataDO.createVirgin(dbt);
            cont.setXPDLContent(xpdl);
            cont.setXPDLClassContent(serializedPkg);
            cont.setXPDL(newXPDLDO);
            cont.setCNT(DODSUtilities.getNext((String)"_xpdldata_"));
            newXPDLDO.save(dbt);
            cont.save(dbt);
            dbt.write();
        }
        catch (Throwable thr) {
            throw new RepositoryException("DODSRepositoryPersistenceManager -> The upload of xpdl " + xpdlId + " failed", thr);
        }
    }

    public void updateXPDL(RepositoryTransaction t, String xpdlId, String xpdlVersion, byte[] xpdl, byte[] serializedPkg, long xpdlClassVer) throws RepositoryException {
        try {
            DBTransaction dbt = ((DODSRepositoryTransaction)t).getDODSTransaction();
            XPDLDO DO = this.getXPDLDO(dbt, xpdlId, xpdlVersion);
            DO.setXPDLClassVersion(xpdlClassVer);
            XPDLDataDO cont = DO.getXPDLDataDO();
            cont.setXPDLContent(xpdl);
            cont.setXPDLClassContent(serializedPkg);
            cont.save(dbt);
            dbt.write();
        }
        catch (Exception ex) {
            this.cus.error("DODSRepositoryPersistenceManager -> The update of the xpdl with Id=" + xpdlId + ", and version=" + xpdlVersion + " failed");
            throw new RepositoryException((Throwable)ex);
        }
    }

    public void deleteXPDL(RepositoryTransaction t, String xpdlId, String xpdlVersion) throws RepositoryException {
        try {
            DBTransaction dbt = ((DODSRepositoryTransaction)t).getDODSTransaction();
            XPDLDO DO = this.getXPDLDO(dbt, xpdlId, xpdlVersion);
            DO.delete(dbt);
            dbt.write();
        }
        catch (Exception ex) {
            throw new RepositoryException("XPDL [" + xpdlId + "," + xpdlVersion + "] is not deleted from repository", (Throwable)ex);
        }
    }

    public void moveToHistory(RepositoryTransaction t, String xpdlId, String xpdlVersion) throws RepositoryException {
        try {
            DBTransaction dbt = ((DODSRepositoryTransaction)t).getDODSTransaction();
            XPDLDO DO = this.getXPDLDO(dbt, xpdlId, xpdlVersion);
            XPDLHistoryDO xpdlHist = XPDLHistoryDO.createVirgin(dbt);
            xpdlHist.setXPDLId(DO.getXPDLId());
            xpdlHist.setXPDLVersion(DO.getXPDLVersion());
            xpdlHist.setXPDLUploadTime(DO.getXPDLUploadTime());
            xpdlHist.setXPDLHistoryUploadTime(new Timestamp(System.currentTimeMillis()));
            XPDLHistoryDataDO cont = XPDLHistoryDataDO.createVirgin(dbt);
            cont.setXPDLContent(DO.getXPDLDataDO().getXPDLContent());
            cont.setXPDLHistory(xpdlHist);
            cont.setCNT(DODSUtilities.getNext((String)"_xpdlhistorydata_"));
            DO.delete(dbt);
            xpdlHist.save(dbt);
            cont.save(dbt);
            dbt.write();
        }
        catch (Exception ex) {
            throw new RepositoryException("XPDL [" + xpdlId + "," + xpdlVersion + "] is not moved to history", (Throwable)ex);
        }
    }

    public void deleteFromHistory(RepositoryTransaction t, String xpdlId, String xpdlVersion) throws RepositoryException {
        try {
            DBTransaction dbt = ((DODSRepositoryTransaction)t).getDODSTransaction();
            XPDLHistoryDO DO = this.getXPDLHistoryDO(dbt, xpdlId, xpdlVersion);
            DO.delete(dbt);
            dbt.write();
        }
        catch (Exception ex) {
            throw new RepositoryException("XPDL [" + xpdlId + "," + xpdlVersion + "] is not deleted from history", (Throwable)ex);
        }
    }

    public void clearRepository(RepositoryTransaction t) throws RepositoryException {
        try {
            DBTransaction dbt = ((DODSRepositoryTransaction)t).getDODSTransaction();
            XPDLDO[] DOs = this.getAllXPDLs(dbt);
            if (DOs != null) {
                for (int i = 0; i < DOs.length; ++i) {
                    DOs[i].delete();
                }
            }
            dbt.write();
        }
        catch (Exception ex) {
            throw new RepositoryException("Some xpdl is not deleted from repository while clearing it", (Throwable)ex);
        }
    }

    public String getCurrentVersion(RepositoryTransaction t, String xpdlId) throws RepositoryException {
        try {
            DBTransaction dbt = ((DODSRepositoryTransaction)t).getDODSTransaction();
            return this.getLastVersionXPDLDO(dbt, xpdlId).getXPDLVersion();
        }
        catch (Exception ex) {
            throw new RepositoryException("No xpdl with Id=" + xpdlId, (Throwable)ex);
        }
    }

    public String getNextVersion(RepositoryTransaction t, String xpdlId) throws RepositoryException {
        try {
            DBTransaction dbt = ((DODSRepositoryTransaction)t).getDODSTransaction();
            NextXPDLVersionQuery query = new NextXPDLVersionQuery(dbt);
            query.setQueryXPDLId(xpdlId);
            NextXPDLVersionDO nvDO = query.getNextDO();
            if (nvDO == null) {
                return INITIAL_VERSION;
            }
            return nvDO.getNextVersion();
        }
        catch (Exception ex) {
            throw new RepositoryException((Throwable)ex);
        }
    }

    public long getSerializedXPDLObjectVersion(RepositoryTransaction t, String xpdlId, String xpdlVersion) throws RepositoryException {
        try {
            DBTransaction dbt = ((DODSRepositoryTransaction)t).getDODSTransaction();
            return this.getXPDLDO(dbt, xpdlId, xpdlVersion).getXPDLClassVersion();
        }
        catch (Exception ex) {
            throw new RepositoryException("No xpdl with Id=" + xpdlId, (Throwable)ex);
        }
    }

    private String updateNextVersion(DBTransaction dbt, String xpdlId) throws Exception {
        NextXPDLVersionQuery query = new NextXPDLVersionQuery(dbt);
        query.setQueryXPDLId(xpdlId);
        NextXPDLVersionDO nvDO = query.getNextDO();
        String curVersion = INITIAL_VERSION;
        if (nvDO == null) {
            nvDO = NextXPDLVersionDO.createVirgin(dbt);
            nvDO.setXPDLId(xpdlId);
            nvDO.setNextVersion(INITIAL_VERSION);
        } else {
            curVersion = nvDO.getNextVersion();
        }
        int nver = Integer.parseInt(nvDO.getNextVersion()) + 1;
        String nextVersion = String.valueOf(nver);
        nvDO.setNextVersion(nextVersion);
        nvDO.save(dbt);
        dbt.write();
        return curVersion;
    }

    public byte[] getXPDL(RepositoryTransaction t, String xpdlId) throws RepositoryException {
        try {
            DBTransaction dbt = ((DODSRepositoryTransaction)t).getDODSTransaction();
            return this.getLastVersionXPDLDO(dbt, xpdlId).getXPDLDataDO().getXPDLContent();
        }
        catch (Exception ex) {
            throw new RepositoryException("No xpdl with Id=" + xpdlId + " in repository", (Throwable)ex);
        }
    }

    public byte[] getSerializedXPDLObject(RepositoryTransaction t, String xpdlId) throws RepositoryException {
        try {
            DBTransaction dbt = ((DODSRepositoryTransaction)t).getDODSTransaction();
            return this.getLastVersionXPDLDO(dbt, xpdlId).getXPDLDataDO().getXPDLClassContent();
        }
        catch (Exception ex) {
            throw new RepositoryException("No xpdl with Id=" + xpdlId + " in repository", (Throwable)ex);
        }
    }

    public byte[] getXPDL(RepositoryTransaction t, String xpdlId, String xpdlVersion) throws RepositoryException {
        try {
            DBTransaction dbt = ((DODSRepositoryTransaction)t).getDODSTransaction();
            return this.getXPDLDO(dbt, xpdlId, xpdlVersion).getXPDLDataDO().getXPDLContent();
        }
        catch (Exception ex) {
            throw new RepositoryException("No xpdl [" + xpdlId + "," + xpdlVersion + "] in repository", (Throwable)ex);
        }
    }

    public byte[] getSerializedXPDLObject(RepositoryTransaction t, String xpdlId, String xpdlVersion) throws RepositoryException {
        try {
            DBTransaction dbt = ((DODSRepositoryTransaction)t).getDODSTransaction();
            return this.getXPDLDO(dbt, xpdlId, xpdlVersion).getXPDLDataDO().getXPDLClassContent();
        }
        catch (Exception ex) {
            throw new RepositoryException("No xpdl [" + xpdlId + "," + xpdlVersion + "] in repository", (Throwable)ex);
        }
    }

    public List getXPDLVersions(RepositoryTransaction t, String xpdlId) throws RepositoryException {
        try {
            ArrayList<String> xpdlVersions = new ArrayList<String>();
            DBTransaction dbt = ((DODSRepositoryTransaction)t).getDODSTransaction();
            XPDLDO[] DOs = this.getAllXPDLs(dbt, xpdlId);
            for (int i = 0; i < DOs.length; ++i) {
                xpdlVersions.add(DOs[i].getXPDLVersion());
            }
            return xpdlVersions;
        }
        catch (Exception ex) {
            throw new RepositoryException("No xpdl with Id=" + xpdlId + " in repository", (Throwable)ex);
        }
    }

    public boolean doesXPDLExist(RepositoryTransaction t, String xpdlId) throws RepositoryException {
        try {
            DBTransaction dbt = ((DODSRepositoryTransaction)t).getDODSTransaction();
            XPDLDO DO = this.getLastVersionXPDLDO(dbt, xpdlId);
            return this.getLastVersionXPDLDO(dbt, xpdlId) != null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean doesXPDLExist(RepositoryTransaction t, String xpdlId, String xpdlVersion) throws RepositoryException {
        try {
            DBTransaction dbt = ((DODSRepositoryTransaction)t).getDODSTransaction();
            this.getXPDLDO(dbt, xpdlId, xpdlVersion);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public List getExistingXPDLIds(RepositoryTransaction t) throws RepositoryException {
        try {
            DBTransaction dbt = ((DODSRepositoryTransaction)t).getDODSTransaction();
            XPDLDO[] DOs = this.getAllXPDLs(dbt);
            HashSet<String> ids = new HashSet<String>();
            if (DOs != null) {
                for (int i = 0; i < DOs.length; ++i) {
                    ids.add(DOs[i].getXPDLId());
                }
            }
            return new ArrayList(ids);
        }
        catch (Exception ex) {
            throw new RepositoryException((Throwable)ex);
        }
    }

    public void addXPDLReference(RepositoryTransaction t, String referredXPDLId, String referringXPDLId, String referringXPDLVersion, int referredXPDLNumber) throws RepositoryException {
        try {
            DBTransaction dbt = ((DODSRepositoryTransaction)t).getDODSTransaction();
            if (this.getXPDLReference(dbt, referredXPDLId, referringXPDLId, referringXPDLVersion) == null) {
                XPDLReferenceDO ref = XPDLReferenceDO.createVirgin(dbt);
                ref.setReferredXPDLId(referredXPDLId);
                ref.setReferringXPDL(this.getXPDLDO(dbt, referringXPDLId, referringXPDLVersion));
                ref.setReferredXPDLNumber(referredXPDLNumber);
                ref.save(dbt);
            }
            dbt.write();
        }
        catch (Exception ex) {
            throw new RepositoryException((Throwable)ex);
        }
    }

    public List getReferringXPDLIds(RepositoryTransaction t, String referredXPDLId) throws RepositoryException {
        try {
            DBTransaction dbt = ((DODSRepositoryTransaction)t).getDODSTransaction();
            XPDLReferenceQuery query = new XPDLReferenceQuery(dbt);
            query.setQueryReferredXPDLId(referredXPDLId);
            XPDLReferenceDO[] refs = query.getDOArray();
            HashSet<String> referrers = new HashSet<String>();
            if (refs != null) {
                for (int i = 0; i < refs.length; ++i) {
                    referrers.add(refs[i].getReferringXPDL().getXPDLId());
                }
            }
            return new ArrayList(referrers);
        }
        catch (Exception ex) {
            throw new RepositoryException((Throwable)ex);
        }
    }

    public List getReferringXPDLVersions(RepositoryTransaction t, String referredXPDLId, String refferingXPDLId) throws RepositoryException {
        try {
            DBTransaction dbt = ((DODSRepositoryTransaction)t).getDODSTransaction();
            XPDLReferenceQuery query = new XPDLReferenceQuery(dbt);
            query.setQueryReferredXPDLId(referredXPDLId);
            XPDLReferenceDO[] refs = query.getDOArray();
            ArrayList<String> referrers = new ArrayList<String>();
            if (refs != null) {
                for (int i = 0; i < refs.length; ++i) {
                    if (!refs[i].getReferringXPDL().getXPDLId().equals(refferingXPDLId)) continue;
                    referrers.add(refs[i].getReferringXPDL().getXPDLVersion());
                }
            }
            return referrers;
        }
        catch (Exception ex) {
            throw new RepositoryException((Throwable)ex);
        }
    }

    public List getReferredXPDLIds(RepositoryTransaction t, String refferingXPDLId, String refferingXPDLVersion) throws RepositoryException {
        try {
            ArrayList ret = new ArrayList();
            DBTransaction dbt = ((DODSRepositoryTransaction)t).getDODSTransaction();
            XPDLDO DO = this.getXPDLDO(dbt, refferingXPDLId, refferingXPDLVersion);
            XPDLReferenceQuery query = new XPDLReferenceQuery(dbt);
            query.setQueryReferringXPDL(DO);
            XPDLReferenceDO[] refs = query.getDOArray();
            if (refs != null) {
                HashMap<Integer, String> temp = new HashMap<Integer, String>();
                for (int i = 0; i < refs.length; ++i) {
                    temp.put(new Integer(refs[i].getReferredXPDLNumber()), refs[i].getReferredXPDLId());
                }
                ArrayList tmp = new ArrayList(temp.keySet());
                Collections.sort(tmp);
                for (int i = 0; i < tmp.size(); ++i) {
                    ret.add(temp.get(tmp.get(i)));
                }
            }
            return ret;
        }
        catch (Exception ex) {
            throw new RepositoryException((Throwable)ex);
        }
    }

    private XPDLReferenceDO getXPDLReference(DBTransaction dbt, String referredId, String referringId, String referringVersion) throws Exception {
        XPDLReferenceQuery query = new XPDLReferenceQuery(dbt);
        query.setQueryReferredXPDLId(referredId);
        query.setQueryReferringXPDL(this.getXPDLDO(dbt, referringId, referringVersion));
        query.requireUniqueInstance();
        XPDLReferenceDO ref = query.getNextDO();
        return ref;
    }

    public RepositoryTransaction createTransaction() throws TransactionException {
        try {
            return new DODSRepositoryTransaction(DODS.getDatabaseManager().createTransaction());
        }
        catch (Exception ex) {
            throw new TransactionException((Throwable)ex);
        }
    }

    private XPDLDO getXPDLDO(DBTransaction dbt, String xpdlId, String xpdlVersion) throws Exception {
        XPDLQuery query = new XPDLQuery(dbt);
        query.setQueryXPDLId(xpdlId);
        query.setQueryXPDLVersion(xpdlVersion);
        query.requireUniqueInstance();
        XPDLDO DO = query.getNextDO();
        if (DO == null) {
            throw new Exception("There is no xpdl with Id=" + xpdlId + ", and version " + xpdlVersion + " in the repository");
        }
        return DO;
    }

    private XPDLDO[] getAllXPDLs(DBTransaction dbt, String xpdlId) throws Exception {
        XPDLQuery query = new XPDLQuery(dbt);
        query.setQueryXPDLId(xpdlId);
        return query.getDOArray();
    }

    private XPDLDO[] getAllXPDLs(DBTransaction dbt) throws Exception {
        XPDLQuery query = new XPDLQuery(dbt);
        return query.getDOArray();
    }

    private XPDLDO getLastVersionXPDLDO(DBTransaction dbt, String xpdlId) throws Exception {
        XPDLDO[] xpdls = this.getAllXPDLs(dbt, xpdlId);
        if (xpdls == null || xpdls.length == 0) {
            return null;
        }
        XPDLDO lastVersionDO = null;
        int maxVer = -1;
        for (int i = 0; i < xpdls.length; ++i) {
            String xpdlVer = xpdls[i].getXPDLVersion();
            int ver = Integer.parseInt(xpdlVer);
            if (ver <= maxVer) continue;
            maxVer = ver;
            lastVersionDO = xpdls[i];
        }
        if (lastVersionDO == null) {
            throw new Exception("Something is wrong in XPDL repository - can't determine XPDL version");
        }
        return lastVersionDO;
    }

    private XPDLHistoryDO getXPDLHistoryDO(DBTransaction dbt, String xpdlId, String xpdlVersion) throws Exception {
        XPDLHistoryQuery query = new XPDLHistoryQuery(dbt);
        query.setQueryXPDLId(xpdlId);
        query.setQueryXPDLVersion(xpdlVersion);
        query.requireUniqueInstance();
        XPDLHistoryDO DO = query.getNextDO();
        if (DO == null) {
            throw new Exception("There is no xpdl with Id=" + xpdlId + ", and version " + xpdlVersion + " in the history repository");
        }
        return DO;
    }
}

