/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.processlocking;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.internal.processlocking.LockMaster;
import org.enhydra.shark.api.internal.working.CallbackUtilities;

public class SimpleLockMaster
implements LockMaster {
    private static final String ENG_PARAM_NAME = "enginename";
    private static final String TOUT_PARM_NAME = "SimpleLockMaster.Timeout";
    private static final String LWT_PARAM_NAME = "SimpleLockMaster.LockWaitTime";
    private Long defaultTimeout = null;
    private Map locks = new HashMap();
    private long lockWaitTime;
    private CallbackUtilities callback;

    public void configure(CallbackUtilities cbImpl) throws RootException {
        if (null == cbImpl) {
            throw new RootException("Cannot configure without call back impl.");
        }
        this.callback = cbImpl;
        String lockMasterName = this.callback.getProperty(ENG_PARAM_NAME, "simpleLockMaster");
        this.defaultTimeout = new Long(this.callback.getProperty(TOUT_PARM_NAME, "-1"));
        this.lockWaitTime = Long.parseLong(this.callback.getProperty(LWT_PARAM_NAME, "100"));
        this.callback.debug(lockMasterName + " startup, timeout is " + this.defaultTimeout);
    }

    public boolean lock(SharkTransaction t, String processId, Long timeout) throws RootException {
        boolean ret = true;
        if (null != processId) {
            long limit;
            if (null == timeout) {
                timeout = this.defaultTimeout;
            }
            boolean checkTimeout = 0L < (limit = timeout.longValue());
            limit += System.currentTimeMillis();
            while (this.hasLock(processId)) {
                ret = false;
                try {
                    Thread.sleep(this.lockWaitTime);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (!checkTimeout || System.currentTimeMillis() <= limit) continue;
                RootException tme = new RootException("Timeout expired waiting on " + processId);
                this.callback.error("SimpleLockMaster", tme);
                throw tme;
            }
        }
        return ret;
    }

    public boolean lock(SharkTransaction t, String processId) throws RootException {
        return this.lock(t, processId, null);
    }

    public void unlock(SharkTransaction t, String processId) throws RootException {
        if (null != processId) {
            this.removeLock(processId);
        }
    }

    public synchronized void unlock(SharkTransaction t) throws RootException {
        List processLocks = this.retrieveLocks();
        if (null == processLocks) {
            throw new RootException("Transaction hasn't locked anything");
        }
        Iterator it = processLocks.iterator();
        while (it.hasNext()) {
            this.locks.remove(it.next());
        }
    }

    public List getLocks(SharkTransaction t) throws RootException {
        List transactionLocks = this.retrieveLocks();
        if (null == transactionLocks) {
            throw new RootException("Transaction hasn't locked anything");
        }
        return transactionLocks;
    }

    private synchronized List retrieveLocks() {
        ArrayList ret = new ArrayList();
        Set entries = this.locks.entrySet();
        Thread th = Thread.currentThread();
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            if (!th.equals(me.getValue())) continue;
            ret.add(me.getKey());
        }
        return ret;
    }

    private synchronized boolean hasLock(String processId) {
        Thread lockOwner = (Thread)this.locks.get(processId);
        if (null == lockOwner) {
            this.locks.put(processId, Thread.currentThread());
            return false;
        }
        return !lockOwner.equals(Thread.currentThread());
    }

    private synchronized void removeLock(String processId) throws RootException {
        Thread lockOwner = (Thread)this.locks.get(processId);
        if (!Thread.currentThread().equals(lockOwner)) {
            RootException tme = new RootException("Trying to unlock " + processId + " while it hasn't been locked ?!?");
            this.callback.error("SimpleLockMaster", tme);
            throw tme;
        }
        this.locks.remove(processId);
    }

    synchronized void info() {
        System.err.print(this.locks.size() + " locks ");
    }
}

