/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.enhydra.shark.BaseIteratorWrapper;
import org.enhydra.shark.SharkEngineManager;
import org.enhydra.shark.SharkUtilities;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfmodel.WfActivity;
import org.enhydra.shark.api.client.wfmodel.WfActivityIterator;
import org.enhydra.shark.api.internal.instancepersistence.ActivityPersistenceInterface;
import org.enhydra.shark.api.internal.instancepersistence.ActivityVariablePersistenceInterface;
import org.enhydra.shark.api.internal.instancepersistence.PersistentManagerInterface;
import org.enhydra.shark.api.internal.instancepersistence.ProcessPersistenceInterface;
import org.enhydra.shark.api.internal.instancepersistence.ProcessVariablePersistenceInterface;
import org.enhydra.shark.api.internal.scripting.Evaluator;
import org.enhydra.shark.api.internal.transaction.SharkInternalTransaction;

public class WfActivityIteratorWrapper
extends BaseIteratorWrapper
implements WfActivityIterator {
    private String procId;

    protected WfActivityIteratorWrapper(SharkTransaction t, String userAuth, String procId) throws BaseException {
        super(userAuth);
        this.procId = procId;
    }

    public WfActivity get_next_object() throws BaseException {
        WfActivity ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_next_object((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfActivity get_next_object(SharkTransaction t) throws BaseException {
        return (WfActivity)super.getNextObject(t);
    }

    public WfActivity get_previous_object() throws BaseException {
        WfActivity ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_previous_object((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfActivity get_previous_object(SharkTransaction t) throws BaseException {
        return (WfActivity)super.getPreviousObject(t);
    }

    public WfActivity[] get_next_n_sequence(int max_number) throws BaseException {
        WfActivity[] ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_next_n_sequence((SharkTransaction)t, max_number);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfActivity[] get_next_n_sequence(SharkTransaction t, int max_number) throws BaseException {
        List l = super.getNextNSequence(t, max_number);
        WfActivity[] ret = new WfActivity[l.size()];
        l.toArray(ret);
        return ret;
    }

    public WfActivity[] get_previous_n_sequence(int max_number) throws BaseException {
        WfActivity[] ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_previous_n_sequence((SharkTransaction)t, max_number);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfActivity[] get_previous_n_sequence(SharkTransaction t, int max_number) throws BaseException {
        List l = super.getPreviousNSequence(t, max_number);
        WfActivity[] ret = new WfActivity[l.size()];
        l.toArray(ret);
        return ret;
    }

    protected void fillObjectList(SharkTransaction t) throws BaseException {
        if (this.objectList != null) {
            return;
        }
        try {
            ArrayList<WfActivity> activities = new ArrayList<WfActivity>();
            PersistentManagerInterface ipm = SharkEngineManager.getInstance().getInstancePersistenceManager();
            String qemod = this.queryExpression;
            if (this.queryExpression.startsWith("QUERY_STATE_ONLY()")) {
                qemod = this.queryExpression.substring("QUERY_STATE_ONLY()".length());
            }
            ArrayList l = new ArrayList();
            if (null != this.sqlWhere) {
                l.addAll(ipm.getActivitiesWhere(t, this.sqlWhere));
            } else if (qemod.equals(this.queryExpression) || this.queryGrammar.equals("text/pythonscript")) {
                l.addAll(ipm.getAllActivitiesForProcess(this.procId, t));
            } else {
                String actState = null;
                if (qemod.indexOf("open.running") != -1) {
                    actState = "open.running";
                } else if (qemod.indexOf("open.not_running.not_started") != -1) {
                    actState = "open.not_running.not_started";
                } else if (qemod.indexOf("open.not_running.suspended") != -1) {
                    actState = "open.not_running.suspended";
                } else if (qemod.indexOf("closed.completed") != -1) {
                    actState = "closed.completed";
                } else if (qemod.indexOf("closed.aborted") != -1) {
                    actState = "closed.aborted";
                } else if (qemod.indexOf("closed.terminated") != -1) {
                    actState = "closed.terminated";
                }
                l.addAll(ipm.getActivitiesForProcess(this.procId, actState, t));
                this.eval = false;
            }
            Evaluator evaluator = SharkEngineManager.getInstance().getScriptingManager().getEvaluator(t, this.queryGrammar);
            for (int i = 0; i < l.size(); ++i) {
                ActivityPersistenceInterface po = (ActivityPersistenceInterface)l.get(i);
                boolean toAdd = true;
                if (this.eval) {
                    List ac;
                    Object value;
                    String name;
                    Iterator iter;
                    HashMap<String, Object> context = new HashMap<String, Object>();
                    ProcessPersistenceInterface ppo = null;
                    if (this.ignoreUsedContext || !this.ignoreUsedContext && 0 <= this.usedContext.indexOf("packageId")) {
                        ppo = ipm.restoreProcess(po.getProcessId(), t);
                        context.put("packageId", SharkUtilities.getProcessMgrVersion(ppo.getProcessMgrName()));
                    }
                    if (this.ignoreUsedContext || !this.ignoreUsedContext && 0 <= this.usedContext.indexOf("processDefinitionId")) {
                        if (null == ppo) {
                            ppo = ipm.restoreProcess(po.getProcessId(), t);
                        }
                        context.put("processDefinitionId", SharkUtilities.getProcessMgrProcDefId(ppo.getProcessMgrName()));
                    }
                    if (this.ignoreUsedContext || !this.ignoreUsedContext && 0 <= this.usedContext.indexOf("version")) {
                        if (null == ppo) {
                            ppo = ipm.restoreProcess(po.getProcessId(), t);
                        }
                        context.put("packageId", SharkUtilities.getProcessMgrPkgId(ppo.getProcessMgrName()));
                    }
                    if (this.ignoreUsedContext || !this.ignoreUsedContext && 0 <= this.usedContext.indexOf("mgrName")) {
                        if (null == ppo) {
                            ppo = ipm.restoreProcess(po.getProcessId(), t);
                        }
                        context.put("mgrName", ppo.getProcessMgrName());
                    }
                    if (this.ignoreUsedContext || !this.ignoreUsedContext && 0 <= this.usedContext.indexOf("pId")) {
                        context.put("pId", po.getProcessId());
                    }
                    if (this.ignoreUsedContext || !this.ignoreUsedContext && 0 <= this.usedContext.indexOf("pState")) {
                        if (null == ppo) {
                            ppo = ipm.restoreProcess(po.getProcessId(), t);
                        }
                        context.put("pState", ppo.getState());
                    }
                    if (this.ignoreUsedContext || !this.ignoreUsedContext && 0 <= this.usedContext.indexOf("requesterId")) {
                        if (null == ppo) {
                            ppo = ipm.restoreProcess(po.getProcessId(), t);
                        }
                        String reqId = ppo.getActivityRequesterId() != null ? ppo.getActivityRequesterId() : ppo.getResourceRequesterId();
                        context.put("requesterId", reqId);
                    }
                    if (this.queryExpression.indexOf("pContext_") != -1) {
                        List pc;
                        if (null == ppo) {
                            ppo = ipm.restoreProcess(po.getProcessId(), t);
                        }
                        if ((pc = ipm.getAllVariablesForProcess(ppo.getId(), t)) != null) {
                            iter = pc.iterator();
                            while (iter.hasNext()) {
                                ProcessVariablePersistenceInterface pvpo = (ProcessVariablePersistenceInterface)iter.next();
                                try {
                                    name = "pContext_" + pvpo.getDefinitionId();
                                    value = pvpo.getValue();
                                    context.put(name, value);
                                }
                                catch (Exception ex) {
                                    throw new BaseException((Throwable)ex);
                                }
                            }
                        }
                    }
                    if (this.ignoreUsedContext || !this.ignoreUsedContext && 0 <= this.usedContext.indexOf("state")) {
                        context.put("state", po.getState());
                    }
                    if (this.ignoreUsedContext || !this.ignoreUsedContext && 0 <= this.usedContext.indexOf("key")) {
                        context.put("key", po.getId());
                    }
                    if (this.ignoreUsedContext || !this.ignoreUsedContext && 0 <= this.usedContext.indexOf("name")) {
                        context.put("name", po.getName());
                    }
                    if (this.ignoreUsedContext || !this.ignoreUsedContext && 0 <= this.usedContext.indexOf("priority")) {
                        context.put("priority", new Integer(po.getPriority()));
                    }
                    if (this.ignoreUsedContext || !this.ignoreUsedContext && 0 <= this.usedContext.indexOf("description")) {
                        context.put("description", po.getDescription());
                    }
                    if (this.ignoreUsedContext || !this.ignoreUsedContext && 0 <= this.usedContext.indexOf("activitySetDefinitionId")) {
                        context.put("activitySetDefinitionId", po.getActivitySetDefinitionId());
                    }
                    if (this.ignoreUsedContext || !this.ignoreUsedContext && 0 <= this.usedContext.indexOf("definitionId")) {
                        context.put("definitionId", po.getActivityDefinitionId());
                    }
                    if (this.ignoreUsedContext || !this.ignoreUsedContext && 0 <= this.usedContext.indexOf("activatedTime_ms")) {
                        context.put("activatedTime_ms", new Long(po.getActivatedTime()));
                    }
                    if (this.ignoreUsedContext || !this.ignoreUsedContext && 0 <= this.usedContext.indexOf("lastStateTime_ms")) {
                        context.put("lastStateTime_ms", new Long(po.getLastStateTime()));
                    }
                    if (this.ignoreUsedContext || !this.ignoreUsedContext && 0 <= this.usedContext.indexOf("resourceUsername")) {
                        context.put("resourceUsername", po.getResourceUsername());
                    }
                    if (this.ignoreUsedContext || !this.ignoreUsedContext && 0 <= this.usedContext.indexOf("accepted")) {
                        context.put("accepted", new Boolean(po.getResourceUsername() != null));
                    }
                    if (this.ignoreUsedContext || !this.ignoreUsedContext && 0 <= this.usedContext.indexOf("acceptedTime_ms")) {
                        context.put("acceptedTime_ms", new Long(po.getAcceptedTime()));
                    }
                    if (this.queryExpression.indexOf("context_") != -1 && (ac = ipm.getAllVariablesForActivity(po.getId(), t)) != null) {
                        iter = ac.iterator();
                        while (iter.hasNext()) {
                            ActivityVariablePersistenceInterface avpo = (ActivityVariablePersistenceInterface)iter.next();
                            try {
                                name = "context_" + avpo.getDefinitionId();
                                value = avpo.getValue();
                                context.put(name, value);
                            }
                            catch (Exception ex) {
                                throw new BaseException((Throwable)ex);
                            }
                        }
                    }
                    toAdd = evaluator.evaluateCondition(t, this.queryExpression, context);
                }
                if (!toAdd) continue;
                activities.add(SharkEngineManager.getInstance().getObjectFactory().createActivityWrapper(this.userAuth, po.getProcessMgrName(), po.getProcessId(), po.getId()));
            }
            this.setObjectList(activities);
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }
}

