/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.enhydra.shark.SharkEngineManager;
import org.enhydra.shark.SharkUtilities;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.internal.transaction.SharkInternalTransaction;
import org.enhydra.shark.util.ResourceManager;
import org.enhydra.shark.xpdl.PackageValidator;
import org.enhydra.shark.xpdl.XMLCollectionElement;
import org.enhydra.shark.xpdl.XMLComplexElement;
import org.enhydra.shark.xpdl.XMLElement;
import org.enhydra.shark.xpdl.XMLInterface;
import org.enhydra.shark.xpdl.XMLUtil;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.ApplicationTypes;
import org.enhydra.shark.xpdl.elements.BasicType;
import org.enhydra.shark.xpdl.elements.DataField;
import org.enhydra.shark.xpdl.elements.DataType;
import org.enhydra.shark.xpdl.elements.DeclaredType;
import org.enhydra.shark.xpdl.elements.ExternalReference;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.Participant;
import org.enhydra.shark.xpdl.elements.Script;
import org.enhydra.shark.xpdl.elements.TypeDeclaration;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.enhydra.shark.xpdl.elements.WorkflowProcesses;

public class SharkPackageValidator
extends PackageValidator {
    private XMLInterface xpdlManager;

    public SharkPackageValidator(Package p, XMLInterface xpdlManager, boolean checkExternalPackages) {
        super(xpdlManager, p, true, checkExternalPackages, true, true);
        this.xpdlManager = xpdlManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkScript(boolean fullCheck) {
        boolean isValid = true;
        Script s = this.pkg.getScript();
        String sType = s.getType().trim();
        boolean isScriptInvalid = false;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            isScriptInvalid = SharkEngineManager.getInstance().getScriptingManager().getEvaluator((SharkTransaction)t, sType) == null;
        }
        catch (Exception ex) {
            isScriptInvalid = true;
        }
        finally {
            try {
                SharkUtilities.releaseTransaction((SharkTransaction)t);
            }
            catch (BaseException e) {}
        }
        if (isScriptInvalid) {
            isValid = false;
            Map les = this.getLogicErrors((XMLComplexElement)this.pkg);
            if (les != null) {
                les.put(this.pkg, ResourceManager.getLanguageDependentString("ErrorUnsupportedScriptLanguage"));
            }
        }
        return isValid;
    }

    public boolean checkDataType(XMLCollectionElement dfOrFp, boolean fullCheck) {
        boolean isValid = super.checkDataType(dfOrFp, fullCheck);
        if (isValid || fullCheck) {
            DataType xpdlType = (DataType)dfOrFp.get("DataType");
            XMLElement type = xpdlType.getDataTypes().getChoosen();
            if (type instanceof DeclaredType) {
                TypeDeclaration td = this.pkg.getTypeDeclaration(((DeclaredType)type).getId());
                isValid = this.checkTypeDeclaration(td, false);
            } else if (!(type instanceof BasicType) && !(type instanceof ExternalReference)) {
                isValid = false;
            }
            if (!isValid) {
                XMLElement firstOwner = dfOrFp.getParent().getParent();
                Map les = dfOrFp instanceof DataField ? this.getLogicErrors((XMLComplexElement)firstOwner) : (firstOwner instanceof ApplicationTypes ? this.getLogicErrors((XMLComplexElement)((ApplicationTypes)firstOwner).getParent().getParent().getParent()) : this.getLogicErrors((XMLComplexElement)firstOwner));
                String msg = (String)les.get(dfOrFp);
                msg = this.prepareMessageString(msg);
                msg = msg + ResourceManager.getLanguageDependentString("ErrorUnsupportedDataType");
                les.put(dfOrFp, msg);
            }
        }
        return isValid;
    }

    public boolean checkTypeDeclaration(TypeDeclaration td, boolean fullCheck) {
        boolean isValid = true;
        XMLElement choosenType = td.getDataTypes().getChoosen();
        if (!(choosenType instanceof BasicType) && !(choosenType instanceof ExternalReference)) {
            isValid = false;
        }
        if (choosenType instanceof DeclaredType) {
            TypeDeclaration td2 = this.pkg.getTypeDeclaration(((DeclaredType)choosenType).getId());
            isValid = this.checkTypeDeclaration(td2, fullCheck);
        }
        if (!isValid) {
            Map les = this.getLogicErrors((XMLComplexElement)this.pkg);
            String msg = ResourceManager.getLanguageDependentString("ErrorUnsupportedTypeDeclaration");
            les.put(td, msg);
        }
        return isValid;
    }

    public boolean validateAgainstXPDLSchema() {
        this.xpdlSchemaValidationErrors = this.xpdlManager.getParsingErrorMessages();
        return this.xpdlSchemaValidationErrors.size() <= 0;
    }

    public boolean checkExternalPackages(boolean fullCheck) {
        boolean isValid = true;
        Map les = this.getLogicErrors((XMLComplexElement)this.pkg);
        Iterator it = this.pkg.getExternalPackageIds().iterator();
        while (it.hasNext() && (fullCheck || isValid)) {
            Package p = this.xmlInterface.getPackageById((String)it.next());
            SharkPackageValidator pv = new SharkPackageValidator(p, this.xpdlManager, false);
            if (pv.validateAll(false)) continue;
            isValid = false;
            if (les == null) continue;
            les.put(p, ResourceManager.getLanguageDependentString("ErrorInvalidExternalPackage"));
        }
        return isValid;
    }

    public boolean isExternalPackageError() {
        List bgces = this.getBasicGraphConformanceErrors((XMLComplexElement)this.pkg);
        String bgce = this.getBasicGraphConnectionError((XMLComplexElement)this.pkg);
        String ble = this.getBasicLogicError((XMLComplexElement)this.pkg);
        String myPkgXmlFile = this.xpdlManager.getAbsoluteFilePath(this.pkg);
        Map scherrs = this.getXPDLSchemaValidationErrors();
        return (bgces == null || bgces.size() <= 0) && bgce == null && ble == null || (scherrs.size() <= 0 || !scherrs.containsKey(myPkgXmlFile)) && scherrs.size() != 0;
    }

    public boolean checkActivity(Activity act, boolean fullCheck) {
        boolean isValid = super.checkActivity(act, fullCheck);
        int type = act.getActivityType();
        if (type == 2 && act.getActivityTypes().getImplementation().getImplementationTypes().getTools().size() > 0) {
            isValid = this.checkStartMode(act) && isValid;
        }
        return isValid;
    }

    protected boolean checkStartMode(Activity toolAct) {
        String msg;
        Map les;
        boolean isValid = true;
        int startMode = toolAct.getActivityStartMode();
        String performer = toolAct.getPerformer().trim();
        boolean isSystemOrEmptyExpressionPerformer = false;
        Participant p = null;
        p = XMLUtil.getWorkflowProcess((XMLElement)toolAct).getParticipant(performer);
        if (p == null && (p = this.pkg.getParticipant(performer)) == null) {
            Package pk;
            List l = XMLUtil.getAllExternalPackageIds((XMLInterface)this.xmlInterface, (Package)this.pkg);
            Iterator ita = l.iterator();
            while (ita.hasNext() && ((pk = this.xmlInterface.getPackageById((String)ita.next())) == null || (p = pk.getParticipant(performer)) == null)) {
            }
        }
        if (p != null) {
            String participantType = p.getParticipantType().getType();
            if (participantType.equals("SYSTEM")) {
                isSystemOrEmptyExpressionPerformer = true;
            }
        } else if (performer.length() == 0) {
            isSystemOrEmptyExpressionPerformer = true;
        }
        if (isSystemOrEmptyExpressionPerformer && startMode == 1) {
            isValid = false;
            les = this.getLogicErrors((XMLComplexElement)toolAct.getParent().getParent());
            msg = (String)les.get(toolAct);
            msg = this.prepareMessageString(msg);
            msg = msg + ResourceManager.getLanguageDependentString("ErrorMANUALStartModeNotAllowedForToolActivitiesWithSystemParticipantOrEmptyExpressionPerformer");
            les.put(toolAct, msg);
        }
        if (!isSystemOrEmptyExpressionPerformer && startMode == 0) {
            isValid = false;
            les = this.getLogicErrors((XMLComplexElement)toolAct.getParent().getParent());
            msg = (String)les.get(toolAct);
            msg = this.prepareMessageString(msg);
            msg = msg + ResourceManager.getLanguageDependentString("ErrorAUTOMATICStartModeNotAllowedForToolActivitiesWithPerformerOtherThenSystemParticipantOrEmptyExpression");
            les.put(toolAct, msg);
        }
        return isValid;
    }

    public boolean checkActivityPerformer(Activity act, boolean fullCheck) {
        boolean isValid = super.checkActivityPerformer(act, fullCheck);
        String performer = act.getPerformer().trim();
        int type = act.getActivityType();
        if (type == 1 || type == 2 && act.getActivityTypes().getImplementation().getImplementationTypes().getTools().size() == 0) {
            String participantType;
            Participant p = null;
            WorkflowProcess wp = XMLUtil.getWorkflowProcess((XMLElement)act);
            p = wp.getParticipant(performer);
            if (p == null) {
                p = this.pkg.getParticipant(performer);
            }
            if (p != null && (participantType = p.getParticipantType().getType()).equals("SYSTEM")) {
                isValid = false;
                Map les = this.getLogicErrors((XMLComplexElement)act.getParent().getParent());
                String msg = (String)les.get(act);
                msg = this.prepareMessageString(msg);
                msg = msg + ResourceManager.getLanguageDependentString("ErrorNoImplementationActivityCannotHaveSystemParticipantPerformer");
                les.put(act, msg);
            }
        }
        return isValid;
    }

    public void printDebug() {
        System.err.println("SVEs=" + this.xpdlSchemaValidationErrors);
        System.err.println("GCEs=" + this.graphsConnectionErrors);
        System.err.println("BGCEs=" + this.basicGraphConnectionErrors);
        System.err.println("GCFEs=" + this.graphsConformanceErrors);
        System.err.println("BGCFEs=" + this.basicGraphsConformanceErrors);
        System.err.println("LEs=" + this.logicErrors);
        System.err.println("BLEs=" + this.basicLogicErrors);
    }

    public String createXPDLValidationErrorsString() {
        String errMsg = "<html>";
        try {
            errMsg = this.processErrors(this.xpdlSchemaValidationErrors, this.getGraphsConnectionErrors((XMLComplexElement)this.pkg), this.getBasicGraphConformanceErrors((XMLComplexElement)this.pkg), this.getGraphConformanceErrors((XMLComplexElement)this.pkg), this.getLogicErrors((XMLComplexElement)this.pkg), errMsg, (XMLComplexElement)this.pkg);
            WorkflowProcesses wps = this.pkg.getWorkflowProcesses();
            Iterator it = wps.toElements().iterator();
            while (it.hasNext()) {
                WorkflowProcess wp = (WorkflowProcess)it.next();
                errMsg = this.processErrors(null, this.getGraphsConnectionErrors((XMLComplexElement)wp), this.getBasicGraphConformanceErrors((XMLComplexElement)wp), this.getGraphConformanceErrors((XMLComplexElement)wp), this.getLogicErrors((XMLComplexElement)wp), errMsg, (XMLComplexElement)wp);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        errMsg = errMsg + "</html>";
        return errMsg;
    }

    protected String processErrors(Map parsingErrors, Map connectionErrors, List basicGraphConformanceErrors, Map graphConformanceErrors, Map logicErrors, String errMsg, XMLComplexElement pkgOrWpOrAs) {
        String msg;
        Object obj;
        String msg2;
        Map.Entry me;
        Iterator it;
        boolean packageLevelProcessing = pkgOrWpOrAs instanceof Package;
        String subtitle = "";
        if (packageLevelProcessing) {
            subtitle = XMLUtil.getLanguageDependentString((String)"XPDLSchemaKey");
            errMsg = errMsg + "<font size=6 face=\"sans-serif\" color=\"green\"><b><i><u>" + subtitle + "</u></i></b></font><br><br>";
            if (parsingErrors != null && parsingErrors.size() > 0) {
                it = parsingErrors.entrySet().iterator();
                while (it.hasNext()) {
                    me = it.next();
                    String pkgFile = (String)me.getKey();
                    Set errorsForPkg = (Set)me.getValue();
                    if (pkgFile.length() > 0) {
                        errMsg = errMsg + "<font size=5 face=\"sans-serif\" color=\"blue\"><b><i><u>" + pkgFile + "</u></i></b></font><br><br>";
                    }
                    errMsg = errMsg + "<font size=4 face=\"sans-serif\" color=\"#FF0000\"><i>";
                    Iterator it2 = errorsForPkg.iterator();
                    while (it2.hasNext()) {
                        String msg3 = it2.next().toString();
                        errMsg = errMsg + msg3 + "<br>";
                    }
                    errMsg = errMsg + "</i></font><br><br>";
                }
            }
            if (parsingErrors == null || parsingErrors.size() == 0) {
                msg2 = XMLUtil.getLanguageDependentString((String)"MessageThereAreNoXPDLSchemaValidationErrors");
                errMsg = errMsg + "<br><font size=4 face=\"sans-serif\" color=\"#0033CC\">" + msg2 + "</font><br><br>";
            }
        } else {
            errMsg = errMsg + "<p>";
        }
        if (packageLevelProcessing) {
            subtitle = XMLUtil.getLanguageDependentString((String)"PackageKey");
        } else if (pkgOrWpOrAs instanceof WorkflowProcess) {
            subtitle = XMLUtil.getLanguageDependentString((String)"WorkflowProcessKey");
        }
        errMsg = errMsg + "<font size=6 face=\"sans-serif\" color=\"black\"><b><i><u>" + subtitle + ":" + pkgOrWpOrAs.get("Id").toValue() + "</u></i></b></font><br><br>";
        errMsg = errMsg + "<p>";
        subtitle = XMLUtil.getLanguageDependentString((String)"ConnectionsKey");
        errMsg = errMsg + "<font size=5 face=\"sans-serif\" color=\"green\"><b><i><u>" + subtitle + "</u></i></b></font><br><br>";
        if (connectionErrors != null) {
            it = connectionErrors.entrySet().iterator();
            while (it.hasNext()) {
                me = it.next();
                obj = me.getKey();
                msg = me.getValue().toString();
                errMsg = errMsg + "<font size=4 face=\"sans-serif\" color=\"#0033CC\">";
                errMsg = this.appendErrorMessage(obj, errMsg, packageLevelProcessing);
                errMsg = errMsg + "<blockquote>";
                errMsg = errMsg + "<font size=\"4\" face=\"sans-serif\">";
                errMsg = errMsg + "<em>" + msg + "</em><br>";
                errMsg = errMsg + "</font></p></blockquote>";
            }
        }
        if (connectionErrors == null || connectionErrors.size() == 0) {
            msg2 = XMLUtil.getLanguageDependentString((String)"MessageAllElementsAreProperlyConnected");
            errMsg = errMsg + "<br><font size=4 face=\"sans-serif\" color=\"#0033CC\">" + msg2 + "</font><br><br>";
        }
        subtitle = XMLUtil.getLanguageDependentString((String)"GraphConformanceKey");
        errMsg = errMsg + "<font size=5 face=\"sans-serif\" color=\"green\"><b><i><u>" + subtitle + "</u></i></b></font><br>";
        if (basicGraphConformanceErrors != null) {
            it = basicGraphConformanceErrors.iterator();
            while (it.hasNext()) {
                String msg4 = (String)((Object)it.next());
                errMsg = errMsg + "<font size=4 face=\"sans-serif\" color=\"#FF0000\">" + msg4 + "</font>";
                errMsg = errMsg + "<br>";
            }
        }
        if (graphConformanceErrors != null && graphConformanceErrors.size() > 0) {
            errMsg = basicGraphConformanceErrors != null && basicGraphConformanceErrors.size() > 0 ? errMsg + "<br><br>" : errMsg + "<br>";
        }
        if (graphConformanceErrors != null) {
            it = graphConformanceErrors.entrySet().iterator();
            while (it.hasNext()) {
                me = it.next();
                obj = me.getKey();
                msg = me.getValue().toString();
                errMsg = errMsg + "<font size=4 face=\"sans-serif\" color=\"#0033CC\">";
                errMsg = this.appendErrorMessage(obj, errMsg, packageLevelProcessing);
                errMsg = errMsg + "<blockquote>";
                errMsg = errMsg + "<font size=\"4\" face=\"sans-serif\">";
                errMsg = errMsg + "<em>" + msg + "</em><br>";
                errMsg = errMsg + "</font></p></blockquote>";
            }
        }
        if (!(basicGraphConformanceErrors != null && basicGraphConformanceErrors.size() != 0 || graphConformanceErrors != null && graphConformanceErrors.size() != 0)) {
            msg2 = packageLevelProcessing ? XMLUtil.getLanguageDependentString((String)"MessagePackageGraphsConformsToTheGivenGraphConformanceClass") : XMLUtil.getLanguageDependentString((String)"MessageProcessGraphConformsToTheGivenGraphConformanceClass");
            errMsg = errMsg + "<br><font size=4 face=\"sans-serif\" color=\"#0033CC\">" + msg2 + "</font><br><br>";
        }
        if (basicGraphConformanceErrors != null && basicGraphConformanceErrors.size() > 0 && (graphConformanceErrors == null || graphConformanceErrors.size() == 0)) {
            errMsg = errMsg + "<br>";
        }
        subtitle = XMLUtil.getLanguageDependentString((String)"LogicKey");
        errMsg = errMsg + "<font size=5 face=\"sans-serif\" color=\"green\"><b><i><u>" + subtitle + "</u></i></b></font><br><br>";
        if (logicErrors != null) {
            it = logicErrors.entrySet().iterator();
            while (it.hasNext()) {
                me = it.next();
                obj = me.getKey();
                msg = me.getValue().toString();
                errMsg = errMsg + "<font size=4 face=\"sans-serif\" color=\"#0033CC\">";
                errMsg = this.appendErrorMessage(obj, errMsg, packageLevelProcessing);
                errMsg = errMsg + "<blockquote>";
                errMsg = errMsg + "<font size=\"4\" face=\"sans-serif\">";
                errMsg = errMsg + "<em>" + msg + "</em><br>";
                errMsg = errMsg + "</font></p></blockquote>";
            }
        }
        if (logicErrors == null || logicErrors.size() == 0) {
            msg2 = XMLUtil.getLanguageDependentString((String)"MessageThereAreNoLogicErrors");
            errMsg = errMsg + "<br><font size=4 face=\"sans-serif\" color=\"#0033CC\">" + msg2 + "</font><br><br>";
        }
        return errMsg;
    }

    private String appendErrorMessage(Object obj, String errMsg, boolean packageLevelProcessing) {
        if (obj instanceof XMLCollectionElement || obj instanceof Package) {
            XMLComplexElement xmlCe = (XMLComplexElement)obj;
            if (obj instanceof WorkflowProcess) {
                if (!packageLevelProcessing) {
                    return errMsg;
                }
                errMsg = errMsg + "<u><strong>" + XMLUtil.getLanguageDependentString((String)"ProcessKey") + ":</strong></u> </font>";
            } else {
                Activity act;
                errMsg = obj instanceof Activity ? ((act = (Activity)obj).getActivityType() == 3 ? errMsg + "<u><strong>" + XMLUtil.getLanguageDependentString((String)"SubFlowKey") + ":</strong></u> </font>" : (act.getActivityType() == 4 ? errMsg + "<u><strong>" + XMLUtil.getLanguageDependentString((String)"BlockActivityKey") + ":</strong></u> </font>" : (act.getActivityType() == 2 ? errMsg + "<u><strong>" + XMLUtil.getLanguageDependentString((String)"GenericKey") + ":</strong></u> </font>" : errMsg + "<u><strong>" + XMLUtil.getLanguageDependentString((String)"RouteKey") + ":</strong></u> </font>"))) : errMsg + "<u><strong>" + XMLUtil.getLanguageDependentString((String)(((XMLElement)obj).toName() + "Key")) + ":</strong></u> </font>";
            }
            try {
                errMsg = errMsg + "<font size=\"4\" face=\"sans-serif\">" + XMLUtil.getLanguageDependentString((String)"IdKey") + "= <font color=\"#FF0000\">" + xmlCe.get("Id").toValue() + "</font>, ";
                errMsg = errMsg + XMLUtil.getLanguageDependentString((String)"NameKey") + "= <font color=\"#FF0000\">" + xmlCe.get("Name").toValue() + "</font></font>";
            }
            catch (Exception ex) {}
        } else if (obj instanceof XMLElement) {
            errMsg = errMsg + "<u><strong>" + XMLUtil.getLanguageDependentString((String)(((XMLElement)obj).toName() + "Key")) + ":</strong></u> </font>";
        }
        return errMsg;
    }
}

