/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.enhydra.shark.Shark;
import org.enhydra.shark.SharkEngineManager;
import org.enhydra.shark.SharkPackageValidator;
import org.enhydra.shark.SharkUtilities;
import org.enhydra.shark.WfPackageEventAuditImpl;
import org.enhydra.shark.api.ApplicationMappingTransaction;
import org.enhydra.shark.api.ParticipantMappingTransaction;
import org.enhydra.shark.api.RepositoryTransaction;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfservice.ExternalPackageInvalid;
import org.enhydra.shark.api.client.wfservice.PackageAdministration;
import org.enhydra.shark.api.client.wfservice.PackageHasActiveProcesses;
import org.enhydra.shark.api.client.wfservice.PackageInUse;
import org.enhydra.shark.api.client.wfservice.PackageInvalid;
import org.enhydra.shark.api.client.wfservice.PackageUpdateNotAllowed;
import org.enhydra.shark.api.internal.appmappersistence.ApplicationMappingManager;
import org.enhydra.shark.api.internal.partmappersistence.ParticipantMap;
import org.enhydra.shark.api.internal.partmappersistence.ParticipantMappingManager;
import org.enhydra.shark.api.internal.repositorypersistence.RepositoryPersistenceManager;
import org.enhydra.shark.api.internal.transaction.SharkInternalTransaction;
import org.enhydra.shark.api.internal.working.CallbackUtilities;
import org.enhydra.shark.api.internal.working.WfProcessMgrInternal;
import org.enhydra.shark.xpdl.Version;
import org.enhydra.shark.xpdl.XMLInterface;
import org.enhydra.shark.xpdl.XMLInterfaceForJDK13;
import org.enhydra.shark.xpdl.XMLUtil;
import org.enhydra.shark.xpdl.elements.Application;
import org.enhydra.shark.xpdl.elements.Applications;
import org.enhydra.shark.xpdl.elements.ExternalPackage;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.Participant;
import org.enhydra.shark.xpdl.elements.Participants;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.enhydra.shark.xpdl.elements.WorkflowProcesses;

public class PackageAdmin
implements PackageAdministration {
    private XMLInterface xmlInterface = SharkEngineManager.getInstance().getXMLInterface();
    private CallbackUtilities cus = SharkEngineManager.getInstance().getCallbackUtilities();
    private RepositoryPersistenceManager repMgr = SharkEngineManager.getInstance().getRepositoryPersistenceManager();
    private String userId = "Unknown";

    protected PackageAdmin() {
    }

    public void connect(String userId) {
        this.userId = userId;
    }

    public XMLInterface getXMLInterface() {
        return this.xmlInterface;
    }

    public String[] getOpenedPackageIds() throws BaseException {
        String[] ret = null;
        RepositoryTransaction t = null;
        try {
            try {
                t = SharkUtilities.createRepositoryTransaction();
                ret = this.getOpenedPackageIds(t);
            }
            catch (RootException e) {
                if (e instanceof BaseException) {
                    throw (BaseException)e;
                }
                throw new BaseException((Throwable)e);
            }
        }
        finally {
            SharkUtilities.releaseRepositoryTransaction(t);
        }
        return ret;
    }

    public String[] getOpenedPackageIds(RepositoryTransaction t) throws BaseException {
        try {
            List pkgIds = this.repMgr.getExistingXPDLIds(t);
            Collections.sort(pkgIds);
            String[] ret = new String[pkgIds.size()];
            pkgIds.toArray(ret);
            return ret;
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public String[] getPackageVersions(String pkgId) throws BaseException {
        String[] ret = null;
        RepositoryTransaction t = null;
        try {
            try {
                t = SharkUtilities.createRepositoryTransaction();
                ret = this.getPackageVersions(t, pkgId);
            }
            catch (RootException e) {
                if (e instanceof BaseException) {
                    throw (BaseException)e;
                }
                throw new BaseException((Throwable)e);
            }
        }
        finally {
            SharkUtilities.releaseRepositoryTransaction(t);
        }
        return ret;
    }

    public String[] getPackageVersions(RepositoryTransaction t, String pkgId) throws BaseException {
        try {
            List pkgVers = this.repMgr.getXPDLVersions(t, pkgId);
            Collections.sort(pkgVers);
            String[] ret = new String[pkgVers.size()];
            pkgVers.toArray(ret);
            return ret;
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public boolean isPackageOpened(String pkgId) throws BaseException {
        boolean ret = false;
        RepositoryTransaction t = null;
        try {
            try {
                t = SharkUtilities.createRepositoryTransaction();
                ret = this.isPackageOpened(t, pkgId);
            }
            catch (RootException e) {
                if (e instanceof BaseException) {
                    throw (BaseException)e;
                }
                throw new BaseException((Throwable)e);
            }
        }
        finally {
            SharkUtilities.releaseRepositoryTransaction(t);
        }
        return ret;
    }

    public boolean isPackageOpened(RepositoryTransaction t, String pkgId) throws BaseException {
        try {
            return this.repMgr.doesXPDLExist(t, pkgId);
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public byte[] getPackageContent(String pkgId) throws BaseException {
        byte[] ret = null;
        RepositoryTransaction t = null;
        try {
            try {
                t = SharkUtilities.createRepositoryTransaction();
                ret = this.getPackageContent(t, pkgId);
            }
            catch (RootException e) {
                if (e instanceof BaseException) {
                    throw (BaseException)e;
                }
                throw new BaseException((Throwable)e);
            }
        }
        finally {
            SharkUtilities.releaseRepositoryTransaction(t);
        }
        return ret;
    }

    public byte[] getPackageContent(RepositoryTransaction t, String pkgId) throws BaseException {
        try {
            return PackageAdmin.convertSharkPackageContentXPDLByteArray(this.repMgr.getSerializedXPDLObject(t, pkgId));
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new BaseException(ex);
        }
    }

    public byte[] getPackageContent(String pkgId, String pkgVer) throws BaseException {
        byte[] ret = null;
        RepositoryTransaction t = null;
        try {
            try {
                t = SharkUtilities.createRepositoryTransaction();
                ret = this.getPackageContent(t, pkgId, pkgVer);
            }
            catch (RootException e) {
                if (e instanceof BaseException) {
                    throw (BaseException)e;
                }
                throw new BaseException((Throwable)e);
            }
        }
        finally {
            SharkUtilities.releaseRepositoryTransaction(t);
        }
        return ret;
    }

    public byte[] getPackageContent(RepositoryTransaction t, String pkgId, String pkgVer) throws BaseException {
        try {
            return PackageAdmin.convertSharkPackageContentXPDLByteArray(this.repMgr.getSerializedXPDLObject(t, pkgId, pkgVer));
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new BaseException(ex);
        }
    }

    public String getCurrentPackageVersion(String pkgId) throws BaseException {
        String ret = null;
        RepositoryTransaction t = null;
        try {
            try {
                t = SharkUtilities.createRepositoryTransaction();
                ret = this.getCurrentPackageVersion(t, pkgId);
            }
            catch (RootException e) {
                if (e instanceof BaseException) {
                    throw (BaseException)e;
                }
                throw new BaseException((Throwable)e);
            }
        }
        finally {
            SharkUtilities.releaseRepositoryTransaction(t);
        }
        return ret;
    }

    public String getCurrentPackageVersion(RepositoryTransaction t, String pkgId) throws BaseException {
        try {
            return this.repMgr.getCurrentVersion(t, pkgId);
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public String openPackage(String relativePath) throws BaseException, PackageInvalid, ExternalPackageInvalid {
        String ret = null;
        RepositoryTransaction t = null;
        try {
            try {
                t = SharkUtilities.createRepositoryTransaction();
                ret = this.openPackage(t, relativePath);
                SharkUtilities.commitRepositoryTransaction(t);
            }
            catch (RootException e) {
                SharkUtilities.rollbackRepositoryTransaction(t, e);
                if (e instanceof PackageInvalid) {
                    throw (PackageInvalid)e;
                }
                if (e instanceof ExternalPackageInvalid) {
                    throw (ExternalPackageInvalid)e;
                }
                if (e instanceof BaseException) {
                    throw (BaseException)e;
                }
                throw new BaseException((Throwable)e);
            }
        }
        finally {
            SharkUtilities.releaseRepositoryTransaction(t);
        }
        return ret;
    }

    public String openPackage(RepositoryTransaction t, String relativePath) throws BaseException, PackageInvalid, ExternalPackageInvalid {
        return this.openPackage(t, null, relativePath);
    }

    public void updatePackage(String id, String relativePathToNewPackage) throws BaseException, PackageUpdateNotAllowed, PackageInvalid, ExternalPackageInvalid {
        RepositoryTransaction t = null;
        try {
            try {
                t = SharkUtilities.createRepositoryTransaction();
                this.updatePackage(t, id, relativePathToNewPackage);
                SharkUtilities.commitRepositoryTransaction(t);
            }
            catch (RootException e) {
                SharkUtilities.rollbackRepositoryTransaction(t, e);
                if (e instanceof PackageUpdateNotAllowed) {
                    throw (PackageUpdateNotAllowed)e;
                }
                if (e instanceof PackageInvalid) {
                    throw (PackageInvalid)e;
                }
                if (e instanceof ExternalPackageInvalid) {
                    throw (ExternalPackageInvalid)e;
                }
                if (e instanceof BaseException) {
                    throw (BaseException)e;
                }
                throw new BaseException((Throwable)e);
            }
        }
        finally {
            SharkUtilities.releaseRepositoryTransaction(t);
        }
    }

    public void updatePackage(RepositoryTransaction t, String id, String relativePathToNewPackage) throws BaseException, PackageUpdateNotAllowed, PackageInvalid, ExternalPackageInvalid {
        if (id == null) {
            throw new BaseException("Invalid package Id");
        }
        this.openPackage(t, id, relativePathToNewPackage);
    }

    public void closePackage(String pkgId) throws BaseException, PackageInUse, PackageHasActiveProcesses {
        RepositoryTransaction t = null;
        try {
            try {
                t = SharkUtilities.createRepositoryTransaction();
                this.closePackage(t, pkgId);
                SharkUtilities.commitRepositoryTransaction(t);
            }
            catch (RootException e) {
                SharkUtilities.rollbackRepositoryTransaction(t, e);
                if (e instanceof PackageInUse) {
                    throw (PackageInUse)e;
                }
                if (e instanceof PackageHasActiveProcesses) {
                    throw (PackageHasActiveProcesses)e;
                }
                if (e instanceof BaseException) {
                    throw (BaseException)e;
                }
                throw new BaseException((Throwable)e);
            }
        }
        finally {
            SharkUtilities.releaseRepositoryTransaction(t);
        }
    }

    public synchronized void closePackage(RepositoryTransaction t, String pkgId) throws BaseException, PackageInUse, PackageHasActiveProcesses {
        this.cus.info("PackageAdmin -> User " + this.userId + " is trying to close all package versions of Package with id " + pkgId);
        try {
            Package pkg;
            String pkgVer;
            SharkUtilities.synchronizeXPDLCache(t);
            if (!this.repMgr.doesXPDLExist(t, pkgId)) {
                throw new BaseException("Package with Id=" + pkgId + " does not exist");
            }
            if (this.repMgr.getReferringXPDLIds(t, pkgId).size() > 0) {
                throw new PackageInUse("The package can't be unloaded because it is referenced");
            }
            List pkgVers = this.repMgr.getXPDLVersions(t, pkgId);
            String curVer = this.repMgr.getCurrentVersion(t, pkgId);
            Package curPkg = null;
            HashMap<String, Package> pkgs = new HashMap<String, Package>();
            int i = 0;
            while (i < pkgVers.size()) {
                String pkgVer2 = (String)pkgVers.get(i);
                Package pkg2 = SharkUtilities.getPackage(pkgId, pkgVer2);
                if (pkg2 == null) {
                    throw new BaseException("Package with Id=" + pkgId + " - something went wrong while getting XPDL object");
                }
                pkgs.put(pkgVer2, pkg2);
                if (pkgVer2.equals(curVer)) {
                    curPkg = pkg2;
                }
                ++i;
            }
            SharkInternalTransaction st = null;
            try {
                try {
                    st = SharkUtilities.createTransaction();
                    for (Map.Entry me : pkgs.entrySet()) {
                        pkgVer = (String)me.getKey();
                        pkg = (Package)me.getValue();
                        if (!this.checkDBProcesses((SharkTransaction)st, pkg, pkgId, pkgVer)) continue;
                        throw new PackageHasActiveProcesses("Can't remove package for which exists process instance in DB");
                    }
                }
                catch (Exception ex) {
                    SharkUtilities.emptyCaches((SharkTransaction)st);
                    throw ex;
                }
            }
            finally {
                SharkUtilities.releaseTransaction((SharkTransaction)st);
            }
            for (Map.Entry me : pkgs.entrySet()) {
                pkgVer = (String)me.getKey();
                pkg = (Package)me.getValue();
                this.repMgr.moveToHistory(t, pkgId, pkgVer);
                WfPackageEventAuditImpl pea = new WfPackageEventAuditImpl(pkg, "packageUnloaded", this.userId);
                this.xmlInterface.closePackageVersion(pkgId, pkgVer);
            }
            this.removeParticipantMappingsForPackage(curPkg);
            this.removeApplicationMappingsForPackage(curPkg);
            this.removeManagersForPackages(pkgs.values());
            this.cus.info("PackageAdmin -> User " + this.userId + " has closed Package with id " + pkgId);
        }
        catch (Exception ex) {
            this.cus.warn("PackageAdmin -> User " + this.userId + " failed to close the Package with id " + pkgId + " because it is in use");
            if (ex instanceof BaseException) {
                throw (BaseException)ex;
            }
            if (ex instanceof PackageInUse) {
                throw (PackageInUse)ex;
            }
            if (ex instanceof PackageHasActiveProcesses) {
                throw (PackageHasActiveProcesses)ex;
            }
            throw new BaseException((Throwable)ex);
        }
    }

    public void closePackage(String pkgId, String pkgVer) throws BaseException, PackageInUse, PackageHasActiveProcesses {
        RepositoryTransaction t = null;
        try {
            try {
                t = SharkUtilities.createRepositoryTransaction();
                this.closePackage(t, pkgId, pkgVer);
                SharkUtilities.commitRepositoryTransaction(t);
            }
            catch (RootException e) {
                SharkUtilities.rollbackRepositoryTransaction(t, e);
                if (e instanceof PackageInUse) {
                    throw (PackageInUse)e;
                }
                if (e instanceof PackageHasActiveProcesses) {
                    throw (PackageHasActiveProcesses)e;
                }
                if (e instanceof BaseException) {
                    throw (BaseException)e;
                }
                throw new BaseException((Throwable)e);
            }
        }
        finally {
            SharkUtilities.releaseRepositoryTransaction(t);
        }
    }

    public synchronized void closePackage(RepositoryTransaction t, String pkgId, String pkgVer) throws BaseException, PackageInUse, PackageHasActiveProcesses {
        this.cus.info("PackageAdmin -> User " + this.userId + " is trying to close Package with id " + pkgId + ", and version " + pkgVer);
        try {
            boolean dpe;
            SharkUtilities.synchronizeXPDLCache(t);
            if (!this.repMgr.doesXPDLExist(t, pkgId, pkgVer)) {
                throw new BaseException("Package with Id=" + pkgId + " and version=" + pkgVer + " does not exist");
            }
            int hm = this.repMgr.getXPDLVersions(t, pkgId).size();
            Package pkg = SharkUtilities.getPackage(pkgId, pkgVer);
            if (pkg == null) {
                throw new BaseException("Package with Id=" + pkgId + " - something went wrong while getting XPDL object");
            }
            String curVer = this.repMgr.getCurrentVersion(t, pkgId);
            if (this.repMgr.getReferringXPDLIds(t, pkgId).size() > 0 && pkgVer.equals(curVer)) {
                throw new PackageInUse("The package can't be unloaded because it is referenced");
            }
            SharkInternalTransaction st = null;
            try {
                try {
                    st = SharkUtilities.createTransaction();
                    dpe = this.checkDBProcesses((SharkTransaction)st, pkg, pkgId, pkgVer);
                }
                catch (Exception ex) {
                    SharkUtilities.emptyCaches((SharkTransaction)st);
                    throw ex;
                }
            }
            finally {
                SharkUtilities.releaseTransaction((SharkTransaction)st);
            }
            if (dpe) {
                throw new PackageHasActiveProcesses("Can't remove package with processes instances in DB");
            }
            this.repMgr.moveToHistory(t, pkgId, pkgVer);
            WfPackageEventAuditImpl pea = new WfPackageEventAuditImpl(pkg, "packageUnloaded", this.userId);
            this.xmlInterface.closePackageVersion(pkgId, pkgVer);
            if (hm == 1) {
                this.removeParticipantMappingsForPackage(pkg);
                this.removeApplicationMappingsForPackage(pkg);
            }
            this.removeManagersForPackage(pkg);
            this.cus.info("PackageAdmin -> User " + this.userId + " has closed Package with id " + pkgId + " and version " + pkgVer);
        }
        catch (Exception ex) {
            this.cus.warn("PackageAdmin -> User " + this.userId + " failed to close the Package with id " + pkgId + " and version " + pkgVer + " because it is in use");
            if (ex instanceof BaseException) {
                throw (BaseException)ex;
            }
            if (ex instanceof PackageInUse) {
                throw (PackageInUse)ex;
            }
            if (ex instanceof PackageHasActiveProcesses) {
                throw (PackageHasActiveProcesses)ex;
            }
            throw new BaseException((Throwable)ex);
        }
    }

    private boolean checkDBProcesses(SharkTransaction st, Package pkg, String pkgId, String pkgVer) throws Exception {
        for (WorkflowProcess wp : ((WorkflowProcesses)pkg.get("WorkflowProcesses")).toElements()) {
            String mgrName = SharkUtilities.createProcessMgrKey(pkgId, pkgVer, wp.getId());
            WfProcessMgrInternal mgr = SharkUtilities.getProcessMgr(st, mgrName);
            List procs = SharkEngineManager.getInstance().getInstancePersistenceManager().getAllProcessesForMgr(mgrName, st);
            if (procs == null || procs.size() <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean isPackageReferenced(String pkgId) throws BaseException {
        boolean ret = false;
        RepositoryTransaction t = null;
        try {
            try {
                t = SharkUtilities.createRepositoryTransaction();
                ret = this.isPackageReferenced(t, pkgId);
            }
            catch (RootException e) {
                if (e instanceof BaseException) {
                    throw (BaseException)e;
                }
                throw new BaseException((Throwable)e);
            }
        }
        finally {
            SharkUtilities.releaseRepositoryTransaction(t);
        }
        return ret;
    }

    public boolean isPackageReferenced(RepositoryTransaction t, String pkgId) throws BaseException {
        try {
            return this.repMgr.getReferringXPDLIds(t, pkgId).size() > 0;
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public void synchronizeXPDLCache() throws BaseException {
        RepositoryTransaction t = null;
        try {
            try {
                t = SharkUtilities.createRepositoryTransaction();
                this.synchronizeXPDLCache(t);
            }
            catch (RootException e) {
                if (e instanceof BaseException) {
                    throw (BaseException)e;
                }
                throw new BaseException((Throwable)e);
            }
        }
        finally {
            SharkUtilities.releaseRepositoryTransaction(t);
        }
    }

    public synchronized void synchronizeXPDLCache(RepositoryTransaction t) throws BaseException {
        SharkUtilities.synchronizeXPDLCache(t);
    }

    public void clearXPDLCache() throws BaseException {
        try {
            SharkUtilities.clearProcessCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.xmlInterface.closeAllPackages();
    }

    public synchronized void clearXPDLCache(RepositoryTransaction t) throws BaseException {
        try {
            SharkUtilities.clearProcessCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.xmlInterface.closeAllPackages();
    }

    public void refreshXPDLCache() throws BaseException {
        RepositoryTransaction t = null;
        try {
            try {
                t = SharkUtilities.createRepositoryTransaction();
                this.refreshXPDLCache(t);
            }
            catch (RootException e) {
                if (e instanceof BaseException) {
                    throw (BaseException)e;
                }
                throw new BaseException((Throwable)e);
            }
        }
        finally {
            SharkUtilities.releaseRepositoryTransaction(t);
        }
    }

    public synchronized void refreshXPDLCache(RepositoryTransaction t) throws BaseException {
        try {
            SharkUtilities.clearProcessCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.xmlInterface.closeAllPackages();
        SharkUtilities.synchronizeXPDLCache(t);
    }

    /*
     * Unable to fully structure code
     */
    private synchronized String openPackage(RepositoryTransaction t, String id, String relativePath) throws BaseException, PackageInvalid, ExternalPackageInvalid {
        block30: {
            v0 = update = id != null;
            if (update) {
                this.cus.info("PackageAdmin -> Trying to update Package with id=" + id + " with content of file at " + relativePath);
            } else {
                this.cus.info("PackageAdmin -> Trying to open Package file " + relativePath);
            }
            exceptionHappened = 0;
            xpdlManager = new XMLInterfaceForJDK13();
            pkgId = null;
            pkgInfo = new HashMap<K, V>();
            relativePath = XMLUtil.convertToSystemPath((String)relativePath);
            try {
                block31: {
                    try {
                        pkgId = Shark.getInstance().getRepositoryManager().getPackageId(relativePath);
                        if (id != null && !id.equals(pkgId)) {
                            msg = "The package at path=" + relativePath + " does not have the id=" + id;
                            this.cus.warn("PackageAdmin -> " + msg);
                            bex = new BaseException(msg);
                            throw bex;
                        }
                        currentPkgIds = new HashSet<E>(this.repMgr.getExistingXPDLIds(t));
                        if (id != null && !currentPkgIds.contains(pkgId)) {
                            msg = "The package with id " + pkgId + " is not open";
                            this.cus.warn("PackageAdmin -> " + msg);
                            bex = new BaseException(msg);
                            throw bex;
                        }
                        if (id == null && currentPkgIds.contains(pkgId)) {
                            msg = "The package with id " + pkgId + " is already open";
                            this.cus.warn("PackageAdmin -> " + msg);
                            bex = new BaseException(msg);
                            throw bex;
                        }
                        pkgVersion = this.repMgr.getNextVersion(t, pkgId);
                        relativePath = SharkUtilities.convertToAbsolutePath(relativePath);
                        pkg = xpdlManager.openPackage(relativePath, true);
                        pkg.setInternalVersion(pkgVersion);
                        pv = new SharkPackageValidator(pkg, (XMLInterface)xpdlManager, true);
                        xpdlValidationErrors = "";
                        if (pkg == null || !pv.validateAll(true)) {
                            this.cus.info("PackageAdmin -> Package file " + relativePath + " failed to open");
                            xpdlValidationErrors = pkg != null ? pv.createXPDLValidationErrorsString() : "Fatal error while opening package from ext. rep.";
                            if (pkg == null) {
                                exceptionHappened = 1;
                                throw new PackageInvalid(xpdlValidationErrors, "No package");
                            }
                            if (pv.isExternalPackageError()) {
                                exceptionHappened = 2;
                                throw new ExternalPackageInvalid(xpdlValidationErrors, "Error in external package");
                            }
                            exceptionHappened = 1;
                            throw new PackageInvalid(xpdlValidationErrors, "Error in package");
                        }
                        SharkUtilities.synchronizeXPDLCache(t);
                        chckExt = this.adjustPkgsForInternalRep(t, (XMLInterface)xpdlManager, pkgInfo, pkgId, update);
                        if (chckExt) {
                            xpdlManager.closeAllPackages();
                            pkgContents = new ArrayList<byte[]>();
                            for (PkgInfo pi : pkgInfo.values()) {
                                if (pi.isForUpload()) {
                                    pkgContents.add(pi.getByteContent());
                                    continue;
                                }
                                pkgContents.add(this.repMgr.getSerializedXPDLObject(t, pi.getId(), pi.getVersion()));
                            }
                            xpdlManager.setValidation(false);
                            pkg = xpdlManager.openPackagesFromStreams(pkgContents, false);
                            xpdlManager.setValidation(true);
                            pv = new SharkPackageValidator(pkg, (XMLInterface)xpdlManager, true);
                            xpdlValidationErrors = "";
                            if (pkg == null || !pv.validateAll(true)) {
                                this.cus.info("PackageAdmin -> Package file " + relativePath + " failed to open");
                                xpdlValidationErrors = pkg != null ? pv.createXPDLValidationErrorsString() : "Fatal error while opening package";
                                if (pkg == null) {
                                    exceptionHappened = 1;
                                    throw new PackageInvalid(xpdlValidationErrors, "No package");
                                }
                                if (pv.isExternalPackageError()) {
                                    this.cus.warn("PackageAdmin -> there is some external package with the same Id and different content as the one of already opened packages - failed to open");
                                    exceptionHappened = 2;
                                    throw new ExternalPackageInvalid("There is some external package with the same Id and different content as the one of already opened packages - failed to open", "Error with ext. package");
                                }
                                exceptionHappened = 1;
                                throw new PackageInvalid(xpdlValidationErrors, "Error in package");
                            }
                        }
                        xpdlManager.closeAllPackages();
                        exceptionHappened = 3;
                        this.copyPackagesToInternalPackagesRepository(t, pkgInfo.values());
                        SharkUtilities.synchronizeXPDLCache(t);
                        it = pkgInfo.values().iterator();
                        pkgsToUpload = new HashSet<Package>();
                        while (it.hasNext()) {
                            pinf = (PkgInfo)it.next();
                            if (!pinf.isForUpload()) continue;
                            p = this.xmlInterface.getPackageByIdAndVersion(pinf.getId(), pinf.getVersion());
                            evType = "packageLoaded";
                            if (update && pinf.getId().equals(id)) {
                                evType = "packageUpdated";
                            }
                            new WfPackageEventAuditImpl(p, evType, this.userId);
                            pkgsToUpload.add(p);
                        }
                        this.addManagersForPackages(pkgsToUpload);
                        break block30;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        this.cus.error("PackageAdmin -> Package file " + relativePath + " failed to open");
                        if (exceptionHappened == 0) {
                            if (ex instanceof BaseException) {
                                throw (BaseException)ex;
                            }
                            throw new BaseException((Throwable)ex);
                        }
                        if (exceptionHappened == 1) {
                            throw (PackageInvalid)ex;
                        }
                        if (exceptionHappened == 2) {
                            throw (ExternalPackageInvalid)ex;
                        }
                        if (pkgInfo == null) break block31;
                        ** for (pi : pkgInfo.values())
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            this.xmlInterface.closePackageVersion(pi.getId(), pi.getVersion());
                        }
                        catch (Exception var12_22) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                throw new BaseException((Throwable)ex);
            }
            finally {
                xpdlManager.closeAllPackages();
            }
        }
        if (update) {
            this.cus.info("PackageAdmin -> Package with id=" + pkgId + " is updated from a file " + relativePath);
        } else {
            this.cus.info("PackageAdmin -> Package with id=" + pkgId + " is opened from a file " + relativePath);
        }
        return pkgId;
    }

    private void addManagersForPackages(Collection pkgInfo) throws Exception {
        SharkInternalTransaction t = null;
        try {
            try {
                t = SharkUtilities.createTransaction();
                for (Package p : pkgInfo) {
                    String pkgId = p.getId();
                    String pkgVer = p.getInternalVersion();
                    WorkflowProcesses wps = p.getWorkflowProcesses();
                    for (WorkflowProcess wp : wps.toElements()) {
                        WfProcessMgrInternal mgrInternal = SharkEngineManager.getInstance().getObjectFactory().createProcessMgr((SharkTransaction)t, pkgId, pkgVer, wp.getId());
                        this.cus.info("PackageAdmin -> ProcessDefinition " + wp.getId() + " for package " + p.getId() + " is added");
                    }
                }
                SharkUtilities.commitTransaction((SharkTransaction)t);
            }
            catch (Exception e) {
                BaseException be = null;
                be = e instanceof BaseException ? (BaseException)e : new BaseException((Throwable)e);
                SharkUtilities.rollbackTransaction((SharkTransaction)t, (RootException)be);
                throw e;
            }
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    private void copyPackagesToInternalPackagesRepository(RepositoryTransaction t, Collection pkgInfo) throws Exception {
        for (PkgInfo pi : pkgInfo) {
            if (!pi.isForUpload()) continue;
            this.repMgr.uploadXPDL(t, pi.getId(), pi.getXPDLContent(), pi.getByteContent(), Version.getVersion());
        }
        for (PkgInfo pi : pkgInfo) {
            if (!pi.isForUpload()) continue;
            Iterator it = pi.getExtRefIds().iterator();
            int i = 0;
            while (it.hasNext()) {
                this.repMgr.addXPDLReference(t, (String)it.next(), pi.getId(), pi.getVersion(), i++);
            }
        }
    }

    private void removeManagersForPackage(Package pkg) throws Exception {
        if (pkg != null) {
            SharkInternalTransaction t = null;
            try {
                try {
                    t = SharkUtilities.createTransaction();
                    WorkflowProcesses wps = pkg.getWorkflowProcesses();
                    for (WorkflowProcess wp : wps.toElements()) {
                        WfProcessMgrInternal toRem = SharkUtilities.getProcessMgr((SharkTransaction)t, SharkUtilities.createProcessMgrKey(pkg.getId(), pkg.getInternalVersion(), wp.getId()));
                        if (toRem == null) continue;
                        toRem.delete((SharkTransaction)t);
                        this.cus.info("PackageAdmin -> ProcessDefinition " + wp.getId() + " for package " + pkg.getId() + " is removed");
                    }
                    SharkUtilities.commitTransaction((SharkTransaction)t);
                }
                catch (Exception ex) {
                    BaseException be = null;
                    be = ex instanceof BaseException ? (BaseException)ex : new BaseException((Throwable)ex);
                    SharkUtilities.rollbackTransaction((SharkTransaction)t, (RootException)be);
                    throw ex;
                }
            }
            finally {
                SharkUtilities.releaseTransaction((SharkTransaction)t);
            }
        }
    }

    private void removeManagersForPackages(Collection pkgs) throws Exception {
        if (pkgs != null) {
            SharkInternalTransaction t = null;
            try {
                try {
                    t = SharkUtilities.createTransaction();
                    for (Package pkg : pkgs) {
                        WorkflowProcesses wps = (WorkflowProcesses)pkg.get("WorkflowProcesses");
                        for (WorkflowProcess wp : wps.toElements()) {
                            WfProcessMgrInternal toRem = SharkUtilities.getProcessMgr((SharkTransaction)t, SharkUtilities.createProcessMgrKey(pkg.getId(), pkg.getInternalVersion(), wp.getId()));
                            if (toRem == null) continue;
                            toRem.delete((SharkTransaction)t);
                            this.cus.info("PackageAdmin -> ProcessDefinition " + wp.getId() + " for package " + pkg.getId() + " is removed");
                        }
                    }
                    SharkUtilities.commitTransaction((SharkTransaction)t);
                }
                catch (Exception ex) {
                    BaseException be = null;
                    be = ex instanceof BaseException ? (BaseException)ex : new BaseException((Throwable)ex);
                    SharkUtilities.rollbackTransaction((SharkTransaction)t, (RootException)be);
                    throw ex;
                }
            }
            finally {
                SharkUtilities.releaseTransaction((SharkTransaction)t);
            }
        }
    }

    private void removeParticipantMappingsForPackage(Package pkg) throws Exception {
        ParticipantMappingManager pms = SharkEngineManager.getInstance().getParticipantMapPersistenceManager();
        if (pms == null) {
            return;
        }
        ParticipantMappingTransaction t = null;
        try {
            try {
                t = SharkUtilities.createParticipantMappingTransaction();
                Participants ps = pkg.getParticipants();
                for (Participant p : ps.toElements()) {
                    pms.deleteParticipantMappings(t, pkg.getId(), null, p.getId());
                }
                for (WorkflowProcess wp : pkg.getWorkflowProcesses().toElements()) {
                    String wpId = wp.getId();
                    ps = wp.getParticipants();
                    for (Participant p : ps.toElements()) {
                        ParticipantMap pm = pms.createParticipantMap();
                        pm.setPackageId(pkg.getId());
                        pm.setProcessDefinitionId(wpId);
                        pm.setParticipantId(p.getId());
                        pms.deleteParticipantMappings(t, pkg.getId(), wpId, p.getId());
                    }
                }
                this.cus.info("PackageAdmin -> Participant mappings for package " + pkg + " are removed");
                SharkUtilities.commitMappingTransaction(t);
            }
            catch (RootException e) {
                SharkUtilities.rollbackMappingTransaction(t, e);
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            SharkUtilities.releaseMappingTransaction(t);
        }
    }

    private void removeApplicationMappingsForPackage(Package pkg) throws Exception {
        ApplicationMappingManager ams = SharkEngineManager.getInstance().getApplicationMapPersistenceManager();
        if (ams == null) {
            return;
        }
        ApplicationMappingTransaction t = null;
        try {
            try {
                t = SharkUtilities.createApplicationMappingTransaction();
                Applications apps = pkg.getApplications();
                for (Application app : apps.toElements()) {
                    if (ams.getApplicationMap(t, pkg.getId(), "", app.getId()) == null) continue;
                    ams.deleteApplicationMapping(t, pkg.getId(), null, app.getId());
                }
                for (WorkflowProcess wp : pkg.getWorkflowProcesses().toElements()) {
                    String wpId = wp.getId();
                    apps = wp.getApplications();
                    for (Application app : apps.toElements()) {
                        if (ams.getApplicationMap(t, pkg.getId(), wpId, app.getId()) == null) continue;
                        ams.deleteApplicationMapping(t, pkg.getId(), wpId, app.getId());
                    }
                }
                this.cus.info("PackageAdmin -> Application mappings for package " + pkg + " are removed");
                SharkUtilities.commitMappingTransaction(t);
            }
            catch (RootException e) {
                SharkUtilities.rollbackMappingTransaction(t, e);
                throw e;
            }
        }
        finally {
            SharkUtilities.releaseMappingTransaction(t);
        }
    }

    private boolean adjustPkgsForInternalRep(RepositoryTransaction t, XMLInterface xpdlMgr, Map pkgInfo, String mainPkgId, boolean update) throws Exception {
        boolean chckExt = false;
        HashSet pkgsToAdjust = new HashSet(xpdlMgr.getAllPackages());
        for (Package p : pkgsToAdjust) {
            String pkgId = p.getId();
            String version = null;
            boolean forUpl = false;
            if (!this.repMgr.doesXPDLExist(t, pkgId) || update && pkgId.equals(mainPkgId)) {
                version = this.repMgr.getNextVersion(t, pkgId);
                forUpl = true;
            } else {
                version = this.repMgr.getCurrentVersion(t, pkgId);
                chckExt = true;
            }
            p.setInternalVersion(version);
            PkgInfo pInfo = new PkgInfo(p, version, forUpl);
            pkgInfo.put(pkgId, pInfo);
        }
        return chckExt;
    }

    public static byte[] convertSharkPackageContentXPDLByteArray(byte[] sharkPkgBytes) throws Exception {
        Package shrkPkg = (Package)XMLUtil.deserialize((byte[])sharkPkgBytes);
        shrkPkg.setReadOnly(false);
        for (ExternalPackage ep : shrkPkg.getExternalPackages().toElements()) {
            String nhref = shrkPkg.getExternalPackageId(ep.getHref());
            ep.setHref(nhref);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        XMLUtil.packageToStream((Package)shrkPkg, (OutputStream)os);
        byte[] content = os.toByteArray();
        os.close();
        return content;
    }

    class PkgInfo {
        private Package pkg;
        private String version;
        private boolean isForUpload;
        private byte[] content;
        private byte[] xpdlContent;

        public PkgInfo(Package pkg, String version, boolean isForUpload) throws Exception {
            this.pkg = pkg;
            this.version = version;
            this.isForUpload = isForUpload;
            if (isForUpload) {
                pkg.setReadOnly(true);
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                XMLUtil.packageToStream((Package)pkg, (OutputStream)os);
                this.xpdlContent = os.toByteArray();
                os.close();
            }
            this.content = XMLUtil.serialize((Object)pkg);
        }

        public Package getPackage() {
            return this.pkg;
        }

        public void setPackage(Package pkg) {
            this.pkg = pkg;
        }

        public String getId() {
            return this.pkg.getId();
        }

        public String getVersion() {
            return this.version;
        }

        public Collection getExtRefIds() {
            return this.pkg.getExternalPackageIds();
        }

        public byte[] getXPDLContent() {
            return this.xpdlContent;
        }

        public byte[] getByteContent() {
            return this.content;
        }

        public boolean isForUpload() {
            return this.isForUpload;
        }

        public String toString() {
            return "PKG=" + this.pkg + ",Id=" + this.pkg.getId() + ",isForUpl=" + this.isForUpload + "]";
        }
    }
}

