/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.enhydra.shark.SharkEngineManager;
import org.enhydra.shark.SharkUtilities;
import org.enhydra.shark.WfDefaultRequester;
import org.enhydra.shark.WfExecutionObjectImpl;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.TransactionException;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfmodel.AlreadyRunning;
import org.enhydra.shark.api.client.wfmodel.AlreadySuspended;
import org.enhydra.shark.api.client.wfmodel.CannotReopen;
import org.enhydra.shark.api.client.wfmodel.CannotResume;
import org.enhydra.shark.api.client.wfmodel.CannotStart;
import org.enhydra.shark.api.client.wfmodel.CannotStop;
import org.enhydra.shark.api.client.wfmodel.CannotSuspend;
import org.enhydra.shark.api.client.wfmodel.InvalidData;
import org.enhydra.shark.api.client.wfmodel.InvalidPerformer;
import org.enhydra.shark.api.client.wfmodel.InvalidState;
import org.enhydra.shark.api.client.wfmodel.NotRunning;
import org.enhydra.shark.api.client.wfmodel.NotSuspended;
import org.enhydra.shark.api.client.wfmodel.ResultNotAvailable;
import org.enhydra.shark.api.client.wfmodel.TransitionNotAllowed;
import org.enhydra.shark.api.client.wfmodel.UpdateNotAllowed;
import org.enhydra.shark.api.client.wfmodel.WfEventAudit;
import org.enhydra.shark.api.client.wfmodel.WfRequester;
import org.enhydra.shark.api.client.wfmodel.WfStateEventAudit;
import org.enhydra.shark.api.internal.instancepersistence.ActivityPersistenceInterface;
import org.enhydra.shark.api.internal.instancepersistence.AndJoinEntryInterface;
import org.enhydra.shark.api.internal.instancepersistence.PersistenceException;
import org.enhydra.shark.api.internal.instancepersistence.PersistentManagerInterface;
import org.enhydra.shark.api.internal.instancepersistence.ProcessPersistenceInterface;
import org.enhydra.shark.api.internal.instancepersistence.ProcessVariablePersistenceInterface;
import org.enhydra.shark.api.internal.limitagent.LimitAgentException;
import org.enhydra.shark.api.internal.limitagent.LimitAgentManager;
import org.enhydra.shark.api.internal.scripting.Evaluator;
import org.enhydra.shark.api.internal.toolagent.ToolAgentGeneralException;
import org.enhydra.shark.api.internal.working.WfActivityInternal;
import org.enhydra.shark.api.internal.working.WfCreateProcessEventAuditInternal;
import org.enhydra.shark.api.internal.working.WfDataEventAuditInternal;
import org.enhydra.shark.api.internal.working.WfExecutionObjectInternal;
import org.enhydra.shark.api.internal.working.WfProcessInternal;
import org.enhydra.shark.api.internal.working.WfProcessMgrInternal;
import org.enhydra.shark.api.internal.working.WfRequesterInternal;
import org.enhydra.shark.utilities.MiscUtilities;
import org.enhydra.shark.xpdl.XMLCollectionElement;
import org.enhydra.shark.xpdl.XMLElement;
import org.enhydra.shark.xpdl.XMLUtil;
import org.enhydra.shark.xpdl.elements.Activities;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.ActivitySet;
import org.enhydra.shark.xpdl.elements.BlockActivity;
import org.enhydra.shark.xpdl.elements.Condition;
import org.enhydra.shark.xpdl.elements.ExtendedAttribute;
import org.enhydra.shark.xpdl.elements.ProcessHeader;
import org.enhydra.shark.xpdl.elements.Transition;
import org.enhydra.shark.xpdl.elements.Transitions;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;

public class WfProcessImpl
extends WfExecutionObjectImpl
implements WfProcessInternal {
    private String actRequesterId;
    private String actRequestersProcessId;
    private String resRequesterId;
    private String managerName;
    private String pkgId;
    private String pDefId;
    private String mgrVer;
    protected Map processContext;
    private Evaluator evaluator;
    private List lastFinishedActivities = new ArrayList();
    private WfProcessMgrInternal manager;
    private Map activeActivitiesMap;
    private Map tmpActivitiesMap;
    private boolean isRunning = false;
    private long creationTime = 0x3FFFFFFFFFFFFFFFL;
    private long startTime = 0x3FFFFFFFFFFFFFFFL;
    protected WorkflowProcess xpdlProcess;
    protected Set variableIdsToPersist = new HashSet();
    protected Map activityToFollowedTransitions = new HashMap();
    protected Map newActivityToFollowedTransitions = new HashMap();
    protected SharkTransaction initialTransaction;
    protected Thread startingThread = null;
    protected WfActivityInternal actRequester;
    private boolean terminateOrAbortFromActivity = false;
    private String externalRequesterClassName = null;
    protected boolean justCreated = false;
    protected boolean justCreatedVariables = false;

    protected WfProcessImpl(SharkTransaction t, WfProcessMgrInternal manager, WfRequesterInternal requester, String key) throws BaseException {
        this.key = key;
        this.manager = manager;
        this.managerName = manager.name(t);
        this.justCreated = true;
        this.justCreatedVariables = true;
        this.setXPDLAttribs();
        if (requester.getExternalRequester(t) != null) {
            this.externalRequesterClassName = requester.getExternalRequester(t).getClass().getName();
        }
        if (requester != null && requester instanceof WfActivityInternal) {
            this.actRequesterId = ((WfActivityInternal)requester).key(t);
            this.actRequestersProcessId = ((WfActivityInternal)requester).process_id(t);
            this.actRequester = (WfActivityInternal)requester;
            this.resRequesterId = this.actRequester.getResourceRequesterUsername(t);
            this.initialTransaction = t;
        } else if (requester != null && requester instanceof WfDefaultRequester) {
            this.resRequesterId = ((WfDefaultRequester)requester).getResourceRequesterUsername(t);
        }
        SharkUtilities.addProcessToCache(t, this);
        this.name = this.getProcessDefinition(t).getName();
        if (this.name.equals("")) {
            this.name = this.getProcessDefinition(t).getId();
        }
        ProcessHeader ph = ((WorkflowProcess)this.getXPDLObject(t)).getProcessHeader();
        this.description = ph.getDescription();
        if (this.description != null && this.description.length() > 254) {
            this.description = this.description.substring(0, 253);
        }
        try {
            this.priority = Integer.valueOf(ph.getPriority()).shortValue();
        }
        catch (Exception ex) {
            this.priority = (short)3;
        }
        this.creationTime = this.lastStateTime = System.currentTimeMillis();
        if (SharkEngineManager.getInstance().getEventAuditManager() != null || this.externalRequesterClassName != null) {
            WfCreateProcessEventAuditInternal cpea = SharkEngineManager.getInstance().getObjectFactory().createCreateProcessEventAuditWrapper(t, (WfProcessInternal)this, requester);
            if (this.externalRequesterClassName != null) {
                this.notifyRequester(t, (WfEventAudit)cpea);
            }
        }
        this.lastStateEventAudit = SharkEngineManager.getInstance().getObjectFactory().createStateEventAuditWrapper(t, (WfExecutionObjectInternal)this, "processStateChanged", null, this.state);
        if (this.externalRequesterClassName != null) {
            this.notifyRequester(t, (WfEventAudit)this.lastStateEventAudit);
        }
        this.activeActivitiesMap = new HashMap();
        this.initializeProcessContext(t);
        if (this.processContext.size() > 0) {
            this.variableIdsToPersist.addAll(this.getContext(t).keySet());
            if (SharkEngineManager.getInstance().getEventAuditManager() != null || this.externalRequesterClassName != null) {
                WfDataEventAuditInternal dea = SharkEngineManager.getInstance().getObjectFactory().createDataEventAuditWrapper(t, (WfExecutionObjectInternal)this, "processContextChanged", null, new HashMap(this.processContext));
                if (this.externalRequesterClassName != null) {
                    this.notifyRequester(t, (WfEventAudit)dea);
                }
            }
        }
        this.activityToFollowedTransitions = new HashMap();
        try {
            this.persist(t);
            this.persistProcessContext(t);
        }
        catch (TransactionException tme) {
            throw new BaseException((Throwable)tme);
        }
        SharkEngineManager.getInstance().getCallbackUtilities().info("Process " + this + " is created");
    }

    protected WfProcessImpl(ProcessPersistenceInterface po) {
        this.restore(po);
    }

    public WfRequesterInternal requester(SharkTransaction t) throws BaseException {
        WfActivityInternal requester = null;
        if (this.actRequesterId != null) {
            if (this.actRequester != null && (this.initialTransaction != null && this.initialTransaction.equals(t) || this.startingThread != null && this.startingThread.equals(Thread.currentThread()))) {
                requester = this.actRequester;
            } else {
                WfProcessInternal pReq = SharkUtilities.getProcess(t, this.actRequestersProcessId);
                if (pReq != null) {
                    requester = pReq.getActivity(t, this.actRequesterId);
                }
            }
        }
        WfRequester extReq = null;
        if (requester == null) {
            if (this.externalRequesterClassName != null) {
                try {
                    extReq = (WfRequester)Class.forName(this.externalRequesterClassName).newInstance();
                }
                catch (Exception ex) {
                    SharkEngineManager.getInstance().getCallbackUtilities().warn("Can't create external requester - " + this.externalRequesterClassName + " is not in the classpath, or it doesn't have default constructor.");
                }
            }
            if (this.resRequesterId != null) {
                requester = SharkEngineManager.getInstance().getObjectFactory().createDefaultRequester(this.resRequesterId, extReq);
            } else {
                System.err.println("Process Requester is missing - maybe the parent process is deleted. Empty requester will be returned !");
                requester = SharkEngineManager.getInstance().getObjectFactory().createDefaultRequester("", extReq);
            }
        }
        return requester;
    }

    public void setExternalRequesterClassName(SharkTransaction t, String extReqClassName) throws BaseException {
        this.externalRequesterClassName = extReqClassName;
        try {
            this.persist(t);
        }
        catch (TransactionException tme) {
            throw new BaseException((Throwable)tme);
        }
    }

    public int how_many_step(SharkTransaction t) throws BaseException {
        return this.getActiveActivitiesMap(t).size();
    }

    public WfProcessMgrInternal manager(SharkTransaction t) throws BaseException {
        if (this.manager == null) {
            this.manager = SharkUtilities.getProcessMgr(t, this.managerName);
            if (this.manager == null) {
                throw new BaseException("process " + this + " - can't find manager " + this.managerName);
            }
        }
        return this.manager;
    }

    public Map result(SharkTransaction t) throws BaseException, ResultNotAvailable {
        Map resultSigLHM = this.manager(t).result_signature(t);
        HashMap<String, Object> results = new HashMap<String, Object>();
        if (resultSigLHM != null) {
            Set resultKeys = resultSigLHM.keySet();
            for (String fpId : resultKeys) {
                try {
                    results.put(fpId, MiscUtilities.cloneWRD(this.getContext(t).get(fpId)));
                }
                catch (Throwable thr) {
                    throw new BaseException(thr);
                }
            }
        }
        return results;
    }

    public void start(SharkTransaction t) throws BaseException, CannotStart, AlreadyRunning, ToolAgentGeneralException {
        if (this.state(t).equals("open.running")) {
            throw new AlreadyRunning("The process is already running - can't start again!");
        }
        if (this.state(t).startsWith("closed")) {
            throw new CannotStart("The process is closed - can't start it!");
        }
        if (this.getProcessDefinition(t).getStartingActivities().size() == 0) {
            throw new CannotStart("There are no starting activities in the process - can't start it!");
        }
        try {
            try {
                this.startingThread = Thread.currentThread();
                this.initialTransaction = null;
                this.change_state(t, "open.running");
                SharkEngineManager.getInstance().getCallbackUtilities().info("Starting Process " + this);
                this.run(t, null);
            }
            catch (InvalidState is) {
                throw new CannotStart((Throwable)is);
            }
            catch (TransitionNotAllowed tna) {
                throw new CannotStart((Throwable)tna);
            }
            catch (ToolAgentGeneralException tage) {
                try {
                    this.change_state(t, "closed.terminated");
                }
                catch (Exception ex) {
                    throw new BaseException((Throwable)ex);
                }
                throw tage;
            }
        }
        finally {
            this.actRequester = null;
            this.startingThread = null;
        }
    }

    protected void change_state(SharkTransaction t, String new_state) throws BaseException, InvalidState, TransitionNotAllowed {
        this.change_state(t, new_state, false);
    }

    protected void change_state(SharkTransaction t, String new_state, boolean force) throws BaseException, InvalidState, TransitionNotAllowed {
        if (!force && !SharkUtilities.valid_process_states(this.state(t)).contains(new_state)) {
            throw new TransitionNotAllowed("Can't change to state " + new_state + ", from state " + this.state + " !");
        }
        if (new_state.equals("open.running")) {
            this.startTime = System.currentTimeMillis();
            if (SharkEngineManager.getInstance().getLimitAgentManager() != null) {
                this.activateLimitAgent(t);
            }
        }
        String oldState = this.state;
        this.state = new_state;
        this.lastStateTime = System.currentTimeMillis();
        try {
            this.persist(t);
        }
        catch (TransactionException tme) {
            throw new BaseException((Throwable)tme);
        }
        String eventType = "processStateChanged";
        this.lastStateEventAudit = SharkEngineManager.getInstance().getObjectFactory().createStateEventAuditWrapper(t, (WfExecutionObjectInternal)this, eventType, oldState, new_state);
        if (this.state.startsWith("closed")) {
            LimitAgentManager mgr;
            if (!(this.terminateOrAbortFromActivity || this.externalRequesterClassName == null && this.actRequesterId == null)) {
                this.notifyRequester(t, (WfEventAudit)this.lastStateEventAudit);
            }
            if (this.state.equals("closed.completed")) {
                try {
                    this.delete(t);
                }
                catch (TransactionException te) {
                    throw new BaseException((Throwable)te);
                }
            }
            if ((mgr = SharkEngineManager.getInstance().getLimitAgentManager()) != null) {
                try {
                    mgr.notifyStop(this.key, null);
                }
                catch (LimitAgentException e) {
                    throw new BaseException((Throwable)e);
                }
            }
        } else if (this.externalRequesterClassName != null) {
            this.notifyRequester(t, (WfEventAudit)this.lastStateEventAudit);
        }
    }

    @Override
    public void set_process_context(SharkTransaction t, Map newValue) throws BaseException, InvalidData, UpdateNotAllowed {
        HashMap oldValues = new HashMap();
        HashMap newChanged = new HashMap();
        for (Map.Entry me : newValue.entrySet()) {
            String id = (String)me.getKey();
            Object val = me.getValue();
            if (this.getContext(t).containsKey(id)) {
                Object oldVal = this.getContext(t).get(id);
                if (SharkUtilities.checkDataType(t, this.getProcessDefinition(t), id, oldVal, val)) {
                    if ((oldVal == null || oldVal.equals(val)) && (oldVal != null || val == null)) continue;
                    oldValues.put(id, oldVal);
                    newChanged.put(id, val);
                    continue;
                }
                throw new InvalidData("Invalid data type for process variable " + id);
            }
            throw new UpdateNotAllowed("Context attribute " + id + " does not exist in process context - adding new attributes to the process context is not allowed");
        }
        if (newChanged.size() > 0) {
            this.getContext(t).putAll(newChanged);
            this.variableIdsToPersist.addAll(newChanged.keySet());
            this.persistProcessContext(t);
            if (SharkEngineManager.getInstance().getEventAuditManager() != null || this.externalRequesterClassName != null) {
                boolean persistOldEventAuditData = new Boolean(SharkEngineManager.getInstance().getCallbackUtilities().getProperty("PERSIST_OLD_EVENT_AUDIT_DATA", "true"));
                if (!persistOldEventAuditData) {
                    oldValues = null;
                }
                WfDataEventAuditInternal dea = SharkEngineManager.getInstance().getObjectFactory().createDataEventAuditWrapper(t, (WfExecutionObjectInternal)this, "processContextChanged", oldValues, newChanged);
                if (this.externalRequesterClassName != null) {
                    this.notifyRequester(t, (WfEventAudit)dea);
                }
            }
        }
    }

    @Override
    public void resume(SharkTransaction t) throws BaseException, CannotResume, NotSuspended {
        try {
            WfActivityInternal waImpl;
            if (!this.state(t).equals("open.not_running.suspended")) {
                throw new NotSuspended("The process is not suspended - can't resume it!");
            }
            WfRequesterInternal requester = this.requester(t);
            if (requester != null && requester instanceof WfActivityInternal && (waImpl = (WfActivityInternal)requester).state(t).equals("open.not_running.suspended") && waImpl.isPerformerSynchronous(t)) {
                SharkEngineManager.getInstance().getCallbackUtilities().error("Process" + this.toString() + " - Cannot resume because the requester activity is suspended");
                throw new CannotResume("Cannot resume - The requester activity is suspended");
            }
            SharkEngineManager.getInstance().getCallbackUtilities().info("Resuming process " + this);
            this.change_state(t, "open.running");
            for (WfActivityInternal act : this.getActiveActivities(t)) {
                if (!act.state(t).equals("open.not_running.suspended") || act.block_activity_id(t) != null) continue;
                act.resume(t);
            }
        }
        catch (InvalidState is) {
            throw new CannotResume((Throwable)is);
        }
        catch (TransitionNotAllowed tna) {
            throw new CannotResume((Throwable)tna);
        }
    }

    @Override
    public void suspend(SharkTransaction t) throws BaseException, CannotSuspend, NotRunning, AlreadySuspended {
        if (this.state(t).equals("open.not_running.suspended")) {
            throw new AlreadySuspended("The process is already suspended - can't suspend it twice!");
        }
        if (this.state(t).startsWith("open.not_running")) {
            throw new NotRunning("The process is not in the running state");
        }
        try {
            SharkEngineManager.getInstance().getCallbackUtilities().info("Suspending process " + this);
            this.change_state(t, "open.not_running.suspended");
            for (WfActivityInternal act : this.getActiveActivities(t)) {
                String actState = act.state(t);
                if (actState.equals("open.not_running.suspended") || act.block_activity_id(t) != null) continue;
                act.suspend(t);
            }
        }
        catch (InvalidState is) {
            throw new CannotSuspend((Throwable)is);
        }
        catch (TransitionNotAllowed tna) {
            throw new CannotSuspend((Throwable)tna);
        }
    }

    public void terminateFromActivity(SharkTransaction t) throws BaseException, CannotStop, NotRunning {
        this.terminateOrAbortFromActivity = true;
        this.terminate(t);
    }

    @Override
    public void terminate(SharkTransaction t) throws BaseException, CannotStop, NotRunning {
        try {
            String stateStr = "closed.terminated";
            if (!this.state(t).startsWith("open")) {
                throw new CannotStop("The process is already closed - can't terminate it!");
            }
            SharkEngineManager.getInstance().getCallbackUtilities().info("Terminating process " + this);
            this.change_state(t, stateStr);
            for (WfActivityInternal act : this.getActiveActivities(t)) {
                if (act.block_activity_id(t) != null) continue;
                act.terminateFromProcess(t);
            }
            this.lastFinishedActivities.clear();
            if (this.activeActivitiesMap != null) {
                this.activeActivitiesMap.clear();
            }
        }
        catch (InvalidState is) {
            throw new CannotStop((Throwable)is);
        }
        catch (TransitionNotAllowed tna) {
            throw new CannotStop((Throwable)tna);
        }
    }

    public void abortFromActivity(SharkTransaction t) throws BaseException, CannotStop, NotRunning {
        this.terminateOrAbortFromActivity = true;
        this.abort(t);
    }

    @Override
    public void abort(SharkTransaction t) throws BaseException, CannotStop, NotRunning {
        String stateStr = "closed.aborted";
        if (!this.state(t).startsWith("open")) {
            throw new CannotStop("The process is already closed - can't abort it!");
        }
        try {
            SharkEngineManager.getInstance().getCallbackUtilities().info("Aborting process " + this);
            this.change_state(t, stateStr);
            for (WfActivityInternal act : this.getActiveActivities(t)) {
                if (act.block_activity_id(t) != null) continue;
                act.abortFromProcess(t);
            }
            this.lastFinishedActivities.clear();
            if (this.activeActivitiesMap != null) {
                this.activeActivitiesMap.clear();
            }
        }
        catch (InvalidState is) {
            throw new CannotStop((Throwable)is);
        }
        catch (TransitionNotAllowed tna) {
            throw new CannotStop((Throwable)tna);
        }
    }

    public void reopen(SharkTransaction t) throws BaseException, CannotReopen {
        if (!this.state(t).startsWith("closed")) {
            throw new CannotReopen("The process is already opened - can't reopen it!");
        }
        try {
            this.change_state(t, "open.not_running.not_started", true);
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    protected void run(SharkTransaction t, WfActivityInternal lastFinishedActivity) throws BaseException, ToolAgentGeneralException {
        this.isRunning = true;
        try {
            if (lastFinishedActivity == null) {
                ArrayList starts = this.getProcessDefinition(t).getStartingActivities();
                Iterator it = starts.iterator();
                while (it.hasNext()) {
                    String asDefId = null;
                    Activity actDef = (Activity)it.next();
                    XMLElement owner = actDef.getParent().getParent();
                    if (owner instanceof ActivitySet) {
                        asDefId = ((ActivitySet)owner).getId();
                    }
                    this.startActivity(t, asDefId, actDef, null, new WfActivityInternal[0]);
                }
            }
            while (this.lastFinishedActivities.size() > 0) {
                if (!this.state.equals("open.not_running.suspended")) {
                    if (!this.state.startsWith("closed")) {
                        this.queueNext(t, (WfActivityInternal)this.lastFinishedActivities.get(0));
                    }
                    this.lastFinishedActivities.remove(0);
                    continue;
                }
                return;
            }
            if (this.state.startsWith("closed")) {
                return;
            }
        }
        finally {
            this.isRunning = false;
        }
    }

    public String start_activity(SharkTransaction t, String actDefId, String blockActId) throws BaseException, ToolAgentGeneralException {
        WfActivityInternal ba;
        WfActivityInternal baImpl;
        if (this.state(t).startsWith("closed")) {
            throw new BaseException("Can't start the activity of closed process!");
        }
        WorkflowProcess wp = this.getProcessDefinition(t);
        Activities acts = null;
        String asDefId = null;
        if (blockActId != null && blockActId.length() > 0 && (baImpl = this.getActiveActivity(t, blockActId)) != null) {
            ba = SharkUtilities.getActivityDefinition(t, baImpl, wp, baImpl.block_activity(t)).getActivityTypes().getBlockActivity();
            asDefId = ba.getBlockId();
            ActivitySet aSet = wp.getActivitySet(asDefId);
            acts = aSet.getActivities();
        }
        if (acts == null) {
            acts = wp.getActivities();
        }
        Activity activity = acts.getActivity(actDefId);
        ba = this.getActiveActivity(t, blockActId);
        if (this.state(t).equals("open.not_running.not_started")) {
            try {
                this.change_state(t, "open.running");
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
            if (SharkEngineManager.getInstance().getLimitAgentManager() != null) {
                this.activateLimitAgent(t);
            }
        }
        return this.startActivity(t, asDefId, activity, ba, new WfActivityInternal[0]);
    }

    public final String process_definition_id(SharkTransaction t) throws BaseException {
        return this.pDefId;
    }

    public final String manager_name(SharkTransaction t) throws BaseException {
        return this.managerName;
    }

    public final String manager_version(SharkTransaction t) throws BaseException {
        return this.mgrVer;
    }

    protected String startActivity(SharkTransaction t, String asDefId, Activity activity, WfActivityInternal blockActivity, WfActivityInternal ... fromActivities) throws BaseException, ToolAgentGeneralException {
        if (!this.allowMultipleActivityDefinitionsActive(activity) && this.isActivityDefinitionActive(t, activity, blockActivity)) {
            SharkEngineManager.getInstance().getCallbackUtilities().warn("Activity " + activity + " is already started - can't start it twice");
            return null;
        }
        WfActivityInternal act = SharkEngineManager.getInstance().getObjectFactory().createActivity(t, (WfProcessInternal)this, this.getNextWorkItemId(activity.getId()), asDefId, activity.getId(), blockActivity, fromActivities);
        SharkEngineManager.getInstance().getCallbackUtilities().info("Process" + this.toString() + " - Activity" + act.toString() + " is created");
        this.addToActiveActivities(t, activity, act);
        try {
            act.activate(t);
            String causeClassName = null;
            if (activity.getActivityType() == 4) {
                try {
                    this.runBlock(t, activity, act);
                }
                catch (ToolAgentGeneralException ex) {
                    causeClassName = SharkUtilities.extractExceptionName(ex);
                    act.setExceptionName(t, causeClassName);
                    act.setToolAgentException(t, ex);
                }
            } else {
                causeClassName = act.getExceptionName(t);
            }
            if (causeClassName != null && this.getExceptionTransFrom(t, act, activity, causeClassName).size() == 0) {
                ToolAgentGeneralException tage = act.getToolAgentException(t);
                if (tage != null) {
                    throw act.getToolAgentException(t);
                }
                throw new BaseException("Unexpected exception from WfProcessImpl.startActivity()");
            }
        }
        catch (AlreadyRunning ar) {
            throw new BaseException((Throwable)ar);
        }
        catch (CannotStart e) {
            throw new BaseException((Throwable)e);
        }
        return act.key(t);
    }

    public void activity_complete(SharkTransaction t, WfActivityInternal activity) throws Exception {
        SharkEngineManager.getInstance().getCallbackUtilities().info("Process" + this.toString() + " - Activity" + activity.toString() + " is completed.");
        this.lastFinishedActivities.add(activity);
        this.getActiveActivitiesMap(t).remove(activity.key(t));
        if (!this.isRunning) {
            this.run(t, activity);
        }
    }

    public void activity_terminate(SharkTransaction t, WfActivityInternal activity) throws Exception {
        SharkEngineManager.getInstance().getCallbackUtilities().info("Process" + this.toString() + " - Activity" + activity.toString() + " is terminated.");
        this.lastFinishedActivities.add(activity);
        this.getActiveActivitiesMap(t).remove(activity.key(t));
        Activity activityDefinition = SharkUtilities.getActivityDefinition(t, activity, this.getProcessDefinition(t), activity.block_activity(t));
        if (activityDefinition.getActivityType() == 4) {
            List bas = this.getAllActiveActivitiesForBlockActivity(t, activity.key(t));
            for (WfActivityInternal baMember : bas) {
                this.getActiveActivitiesMap(t).remove(baMember.key(t));
            }
        }
        if (!this.isRunning) {
            this.run(t, activity);
        }
    }

    public void activity_abort(SharkTransaction t, WfActivityInternal activity) throws Exception {
        if (!activity.state(t).equals("closed.aborted")) {
            throw new Exception("Activity state is not aborted");
        }
        SharkEngineManager.getInstance().getCallbackUtilities().info("Process" + this.toString() + " - Aborting activity" + activity.toString());
        this.getActiveActivitiesMap(t).remove(activity.key(t));
    }

    protected void queueNext(SharkTransaction t, WfActivityInternal fromActivity) throws BaseException, ToolAgentGeneralException {
        List nextTrans;
        Transitions transitions;
        Activities activityDefs;
        WorkflowProcess wp = this.getProcessDefinition(t);
        Activity aDef = SharkUtilities.getActivityDefinition(t, fromActivity, wp, fromActivity.block_activity(t));
        WfActivityInternal blockActivity = fromActivity.block_activity(t);
        ActivitySet aSet = null;
        String asDefId = null;
        if (blockActivity != null) {
            aSet = (ActivitySet)aDef.getParent().getParent();
            asDefId = aSet.getId();
            activityDefs = aSet.getActivities();
            transitions = aSet.getTransitions();
        } else {
            activityDefs = wp.getActivities();
            transitions = wp.getTransitions();
        }
        String causeClassName = fromActivity.getExceptionName(t);
        boolean checkIfSomethingWrong = true;
        if (causeClassName == null) {
            nextTrans = this.getTransFrom(t, fromActivity, aDef);
        } else {
            nextTrans = this.getExceptionTransFrom(t, fromActivity, aDef, causeClassName);
            if (nextTrans.size() == 0) {
                if (blockActivity != null && blockActivity.getToolAgentException(t) != null) {
                    nextTrans = new ArrayList();
                    checkIfSomethingWrong = false;
                } else {
                    ToolAgentGeneralException tage = blockActivity.getToolAgentException(t);
                    if (tage != null) {
                        throw tage;
                    }
                    throw new BaseException("Unexpected exception from WfProcessImpl.queryNext()");
                }
            }
        }
        if (checkIfSomethingWrong && nextTrans.size() == 0) {
            WorkflowProcess wpOrASet = wp;
            if (aSet != null) {
                wpOrASet = aSet;
            }
            ArrayList endingActDefs = null;
            endingActDefs = wpOrASet instanceof WorkflowProcess ? wpOrASet.getEndingActivities() : ((ActivitySet)wpOrASet).getEndingActivities();
            if (!endingActDefs.contains(aDef)) {
                String unsatSplitHandling = SharkEngineManager.getInstance().getCallbackUtilities().getProperty("SharkKernel.UnsatisfiedSplitConditionsHandling", "FINISH_IF_POSSIBLE");
                if (unsatSplitHandling.equals("IGNORE")) {
                    SharkEngineManager.getInstance().getCallbackUtilities().warn("Process " + this + " could hang forever in " + fromActivity + " branch, after this activity is finished");
                    return;
                }
                if (unsatSplitHandling.equals("ROLLBACK")) {
                    throw new BaseException("Shark kernel is configured not to allow hanging processes!");
                }
                SharkEngineManager.getInstance().getCallbackUtilities().error("Process " + this + " will try to finish after " + fromActivity + " is executed because kernel is configured not to allow hanging and not to rollback");
            }
        }
        if (nextTrans.size() > 0) {
            for (Transition trans : nextTrans) {
                Activity toActivityDef = trans.getToActivity();
                if (!toActivityDef.isAndTypeJoin() || toActivityDef.getIncomingTransitions().size() == 1) {
                    this.startActivity(t, asDefId, toActivityDef, blockActivity, fromActivity);
                    continue;
                }
                this.joinTransition(t, fromActivity, toActivityDef, asDefId);
            }
        } else {
            List actActs = this.getActiveActivities(t);
            if (actActs.size() > 0) {
                if (blockActivity != null) {
                    int i = 0;
                    while (i < actActs.size()) {
                        WfActivityInternal ba = this.getActiveActivity(t, ((WfActivityInternal)actActs.get(i)).block_activity_id(t));
                        if (ba != null && ba.equals(blockActivity)) {
                            return;
                        }
                        ++i;
                    }
                    try {
                        blockActivity.finish(t);
                    }
                    catch (Exception ex) {
                        throw new BaseException("Something went wrong while finishing block activity " + blockActivity, (Throwable)ex);
                    }
                    return;
                }
            } else {
                if (aSet != null) {
                    try {
                        if (blockActivity.state(t).startsWith("closed")) {
                            return;
                        }
                        blockActivity.finish(t);
                    }
                    catch (Exception ex) {
                        throw new BaseException("Something went wrong while finishing block activity " + blockActivity, (Throwable)ex);
                    }
                    return;
                }
                if (this.lastFinishedActivities.size() <= 1) {
                    SharkEngineManager.getInstance().getCallbackUtilities().info("Process" + this.toString() + " - No transitions left to follow");
                    try {
                        this.change_state(t, "closed.completed");
                    }
                    catch (Exception ex) {
                        throw new BaseException("Something went wrong while changing process state to closed.completed", (Throwable)ex);
                    }
                }
            }
        }
    }

    protected void joinTransition(SharkTransaction t, WfActivityInternal fromActivity, Activity toActivityDef, String asDefId) throws BaseException, ToolAgentGeneralException {
        ArrayList toTrans = toActivityDef.getIncomingTransitions();
        ArrayList andJoinEntries = new ArrayList();
        int followed = this.restoreActivityToFollowedTransitionsMap(t, toActivityDef, asDefId, andJoinEntries);
        SharkEngineManager.getInstance().getCallbackUtilities().info("Process" + this.toString() + " - " + (followed + 1) + " of " + toTrans.size() + " transitions followed to activity with definition " + toActivityDef.getId());
        if (toTrans.size() == followed + 1) {
            SharkEngineManager.getInstance().getCallbackUtilities().info("Process" + this.toString() + " - All transition have been followed to activity with definition " + toActivityDef.getId());
            Set currentTrans = (Set)this.newActivityToFollowedTransitions.get(toActivityDef);
            if (currentTrans != null && currentTrans.size() == followed) {
                this.newActivityToFollowedTransitions.remove(toActivityDef);
            } else if (currentTrans != null) {
                currentTrans.clear();
            } else {
                this.newActivityToFollowedTransitions.put(toActivityDef, currentTrans);
            }
            this.activityToFollowedTransitions.put(toActivityDef, new Integer(0));
            try {
                this.persistActivityToFollowedTransitions(t);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
            ArrayList<WfActivityInternal> fromActivities = new ArrayList<WfActivityInternal>();
            fromActivities.add(fromActivity);
            for (AndJoinEntryInterface andJoinEntry : andJoinEntries) {
                fromActivities.add(this.getActivity(t, andJoinEntry.getActivityId()));
            }
            this.startActivity(t, asDefId, toActivityDef, this.getActiveActivity(t, fromActivity.block_activity_id(t)), fromActivities.toArray(new WfActivityInternal[fromActivities.size()]));
        } else {
            this.activityToFollowedTransitions.put(toActivityDef, new Integer(followed + 1));
            HashSet<String> currentTrans = (HashSet<String>)this.newActivityToFollowedTransitions.get(toActivityDef);
            if (currentTrans == null) {
                currentTrans = new HashSet<String>();
                this.newActivityToFollowedTransitions.put(toActivityDef, currentTrans);
            }
            currentTrans.add(fromActivity.key(t));
            try {
                this.persistActivityToFollowedTransitions(t);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
    }

    protected List getTransFrom(SharkTransaction t, WfActivityInternal fromActivity, Activity fromActDef) throws BaseException {
        ArrayList orderedOutTransitions = fromActDef.getNonExceptionalOutgoingTransitions();
        ArrayList<Transition> transList = new ArrayList<Transition>();
        boolean isAndSplit = fromActDef.isAndTypeSplit();
        Transition otherwiseTransition = null;
        for (Transition trans : orderedOutTransitions) {
            Condition condition = trans.getCondition();
            String condType = condition.getType();
            if (condType.equals("OTHERWISE")) {
                otherwiseTransition = trans;
                boolean handleOtherwiseTransitionLast = new Boolean(SharkEngineManager.getInstance().getCallbackUtilities().getProperty("SharkKernel.handleOtherwiseTransitionLast", "false"));
                if (isAndSplit || handleOtherwiseTransitionLast) continue;
                break;
            }
            boolean evalRes = false;
            String cond = condition.toValue();
            if (cond.trim().length() == 0) {
                evalRes = true;
            } else {
                try {
                    evalRes = this.evaluator(t).evaluateCondition(t, cond, this.process_context(t));
                }
                catch (Exception ex) {
                    throw new BaseException("Exception while evaluating transition condition", (Throwable)ex);
                }
            }
            if (!evalRes) continue;
            transList.add(trans);
            if (!isAndSplit) break;
        }
        if (transList.size() == 0 && otherwiseTransition != null) {
            transList.add(otherwiseTransition);
            SharkEngineManager.getInstance().getCallbackUtilities().info("Process" + this.toString() + " - process is proceeding with otherwise transition of Activity" + fromActivity);
        }
        return transList;
    }

    protected List getExceptionTransFrom(SharkTransaction t, WfActivityInternal fromActivity, Activity fromActDef, String exceptionName) throws BaseException {
        Condition condition;
        ArrayList outTransitions = fromActDef.getExceptionalOutgoingTransitions();
        ArrayList<Transition> transList = new ArrayList<Transition>();
        if (outTransitions.size() == 0) {
            return transList;
        }
        Transition excTransition = null;
        Transition defaultExceptionTransition = null;
        for (Transition trans : outTransitions) {
            condition = trans.getCondition();
            String condType = condition.getType();
            if (condType.equals("DEFAULTEXCEPTION")) {
                defaultExceptionTransition = trans;
                continue;
            }
            boolean evalRes = false;
            String cond = condition.toValue();
            evalRes = cond.length() == 0 ? true : cond.equals(exceptionName);
            if (!evalRes) continue;
            excTransition = trans;
            break;
        }
        if (excTransition == null && defaultExceptionTransition == null) {
            for (Transition trans : outTransitions) {
                condition = trans.getCondition();
                boolean evalRes = false;
                String cond = condition.toValue();
                try {
                    evalRes = this.evaluator(t).evaluateCondition(t, cond, this.process_context(t));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!evalRes) continue;
                excTransition = trans;
                break;
            }
        }
        if (excTransition == null && defaultExceptionTransition != null) {
            excTransition = defaultExceptionTransition;
            SharkEngineManager.getInstance().getCallbackUtilities().info("Process" + this.toString() + " - process is proceeding with default exception transition of Activity" + fromActivity);
        }
        if (excTransition != null) {
            transList.add(excTransition);
        }
        return transList;
    }

    protected void notifyRequester(SharkTransaction t, WfEventAudit event) throws BaseException {
        SharkEngineManager.getInstance().getCallbackUtilities().info("Process" + this.toString() + " - notifying requester of the event");
        WfRequesterInternal req = this.requester(t);
        if (req != null) {
            try {
                WfActivityInternal aReq = null;
                if (req instanceof WfActivityInternal) {
                    aReq = (WfActivityInternal)req;
                }
                if (aReq == null) {
                    req.receive_event(t, event, (WfProcessInternal)this);
                } else if (event instanceof WfStateEventAudit && aReq.state(t).startsWith("open")) {
                    aReq.receive_event(t, event, (WfProcessInternal)this);
                }
            }
            catch (InvalidPerformer ip) {
                throw new BaseException((Throwable)ip);
            }
        }
    }

    protected void initializeProcessContext(SharkTransaction t) throws BaseException {
        this.processContext = new HashMap();
        WorkflowProcess wp = this.getProcessDefinition(t);
        Collection dfsAndFPs = wp.getAllVariables().values();
        for (XMLCollectionElement dfOrFp : dfsAndFPs) {
            Object initVal = SharkUtilities.getInitialValue(dfOrFp, false);
            String id = dfOrFp.getId();
            this.processContext.put(id, initVal);
        }
    }

    protected String getNextWorkItemId(String aDefId) throws BaseException {
        String id = SharkUtilities.getNextId("_activity_");
        if ((id = String.valueOf(id) + "_" + this.key + "_" + aDefId).length() > 100) {
            id = id.substring(0, 100);
        }
        return id;
    }

    public String toString() {
        return "[key=" + this.key + ",mgrname=" + this.managerName + "]";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WfProcessImpl)) {
            return false;
        }
        return ((WfProcessImpl)obj).key.equals(this.key);
    }

    protected boolean isActivityDefinitionActive(SharkTransaction t, Activity aDef, WfActivityInternal blockActivity) throws BaseException {
        String aDefId = aDef.getId();
        for (WfActivityInternal act : this.getActiveActivities(t)) {
            if (!act.activity_definition_id(t).equals(aDefId) || !act.state(t).equals("open.running") && !act.state(t).equals("open.not_running.not_started") || (blockActivity == null || !blockActivity.key(t).equals(act.block_activity_id(t))) && (blockActivity != null || act.block_activity_id(t) != null)) continue;
            return true;
        }
        return false;
    }

    private boolean allowMultipleActivityDefinitionsActive(Activity activity) {
        ExtendedAttribute config = activity.getExtendedAttributes().getFirstExtendedAttributeForName("CONFIGURATION");
        if (config != null) {
            String[] lines;
            String[] stringArray = lines = config.getVValue().split("\n");
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                String[] entry = line.split("=");
                if (entry.length > 1 && entry[0].equalsIgnoreCase("allowMultipleActiveActivities")) {
                    return Boolean.valueOf(entry[1]);
                }
                ++n2;
            }
        }
        return false;
    }

    protected void setProcessVariables(SharkTransaction t) throws BaseException {
        try {
            this.processContext = new HashMap();
            PersistentManagerInterface ipm = SharkEngineManager.getInstance().getInstancePersistenceManager();
            WorkflowProcess wp = this.getProcessDefinition(t);
            List<Object> l = new ArrayList(wp.getAllVariables().values());
            if (l.size() == 0) {
                return;
            }
            Iterator<Object> it = l.iterator();
            ArrayList<String> variableIds = new ArrayList<String>();
            while (it.hasNext()) {
                XMLCollectionElement xMLCollectionElement = (XMLCollectionElement)it.next();
                String vdId = xMLCollectionElement.getId();
                variableIds.add(vdId);
            }
            l = ipm.getProcessVariables(this.key, variableIds, t);
            for (ProcessVariablePersistenceInterface processVariablePersistenceInterface : l) {
                this.processContext.put(processVariablePersistenceInterface.getDefinitionId(), processVariablePersistenceInterface.getValue());
            }
        }
        catch (Exception ex) {
            throw new BaseException("Restoring of process context failed!", (Throwable)ex);
        }
    }

    protected WorkflowProcess getProcessDefinition(SharkTransaction t) throws BaseException {
        if (this.xpdlProcess == null) {
            this.xpdlProcess = SharkUtilities.getWorkflowProcess(this.pkgId, this.mgrVer, this.pDefId);
        }
        return this.xpdlProcess;
    }

    public void persist(SharkTransaction t) throws TransactionException {
        try {
            SharkEngineManager.getInstance().getInstancePersistenceManager().persist(this.createAndFillPersistentObject(), this.justCreated, t);
            this.justCreated = false;
        }
        catch (Exception pe) {
            throw new TransactionException("Exc when persisting process " + this.key, (Throwable)pe);
        }
    }

    protected void persistProcessContext(SharkTransaction t) throws BaseException {
        try {
            if (this.variableIdsToPersist.size() == 0) {
                return;
            }
            PersistentManagerInterface pmgr = SharkEngineManager.getInstance().getInstancePersistenceManager();
            for (Map.Entry me : this.getContext(t).entrySet()) {
                String defId = (String)me.getKey();
                if (!this.variableIdsToPersist.contains(defId)) continue;
                Object val = me.getValue();
                ProcessVariablePersistenceInterface var = pmgr.createProcessVariable();
                var.setProcessId(this.key);
                var.setDefinitionId(defId);
                var.setValue(val);
                pmgr.persist(var, this.justCreatedVariables, t);
            }
            this.variableIdsToPersist.clear();
            this.justCreatedVariables = false;
        }
        catch (PersistenceException pe) {
            throw new BaseException((Throwable)pe);
        }
    }

    public void delete(SharkTransaction t) throws TransactionException {
        try {
            SharkEngineManager.getInstance().getInstancePersistenceManager().deleteProcess(this.key, false, t);
            SharkUtilities.removeProcessFromCache(t, this);
        }
        catch (Exception ex) {
            throw new TransactionException("Exception while deleting process", (Throwable)ex);
        }
    }

    public void mandatoryDelete(SharkTransaction t) throws TransactionException {
        try {
            SharkEngineManager.getInstance().getInstancePersistenceManager().deleteProcess(this.key, true, t);
            SharkUtilities.removeProcessFromCache(t, this);
        }
        catch (Exception ex) {
            throw new TransactionException("Exception while deleting process", (Throwable)ex);
        }
    }

    @Override
    protected XMLCollectionElement getXPDLObject(SharkTransaction t) throws BaseException {
        return this.getProcessDefinition(t);
    }

    public Map getContext(SharkTransaction t) throws BaseException {
        if (this.processContext == null) {
            this.setProcessVariables(t);
        }
        return this.processContext;
    }

    public Evaluator evaluator(SharkTransaction t) throws RootException {
        if (this.evaluator == null) {
            this.evaluator = SharkEngineManager.getInstance().getScriptingManager().getEvaluator(t, SharkUtilities.getScriptType(this.pkgId, this.mgrVer));
        }
        return this.evaluator;
    }

    private ProcessPersistenceInterface createAndFillPersistentObject() {
        ProcessPersistenceInterface po = SharkEngineManager.getInstance().getInstancePersistenceManager().createProcess();
        this.fillPersistentObject(po);
        return po;
    }

    private void fillPersistentObject(ProcessPersistenceInterface po) {
        po.setId(this.key);
        po.setActivityRequesterId(this.actRequesterId);
        po.setActivityRequestersProcessId(this.actRequestersProcessId);
        po.setResourceRequesterId(this.resRequesterId);
        po.setExternalRequesterClassName(this.externalRequesterClassName);
        po.setState(this.state);
        po.setLastStateTime(this.lastStateTime);
        po.setCreatedTime(this.creationTime);
        po.setStartedTime(this.startTime);
        po.setProcessMgrName(this.managerName);
        po.setName(this.name);
        po.setDescription(this.description);
        po.setPriority(this.priority);
        po.setLimitTime(this.limitTime);
    }

    private void restore(ProcessPersistenceInterface po) {
        this.key = po.getId();
        this.actRequesterId = po.getActivityRequesterId();
        this.actRequestersProcessId = po.getActivityRequestersProcessId();
        this.resRequesterId = po.getResourceRequesterId();
        this.externalRequesterClassName = po.getExternalRequesterClassName();
        this.state = po.getState();
        this.lastStateTime = po.getLastStateTime();
        this.creationTime = po.getCreatedTime();
        this.startTime = po.getStartedTime();
        this.managerName = po.getProcessMgrName();
        this.name = po.getName();
        this.description = po.getDescription();
        this.priority = po.getPriority();
        this.limitTime = po.getLimitTime();
        this.setXPDLAttribs();
    }

    public final String package_id(SharkTransaction t) throws BaseException {
        return this.pkgId;
    }

    public WfActivityInternal getActiveActivity(SharkTransaction t, String actId) throws BaseException {
        return (WfActivityInternal)this.getActiveActivitiesMap(t).get(actId);
    }

    protected Map getActiveActivitiesMap(SharkTransaction t) throws BaseException {
        if (this.activeActivitiesMap == null) {
            this.clearTmpActiveActivityMap();
            try {
                SharkEngineManager sharkEngineManager = SharkEngineManager.getInstance();
                List l = sharkEngineManager.getInstancePersistenceManager().getAllActiveActivitiesForProcess(this.key, t);
                this.activeActivitiesMap = new HashMap();
                int i = 0;
                while (i < l.size()) {
                    ActivityPersistenceInterface po = (ActivityPersistenceInterface)l.get(i);
                    WfActivityInternal act = sharkEngineManager.getObjectFactory().createActivity(po, (WfProcessInternal)this);
                    this.activeActivitiesMap.put(po.getId(), act);
                    ++i;
                }
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        return this.activeActivitiesMap;
    }

    protected void clearTmpActiveActivityMap() {
        if (this.tmpActivitiesMap != null) {
            this.tmpActivitiesMap.clear();
        }
    }

    protected WfActivityInternal getTmpActivity(String actId) {
        if (this.tmpActivitiesMap == null) {
            this.tmpActivitiesMap = new HashMap();
        }
        return (WfActivityInternal)this.tmpActivitiesMap.get(actId);
    }

    protected void addToTmpActivitiesMap(String actId, WfActivityInternal act) {
        if (this.tmpActivitiesMap == null) {
            this.tmpActivitiesMap = new HashMap();
        }
        this.tmpActivitiesMap.put(actId, act);
    }

    public List getActiveActivities(SharkTransaction t) throws BaseException {
        return new ArrayList(this.getActiveActivitiesMap(t).values());
    }

    public List getAllActivities(SharkTransaction t) throws BaseException {
        try {
            this.clearTmpActiveActivityMap();
            SharkEngineManager sharkEngineManager = SharkEngineManager.getInstance();
            List l = sharkEngineManager.getInstancePersistenceManager().getAllActivitiesForProcess(this.key, t);
            ArrayList<WfActivityInternal> ret = new ArrayList<WfActivityInternal>();
            HashMap<String, WfActivityInternal> tmpActActivitiesMap = new HashMap<String, WfActivityInternal>();
            int i = 0;
            while (i < l.size()) {
                ActivityPersistenceInterface po = (ActivityPersistenceInterface)l.get(i);
                WfActivityInternal act = null;
                if (this.activeActivitiesMap != null) {
                    act = this.getActiveActivity(t, po.getId());
                }
                if (act == null) {
                    act = sharkEngineManager.getObjectFactory().createActivity(po, (WfProcessInternal)this);
                }
                if (this.activeActivitiesMap == null && !po.getState().startsWith("closed")) {
                    tmpActActivitiesMap.put(po.getId(), act);
                }
                ret.add(act);
                ++i;
            }
            if (this.activeActivitiesMap == null) {
                this.activeActivitiesMap = new HashMap(tmpActActivitiesMap);
            }
            return ret;
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public WfActivityInternal getActivity(SharkTransaction t, String actId) throws BaseException {
        try {
            ActivityPersistenceInterface po;
            WfActivityInternal act = null;
            act = this.activeActivitiesMap != null ? this.getActiveActivity(t, actId) : this.getTmpActivity(actId);
            if (act == null && (po = SharkEngineManager.getInstance().getInstancePersistenceManager().restoreActivity(actId, t)) != null) {
                act = SharkEngineManager.getInstance().getObjectFactory().createActivity(po, (WfProcessInternal)this);
                this.addToTmpActivitiesMap(actId, act);
            }
            return act;
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    @Override
    public final long getCreationTime(SharkTransaction t) throws BaseException {
        return this.creationTime;
    }

    @Override
    public final long getStartTime(SharkTransaction t) throws BaseException {
        return this.startTime;
    }

    private void setXPDLAttribs() {
        this.pkgId = SharkUtilities.getProcessMgrPkgId(this.managerName);
        this.pDefId = SharkUtilities.getProcessMgrProcDefId(this.managerName);
        this.mgrVer = SharkUtilities.getProcessMgrVersion(this.managerName);
    }

    protected int restoreActivityToFollowedTransitionsMap(SharkTransaction t, Activity actDef, String asDefId, List andJoinEntries) throws BaseException {
        Integer followed = (Integer)this.activityToFollowedTransitions.get(actDef);
        if (followed == null) {
            PersistentManagerInterface pmi = SharkEngineManager.getInstance().getInstancePersistenceManager();
            int noOfFollowed = 0;
            try {
                List joinEntries = pmi.getAndJoinEntries(this.key, asDefId, actDef.getId(), t);
                andJoinEntries.addAll(joinEntries);
                noOfFollowed = joinEntries.size();
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
            followed = new Integer(noOfFollowed);
            this.activityToFollowedTransitions.put(actDef, followed);
        }
        return followed;
    }

    protected void persistActivityToFollowedTransitions(SharkTransaction t) throws TransactionException {
        PersistentManagerInterface pmi = SharkEngineManager.getInstance().getInstancePersistenceManager();
        for (Map.Entry me : this.newActivityToFollowedTransitions.entrySet()) {
            Set actInstances;
            Activity actDef = (Activity)me.getKey();
            String asDefId = null;
            XMLElement asOrWp = actDef.getParent().getParent();
            if (asOrWp instanceof ActivitySet) {
                asDefId = ((ActivitySet)asOrWp).getId();
            }
            if ((actInstances = (Set)me.getValue()) == null || actInstances.size() == 0) {
                try {
                    pmi.deleteAndJoinEntries(this.key, asDefId, actDef.getId(), t);
                    continue;
                }
                catch (Exception ex) {
                    throw new TransactionException((Throwable)ex);
                }
            }
            for (String actId : actInstances) {
                AndJoinEntryInterface aji = pmi.createAndJoinEntry();
                aji.setProcessId(this.key);
                aji.setActivitySetDefinitionId(asDefId);
                aji.setActivityDefinitionId(actDef.getId());
                aji.setActivityId(actId);
                try {
                    pmi.persist(aji, t);
                }
                catch (Exception ex) {
                    throw new TransactionException((Throwable)ex);
                }
            }
        }
        this.newActivityToFollowedTransitions.clear();
    }

    protected void runBlock(SharkTransaction t, Activity bActivity, WfActivityInternal blockActivity) throws BaseException, ToolAgentGeneralException {
        BlockActivity ba = bActivity.getActivityTypes().getBlockActivity();
        if (ba != null) {
            String asId = ba.getBlockId();
            ActivitySet as = XMLUtil.getWorkflowProcess((XMLElement)bActivity).getActivitySet(asId);
            if (as != null) {
                ArrayList starts = as.getStartingActivities();
                for (Activity act : starts) {
                    this.startActivity(t, asId, act, blockActivity, new WfActivityInternal[0]);
                }
            }
        }
    }

    protected void addToActiveActivities(SharkTransaction t, Activity aDef, WfActivityInternal act) throws BaseException {
        this.getActiveActivitiesMap(t).put(act.key(t), act);
    }

    public void checkDeadlines(SharkTransaction t) throws BaseException {
        if (!this.state(t).equals("open.running")) {
            return;
        }
        List activeActs = this.getActiveActivities(t);
        long timeLimitBoundary = System.currentTimeMillis();
        HashMap actToExcNames = new HashMap();
        int i = 0;
        while (i < activeActs.size()) {
            HashMap ataens;
            boolean syncDeadlineHappened;
            WfActivityInternal act = (WfActivityInternal)activeActs.get(i);
            if (!(act.block_activity_id(t) != null || (syncDeadlineHappened = act.checkDeadlines(t, timeLimitBoundary, ataens = new HashMap())) || ataens == null && ataens.size() <= 0)) {
                actToExcNames.putAll(ataens);
            }
            ++i;
        }
        if (actToExcNames.size() > 0) {
            this.handleBrokenAsyncDeadlines(t, actToExcNames);
        }
    }

    public void checkDeadline(SharkTransaction t, String actId) throws BaseException {
        if (!this.state(t).equals("open.running")) {
            return;
        }
        WfActivityInternal act = this.getActiveActivity(t, actId);
        if (act == null) {
            throw new BaseException("There is no active activity with Id=" + actId + " within the process with Id=" + this.key);
        }
        HashMap actToExcNames = new HashMap();
        boolean syncDeadlineHappened = act.checkDeadlines(t, System.currentTimeMillis(), actToExcNames);
        if (actToExcNames != null && actToExcNames.size() > 0) {
            this.handleBrokenAsyncDeadlines(t, actToExcNames);
        }
    }

    private void handleBrokenAsyncDeadlines(SharkTransaction t, Map actToExcNames) throws BaseException {
        WorkflowProcess wp = this.getProcessDefinition(t);
        for (Map.Entry me : actToExcNames.entrySet()) {
            WfActivityInternal act = (WfActivityInternal)me.getKey();
            List excNames = (List)me.getValue();
            WfActivityInternal blockActivity = act.block_activity(t);
            Activity aDef = SharkUtilities.getActivityDefinition(t, act, wp, blockActivity);
            ArrayList resultingTransitions = new ArrayList();
            Iterator it = excNames.iterator();
            while (it.hasNext()) {
                List ets = this.getExceptionTransFrom(t, act, aDef, (String)it.next());
                for (Object trans : ets) {
                    if (resultingTransitions.contains(trans)) continue;
                    resultingTransitions.add(trans);
                }
            }
            for (Transition trans : resultingTransitions) {
                try {
                    Activity actToDef = trans.getToActivity();
                    String asDefId = null;
                    XMLElement owner = actToDef.getParent().getParent();
                    if (owner instanceof ActivitySet) {
                        asDefId = ((ActivitySet)owner).getId();
                    }
                    this.startActivity(t, asDefId, actToDef, blockActivity, act);
                }
                catch (ToolAgentGeneralException tage) {
                    throw new BaseException((Throwable)tage);
                }
            }
        }
    }

    public List getAllActiveActivitiesForBlockActivity(SharkTransaction t, String blockActivityId) throws BaseException {
        List allActiveActivities = this.getActiveActivities(t);
        Iterator it = allActiveActivities.iterator();
        ArrayList<WfActivityInternal> ret = new ArrayList<WfActivityInternal>();
        while (it.hasNext()) {
            WfActivityInternal act = (WfActivityInternal)it.next();
            if (!blockActivityId.equals(act.block_activity_id(t))) continue;
            ret.add(act);
        }
        return ret;
    }

    @Override
    protected void notifyStart(SharkTransaction t, Map context, long runtime) throws BaseException {
        LimitAgentManager mgr = SharkEngineManager.getInstance().getLimitAgentManager();
        try {
            mgr.notifyStart(this.key, null, context, runtime);
        }
        catch (LimitAgentException e) {
            throw new BaseException("Unable to register time limit for process " + this + " with limit agent", (Throwable)e);
        }
    }
}

