/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.enhydra.shark.SharkEngineManager;
import org.enhydra.shark.SharkUtilities;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfservice.DeadlineAdministration;
import org.enhydra.shark.api.common.DeadlineInfo;
import org.enhydra.shark.api.internal.instancepersistence.DeadlinePersistenceInterface;
import org.enhydra.shark.api.internal.instancepersistence.PersistentManagerInterface;
import org.enhydra.shark.api.internal.instancepersistence.ProcessPersistenceInterface;
import org.enhydra.shark.api.internal.security.SecurityManager;
import org.enhydra.shark.api.internal.transaction.SharkInternalTransaction;
import org.enhydra.shark.api.internal.working.WfActivityInternal;
import org.enhydra.shark.api.internal.working.WfProcessInternal;
import org.enhydra.shark.api.internal.working.WfRequesterInternal;

public class DeadlineAdmin
implements DeadlineAdministration {
    private String userId = "Unknown";

    protected DeadlineAdmin() {
    }

    public void connect(String userId) {
        this.userId = userId;
    }

    public void checkDeadlines() throws BaseException {
        List pos;
        this.checkSecurity();
        SharkInternalTransaction t = null;
        try {
            try {
                t = SharkUtilities.createTransaction();
                pos = SharkEngineManager.getInstance().getInstancePersistenceManager().getAllRunningProcesses((SharkTransaction)t);
            }
            catch (RootException e) {
                SharkUtilities.emptyCaches((SharkTransaction)t);
                if (e instanceof BaseException) {
                    throw (BaseException)e;
                }
                throw new BaseException((Throwable)e);
            }
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        int i = 0;
        while (i < pos.size()) {
            try {
                try {
                    t = SharkUtilities.createTransaction();
                    ProcessPersistenceInterface po = (ProcessPersistenceInterface)pos.get(i);
                    System.out.println("Check deadline for process:" + po.getId());
                    WfProcessInternal proc = SharkUtilities.getProcess((SharkTransaction)t, po.getId());
                    if (proc.state((SharkTransaction)t).equals("open.running")) {
                        proc.checkDeadlines((SharkTransaction)t);
                        SharkUtilities.commitTransaction((SharkTransaction)t);
                    }
                }
                catch (Exception e) {
                    BaseException be = null;
                    be = e instanceof BaseException ? (BaseException)e : new BaseException((Throwable)e);
                    SharkUtilities.rollbackTransaction((SharkTransaction)t, (RootException)be);
                    throw be;
                }
            }
            finally {
                SharkUtilities.releaseTransaction((SharkTransaction)t);
            }
            ++i;
        }
    }

    public String[] checkDeadlines(int instancesPerTransaction, int failuresToIgnore) throws BaseException {
        this.checkSecurity();
        ArrayList instancesFailed2check = new ArrayList();
        String reevalStr = SharkEngineManager.getInstance().getCallbackUtilities().getProperty("Deadlines.reevaluateDeadlines", "true");
        boolean dreeval = Boolean.valueOf(reevalStr);
        List instancesToCheck = null;
        instancesToCheck = dreeval ? this.getAllRunningProcesses() : this.getAllDeadlineInvalidProcessIds();
        int sizeToCheck = instancesToCheck.size();
        Iterator iterProcesses = instancesToCheck.iterator();
        ArrayList<String> currentBatch = null;
        do {
            SharkInternalTransaction t = null;
            String iid = null;
            currentBatch = new ArrayList<String>();
            try {
                try {
                    t = SharkUtilities.createTransaction();
                    int n = 0;
                    while (n < instancesPerTransaction) {
                        if (!iterProcesses.hasNext()) break;
                        iid = dreeval ? ((ProcessPersistenceInterface)iterProcesses.next()).getId() : (String)iterProcesses.next();
                        iterProcesses.remove();
                        currentBatch.add(iid);
                        this.checkDeadlines((SharkTransaction)t, iid);
                        ++n;
                    }
                    SharkUtilities.commitTransaction((SharkTransaction)t);
                }
                catch (RootException _) {
                    SharkUtilities.rollbackTransaction((SharkTransaction)t, _);
                    instancesFailed2check.addAll(currentBatch);
                    SharkUtilities.releaseTransaction((SharkTransaction)t);
                    continue;
                }
            }
            catch (Throwable throwable) {
                SharkUtilities.releaseTransaction((SharkTransaction)t);
                throw throwable;
            }
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        } while (instancesFailed2check.size() <= failuresToIgnore && iterProcesses.hasNext());
        String[] ret = new String[instancesFailed2check.size()];
        instancesFailed2check.toArray(ret);
        System.out.println("  deadline check finished: checked:" + sizeToCheck + ", failed:" + ret.length);
        return ret;
    }

    public String[] checkDeadlinesWithTermination() throws BaseException {
        this.checkSecurity();
        ArrayList<String> instancesFailed2check = new ArrayList<String>();
        String reevalStr = SharkEngineManager.getInstance().getCallbackUtilities().getProperty("Deadlines.reevaluateDeadlines", "true");
        boolean dreeval = Boolean.valueOf(reevalStr);
        List instancesToCheck = null;
        instancesToCheck = dreeval ? this.getAllRunningProcesses() : this.getAllDeadlineInvalidProcessIds();
        Iterator iterProcesses = instancesToCheck.iterator();
        String iid = null;
        while (iterProcesses.hasNext()) {
            iid = (String)iterProcesses.next();
            SharkInternalTransaction st = null;
            try {
                try {
                    st = SharkUtilities.createTransaction();
                    WfProcessInternal proc = SharkUtilities.getProcess((SharkTransaction)st, iid);
                    if (proc.state((SharkTransaction)st).equals("open.running")) {
                        WfRequesterInternal req = proc.requester((SharkTransaction)st);
                        if (req instanceof WfActivityInternal) {
                            WfActivityInternal act = (WfActivityInternal)req;
                            act.terminate((SharkTransaction)st);
                        } else {
                            proc.terminate((SharkTransaction)st);
                        }
                        SharkUtilities.commitTransaction((SharkTransaction)st);
                        String msg = "Proc " + iid + " terminated ";
                        if (req instanceof WfActivityInternal) {
                            msg = String.valueOf(msg) + " through his parent subflow activity " + req;
                        }
                        msg = String.valueOf(msg) + " !";
                        System.out.println(msg);
                    }
                }
                catch (RootException _) {
                    SharkUtilities.rollbackTransaction((SharkTransaction)st, _);
                    instancesFailed2check.add(iid);
                    System.out.println("Failed to terminate process " + iid);
                    SharkUtilities.releaseTransaction((SharkTransaction)st);
                    continue;
                }
            }
            catch (Throwable throwable) {
                SharkUtilities.releaseTransaction((SharkTransaction)st);
                throw throwable;
            }
            SharkUtilities.releaseTransaction((SharkTransaction)st);
        }
        String[] ret = new String[instancesFailed2check.size()];
        instancesFailed2check.toArray(ret);
        System.out.println("  deadline check finished: checked:" + instancesToCheck.size() + ", failed:" + ret.length);
        return ret;
    }

    public void checkDeadlines(SharkTransaction t) throws BaseException {
        throw new BaseException("Not implemented - please use the method without SharkTransaction parameter");
    }

    public void checkDeadlines(String[] procIds) throws BaseException {
        this.checkSecurity();
        if (procIds == null) {
            throw new BaseException("Invalid null value for parameter procIds");
        }
        SharkInternalTransaction t = null;
        int i = 0;
        while (i < procIds.length) {
            try {
                try {
                    t = SharkUtilities.createTransaction();
                    WfProcessInternal proc = SharkUtilities.getProcess((SharkTransaction)t, procIds[i]);
                    if (proc.state((SharkTransaction)t).equals("open.running")) {
                        proc.checkDeadlines((SharkTransaction)t);
                        SharkUtilities.commitTransaction((SharkTransaction)t);
                    }
                }
                catch (Exception e) {
                    BaseException be = null;
                    be = e instanceof BaseException ? (BaseException)e : new BaseException((Throwable)e);
                    SharkUtilities.rollbackTransaction((SharkTransaction)t, (RootException)be);
                    throw be;
                }
            }
            finally {
                SharkUtilities.releaseTransaction((SharkTransaction)t);
            }
            ++i;
        }
    }

    public void checkDeadlines(SharkTransaction t, String[] procIds) throws BaseException {
        throw new BaseException("Not implemented - please use the method without SharkTransaction parameter");
    }

    public void checkDeadlines(String procId) throws BaseException {
        SharkInternalTransaction t = null;
        try {
            try {
                t = SharkUtilities.createTransaction();
                this.checkDeadlines((SharkTransaction)t, procId);
                SharkUtilities.commitTransaction((SharkTransaction)t);
            }
            catch (RootException e) {
                SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
                if (e instanceof BaseException) {
                    throw (BaseException)e;
                }
                throw new BaseException((Throwable)e);
            }
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void checkDeadlines(SharkTransaction t, String procId) throws BaseException {
        this.checkSecurity(t);
        WfProcessInternal proc = SharkUtilities.getProcess(t, procId);
        if (proc == null) {
            throw new BaseException("Deadline checking failed - can't find process with Id=" + procId);
        }
        if (proc.state(t).equals("open.running")) {
            proc.checkDeadlines(t);
        }
    }

    public void checkDeadline(String procId, String actId) throws BaseException {
        SharkInternalTransaction t = null;
        try {
            try {
                t = SharkUtilities.createTransaction();
                this.checkDeadline((SharkTransaction)t, procId, actId);
                SharkUtilities.commitTransaction((SharkTransaction)t);
            }
            catch (RootException e) {
                SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
                if (e instanceof BaseException) {
                    throw (BaseException)e;
                }
                throw new BaseException((Throwable)e);
            }
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void checkDeadline(SharkTransaction t, String procId, String actId) throws BaseException {
        this.checkSecurity(t);
        WfProcessInternal proc = SharkUtilities.getProcess(t, procId);
        if (proc == null) {
            throw new BaseException("Deadline checking failed - can't find process with Id=" + procId);
        }
        if (proc.state(t).equals("open.running")) {
            proc.checkDeadline(t, actId);
        }
    }

    public DeadlineInfo[] getDeadlineInfo(String procId) throws BaseException {
        DeadlineInfo[] ret;
        SharkInternalTransaction t = null;
        try {
            try {
                t = SharkUtilities.createTransaction();
                ret = this.getDeadlineInfo((SharkTransaction)t, procId);
            }
            catch (RootException e) {
                SharkUtilities.emptyCaches((SharkTransaction)t);
                if (e instanceof BaseException) {
                    throw (BaseException)e;
                }
                throw new BaseException((Throwable)e);
            }
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public DeadlineInfo[] getDeadlineInfo(SharkTransaction t, String procId) throws BaseException {
        this.checkSecurity(t);
        WfProcessInternal proc = SharkUtilities.getProcess(t, procId);
        if (proc == null) {
            throw new BaseException("There is no process with id " + procId + " !");
        }
        List acts = proc.getActiveActivities(t);
        ArrayList dinfo = new ArrayList();
        for (WfActivityInternal act : acts) {
            dinfo.addAll(act.getDeadlineInfo(t));
        }
        DeadlineInfo[] ret = new DeadlineInfo[dinfo.size()];
        dinfo.toArray(ret);
        return ret;
    }

    public DeadlineInfo[] getDeadlineInfo(String procId, String actId) throws BaseException {
        DeadlineInfo[] ret;
        SharkInternalTransaction t = null;
        try {
            try {
                t = SharkUtilities.createTransaction();
                ret = this.getDeadlineInfo((SharkTransaction)t, procId, actId);
            }
            catch (RootException e) {
                SharkUtilities.emptyCaches((SharkTransaction)t);
                if (e instanceof BaseException) {
                    throw (BaseException)e;
                }
                throw new BaseException((Throwable)e);
            }
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public DeadlineInfo[] getDeadlineInfo(SharkTransaction t, String procId, String actId) throws BaseException {
        this.checkSecurity(t);
        WfActivityInternal act = SharkUtilities.getActivity(t, procId, actId);
        if (act == null) {
            throw new BaseException("There is no activity with id " + actId + " in process " + procId + " !");
        }
        List dinfo = act.getDeadlineInfo(t);
        DeadlineInfo[] ret = new DeadlineInfo[dinfo.size()];
        dinfo.toArray(ret);
        return ret;
    }

    protected List getAllRunningProcesses() throws BaseException {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            List list = SharkEngineManager.getInstance().getInstancePersistenceManager().getAllRunningProcesses((SharkTransaction)t);
            return list;
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    protected List getAllDeadlineInvalidProcessIds() throws BaseException {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            List list = SharkEngineManager.getInstance().getInstancePersistenceManager().getAllIdsForProcessesWithExpiriedDeadlines(System.currentTimeMillis(), (SharkTransaction)t);
            return list;
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    protected void checkSecurity() throws BaseException {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            SharkInternalTransaction t = null;
            try {
                try {
                    t = SharkUtilities.createTransaction();
                    sm.check_deadlines((SharkTransaction)t, this.userId);
                    SharkUtilities.commitTransaction((SharkTransaction)t);
                }
                catch (RootException e) {
                    SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
                    if (e instanceof BaseException) {
                        throw (BaseException)e;
                    }
                    throw new BaseException((Throwable)e);
                }
            }
            finally {
                SharkUtilities.releaseTransaction((SharkTransaction)t);
            }
        }
    }

    protected void checkSecurity(SharkTransaction t) throws BaseException {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_deadlines(t, this.userId);
            }
            catch (RootException e) {
                if (e instanceof BaseException) {
                    throw (BaseException)e;
                }
                throw new BaseException((Throwable)e);
            }
        }
    }

    public boolean resetAllDeadlines(SharkTransaction t, String sProcessId, String sActivityId) throws BaseException {
        boolean bRet = false;
        Object syncDeadlineExcName = null;
        Object brokenDeadlines = null;
        ArrayList excNames = new ArrayList();
        PersistentManagerInterface pmgr = SharkEngineManager.getInstance().getInstancePersistenceManager();
        List pDeadlines = null;
        try {
            pDeadlines = SharkEngineManager.getInstance().getInstancePersistenceManager().getAllDeadlinesForActivity(sProcessId, sActivityId, t);
            int i = 0;
            while (i < pDeadlines.size()) {
                DeadlinePersistenceInterface dpo = (DeadlinePersistenceInterface)pDeadlines.get(i);
                dpo.setExecuted(false);
                pmgr.persist(dpo, false, t);
                ++i;
            }
            bRet = true;
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
        return bRet;
    }
}

