/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark;

import java.util.List;
import org.enhydra.shark.SharkEngineManager;
import org.enhydra.shark.SharkUtilities;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfmodel.InvalidPerformer;
import org.enhydra.shark.api.client.wfmodel.WfEventAudit;
import org.enhydra.shark.api.client.wfmodel.WfProcess;
import org.enhydra.shark.api.client.wfmodel.WfProcessIterator;
import org.enhydra.shark.api.client.wfmodel.WfRequester;
import org.enhydra.shark.api.internal.security.SecurityManager;
import org.enhydra.shark.api.internal.transaction.SharkInternalTransaction;

public class WfRequesterWrapper
implements WfRequester {
    private String userAuth;
    private String resourceUsername;

    protected WfRequesterWrapper(String userAuth, String resUsername) {
        this.userAuth = userAuth;
        this.resourceUsername = resUsername;
    }

    public int how_many_performer() throws BaseException {
        int ret = -1;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.how_many_performer((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            throw (BaseException)((Object)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public int how_many_performer(SharkTransaction t) throws BaseException {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_requester_how_many_performer(t, this.resourceUsername, this.userAuth);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        try {
            return SharkEngineManager.getInstance().getInstancePersistenceManager().getResourceRequestersProcessIds(this.resourceUsername, t).size();
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public WfProcessIterator get_iterator_performer() throws BaseException {
        WfProcessIterator ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_iterator_performer((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            throw (BaseException)((Object)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfProcessIterator get_iterator_performer(SharkTransaction t) throws BaseException {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_requester_get_iterator_performer(t, this.resourceUsername, this.userAuth);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        return SharkEngineManager.getInstance().getObjectFactory().createProcessIteratorWrapper(t, this.userAuth, this.resourceUsername, true);
    }

    public WfProcess[] get_sequence_performer(int max_number) throws BaseException {
        WfProcess[] ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_sequence_performer((SharkTransaction)t, max_number);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            throw (BaseException)((Object)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfProcess[] get_sequence_performer(SharkTransaction t, int max_number) throws BaseException {
        List alist;
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_requester_get_sequence_performer(t, this.resourceUsername, this.userAuth);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        if (max_number > (alist = SharkUtilities.createResourceRequesterPerformersWrapper(t, this.userAuth, this.resourceUsername)).size() || max_number <= 0) {
            max_number = alist.size();
        }
        WfProcess[] ret = new WfProcess[max_number];
        alist.subList(0, max_number).toArray(ret);
        return ret;
    }

    public boolean is_member_of_performer(WfProcess member) throws BaseException {
        boolean ret = false;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.is_member_of_performer((SharkTransaction)t, member);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            throw (BaseException)((Object)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public boolean is_member_of_performer(SharkTransaction t, WfProcess member) throws BaseException {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_requester_is_member_of_performer(t, this.resourceUsername, this.userAuth);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        try {
            String procId = member.key(t);
            List ids = SharkEngineManager.getInstance().getInstancePersistenceManager().getResourceRequestersProcessIds(this.resourceUsername, t);
            return ids.contains(procId);
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public void receive_event(WfEventAudit event) throws BaseException, InvalidPerformer {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.receive_event((SharkTransaction)t, event);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            throw (BaseException)((Object)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void receive_event(SharkTransaction t, WfEventAudit event) throws BaseException, InvalidPerformer {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_requester_receive_event(t, this.resourceUsername, this.userAuth);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
    }
}

