/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark;

import java.util.Properties;
import org.enhydra.shark.api.RootError;
import org.enhydra.shark.api.internal.appmappersistence.ApplicationMappingManager;
import org.enhydra.shark.api.internal.assignment.AssignmentManager;
import org.enhydra.shark.api.internal.authentication.AuthenticationManager;
import org.enhydra.shark.api.internal.caching.CacheMgr;
import org.enhydra.shark.api.internal.eventaudit.EventAuditManagerInterface;
import org.enhydra.shark.api.internal.instancepersistence.PersistentManagerInterface;
import org.enhydra.shark.api.internal.interoperability.WfEngineInteroperability;
import org.enhydra.shark.api.internal.limitagent.LimitAgentManager;
import org.enhydra.shark.api.internal.logging.LoggingManager;
import org.enhydra.shark.api.internal.partmappersistence.ParticipantMappingManager;
import org.enhydra.shark.api.internal.processlocking.LockMaster;
import org.enhydra.shark.api.internal.repositorypersistence.RepositoryPersistenceManager;
import org.enhydra.shark.api.internal.scripting.ScriptingManager;
import org.enhydra.shark.api.internal.scriptmappersistence.ScriptMappingManager;
import org.enhydra.shark.api.internal.security.SecurityManager;
import org.enhydra.shark.api.internal.toolagent.ToolAgentFactory;
import org.enhydra.shark.api.internal.transaction.TransactionFactory;
import org.enhydra.shark.api.internal.usergroup.UserGroupManager;
import org.enhydra.shark.api.internal.usertransaction.UserTransactionFactory;
import org.enhydra.shark.api.internal.working.CallbackUtilities;
import org.enhydra.shark.api.internal.working.ObjectFactory;
import org.enhydra.shark.api.internal.working.ToolAgentManager;
import org.enhydra.shark.xpdl.XMLInterface;
import org.enhydra.shark.xpdl.XMLInterfaceForJDK13;

public final class SharkEngineManager {
    private CallbackUtilities callbackUtilities;
    private ObjectFactory objectFactory;
    private ToolAgentManager toolAgentManager;
    private XMLInterface xmlInterface;
    private AssignmentManager assManager;
    private AuthenticationManager authManager;
    private CacheMgr cacheManager;
    private PersistentManagerInterface instancePersistenceMgr;
    private EventAuditManagerInterface instanceEventAuditMgr;
    private LimitAgentManager limitAgentManager;
    private LockMaster lockMaster;
    private LoggingManager logManager;
    private RepositoryPersistenceManager repPersistenceMgr;
    private ScriptingManager scriptingManager;
    private SecurityManager securityManager;
    private ToolAgentFactory toolAgentFactory;
    private TransactionFactory transactionFactory;
    private UserGroupManager userGroupManager;
    private UserTransactionFactory userTransactionFactory;
    private ParticipantMappingManager participantMappings;
    private ApplicationMappingManager applicationMappings;
    private ScriptMappingManager scriptMappings;
    private WfEngineInteroperability wfEngineInteroperabilityMgr;
    private static SharkEngineManager engineManager;

    public static SharkEngineManager getInstance() {
        if (engineManager == null) {
            engineManager = new SharkEngineManager();
        }
        return engineManager;
    }

    void init(Properties properties) {
        block87: {
            String msg;
            boolean throwError;
            ClassLoader cl;
            String wfEIClassName;
            block86: {
                String utfClassName;
                block85: {
                    String ugClassName;
                    block84: {
                        String tfClassName;
                        block83: {
                            String tafClassName;
                            block82: {
                                String seClassName;
                                String smClassName;
                                String rpClassName;
                                block81: {
                                    String smmClassName;
                                    block80: {
                                        String ammClassName;
                                        block79: {
                                            String pmmClassName;
                                            block78: {
                                                String lockMasterClassName;
                                                block77: {
                                                    String lmClassName;
                                                    block76: {
                                                        String eventauditManagerClassName;
                                                        String persistentManagerClassName;
                                                        block75: {
                                                            String cmClassName;
                                                            block74: {
                                                                String auClassName;
                                                                block73: {
                                                                    String amClassName;
                                                                    block72: {
                                                                        String cbuClassName = properties.getProperty("CallbackUtilitiesClassName", "org.enhydra.shark.CallbackUtil");
                                                                        String objectFactoryClassName = properties.getProperty("ObjectFactoryClassName", "org.enhydra.shark.SharkObjectFactory");
                                                                        String tamClassName = properties.getProperty("ToolAgentManagerClassName", "org.enhydra.shark.ToolAgentManagerImpl");
                                                                        amClassName = properties.getProperty("AssignmentManagerClassName");
                                                                        auClassName = properties.getProperty("AuthenticationManagerClassName");
                                                                        cmClassName = properties.getProperty("CacheManagerClassName");
                                                                        persistentManagerClassName = properties.getProperty("InstancePersistenceManagerClassName");
                                                                        eventauditManagerClassName = properties.getProperty("EventAuditManagerClassName");
                                                                        lmClassName = properties.getProperty("LimitAgentManagerClassName");
                                                                        lockMasterClassName = properties.getProperty("LockMasterClassName");
                                                                        String logClassName = properties.getProperty("LoggingManagerClassName");
                                                                        pmmClassName = properties.getProperty("ParticipantMapPersistenceManagerClassName");
                                                                        ammClassName = properties.getProperty("ApplicationMapPersistenceManagerClassName");
                                                                        smmClassName = properties.getProperty("ScriptMapPersistenceManagerClassName");
                                                                        rpClassName = properties.getProperty("RepositoryPersistenceManagerClassName");
                                                                        smClassName = properties.getProperty("ScriptingManagerClassName");
                                                                        seClassName = properties.getProperty("SecurityManagerClassName");
                                                                        tafClassName = properties.getProperty("ToolAgentFactoryClassName");
                                                                        tfClassName = properties.getProperty("TransactionManagerClassName");
                                                                        ugClassName = properties.getProperty("UserGroupManagerClassName");
                                                                        utfClassName = properties.getProperty("UserTransactionManagerClassName");
                                                                        wfEIClassName = properties.getProperty("WfEngineInteroperabilityManagerClassName");
                                                                        cl = this.getClass().getClassLoader();
                                                                        try {
                                                                            this.callbackUtilities = (CallbackUtilities)cl.loadClass(cbuClassName).newInstance();
                                                                            this.callbackUtilities.setProperties(properties);
                                                                            this.objectFactory = (ObjectFactory)cl.loadClass(objectFactoryClassName).newInstance();
                                                                            this.toolAgentManager = (ToolAgentManager)cl.loadClass(tamClassName).newInstance();
                                                                            this.xmlInterface = new XMLInterfaceForJDK13();
                                                                        }
                                                                        catch (Throwable ex) {
                                                                            String msg2 = "SharkEngineManager -> Problems instantiating core managers - ";
                                                                            msg2 = this.callbackUtilities == null ? msg2 + "Can't find CallbackUtilities class '" + cbuClassName + "' in classpath!" : (this.objectFactory == null ? msg2 + "Can't find ObjectFactory class '" + objectFactoryClassName + "' in classpath!" : (this.toolAgentManager == null ? msg2 + "Can't find ToolAgentManager class '" + tamClassName + "' in classpath!" : msg2 + "Unknown problem!"));
                                                                            System.err.println(msg2);
                                                                            throw new RootError(msg2, ex);
                                                                        }
                                                                        try {
                                                                            this.logManager = (LoggingManager)cl.loadClass(logClassName).newInstance();
                                                                            this.logManager.configure(this.callbackUtilities);
                                                                            this.callbackUtilities.info("SharkEngineManager -> Working with '" + cbuClassName + "' implementation of core CallbackUtilities API");
                                                                            this.callbackUtilities.info("SharkEngineManager -> Working with '" + objectFactoryClassName + "' implementation of core SharkObjectFactory API");
                                                                            this.callbackUtilities.info("SharkEngineManager -> Working with '" + tamClassName + "' implementation of core ToolAgentManager API");
                                                                            this.callbackUtilities.info("SharkEngineManager -> Working with '" + logClassName + "' implementation of Logging API");
                                                                        }
                                                                        catch (Exception ex) {
                                                                            throwError = true;
                                                                            msg = "SharkEngineManager -> Can't work - ";
                                                                            if (logClassName == null || logClassName.trim().equals("")) {
                                                                                msg = "SharkEngineManager -> Working without Logging API implementation - ";
                                                                                msg = msg + "LoggingManager is not specified.";
                                                                                throwError = false;
                                                                            } else {
                                                                                msg = this.logManager == null ? msg + "Can't find LoggingManager class '" + logClassName + "' in classpath!" : msg + "Problems while configuring LoggingManager!";
                                                                            }
                                                                            this.callbackUtilities.info(msg);
                                                                            if (!throwError) break block72;
                                                                            throw new RootError(msg, (Throwable)ex);
                                                                        }
                                                                    }
                                                                    try {
                                                                        this.assManager = (AssignmentManager)cl.loadClass(amClassName).newInstance();
                                                                        this.assManager.configure(this.callbackUtilities);
                                                                        this.callbackUtilities.info("SharkEngineManager -> Working with '" + amClassName + "' implementation of Assignment API");
                                                                    }
                                                                    catch (Exception ex) {
                                                                        throwError = true;
                                                                        msg = "SharkEngineManager -> Can't work - ";
                                                                        if (amClassName == null || amClassName.trim().equals("")) {
                                                                            msg = "SharkEngineManager -> Working without Assignment API implementation - ";
                                                                            msg = msg + "AssignmentManager is not specified.";
                                                                            throwError = false;
                                                                        } else {
                                                                            msg = this.assManager == null ? msg + "Can't find AssignmentManager class '" + amClassName + "' in classpath!" : msg + "Problems while configuring AssignmentManager!";
                                                                        }
                                                                        this.callbackUtilities.info(msg);
                                                                        if (!throwError) break block73;
                                                                        throw new RootError(msg, (Throwable)ex);
                                                                    }
                                                                }
                                                                try {
                                                                    this.authManager = (AuthenticationManager)cl.loadClass(auClassName).newInstance();
                                                                    this.authManager.configure(this.callbackUtilities);
                                                                    this.callbackUtilities.info("SharkEngineManager -> Working with '" + auClassName + "' implementation of Authentication API");
                                                                }
                                                                catch (Exception ex) {
                                                                    throwError = true;
                                                                    msg = "SharkEngineManager -> Can't work - ";
                                                                    if (auClassName == null || auClassName.trim().equals("")) {
                                                                        msg = "SharkEngineManager -> Working without Authentication API implementation - ";
                                                                        msg = msg + "AuthenticationManager is not specified.";
                                                                        throwError = false;
                                                                    } else {
                                                                        msg = this.authManager == null ? msg + "Can't find AuthenticationManager class '" + auClassName + "' in classpath!" : msg + "Problems while configuring AuthenticationManager!";
                                                                    }
                                                                    this.callbackUtilities.info(msg);
                                                                    if (!throwError) break block74;
                                                                    throw new RootError(msg, (Throwable)ex);
                                                                }
                                                            }
                                                            try {
                                                                this.cacheManager = (CacheMgr)cl.loadClass(cmClassName).newInstance();
                                                                this.cacheManager.configure(this.callbackUtilities);
                                                                this.callbackUtilities.info("SharkEngineManager -> Working with '" + cmClassName + "' implementation of Caching API");
                                                            }
                                                            catch (Exception ex) {
                                                                throwError = true;
                                                                msg = "SharkEngineManager -> Can't work - ";
                                                                if (cmClassName == null || cmClassName.trim().equals("")) {
                                                                    msg = "SharkEngineManager -> Working without Caching API implementation - ";
                                                                    msg = msg + "CacheManager is not specified.";
                                                                    throwError = false;
                                                                } else {
                                                                    msg = this.cacheManager == null ? msg + "Can't find CacheManager class '" + cmClassName + "' in classpath!" : msg + "Problems while configuring CacheManager!";
                                                                }
                                                                this.callbackUtilities.info(msg);
                                                                if (!throwError) break block75;
                                                                throw new RootError(msg, (Throwable)ex);
                                                            }
                                                        }
                                                        try {
                                                            this.instancePersistenceMgr = (PersistentManagerInterface)cl.loadClass(persistentManagerClassName).newInstance();
                                                            this.instancePersistenceMgr.configure(this.callbackUtilities);
                                                            this.callbackUtilities.info("SharkEngineManager -> Working with '" + persistentManagerClassName + "' implementation of InstancePersistence API");
                                                        }
                                                        catch (Exception ex) {
                                                            throwError = true;
                                                            msg = "SharkEngineManager -> Can not work - ";
                                                            msg = persistentManagerClassName == null || persistentManagerClassName.trim().equals("") ? msg + "InstancePersistenceManager is not specified." : (this.instancePersistenceMgr == null ? msg + "Can't find InstancePersistenceManager class '" + persistentManagerClassName + "' in classpath" : msg + "Problems while configuring InstancePersistenceManager!");
                                                            this.callbackUtilities.error(msg, ex.getMessage());
                                                            throw new RootError(msg, (Throwable)ex);
                                                        }
                                                        try {
                                                            this.instanceEventAuditMgr = (EventAuditManagerInterface)cl.loadClass(eventauditManagerClassName).newInstance();
                                                            this.instanceEventAuditMgr.configure(this.callbackUtilities);
                                                            this.callbackUtilities.info("SharkEngineManager -> Working with '" + eventauditManagerClassName + "' implementation of EventAudit API");
                                                        }
                                                        catch (Exception ex) {
                                                            throwError = true;
                                                            msg = "SharkEngineManager -> Can't work - ";
                                                            if (eventauditManagerClassName == null || eventauditManagerClassName.trim().equals("")) {
                                                                msg = "SharkEngineManager -> Working without EventAudit API implementation - ";
                                                                msg = msg + "EventAuditManager is not specified.";
                                                                throwError = false;
                                                            } else {
                                                                msg = this.instanceEventAuditMgr == null ? msg + "Can't find EventAuditManager class '" + eventauditManagerClassName + "' in classpath!" : msg + "Problems while configuring EventAuditManager!";
                                                            }
                                                            this.callbackUtilities.info(msg);
                                                            if (!throwError) break block76;
                                                            throw new RootError(msg, (Throwable)ex);
                                                        }
                                                    }
                                                    try {
                                                        this.limitAgentManager = (LimitAgentManager)cl.loadClass(lmClassName).newInstance();
                                                        this.limitAgentManager.configure(this.callbackUtilities);
                                                        this.callbackUtilities.info("SharkEngineManager -> Working with '" + lmClassName + "' implementation of Limit API");
                                                    }
                                                    catch (Exception ex) {
                                                        throwError = true;
                                                        msg = "SharkEngineManager -> Can't work - ";
                                                        if (lmClassName == null || lmClassName.trim().equals("")) {
                                                            msg = "SharkEngineManager -> Working without Limit API implementation - ";
                                                            msg = msg + "LimitAgentManager is not specified.";
                                                            throwError = false;
                                                        } else {
                                                            msg = this.limitAgentManager == null ? msg + "Can't find LimitAgentManager class '" + lmClassName + "' in classpath!" : msg + "Problems while configuring LimitAgentManager!";
                                                        }
                                                        this.callbackUtilities.info(msg);
                                                        if (!throwError) break block77;
                                                        throw new RootError(msg, (Throwable)ex);
                                                    }
                                                }
                                                try {
                                                    this.lockMaster = (LockMaster)cl.loadClass(lockMasterClassName).newInstance();
                                                    this.lockMaster.configure(this.callbackUtilities);
                                                    this.callbackUtilities.info("SharkEngineManager -> Working with '" + lockMasterClassName + "' implementation of ProcessLocking API");
                                                }
                                                catch (Exception ex) {
                                                    throwError = true;
                                                    msg = "SharkEngineManager -> Can't work - ";
                                                    if (lockMasterClassName == null || lockMasterClassName.trim().equals("")) {
                                                        msg = "SharkEngineManager -> Working without ProcessLocking API implementation - ";
                                                        msg = msg + "LockMaster is not specified.";
                                                        throwError = false;
                                                    } else {
                                                        msg = this.lockMaster == null ? msg + "Can't find LockMaster class '" + lockMasterClassName + "' in classpath!" : msg + "Problems while configuring LockMaster!";
                                                    }
                                                    this.callbackUtilities.info(msg);
                                                    if (!throwError) break block78;
                                                    throw new RootError(msg, (Throwable)ex);
                                                }
                                            }
                                            try {
                                                this.participantMappings = (ParticipantMappingManager)cl.loadClass(pmmClassName).newInstance();
                                                this.participantMappings.configure(this.callbackUtilities);
                                                this.callbackUtilities.info("SharkEngineManager -> Working with '" + pmmClassName + "' implementation of ParticipantMapPersistence API");
                                            }
                                            catch (Exception ex) {
                                                throwError = true;
                                                msg = "SharkEngineManager -> Can't work - ";
                                                if (pmmClassName == null || pmmClassName.trim().equals("")) {
                                                    msg = "SharkEngineManager -> Working without ParticipantMapPersistence API implementation - ";
                                                    msg = msg + "ParticipantMapPersistenceManager is not specified.";
                                                    throwError = false;
                                                } else {
                                                    msg = this.participantMappings == null ? msg + "Can't find ParticipantMapPersistenceManager class '" + pmmClassName + "' in classpath!" : msg + "Problems while configuring ParticipantMapPersistenceManager!";
                                                }
                                                this.callbackUtilities.info(msg);
                                                if (!throwError) break block79;
                                                throw new RootError(msg, (Throwable)ex);
                                            }
                                        }
                                        try {
                                            this.applicationMappings = (ApplicationMappingManager)cl.loadClass(ammClassName).newInstance();
                                            this.applicationMappings.configure(this.callbackUtilities);
                                            this.callbackUtilities.info("SharkEngineManager -> Working with '" + ammClassName + "' implementation of ApplicationMapPersistence API");
                                        }
                                        catch (Exception ex) {
                                            throwError = true;
                                            msg = "SharkEngineManager -> Can't work - ";
                                            if (ammClassName == null || ammClassName.trim().equals("")) {
                                                msg = "SharkEngineManager -> Working without ApplicationMapPersistence API implementation - ";
                                                msg = msg + "ApplicationMapPersistenceManager is not specified.";
                                                throwError = false;
                                            } else {
                                                msg = this.applicationMappings == null ? msg + "Can't find ApplicationMapPersistenceManager class '" + ammClassName + "' in classpath!" : msg + "Problems while configuring ApplicationMapPersistenceManager!";
                                            }
                                            this.callbackUtilities.info(msg);
                                            if (!throwError) break block80;
                                            throw new RootError(msg, (Throwable)ex);
                                        }
                                    }
                                    try {
                                        this.scriptMappings = (ScriptMappingManager)cl.loadClass(smmClassName).newInstance();
                                        this.scriptMappings.configure(this.callbackUtilities);
                                        this.callbackUtilities.info("SharkEngineManager -> Working with '" + smmClassName + "' implementation of ScriptMapPersistence API");
                                    }
                                    catch (Exception ex) {
                                        throwError = false;
                                        msg = "SharkEngineManager -> ";
                                        if (smmClassName == null || smmClassName.trim().equals("")) {
                                            msg = "SharkEngineManager -> Working without ScriptMapPersistence API implementation - ";
                                            msg = msg + "ScriptMapPersistenceManager is not specified.";
                                            throwError = false;
                                        } else {
                                            msg = this.scriptMappings == null ? msg + "Can't find ScriptMapPersistenceManager class '" + smmClassName + "' in classpath!" : msg + "Problems while configuring ScriptMapPersistenceManager!";
                                        }
                                        this.callbackUtilities.info(msg);
                                        if (!throwError) break block81;
                                        throw new RootError(msg, (Throwable)ex);
                                    }
                                }
                                try {
                                    this.repPersistenceMgr = (RepositoryPersistenceManager)cl.loadClass(rpClassName).newInstance();
                                    this.repPersistenceMgr.configure(this.callbackUtilities);
                                    this.callbackUtilities.info("SharkEngineManager -> Working with '" + rpClassName + "' implementation of RepositoryPersistence API");
                                }
                                catch (Exception ex) {
                                    throwError = true;
                                    msg = "SharkEngineManager -> Can not work - ";
                                    msg = rpClassName == null || rpClassName.trim().equals("") ? msg + "RepositoryPersistenceManager is not specified." : (this.repPersistenceMgr == null ? msg + "Can't find RepositoryPersistenceManager class '" + rpClassName + "' in classpath" : msg + "Problems while configuring RepositoryPersistenceManager!");
                                    this.callbackUtilities.error(msg, ex.getMessage());
                                    throw new RootError(msg, (Throwable)ex);
                                }
                                try {
                                    this.scriptingManager = (ScriptingManager)cl.loadClass(smClassName).newInstance();
                                    this.scriptingManager.configure(this.callbackUtilities);
                                    this.callbackUtilities.info("SharkEngineManager -> Working with '" + smClassName + "' implementation of Scripting API");
                                }
                                catch (Exception ex) {
                                    throwError = true;
                                    msg = "SharkEngineManager -> Can not work - ";
                                    msg = smClassName == null || smClassName.trim().equals("") ? msg + "ScriptingManager is not specified." : (this.scriptingManager == null ? msg + "Can't find ScriptingManager class '" + smClassName + "' in classpath" : msg + "Problems while configuring ScriptingManager!");
                                    this.callbackUtilities.error(msg, ex.getMessage());
                                    throw new RootError(msg, (Throwable)ex);
                                }
                                try {
                                    this.securityManager = (SecurityManager)cl.loadClass(seClassName).newInstance();
                                    this.securityManager.configure(this.callbackUtilities);
                                    this.callbackUtilities.info("SharkEngineManager -> Working with '" + seClassName + "' implementation of Security API");
                                }
                                catch (Exception ex) {
                                    throwError = true;
                                    msg = "SharkEngineManager -> Can't work - ";
                                    if (seClassName == null || seClassName.trim().equals("")) {
                                        msg = "SharkEngineManager -> Working without Security API implementation - ";
                                        msg = msg + "SecurityManager is not specified.";
                                        throwError = false;
                                    } else {
                                        msg = this.securityManager == null ? msg + "Can't find SecurityManager class '" + seClassName + "' in classpath!" : msg + "Problems while configuring SecurityManager!";
                                    }
                                    this.callbackUtilities.info(msg);
                                    if (!throwError) break block82;
                                    throw new RootError(msg, (Throwable)ex);
                                }
                            }
                            try {
                                this.toolAgentFactory = (ToolAgentFactory)cl.loadClass(tafClassName).newInstance();
                                this.toolAgentFactory.configure(this.callbackUtilities);
                                this.callbackUtilities.info("SharkEngineManager -> Working with '" + tafClassName + "' implementation of ToolAgent API");
                            }
                            catch (Exception ex) {
                                throwError = true;
                                msg = "SharkEngineManager -> Can't work - ";
                                if (tafClassName == null || tafClassName.trim().equals("")) {
                                    msg = "SharkEngineManager -> Working without ToolAgent API implementation - ";
                                    msg = msg + "ToolAgentFactory is not specified.";
                                    throwError = false;
                                } else {
                                    msg = this.toolAgentFactory == null ? msg + "Can't find ToolAgentFactory class '" + tafClassName + "' in classpath!" : msg + "Problems while configuring ToolAgentFactory!";
                                }
                                this.callbackUtilities.info(msg);
                                if (!throwError) break block83;
                                throw new RootError(msg, (Throwable)ex);
                            }
                        }
                        try {
                            this.transactionFactory = (TransactionFactory)cl.loadClass(tfClassName).newInstance();
                            this.transactionFactory.configure(this.callbackUtilities);
                            this.callbackUtilities.info("SharkEngineManager -> Working with '" + tfClassName + "' implementation of Transaction API");
                        }
                        catch (Exception ex) {
                            throwError = true;
                            msg = "SharkEngineManager -> Can't work - ";
                            if (tfClassName == null || tfClassName.trim().equals("")) {
                                msg = "SharkEngineManager -> Working without Transaction API implementation - ";
                                msg = msg + "TransactionManager is not specified.";
                                throwError = false;
                            } else {
                                msg = this.transactionFactory == null ? msg + "Can't find TransactionManager class '" + tfClassName + "' in classpath!" : msg + "Problems while configuring TransactionManager!";
                            }
                            this.callbackUtilities.info(msg);
                            if (!throwError) break block84;
                            throw new RootError(msg, (Throwable)ex);
                        }
                    }
                    try {
                        this.userGroupManager = (UserGroupManager)cl.loadClass(ugClassName).newInstance();
                        this.userGroupManager.configure(this.callbackUtilities);
                        this.callbackUtilities.info("SharkEngineManager -> Working with '" + ugClassName + "' implementation of UserGroup API");
                    }
                    catch (Exception ex) {
                        throwError = true;
                        msg = "SharkEngineManager -> Can't work - ";
                        if (ugClassName == null || ugClassName.trim().equals("")) {
                            msg = "SharkEngineManager -> Working without UserGroup API implementation - ";
                            msg = msg + "UserGroupManager is not specified.";
                            throwError = false;
                        } else {
                            msg = this.userGroupManager == null ? msg + "Can't find UserGroupManager class '" + ugClassName + "' in classpath!" : msg + "Problems while configuring UserGroupManager!";
                        }
                        this.callbackUtilities.info(msg);
                        if (!throwError) break block85;
                        throw new RootError(msg, (Throwable)ex);
                    }
                }
                try {
                    this.userTransactionFactory = (UserTransactionFactory)cl.loadClass(utfClassName).newInstance();
                    this.userTransactionFactory.configure(this.callbackUtilities);
                    this.callbackUtilities.info("SharkEngineManager -> Working with '" + utfClassName + "' implementation of UserTransaction API");
                }
                catch (Exception ex) {
                    throwError = true;
                    msg = "SharkEngineManager -> Can't work - ";
                    if (utfClassName == null || utfClassName.trim().equals("")) {
                        msg = "SharkEngineManager -> Working without UserTransaction API implementation - ";
                        msg = msg + "UserTransactionManager is not specified.";
                        throwError = false;
                    } else {
                        msg = this.userTransactionFactory == null ? msg + "Can't find UserTransactionManager class '" + utfClassName + "' in classpath!" : msg + "Problems while configuring UserTransactionManager!";
                    }
                    this.callbackUtilities.info(msg);
                    if (!throwError) break block86;
                    throw new RootError(msg, (Throwable)ex);
                }
            }
            try {
                this.wfEngineInteroperabilityMgr = (WfEngineInteroperability)cl.loadClass(wfEIClassName).newInstance();
                this.wfEngineInteroperabilityMgr.configure(this.callbackUtilities);
                this.callbackUtilities.info("SharkEngineManager -> Working with '" + wfEIClassName + "' implementation of WfEngineInteroperability API");
            }
            catch (Exception ex) {
                throwError = true;
                msg = "SharkEngineManager -> Can't work - ";
                if (wfEIClassName == null || wfEIClassName.trim().equals("")) {
                    msg = "SharkEngineManager -> Working without wfEngineInteroperability API implementation - ";
                    msg = msg + "WfEngineInteroperability implementation is not specified.";
                    throwError = false;
                } else {
                    msg = this.wfEngineInteroperabilityMgr == null ? msg + "Can't find WfEngineInteroperability class '" + wfEIClassName + "' in classpath!" : msg + "Problems while configuring wfEngineInteroperability implementation " + wfEIClassName + "!";
                }
                this.callbackUtilities.info(msg);
                if (!throwError) break block87;
                throw new RootError(msg, (Throwable)ex);
            }
        }
    }

    public CallbackUtilities getCallbackUtilities() {
        return this.callbackUtilities;
    }

    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public ToolAgentManager getToolAgentManager() {
        return this.toolAgentManager;
    }

    public XMLInterface getXMLInterface() {
        return this.xmlInterface;
    }

    public AssignmentManager getAssignmentManager() {
        return this.assManager;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authManager;
    }

    public CacheMgr getCacheManager() {
        return this.cacheManager;
    }

    public PersistentManagerInterface getInstancePersistenceManager() {
        return this.instancePersistenceMgr;
    }

    public EventAuditManagerInterface getEventAuditManager() {
        return this.instanceEventAuditMgr;
    }

    public LimitAgentManager getLimitAgentManager() {
        return this.limitAgentManager;
    }

    public LockMaster getLockMaster() {
        return this.lockMaster;
    }

    public ParticipantMappingManager getParticipantMapPersistenceManager() {
        return this.participantMappings;
    }

    public ApplicationMappingManager getApplicationMapPersistenceManager() {
        return this.applicationMappings;
    }

    public ScriptMappingManager getScriptMapPersistenceManager() {
        return this.scriptMappings;
    }

    public RepositoryPersistenceManager getRepositoryPersistenceManager() {
        return this.repPersistenceMgr;
    }

    public ScriptingManager getScriptingManager() {
        return this.scriptingManager;
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public ToolAgentFactory getToolAgentFactory() {
        return this.toolAgentFactory;
    }

    public TransactionFactory getTransactionFactory() {
        return this.transactionFactory;
    }

    public UserGroupManager getUserGroupManager() {
        return this.userGroupManager;
    }

    public UserTransactionFactory getUserTransactionFactory() {
        return this.userTransactionFactory;
    }

    public LoggingManager getLoggingManager() {
        return this.logManager;
    }

    public WfEngineInteroperability getWfEngineInteroperabilityMgr() {
        return this.wfEngineInteroperabilityMgr;
    }
}

