/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.enhydra.shark.SharkEngineManager;
import org.enhydra.shark.SharkUtilities;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.TransactionException;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfmodel.NotAssigned;
import org.enhydra.shark.api.internal.instancepersistence.AssignmentPersistenceInterface;
import org.enhydra.shark.api.internal.instancepersistence.PersistenceException;
import org.enhydra.shark.api.internal.instancepersistence.ResourcePersistenceInterface;
import org.enhydra.shark.api.internal.working.ObjectFactory;
import org.enhydra.shark.api.internal.working.WfAssignmentInternal;
import org.enhydra.shark.api.internal.working.WfResourceInternal;

public class WfResourceImpl
implements WfResourceInternal {
    private String resourceKey;
    private String resourceName;
    private Map assignments;
    private boolean justCreated = false;
    private boolean isAssignmentMapValid = false;

    protected WfResourceImpl(SharkTransaction t, String resourceKey) throws BaseException {
        this.justCreated = true;
        this.assignments = new HashMap();
        this.resourceKey = resourceKey;
        SharkUtilities.addResourceToCache(t, this);
        try {
            this.persist(t);
        }
        catch (TransactionException e) {
            throw new BaseException((Throwable)e);
        }
    }

    protected WfResourceImpl(ResourcePersistenceInterface po) {
        this.restore(po);
    }

    public String resource_key(SharkTransaction t) throws BaseException {
        return this.resourceKey;
    }

    public String resource_name(SharkTransaction t) throws BaseException {
        return this.resourceName;
    }

    public void release(SharkTransaction t, WfAssignmentInternal from_assigment, String release_info) throws BaseException, NotAssigned {
        if (!this.getAssignmentsMap(t).containsKey(from_assigment.activityId(t))) {
            throw new NotAssigned("Can't release assignment " + from_assigment + " - it is not assigned to this resource!");
        }
    }

    public String toString() {
        return "[Id=" + this.resourceKey + ",name=" + this.resourceName + "]";
    }

    public synchronized void addAssignment(SharkTransaction t, WfAssignmentInternal ass) throws BaseException {
        if (this.assignments == null) {
            this.assignments = new HashMap();
        }
        this.assignments.put(ass.activityId(t), ass);
    }

    public synchronized void removeAssignment(SharkTransaction t, String procId, String actId) throws BaseException {
        if (this.assignments != null) {
            this.assignments.remove(actId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreAssignment(SharkTransaction t, String mgrName, String procId, String actId, boolean isAccepted) throws BaseException {
        AssignmentPersistenceInterface po = SharkEngineManager.getInstance().getInstancePersistenceManager().createAssignment();
        po.setProcessMgrName(mgrName);
        po.setProcessId(procId);
        po.setActivityId(actId);
        po.setResourceUsername(this.resourceKey);
        po.setAccepted(isAccepted);
        WfAssignmentInternal ass = SharkEngineManager.getInstance().getObjectFactory().createAssignment(po, (WfResourceInternal)this);
        WfResourceImpl wfResourceImpl = this;
        synchronized (wfResourceImpl) {
            if (this.assignments == null) {
                this.assignments = new HashMap();
            }
            this.assignments.put(actId, ass);
        }
    }

    protected synchronized Map getAssignmentsMap(SharkTransaction t) throws BaseException {
        if (this.assignments == null || !this.isAssignmentMapValid) {
            try {
                this.assignments = new HashMap();
                List l = SharkEngineManager.getInstance().getInstancePersistenceManager().getAllValidAssignmentsForResource(this.resourceKey, t);
                ObjectFactory objectFactory = SharkEngineManager.getInstance().getObjectFactory();
                int i = 0;
                while (i < l.size()) {
                    AssignmentPersistenceInterface po = (AssignmentPersistenceInterface)l.get(i);
                    if (!this.assignments.containsKey(po.getActivityId())) {
                        WfAssignmentInternal ass = objectFactory.createAssignment(po, (WfResourceInternal)this);
                        this.assignments.put(po.getActivityId(), ass);
                    }
                    ++i;
                }
                this.isAssignmentMapValid = true;
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        return this.assignments;
    }

    public synchronized List getAssignments(SharkTransaction t) throws BaseException {
        return new ArrayList(this.getAssignmentsMap(t).values());
    }

    public synchronized WfAssignmentInternal getAssignment(SharkTransaction t, String procId, String actId) throws BaseException {
        WfAssignmentInternal ass = null;
        if (this.assignments != null) {
            ass = (WfAssignmentInternal)this.assignments.get(actId);
        }
        if (ass == null) {
            try {
                AssignmentPersistenceInterface po = SharkEngineManager.getInstance().getInstancePersistenceManager().restoreAssignment(actId, this.resourceKey, t);
                if (po != null) {
                    ass = SharkEngineManager.getInstance().getObjectFactory().createAssignment(po, (WfResourceInternal)this);
                    if (this.assignments == null) {
                        this.assignments = new HashMap();
                    }
                    this.assignments.put(actId, ass);
                }
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        return (WfAssignmentInternal)this.assignments.get(actId);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WfResourceImpl)) {
            return false;
        }
        return ((WfResourceImpl)obj).resourceKey.equals(this.resourceKey);
    }

    public void persist(SharkTransaction t) throws TransactionException {
        try {
            SharkEngineManager.getInstance().getInstancePersistenceManager().persist(this.createAndFillPersistentObject(), this.justCreated, t);
            this.justCreated = false;
        }
        catch (PersistenceException pe) {
            throw new TransactionException((Throwable)pe);
        }
    }

    public void delete(SharkTransaction t) throws TransactionException {
        try {
            SharkEngineManager.getInstance().getInstancePersistenceManager().deleteResource(this.resourceKey, t);
            SharkUtilities.removeResourceFromCache(t, this);
        }
        catch (Exception ex) {
            throw new TransactionException("Exception while deleting assignment", (Throwable)ex);
        }
    }

    private ResourcePersistenceInterface createAndFillPersistentObject() {
        ResourcePersistenceInterface po = SharkEngineManager.getInstance().getInstancePersistenceManager().createResource();
        this.fillPersistentObject(po);
        return po;
    }

    private void fillPersistentObject(ResourcePersistenceInterface po) {
        po.setUsername(this.resourceKey);
        po.setName(this.resourceName);
    }

    private void restore(ResourcePersistenceInterface po) {
        this.resourceKey = po.getUsername();
        this.resourceName = po.getName();
    }
}

