/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark;

import java.util.List;
import org.enhydra.shark.SharkEngineManager;
import org.enhydra.shark.SharkUtilities;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.TransactionException;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfmodel.InvalidResource;
import org.enhydra.shark.api.internal.instancepersistence.AssignmentPersistenceInterface;
import org.enhydra.shark.api.internal.instancepersistence.PersistenceException;
import org.enhydra.shark.api.internal.working.WfActivityInternal;
import org.enhydra.shark.api.internal.working.WfAssignmentInternal;
import org.enhydra.shark.api.internal.working.WfResourceInternal;

public class WfAssignmentImpl
implements WfAssignmentInternal {
    private String activityId;
    private String resourceUsername;
    private String mgrName;
    private String processId;
    private boolean isAccepted = false;
    private WfResourceInternal resource;
    private String oldAssignee = null;
    private boolean justCreated = false;

    protected WfAssignmentImpl(SharkTransaction t, WfActivityInternal activity, WfResourceInternal resource) throws BaseException {
        this.resource = resource;
        this.justCreated = true;
        this.activityId = activity.key(t);
        this.resourceUsername = resource.resource_key(t);
        this.mgrName = activity.container(t).manager_name(t);
        this.processId = activity.process_id(t);
        try {
            this.persist(t);
        }
        catch (TransactionException tme) {
            throw new BaseException((Throwable)tme);
        }
        if (SharkEngineManager.getInstance().getEventAuditManager() != null) {
            SharkEngineManager.getInstance().getObjectFactory().createAssignmentEventAuditWrapper(t, activity, null, resource, false);
        }
        resource.addAssignment(t, (WfAssignmentInternal)this);
    }

    public WfAssignmentImpl(AssignmentPersistenceInterface po, WfResourceInternal res) {
        this.resource = res;
        this.restore(po);
    }

    public WfActivityInternal activity(SharkTransaction t) throws BaseException {
        return SharkUtilities.getActivity(t, this.processId, this.activityId);
    }

    public WfResourceInternal assignee(SharkTransaction t) throws BaseException {
        if (this.resource == null) {
            this.resource = SharkUtilities.getResource(t, this.resourceUsername);
        }
        return this.resource;
    }

    public void set_assignee(SharkTransaction t, WfResourceInternal new_value) throws BaseException, InvalidResource {
        if (new_value == null) {
            throw new InvalidResource("Can not change resource to null");
        }
        WfActivityInternal act = this.activity(t);
        List assResIds = act.getAssignmentResourceIds(t);
        boolean reassignToInvalid = false;
        if (assResIds.contains(new_value.resource_key(t))) {
            if (act.getResourceUsername(t) == null) {
                throw new InvalidResource("Such assignment already exists!");
            }
            reassignToInvalid = true;
        }
        WfResourceInternal old_value = this.assignee(t);
        old_value.removeAssignment(t, this.processId, this.activityId);
        String oldUsername = this.resourceUsername;
        this.resource = new_value;
        this.resourceUsername = new_value.resource_key(t);
        act.updateAssignmentResourceIds(t, oldUsername, this.resourceUsername);
        this.oldAssignee = oldUsername;
        try {
            if (reassignToInvalid) {
                SharkEngineManager.getInstance().getInstancePersistenceManager().deleteAssignment(this.activityId, this.resourceUsername, t);
            }
            this.persist(t);
        }
        catch (Exception te) {
            throw new BaseException((Throwable)te);
        }
        if (SharkEngineManager.getInstance().getEventAuditManager() != null) {
            SharkEngineManager.getInstance().getObjectFactory().createAssignmentEventAuditWrapper(t, act, old_value, new_value, act.accepted_status(t));
        }
        this.resource.addAssignment(t, (WfAssignmentInternal)this);
    }

    public final String managerName(SharkTransaction t) throws BaseException {
        return this.mgrName;
    }

    public final String processId(SharkTransaction t) throws BaseException {
        return this.processId;
    }

    public final String activityId(SharkTransaction t) throws BaseException {
        return this.activityId;
    }

    public final String resourceUsername(SharkTransaction t) throws BaseException {
        return this.resourceUsername;
    }

    public String toString() {
        return "[" + this.activityId + "->" + this.resourceUsername + "]";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WfAssignmentImpl)) {
            return false;
        }
        WfAssignmentImpl ass = (WfAssignmentImpl)obj;
        return ass.activityId.equals(this.activityId) && ass.resourceUsername.equals(this.resourceUsername);
    }

    public void persist(SharkTransaction t) throws TransactionException {
        try {
            if (this.oldAssignee == null) {
                SharkEngineManager.getInstance().getInstancePersistenceManager().persist(this.createAndFillPersistentObject(), this.justCreated, t);
            } else {
                SharkEngineManager.getInstance().getInstancePersistenceManager().persist(this.createAndFillPersistentObject(), this.oldAssignee, t);
                this.oldAssignee = null;
            }
            this.justCreated = false;
        }
        catch (PersistenceException pe) {
            throw new TransactionException((Throwable)pe);
        }
    }

    public void delete(SharkTransaction t) throws TransactionException {
        try {
            SharkEngineManager.getInstance().getInstancePersistenceManager().deleteAssignment(this.activityId, this.resourceUsername, t);
            this.assignee(t).removeAssignment(t, this.processId, this.activityId);
        }
        catch (Exception ex) {
            throw new TransactionException("Exception while deleting assignment", (Throwable)ex);
        }
    }

    private AssignmentPersistenceInterface createAndFillPersistentObject() {
        AssignmentPersistenceInterface po = SharkEngineManager.getInstance().getInstancePersistenceManager().createAssignment();
        po.setProcessMgrName(this.mgrName);
        po.setProcessId(this.processId);
        po.setActivityId(this.activityId);
        po.setResourceUsername(this.resourceUsername);
        po.setValid(true);
        po.setAccepted(this.isAccepted);
        return po;
    }

    private void restore(AssignmentPersistenceInterface po) {
        this.activityId = po.getActivityId();
        this.resourceUsername = po.getResourceUsername();
        this.processId = po.getProcessId();
        this.mgrName = po.getProcessMgrName();
        this.isAccepted = po.isAccepted();
    }
}

