/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark;

import java.io.File;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.enhydra.shark.PackageFileFilter;
import org.enhydra.shark.SharkEngineManager;
import org.enhydra.shark.api.ApplicationMappingTransaction;
import org.enhydra.shark.api.ParticipantMappingTransaction;
import org.enhydra.shark.api.RepositoryTransaction;
import org.enhydra.shark.api.RootError;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.ScriptMappingTransaction;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.TransactionException;
import org.enhydra.shark.api.UserTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfmodel.WfActivity;
import org.enhydra.shark.api.client.wfmodel.WfAssignment;
import org.enhydra.shark.api.client.wfmodel.WfProcess;
import org.enhydra.shark.api.client.wfmodel.WfProcessMgr;
import org.enhydra.shark.api.client.wfmodel.WfResource;
import org.enhydra.shark.api.common.SharkConstants;
import org.enhydra.shark.api.internal.appmappersistence.ApplicationMappingManager;
import org.enhydra.shark.api.internal.assignment.AssignmentManager;
import org.enhydra.shark.api.internal.assignment.PerformerData;
import org.enhydra.shark.api.internal.authentication.AuthenticationManager;
import org.enhydra.shark.api.internal.caching.CacheMgr;
import org.enhydra.shark.api.internal.caching.ProcessCache;
import org.enhydra.shark.api.internal.caching.ResourceCache;
import org.enhydra.shark.api.internal.eventaudit.AssignmentEventAuditPersistenceInterface;
import org.enhydra.shark.api.internal.eventaudit.CreateProcessEventAuditPersistenceInterface;
import org.enhydra.shark.api.internal.eventaudit.DataEventAuditPersistenceInterface;
import org.enhydra.shark.api.internal.eventaudit.EventAuditManagerInterface;
import org.enhydra.shark.api.internal.eventaudit.EventAuditPersistenceInterface;
import org.enhydra.shark.api.internal.eventaudit.StateEventAuditPersistenceInterface;
import org.enhydra.shark.api.internal.instancepersistence.AssignmentPersistenceInterface;
import org.enhydra.shark.api.internal.instancepersistence.PersistenceException;
import org.enhydra.shark.api.internal.instancepersistence.PersistentManagerInterface;
import org.enhydra.shark.api.internal.instancepersistence.ProcessMgrPersistenceInterface;
import org.enhydra.shark.api.internal.instancepersistence.ProcessPersistenceInterface;
import org.enhydra.shark.api.internal.instancepersistence.ResourcePersistenceInterface;
import org.enhydra.shark.api.internal.partmappersistence.ParticipantMappingManager;
import org.enhydra.shark.api.internal.processlocking.LockMaster;
import org.enhydra.shark.api.internal.repositorypersistence.RepositoryPersistenceManager;
import org.enhydra.shark.api.internal.scripting.Evaluator;
import org.enhydra.shark.api.internal.scriptmappersistence.ScriptMappingManager;
import org.enhydra.shark.api.internal.security.SecurityManager;
import org.enhydra.shark.api.internal.toolagent.ToolAgentGeneralException;
import org.enhydra.shark.api.internal.transaction.SharkInternalTransaction;
import org.enhydra.shark.api.internal.transaction.TransactionFactory;
import org.enhydra.shark.api.internal.usertransaction.UserTransactionFactory;
import org.enhydra.shark.api.internal.working.CallbackUtilities;
import org.enhydra.shark.api.internal.working.ObjectFactory;
import org.enhydra.shark.api.internal.working.WfActivityInternal;
import org.enhydra.shark.api.internal.working.WfAssignmentInternal;
import org.enhydra.shark.api.internal.working.WfProcessInternal;
import org.enhydra.shark.api.internal.working.WfProcessMgrInternal;
import org.enhydra.shark.api.internal.working.WfResourceInternal;
import org.enhydra.shark.utilities.MiscUtilities;
import org.enhydra.shark.utilities.SequencedHashMap;
import org.enhydra.shark.xpdl.Version;
import org.enhydra.shark.xpdl.XMLCollectionElement;
import org.enhydra.shark.xpdl.XMLElement;
import org.enhydra.shark.xpdl.XMLInterface;
import org.enhydra.shark.xpdl.XMLInterfaceForJDK13;
import org.enhydra.shark.xpdl.XMLUtil;
import org.enhydra.shark.xpdl.elements.Activities;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.ActivitySet;
import org.enhydra.shark.xpdl.elements.ActualParameter;
import org.enhydra.shark.xpdl.elements.ActualParameters;
import org.enhydra.shark.xpdl.elements.Application;
import org.enhydra.shark.xpdl.elements.BlockActivity;
import org.enhydra.shark.xpdl.elements.DataField;
import org.enhydra.shark.xpdl.elements.DataType;
import org.enhydra.shark.xpdl.elements.ExtendedAttribute;
import org.enhydra.shark.xpdl.elements.ExtendedAttributes;
import org.enhydra.shark.xpdl.elements.ExternalPackage;
import org.enhydra.shark.xpdl.elements.FormalParameter;
import org.enhydra.shark.xpdl.elements.FormalParameters;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.Participant;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;

public class SharkUtilities {
    private static Map validActivityStates = new HashMap();
    private static Map validProcessStates;
    public static final String EXTERNAL_PACKAGES_REPOSITORY;
    private static int nextConnectionKey;
    private static Map loggedUsers;
    private static Map currentPkgVersions;
    private static PackageFileFilter packageFileFilter;
    static /* synthetic */ Class class$java$lang$Object;

    static final List valid_activity_states(String currentState) {
        return (List)validActivityStates.get(currentState);
    }

    static final List valid_process_states(String currentState) {
        return (List)validProcessStates.get(currentState);
    }

    static synchronized String getNextConnectionKey() {
        String ck = Integer.toString(nextConnectionKey);
        ++nextConnectionKey;
        return ck;
    }

    static String connect(String userId) {
        String connectionKey = SharkUtilities.getNextConnectionKey();
        loggedUsers.put(connectionKey, userId);
        return connectionKey;
    }

    static void disconnect(String connectionKey) {
        loggedUsers.remove(connectionKey);
    }

    static Map getLoggedUsers() throws Exception {
        return Collections.unmodifiableMap(loggedUsers);
    }

    static List getDefinedPackageFiles(String repository, boolean traverse) {
        File startingFolder = new File(repository);
        List<Object> packageFiles = new ArrayList();
        if (!startingFolder.exists()) {
            SharkEngineManager.getInstance().getCallbackUtilities().warn("SharkUtilities -> Repository " + startingFolder + " doesn't exist");
        }
        if (traverse) {
            MiscUtilities.traverse((File)startingFolder, packageFiles, null);
        } else {
            packageFiles = Arrays.asList(startingFolder.listFiles(packageFileFilter));
        }
        return packageFiles;
    }

    static String convertToAbsolutePath(String relativePathToPackage) {
        String absolutePath = relativePathToPackage;
        List packageFiles = SharkUtilities.getDefinedPackageFiles(EXTERNAL_PACKAGES_REPOSITORY, true);
        String dirName = new File(EXTERNAL_PACKAGES_REPOSITORY).getAbsolutePath();
        Iterator pfi = packageFiles.iterator();
        while (pfi.hasNext()) {
            File f = (File)pfi.next();
            String fileName = f.getAbsolutePath();
            if (!(fileName = fileName.substring(dirName.length() + 1)).equals(relativePathToPackage)) continue;
            absolutePath = f.getAbsolutePath();
            break;
        }
        return absolutePath;
    }

    static List createAllProcessMgrWrappers(SharkTransaction t, String userAuth) throws BaseException {
        try {
            ArrayList<WfProcessMgr> mgrs = new ArrayList<WfProcessMgr>();
            List l = SharkEngineManager.getInstance().getInstancePersistenceManager().getAllProcessMgrs(t);
            for (int i = 0; i < l.size(); ++i) {
                ProcessMgrPersistenceInterface po = (ProcessMgrPersistenceInterface)l.get(i);
                mgrs.add(SharkEngineManager.getInstance().getObjectFactory().createProcessMgrWrapper(userAuth, po.getName()));
            }
            return mgrs;
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    static List createProcessMgrsProcessWrappers(SharkTransaction t, String userAuth, String mgrName) throws BaseException {
        try {
            List l = SharkEngineManager.getInstance().getInstancePersistenceManager().getAllProcessesForMgr(mgrName, t);
            ArrayList<WfProcess> ret = new ArrayList<WfProcess>();
            for (int i = 0; i < l.size(); ++i) {
                ProcessPersistenceInterface po = (ProcessPersistenceInterface)l.get(i);
                ret.add(SharkEngineManager.getInstance().getObjectFactory().createProcessWrapper(userAuth, po.getProcessMgrName(), po.getId()));
            }
            return ret;
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    static List createActivityPerformerWrapper(SharkTransaction t, String userAuth, String procId, String actId) throws BaseException {
        WfActivityInternal act = SharkUtilities.getActivity(t, procId, actId);
        String performerId = act.getPerformerId(t);
        ArrayList<WfProcess> ret = new ArrayList<WfProcess>();
        if (performerId != null) {
            ret.add(SharkEngineManager.getInstance().getObjectFactory().createProcessWrapper(userAuth, act.manager_name(t), performerId));
        }
        return ret;
    }

    static List createResourceRequesterPerformersWrapper(SharkTransaction t, String userAuth, String username) throws BaseException {
        try {
            PersistentManagerInterface ipi = SharkEngineManager.getInstance().getInstancePersistenceManager();
            List l = ipi.getResourceRequestersProcessIds(username, t);
            ArrayList<WfProcess> ret = new ArrayList<WfProcess>();
            for (int i = 0; i < l.size(); ++i) {
                String pId = (String)l.get(i);
                ProcessPersistenceInterface po = ipi.restoreProcess(pId, t);
                ret.add(SharkEngineManager.getInstance().getObjectFactory().createProcessWrapper(userAuth, po.getId(), po.getProcessMgrName()));
            }
            return ret;
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    static List createProcessActivityWrappers(SharkTransaction t, String userAuth, String procId) throws BaseException {
        try {
            WfProcessInternal proc = SharkUtilities.getProcess(t, procId);
            List l = proc.getAllActivities(t);
            ArrayList<WfActivity> ret = new ArrayList<WfActivity>();
            for (int i = 0; i < l.size(); ++i) {
                WfActivityInternal act = (WfActivityInternal)l.get(i);
                ret.add(SharkEngineManager.getInstance().getObjectFactory().createActivityWrapper(userAuth, proc.manager_name(t), procId, act.key(t)));
            }
            return ret;
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    static List createAssignmentWrappers(SharkTransaction t, String userAuth, String procId, String actId) throws BaseException {
        try {
            List objs = SharkEngineManager.getInstance().getInstancePersistenceManager().getAllValidAssignmentsForActivity(actId, t);
            ArrayList<WfAssignment> pobjs = new ArrayList<WfAssignment>();
            Iterator i = objs.iterator();
            while (i.hasNext()) {
                AssignmentPersistenceInterface po = (AssignmentPersistenceInterface)i.next();
                pobjs.add(SharkEngineManager.getInstance().getObjectFactory().createAssignmentWrapper(userAuth, po.getProcessMgrName(), procId, actId, po.getResourceUsername()));
            }
            return pobjs;
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    static List createAssignmentWrappers(SharkTransaction t, String userAuth, String username) throws BaseException {
        try {
            List objs = SharkUtilities.getResource(t, username).getAssignments(t);
            ArrayList<WfAssignment> pobjs = new ArrayList<WfAssignment>();
            Iterator i = objs.iterator();
            while (i.hasNext()) {
                WfAssignmentInternal ass = (WfAssignmentInternal)i.next();
                pobjs.add(SharkEngineManager.getInstance().getObjectFactory().createAssignmentWrapper(userAuth, ass.managerName(t), ass.processId(t), ass.activityId(t), username));
            }
            return pobjs;
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    static List createAllResourceWrappers(SharkTransaction t, String userAuth) throws BaseException {
        try {
            ArrayList<WfResource> resources = new ArrayList<WfResource>();
            List l = SharkEngineManager.getInstance().getInstancePersistenceManager().getAllResources(t);
            for (int i = 0; i < l.size(); ++i) {
                ResourcePersistenceInterface po = (ResourcePersistenceInterface)l.get(i);
                resources.add(SharkEngineManager.getInstance().getObjectFactory().createResourceWrapper(userAuth, po.getUsername()));
            }
            return resources;
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    static List createProcessHistoryEvents(SharkTransaction t, String userAuth, String procId) throws BaseException {
        ArrayList<Object> history = new ArrayList<Object>();
        try {
            EventAuditManagerInterface eam = SharkEngineManager.getInstance().getEventAuditManager();
            if (null == eam) {
                return history;
            }
            List l = eam.restoreProcessHistory(procId, t);
            for (int i = 0; i < l.size(); ++i) {
                EventAuditPersistenceInterface audit = (EventAuditPersistenceInterface)l.get(i);
                if (audit instanceof CreateProcessEventAuditPersistenceInterface) {
                    history.add(SharkEngineManager.getInstance().getObjectFactory().createCreateProcessEventAuditWrapper(userAuth, (CreateProcessEventAuditPersistenceInterface)audit));
                    continue;
                }
                if (audit instanceof DataEventAuditPersistenceInterface) {
                    history.add(SharkEngineManager.getInstance().getObjectFactory().createDataEventAuditWrapper(userAuth, (DataEventAuditPersistenceInterface)audit));
                    continue;
                }
                if (!(audit instanceof StateEventAuditPersistenceInterface)) continue;
                history.add(SharkEngineManager.getInstance().getObjectFactory().createStateEventAuditWrapper(userAuth, (StateEventAuditPersistenceInterface)audit));
            }
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
        return history;
    }

    static List createActivityHistoryEvents(SharkTransaction t, String userAuth, String procId, String actId) throws BaseException {
        ArrayList<Object> history = new ArrayList<Object>();
        try {
            EventAuditManagerInterface eam = SharkEngineManager.getInstance().getEventAuditManager();
            if (null == eam) {
                return history;
            }
            List l = eam.restoreActivityHistory(procId, actId, t);
            for (int i = 0; i < l.size(); ++i) {
                EventAuditPersistenceInterface audit = (EventAuditPersistenceInterface)l.get(i);
                if (audit instanceof AssignmentEventAuditPersistenceInterface) {
                    history.add(SharkEngineManager.getInstance().getObjectFactory().createAssignmentEventAuditWrapper(userAuth, (AssignmentEventAuditPersistenceInterface)audit));
                    continue;
                }
                if (audit instanceof DataEventAuditPersistenceInterface) {
                    history.add(SharkEngineManager.getInstance().getObjectFactory().createDataEventAuditWrapper(userAuth, (DataEventAuditPersistenceInterface)audit));
                    continue;
                }
                if (!(audit instanceof StateEventAuditPersistenceInterface)) continue;
                history.add(SharkEngineManager.getInstance().getObjectFactory().createStateEventAuditWrapper(userAuth, (StateEventAuditPersistenceInterface)audit));
            }
            return history;
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    static void reevaluateAssignments(SharkTransaction t) throws BaseException {
        try {
            ArrayList mgrs = new ArrayList();
            List l = SharkEngineManager.getInstance().getInstancePersistenceManager().getAllProcessMgrs(t);
            for (int i = 0; i < l.size(); ++i) {
                ProcessMgrPersistenceInterface po = (ProcessMgrPersistenceInterface)l.get(i);
                SharkUtilities.reevalAssignments(t, po.getName());
            }
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    static void reevalAssignments(SharkTransaction t, String mgrName) throws BaseException {
        try {
            List l = SharkEngineManager.getInstance().getInstancePersistenceManager().getAllProcessesForMgr(mgrName, t);
            ArrayList ret = new ArrayList();
            for (int i = 0; i < l.size(); ++i) {
                ProcessPersistenceInterface po = (ProcessPersistenceInterface)l.get(i);
                WfProcessInternal proc = SharkUtilities.getProcess(t, po.getId());
                List acts = proc.getActiveActivities(t);
                Iterator itActs = acts.iterator();
                while (itActs.hasNext()) {
                    WfActivityInternal aint = (WfActivityInternal)itActs.next();
                    aint.reevaluateAssignments(t);
                }
            }
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    static boolean lock(SharkTransaction t, String processId) throws BaseException {
        LockMaster lm = SharkEngineManager.getInstance().getLockMaster();
        try {
            return null != lm ? lm.lock(t, processId) : true;
        }
        catch (RootException e) {
            throw new BaseException("lock not acquired", (Throwable)e);
        }
    }

    static void unlock(SharkTransaction t) throws TransactionException {
        LockMaster lm = SharkEngineManager.getInstance().getLockMaster();
        try {
            if (null != lm) {
                lm.unlock(t);
            }
        }
        catch (RootException e) {
            throw new TransactionException("lock not acquired", (Throwable)e);
        }
    }

    static ParticipantMappingTransaction createParticipantMappingTransaction() throws TransactionException {
        try {
            ParticipantMappingManager mm = SharkEngineManager.getInstance().getParticipantMapPersistenceManager();
            return null != mm ? mm.getParticipantMappingTransaction() : null;
        }
        catch (RootException e) {
            throw new TransactionException((Throwable)e);
        }
    }

    static ApplicationMappingTransaction createApplicationMappingTransaction() throws TransactionException {
        try {
            ApplicationMappingManager mm = SharkEngineManager.getInstance().getApplicationMapPersistenceManager();
            return null != mm ? mm.getApplicationMappingTransaction() : null;
        }
        catch (RootException e) {
            throw new TransactionException((Throwable)e);
        }
    }

    static ScriptMappingTransaction createScriptMappingTransaction() throws TransactionException {
        try {
            ScriptMappingManager mm = SharkEngineManager.getInstance().getScriptMapPersistenceManager();
            return null != mm ? mm.getScriptMappingTransaction() : null;
        }
        catch (RootException e) {
            throw new TransactionException((Throwable)e);
        }
    }

    static void commitMappingTransaction(ParticipantMappingTransaction t) throws BaseException {
        try {
            if (null != t) {
                t.commit();
            }
        }
        catch (TransactionException e) {
            throw new BaseException((Throwable)e);
        }
    }

    static void rollbackMappingTransaction(ParticipantMappingTransaction t, RootException ex) throws BaseException {
        SharkEngineManager.getInstance().getCallbackUtilities().error("Rollback of Participant transaction happened.", ex);
        try {
            if (null != t) {
                t.rollback();
            }
        }
        catch (TransactionException e) {
            throw new BaseException((Throwable)e);
        }
    }

    static void releaseMappingTransaction(ParticipantMappingTransaction t) throws BaseException {
        try {
            if (null != t) {
                t.release();
            }
        }
        catch (TransactionException e) {
            throw new BaseException((Throwable)e);
        }
    }

    static void commitMappingTransaction(ApplicationMappingTransaction t) throws BaseException {
        try {
            if (null != t) {
                t.commit();
            }
        }
        catch (TransactionException e) {
            throw new BaseException((Throwable)e);
        }
    }

    static void rollbackMappingTransaction(ApplicationMappingTransaction t, RootException ex) throws BaseException {
        SharkEngineManager.getInstance().getCallbackUtilities().error("Rollback of ApplicationMapping transaction happened.", ex);
        try {
            if (null != t) {
                t.rollback();
            }
        }
        catch (TransactionException e) {
            throw new BaseException((Throwable)e);
        }
    }

    static void releaseMappingTransaction(ApplicationMappingTransaction t) throws BaseException {
        try {
            if (null != t) {
                t.release();
            }
        }
        catch (TransactionException e) {
            throw new BaseException((Throwable)e);
        }
    }

    static void commitMappingTransaction(ScriptMappingTransaction t) throws BaseException {
        try {
            if (null != t) {
                t.commit();
            }
        }
        catch (TransactionException e) {
            throw new BaseException((Throwable)e);
        }
    }

    static void rollbackMappingTransaction(ScriptMappingTransaction t, RootException ex) throws BaseException {
        SharkEngineManager.getInstance().getCallbackUtilities().error("Rollback of ScriptMapping transaction happened.", ex);
        try {
            if (null != t) {
                t.rollback();
            }
        }
        catch (TransactionException e) {
            throw new BaseException((Throwable)e);
        }
    }

    static void releaseMappingTransaction(ScriptMappingTransaction t) throws BaseException {
        try {
            if (null != t) {
                t.release();
            }
        }
        catch (TransactionException e) {
            throw new BaseException((Throwable)e);
        }
    }

    static UserTransaction createUserTransaction() throws TransactionException {
        UserTransactionFactory utf = SharkEngineManager.getInstance().getUserTransactionFactory();
        return null != utf ? utf.createTransaction() : null;
    }

    static void commitUserTransaction(UserTransaction t) throws BaseException {
        try {
            if (null != t) {
                t.commit();
            }
        }
        catch (TransactionException e) {
            throw new BaseException((Throwable)e);
        }
    }

    static void rollbackUserTransaction(UserTransaction t, RootException ex) throws BaseException {
        SharkEngineManager.getInstance().getCallbackUtilities().error("Rollback of User transaction happened.", ex);
        try {
            if (null != t) {
                t.rollback();
            }
        }
        catch (TransactionException e) {
            throw new BaseException((Throwable)e);
        }
    }

    static void releaseUserTransaction(UserTransaction t) throws BaseException {
        try {
            if (null != t) {
                t.release();
            }
        }
        catch (TransactionException e) {
            throw new BaseException((Throwable)e);
        }
    }

    static RepositoryTransaction createRepositoryTransaction() throws TransactionException {
        RepositoryPersistenceManager rpm = SharkEngineManager.getInstance().getRepositoryPersistenceManager();
        return null != rpm ? rpm.createTransaction() : null;
    }

    static void commitRepositoryTransaction(RepositoryTransaction t) throws BaseException {
        try {
            if (null != t) {
                t.commit();
            }
        }
        catch (TransactionException e) {
            throw new BaseException((Throwable)e);
        }
    }

    static void rollbackRepositoryTransaction(RepositoryTransaction t, RootException ex) throws BaseException {
        SharkEngineManager.getInstance().getCallbackUtilities().error("Rollback of Repository transaction happened.", ex);
        try {
            if (null != t) {
                t.rollback();
            }
        }
        catch (TransactionException e) {
            throw new BaseException((Throwable)e);
        }
    }

    static void releaseRepositoryTransaction(RepositoryTransaction t) throws BaseException {
        try {
            if (null != t) {
                t.release();
            }
        }
        catch (TransactionException e) {
            throw new BaseException((Throwable)e);
        }
    }

    static SharkInternalTransaction createTransaction() throws TransactionException {
        TransactionFactory tf = SharkEngineManager.getInstance().getTransactionFactory();
        return null != tf ? tf.createTransaction() : null;
    }

    static void commitTransaction(SharkTransaction t) throws BaseException {
        try {
            if (null != t) {
                t.commit();
            }
        }
        catch (TransactionException e) {
            throw new BaseException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void releaseTransaction(SharkTransaction t) throws BaseException {
        try {
            try {
                SharkUtilities.unlock(t);
            }
            catch (TransactionException e) {
                throw new BaseException((Throwable)e);
            }
            Object var3_1 = null;
            if (null == t) return;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            if (null == t) throw throwable;
            try {
                t.release();
                throw throwable;
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        try {}
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
        t.release();
    }

    static void rollbackTransaction(SharkTransaction t, RootException ex) throws BaseException {
        SharkEngineManager.getInstance().getCallbackUtilities().error("Rollback of Shark transaction happened.", ex);
        SharkUtilities.emptyCaches(t);
        if (null != t) {
            try {
                t.rollback();
            }
            catch (TransactionException oops) {
                throw new BaseException((Throwable)oops);
            }
        }
    }

    static void emptyCaches(SharkTransaction t) {
        CacheMgr cm = SharkEngineManager.getInstance().getCacheManager();
        if (null != cm) {
            ProcessCache procache = cm.getProcessCache();
            ResourceCache rescache = cm.getResourceCache();
            LockMaster lm = SharkEngineManager.getInstance().getLockMaster();
            if (null != lm) {
                try {
                    List processLocks = lm.getLocks(t);
                    Iterator it = processLocks.iterator();
                    while (it.hasNext()) {
                        String pLock = (String)it.next();
                        procache.remove(pLock);
                    }
                }
                catch (RootException e) {}
            } else {
                try {
                    int size = procache.getSize();
                    procache.setSize(0);
                    procache.setSize(size);
                }
                catch (RootException e) {
                    // empty catch block
                }
            }
            try {
                int size = rescache.getSize();
                rescache.setSize(0);
                rescache.setSize(size);
            }
            catch (RootException e) {
                // empty catch block
            }
        }
    }

    static void addResourceToCache(SharkTransaction t, WfResourceInternal r) throws BaseException {
        try {
            ((SharkInternalTransaction)t).addToTransaction(r.resource_key(t), r);
        }
        catch (RootException ex) {
            throw new BaseException((Throwable)ex);
        }
        CacheMgr cm = SharkEngineManager.getInstance().getCacheManager();
        if (null != cm) {
            try {
                cm.getResourceCache().add(r.resource_key(t), r);
            }
            catch (RootException rootException) {
                // empty catch block
            }
        }
    }

    static void removeResourceFromCache(SharkTransaction t, WfResourceInternal r) throws RootException {
        CacheMgr cm = SharkEngineManager.getInstance().getCacheManager();
        if (null != cm) {
            cm.getResourceCache().remove(r.resource_key(t));
        }
    }

    static WfResourceInternal getResourceFromCache(SharkTransaction t, String username) throws RootException {
        CacheMgr cm;
        WfResourceInternal res = ((SharkInternalTransaction)t).getResource(username);
        if (res == null && null != (cm = SharkEngineManager.getInstance().getCacheManager())) {
            try {
                res = cm.getResourceCache().get(username);
                if (res != null) {
                    ((SharkInternalTransaction)t).addToTransaction(username, res);
                }
            }
            catch (RootException ex) {
                // empty catch block
            }
        }
        return res;
    }

    static WfResourceInternal getResource(SharkTransaction t, String username) throws BaseException {
        try {
            PersistentManagerInterface pmi;
            ResourcePersistenceInterface po;
            SharkEngineManager em = SharkEngineManager.getInstance();
            ObjectFactory objectFactory = em.getObjectFactory();
            WfResourceInternal res = SharkUtilities.getResourceFromCache(t, username);
            if (res == null && (po = (pmi = em.getInstancePersistenceManager()).restoreResource(username, t)) != null) {
                res = objectFactory.createResource(po);
                SharkUtilities.addResourceToCache(t, res);
            }
            return res;
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    static void addProcessToCache(SharkTransaction t, WfProcessInternal p) throws BaseException {
        try {
            ((SharkInternalTransaction)t).addToTransaction(p.key(t), p);
        }
        catch (RootException ex) {
            throw new BaseException((Throwable)ex);
        }
        CacheMgr cm = SharkEngineManager.getInstance().getCacheManager();
        if (null != cm) {
            try {
                cm.getProcessCache().add(p.key(t), p);
            }
            catch (RootException rootException) {
                // empty catch block
            }
        }
    }

    static void removeProcessFromCache(SharkTransaction t, WfProcessInternal p) throws RootException {
        CacheMgr cm = SharkEngineManager.getInstance().getCacheManager();
        if (null != cm) {
            cm.getProcessCache().remove(p.key(t));
        }
    }

    private static WfProcessInternal getProcessFromCache(SharkTransaction t, String procId) throws RootException {
        CacheMgr cm;
        WfProcessInternal proc = ((SharkInternalTransaction)t).getProcess(procId);
        if (proc == null && null != (cm = SharkEngineManager.getInstance().getCacheManager())) {
            try {
                proc = cm.getProcessCache().get(procId);
            }
            catch (RootException ex) {
                // empty catch block
            }
        }
        return proc;
    }

    static WfProcessInternal getProcess(SharkTransaction t, String procId) throws BaseException {
        SharkUtilities.lock(t, procId);
        try {
            PersistentManagerInterface pmi;
            ProcessPersistenceInterface po;
            ObjectFactory objectFactory = SharkEngineManager.getInstance().getObjectFactory();
            WfProcessInternal proc = SharkUtilities.getProcessFromCache(t, procId);
            if (proc == null && (po = (pmi = SharkEngineManager.getInstance().getInstancePersistenceManager()).restoreProcess(procId, t)) != null) {
                proc = objectFactory.createProcess(po);
                SharkUtilities.addProcessToCache(t, proc);
            }
            return proc;
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    static WfProcessMgrInternal getProcessMgr(SharkTransaction t, String name) throws BaseException {
        try {
            WfProcessMgrInternal mgr = null;
            PersistentManagerInterface pmi = SharkEngineManager.getInstance().getInstancePersistenceManager();
            ProcessMgrPersistenceInterface po = pmi.restoreProcessMgr(name, t);
            if (po != null) {
                mgr = SharkEngineManager.getInstance().getObjectFactory().createProcessMgr(po);
            }
            return mgr;
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    static WfActivityInternal getActivity(SharkTransaction t, String procId, String actId) throws BaseException {
        try {
            WfProcessInternal proc = SharkUtilities.getProcess(t, procId);
            WfActivityInternal act = proc.getActivity(t, actId);
            return act;
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    static WfAssignmentInternal getAssignment(SharkTransaction t, String procId, String actId, String username) throws BaseException {
        try {
            WfResourceInternal res = SharkUtilities.getResource(t, username);
            WfAssignmentInternal ass = res.getAssignment(t, procId, actId);
            return ass;
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    static WfAssignment getAssignmentWrapper(SharkTransaction t, String userAuth, String procId, String assId) throws BaseException {
        try {
            String[] tokens = MiscUtilities.tokenize((String)assId, (String)"#");
            String actId = tokens[0];
            String uname = tokens[1];
            WfResourceInternal res = SharkUtilities.getResource(t, uname);
            WfAssignmentInternal ass = null;
            if (res != null) {
                ass = res.getAssignment(t, procId, actId);
            }
            if (ass != null) {
                return SharkEngineManager.getInstance().getObjectFactory().createAssignmentWrapper(userAuth, ass.managerName(t), procId, actId, uname);
            }
            return null;
        }
        catch (Exception ex) {
            throw new BaseException("Invalid process or assignment Id", (Throwable)ex);
        }
    }

    static List getAssignments(SharkTransaction t, String engineName, String procId, String actId, List userIds, List responsibleIds, String processRequesterId, PerformerData xpdlParticipant, List xpdlResponsibleParticipants) throws RootException {
        AssignmentManager am = SharkEngineManager.getInstance().getAssignmentManager();
        if (am != null) {
            return am.getAssignments(t, engineName, procId, actId, userIds, responsibleIds, processRequesterId, xpdlParticipant, xpdlResponsibleParticipants);
        }
        if (userIds != null && userIds.size() > 0) {
            return userIds;
        }
        if (responsibleIds != null && responsibleIds.size() > 0) {
            return responsibleIds;
        }
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(processRequesterId);
        return ret;
    }

    static List getSecureAssignments(SharkTransaction t, String engineName, String procId, String actId, List userIds) throws RootException {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            return sm.getAssignments(t, engineName, procId, actId, userIds);
        }
        return userIds;
    }

    static boolean validateUser(String username, String pwd) throws RootException {
        AuthenticationManager am = SharkEngineManager.getInstance().getAuthenticationManager();
        boolean ret = true;
        UserTransaction ut = null;
        try {
            ut = SharkUtilities.createUserTransaction();
            if (am != null) {
                ret = am.validateUser(ut, username, pwd);
            }
            boolean bl = ret;
            return bl;
        }
        catch (RootException e) {
            throw e;
        }
        finally {
            SharkUtilities.releaseUserTransaction(ut);
        }
    }

    static boolean checkDataType(SharkTransaction t, WorkflowProcess wp, String nm, Object oldVal, Object val) throws BaseException {
        if (val == null) {
            return true;
        }
        if (oldVal != null && oldVal.getClass().isInstance(val)) {
            return true;
        }
        if (oldVal == null) {
            XMLCollectionElement dfOrFp = (XMLCollectionElement)wp.getAllVariables().get(nm);
            if (dfOrFp == null) {
                throw new BaseException("Can't find variable with Id=" + nm + " in XPDL definition");
            }
            Class cls = SharkUtilities.getJavaClass(dfOrFp);
            if (cls.isInstance(val)) {
                return true;
            }
        }
        return false;
    }

    static Object getInitialValue(XMLCollectionElement dfOrFp, boolean forceDefaultValueForType) {
        String initialValStr = null;
        if (dfOrFp instanceof DataField) {
            initialValStr = ((DataField)dfOrFp).getInitialValue();
            if (initialValStr.equalsIgnoreCase("null")) {
                return null;
            }
            if (forceDefaultValueForType) {
                initialValStr = "";
            }
        } else {
            initialValStr = "";
        }
        return SharkUtilities.createInitialValue(initialValStr, dfOrFp);
    }

    static Class getJavaClass(XMLCollectionElement dfOrFp) {
        String jt = ((DataType)dfOrFp.get("DataType")).getJavaType();
        Class cls = class$java$lang$Object == null ? (class$java$lang$Object = SharkUtilities.class$("java.lang.Object")) : class$java$lang$Object;
        try {
            cls = Class.forName(jt);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cls;
    }

    private static Object createInitialValue(String initialValStr, XMLCollectionElement dfOrFp) {
        String javaType = ((DataType)dfOrFp.get("DataType")).getJavaType();
        Object any = null;
        if (javaType.equals("java.lang.Boolean")) {
            Boolean value = new Boolean(false);
            try {
                if (initialValStr.equalsIgnoreCase("true") || initialValStr.equals("1")) {
                    value = new Boolean(true);
                } else if (initialValStr.equalsIgnoreCase("false") || initialValStr.equals("0")) {
                    value = new Boolean(false);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            any = value;
        } else if (javaType.equals("java.lang.String")) {
            any = initialValStr;
        } else if (javaType.equals("java.lang.Long")) {
            Long value;
            try {
                value = new Long(initialValStr);
            }
            catch (NumberFormatException nfe) {
                try {
                    Double d = new Double(initialValStr);
                    value = new Long(d.longValue());
                }
                catch (Exception ex) {
                    value = new Long(0L);
                }
            }
            any = value;
        } else if (javaType.equals("java.lang.Double")) {
            Double value;
            try {
                value = new Double(initialValStr);
            }
            catch (NumberFormatException nfe) {
                value = new Double(0.0);
            }
            any = value;
        } else if (javaType.equals("java.util.Date")) {
            Date value;
            try {
                value = DateFormat.getDateInstance().parse(initialValStr);
            }
            catch (ParseException pe) {
                try {
                    value = new Date(Long.parseLong(initialValStr));
                }
                catch (Exception ex) {
                    value = new Date();
                }
            }
            any = value;
        } else {
            try {
                Class<?> cls = Class.forName(javaType);
                if (!cls.isInterface()) {
                    any = cls.newInstance();
                }
            }
            catch (Throwable ex) {
                SharkEngineManager.getInstance().getCallbackUtilities().warn("The instantiation of object for class " + javaType + " failed");
            }
        }
        return any;
    }

    static String getRepository(String rep) {
        String rdPath = SharkEngineManager.getInstance().getCallbackUtilities().getProperty("RootDirectoryPath");
        CallbackUtilities cus = SharkEngineManager.getInstance().getCallbackUtilities();
        String path = cus.getProperty(rep);
        if (path != null) {
            File f = new File(path);
            if (!f.isAbsolute()) {
                f = new File(XMLUtil.createPath((String)rdPath, (String)path));
            }
            if (!f.exists()) {
                cus.warn("The repository " + rep + " does not exist - trying to create one!");
                if (!f.mkdir()) {
                    cus.warn("The repository " + rep + " can't be created!");
                    return path;
                }
            }
            try {
                String er = f.getCanonicalPath();
                cus.info("The repository " + rep + " is at " + er);
                return er;
            }
            catch (Exception ex) {
                String er = f.getAbsolutePath();
                cus.info("The repository " + rep + " is at " + er);
                return er;
            }
        }
        cus.warn("The repository " + rep + " does not exist!");
        return null;
    }

    static Package getPackage(String pkgId, String pkgVer) throws BaseException {
        XMLInterface xmlInterface = SharkEngineManager.getInstance().getXMLInterface();
        Package pkg = null;
        pkg = pkgVer != null ? xmlInterface.getPackageByIdAndVersion(pkgId, pkgVer) : xmlInterface.getPackageById(pkgId);
        if (pkg == null) {
            SharkEngineManager.getInstance().getCallbackUtilities().info("Package [" + pkgId + "," + pkgVer + "] is not found - synchronizing XPDL caches ...");
            RepositoryTransaction t = null;
            try {
                t = SharkUtilities.createRepositoryTransaction();
                SharkUtilities.synchronizeXPDLCache(t);
                pkg = pkgVer != null ? xmlInterface.getPackageByIdAndVersion(pkgId, pkgVer) : xmlInterface.getPackageById(pkgId);
                if (pkg == null) {
                    throw new BaseException("Package with Id=" + pkgId + " and version=" + pkgVer + " can't be found!");
                }
            }
            catch (RootException e) {
                if (e instanceof BaseException) {
                    throw (BaseException)((Object)e);
                }
                throw new BaseException((Throwable)e);
            }
            finally {
                SharkUtilities.releaseRepositoryTransaction(t);
            }
        }
        return pkg;
    }

    static WorkflowProcess getWorkflowProcess(String pkgId, String pkgVer, String wpId) throws BaseException {
        try {
            return SharkUtilities.getPackage(pkgId, pkgVer).getWorkflowProcess(wpId);
        }
        catch (Exception ex) {
            return null;
        }
    }

    static Activity getActivityDefinition(String pkgId, String pkgVer, String wpId, String aSetId, String actDefId) throws BaseException {
        WorkflowProcess wp = SharkUtilities.getWorkflowProcess(pkgId, pkgVer, wpId);
        Activities acts = null;
        if (aSetId != null) {
            ActivitySet as = wp.getActivitySet(aSetId);
            acts = as.getActivities();
        } else {
            acts = wp.getActivities();
        }
        return acts.getActivity(actDefId);
    }

    static Activity getActivityDefinition(SharkTransaction t, WfActivityInternal act, WorkflowProcess wp, WfActivityInternal parentAct) throws BaseException {
        if (parentAct == null) {
            return wp.getActivities().getActivity(act.activity_definition_id(t));
        }
        Activity bad = SharkUtilities.getActivityDefinition(t, parentAct, wp, parentAct.block_activity(t));
        BlockActivity ba = bad.getActivityTypes().getBlockActivity();
        String asId = ba.getBlockId();
        ActivitySet as = wp.getActivitySet(asId);
        return as.getActivity(act.activity_definition_id(t));
    }

    static Map createContextMap(SharkTransaction t, WfActivityInternal act, ActualParameters actualParameters, FormalParameters formalParameters) throws Exception {
        String packageId = act.container(t).package_id(t);
        String packageVer = act.container(t).manager_version(t);
        return SharkUtilities.createContextMap(t, act.process_context(t), actualParameters, formalParameters, packageId, packageVer);
    }

    public static Map createContextMap(SharkTransaction t, Map context, ActualParameters actualParameters, FormalParameters formalParameters, String packageId, String packageVer) throws Exception {
        Evaluator evaluator = SharkEngineManager.getInstance().getScriptingManager().getEvaluator(t, SharkUtilities.getScriptType(packageId, packageVer));
        HashMap<String, Object> m = new HashMap<String, Object>();
        Iterator fps = formalParameters.toElements().iterator();
        Iterator aps = actualParameters.toElements().iterator();
        while (aps.hasNext() && fps.hasNext()) {
            ActualParameter ap = (ActualParameter)aps.next();
            FormalParameter fp = (FormalParameter)fps.next();
            String fpMode = fp.getMode();
            Object val = null;
            String apVal = ap.toValue().trim();
            if (fpMode.equals("IN")) {
                DataField dfOrFp = null;
                WorkflowProcess wp = XMLUtil.getWorkflowProcess((XMLElement)ap);
                dfOrFp = wp.getDataField(apVal);
                if (dfOrFp == null && (dfOrFp = XMLUtil.getPackage((XMLElement)wp).getDataField(apVal)) == null) {
                    dfOrFp = wp.getFormalParameter(apVal);
                }
                if (dfOrFp != null) {
                    val = context.get(dfOrFp.getId());
                }
                if (val == null) {
                    val = evaluator.evaluateExpression(t, apVal, context, SharkUtilities.getJavaClass((XMLCollectionElement)fp));
                }
            } else if (!fpMode.equals("OUT")) {
                if (!context.containsKey(apVal)) {
                    throw new Exception("There is no variable " + apVal + " in a context");
                }
                val = context.get(apVal);
            } else {
                val = SharkUtilities.getInitialValue(SharkUtilities.getVariable((XMLElement)actualParameters, apVal), true);
            }
            m.put(fp.getId(), val);
        }
        return m;
    }

    static Map createContextMap(SharkTransaction t, Map context, ActualParameters actualParameters, String packageId, String packageVer) throws Exception {
        Evaluator evaluator = SharkEngineManager.getInstance().getScriptingManager().getEvaluator(t, SharkUtilities.getScriptType(packageId, packageVer));
        HashMap<String, Object> m = new HashMap<String, Object>();
        Iterator aps = actualParameters.toElements().iterator();
        int i = 0;
        while (aps.hasNext()) {
            ActualParameter ap = (ActualParameter)aps.next();
            Object val = null;
            String apVal = ap.toValue().trim();
            DataField dfOrFp = null;
            WorkflowProcess wp = XMLUtil.getWorkflowProcess((XMLElement)ap);
            dfOrFp = wp.getDataField(apVal);
            if (dfOrFp == null && (dfOrFp = XMLUtil.getPackage((XMLElement)wp).getDataField(apVal)) == null) {
                dfOrFp = wp.getFormalParameter(apVal);
            }
            if (dfOrFp != null) {
                val = context.get(apVal);
            }
            if (val == null) {
                apVal = "#REMOTE_SUBPROCESS_EVAL_PARAM#" + String.valueOf(i++);
                val = evaluator.evaluateExpression(t, apVal, context, null);
            }
            m.put(apVal, val);
        }
        return m;
    }

    static String[][] getPackageExtendedAttributeNameValuePairs(SharkTransaction t, String pkgId) throws Exception {
        String curVer = SharkUtilities.getCurrentPkgVersion(pkgId, false);
        Package pkg = SharkUtilities.getPackage(pkgId, curVer);
        ExtendedAttributes eas = pkg.getExtendedAttributes();
        return SharkUtilities.getExtAttribNameValues(eas);
    }

    static String[] getPackageExtendedAttributeNames(SharkTransaction t, String pkgId) throws Exception {
        String curVer = SharkUtilities.getCurrentPkgVersion(pkgId, false);
        Package pkg = SharkUtilities.getPackage(pkgId, curVer);
        ExtendedAttributes eas = pkg.getExtendedAttributes();
        return SharkUtilities.getExtAttribNames(eas);
    }

    static String getPackageExtendedAttributeValue(SharkTransaction t, String pkgId, String extAttrName) throws Exception {
        String curVer = SharkUtilities.getCurrentPkgVersion(pkgId, false);
        Package pkg = SharkUtilities.getPackage(pkgId, curVer);
        ExtendedAttributes eas = pkg.getExtendedAttributes();
        return SharkUtilities.getExtAttribValue(eas, extAttrName);
    }

    static String[][] getProcessDefinitionExtendedAttributeNameValuePairs(SharkTransaction t, String mgrName) throws Exception {
        WfProcessMgrInternal mgr = SharkUtilities.getProcessMgr(t, mgrName);
        WorkflowProcess pDef = SharkUtilities.getWorkflowProcess(mgr.package_id(t), mgr.version(t), mgr.process_definition_id(t));
        ExtendedAttributes eas = pDef.getExtendedAttributes();
        return SharkUtilities.getExtAttribNameValues(eas);
    }

    static String[] getProcessDefinitionExtendedAttributeNames(SharkTransaction t, String mgrName) throws Exception {
        WfProcessMgrInternal mgr = SharkUtilities.getProcessMgr(t, mgrName);
        WorkflowProcess pDef = SharkUtilities.getWorkflowProcess(mgr.package_id(t), mgr.version(t), mgr.process_definition_id(t));
        ExtendedAttributes eas = pDef.getExtendedAttributes();
        return SharkUtilities.getExtAttribNames(eas);
    }

    static String getProcessDefinitionExtendedAttributeValue(SharkTransaction t, String mgrName, String extAttrName) throws Exception {
        WfProcessMgrInternal mgr = SharkUtilities.getProcessMgr(t, mgrName);
        WorkflowProcess pDef = SharkUtilities.getWorkflowProcess(mgr.package_id(t), mgr.version(t), mgr.process_definition_id(t));
        ExtendedAttributes eas = pDef.getExtendedAttributes();
        return SharkUtilities.getExtAttribValue(eas, extAttrName);
    }

    static String[][] getProcessExtendedAttributeNameValuePairs(SharkTransaction t, String procId) throws Exception {
        WfProcessInternal proc = SharkUtilities.getProcess(t, procId);
        WorkflowProcess pDef = SharkUtilities.getWorkflowProcess(proc.package_id(t), proc.manager_version(t), proc.process_definition_id(t));
        ExtendedAttributes eas = pDef.getExtendedAttributes();
        return SharkUtilities.getExtAttribNameValues(eas);
    }

    static String[] getProcessExtendedAttributeNames(SharkTransaction t, String procId) throws Exception {
        WfProcessInternal proc = SharkUtilities.getProcess(t, procId);
        WorkflowProcess pDef = SharkUtilities.getWorkflowProcess(proc.package_id(t), proc.manager_version(t), proc.process_definition_id(t));
        ExtendedAttributes eas = pDef.getExtendedAttributes();
        return SharkUtilities.getExtAttribNames(eas);
    }

    static String getProcessExtendedAttributeValue(SharkTransaction t, String procId, String extAttrName) throws Exception {
        WfProcessInternal proc = SharkUtilities.getProcess(t, procId);
        WorkflowProcess pDef = SharkUtilities.getWorkflowProcess(proc.package_id(t), proc.manager_version(t), proc.process_definition_id(t));
        ExtendedAttributes eas = pDef.getExtendedAttributes();
        return SharkUtilities.getExtAttribValue(eas, extAttrName);
    }

    static String getActivitiesExtendedAttributes(SharkTransaction t, String procId, String actId) throws Exception {
        WfActivityInternal act = SharkUtilities.getActivity(t, procId, actId);
        Activity aDef = SharkUtilities.getActivityDefinition(t, act, SharkUtilities.getWorkflowProcess(act.container(t).package_id(t), act.container(t).manager_version(t), act.container(t).process_definition_id(t)), act.block_activity(t));
        return aDef.getExtendedAttributes().getExtendedAttributesString();
    }

    static String[][] getActivitiesExtendedAttributeNameValuePairs(SharkTransaction t, String procId, String actId) throws Exception {
        WfActivityInternal act = SharkUtilities.getActivity(t, procId, actId);
        Activity aDef = SharkUtilities.getActivityDefinition(t, act, SharkUtilities.getWorkflowProcess(act.container(t).package_id(t), act.container(t).manager_version(t), act.container(t).process_definition_id(t)), act.block_activity(t));
        ExtendedAttributes eas = aDef.getExtendedAttributes();
        return SharkUtilities.getExtAttribNameValues(eas);
    }

    static String[] getActivitiesExtendedAttributeNames(SharkTransaction t, String procId, String actId) throws Exception {
        WfActivityInternal act = SharkUtilities.getActivity(t, procId, actId);
        Activity aDef = SharkUtilities.getActivityDefinition(t, act, SharkUtilities.getWorkflowProcess(act.container(t).package_id(t), act.container(t).manager_version(t), act.container(t).process_definition_id(t)), act.block_activity(t));
        ExtendedAttributes eas = aDef.getExtendedAttributes();
        return SharkUtilities.getExtAttribNames(eas);
    }

    static String getActivitiesExtendedAttributeValue(SharkTransaction t, String procId, String actId, String extAttrName) throws Exception {
        WfActivityInternal act = SharkUtilities.getActivity(t, procId, actId);
        Activity aDef = SharkUtilities.getActivityDefinition(t, act, SharkUtilities.getWorkflowProcess(act.container(t).package_id(t), act.container(t).manager_version(t), act.container(t).process_definition_id(t)), act.block_activity(t));
        ExtendedAttributes eas = aDef.getExtendedAttributes();
        return SharkUtilities.getExtAttribValue(eas, extAttrName);
    }

    static String[][] getDefVariableExtendedAttributeNameValuePairs(SharkTransaction t, String mgrName, String variableId) throws Exception {
        XMLCollectionElement dfOrFp = SharkUtilities.getXPDLVariable(t, mgrName, variableId, true);
        if (dfOrFp instanceof FormalParameter) {
            return new String[0][];
        }
        ExtendedAttributes eas = (ExtendedAttributes)dfOrFp.get("ExtendedAttributes");
        return SharkUtilities.getExtAttribNameValues(eas);
    }

    static String[] getDefVariableExtendedAttributeNames(SharkTransaction t, String mgrName, String variableId) throws Exception {
        XMLCollectionElement dfOrFp = SharkUtilities.getXPDLVariable(t, mgrName, variableId, true);
        if (dfOrFp instanceof FormalParameter) {
            throw new Exception("There is no variable " + variableId + " for the process manager " + mgrName);
        }
        ExtendedAttributes eas = (ExtendedAttributes)dfOrFp.get("ExtendedAttributes");
        return SharkUtilities.getExtAttribNames(eas);
    }

    static String getDefVariableExtendedAttributeValue(SharkTransaction t, String mgrName, String variableId, String extAttrName) throws Exception {
        XMLCollectionElement dfOrFp = SharkUtilities.getXPDLVariable(t, mgrName, variableId, true);
        if (dfOrFp instanceof FormalParameter) {
            throw new Exception("There is no variable " + variableId + " for the process manager " + mgrName);
        }
        ExtendedAttributes eas = (ExtendedAttributes)dfOrFp.get("ExtendedAttributes");
        return SharkUtilities.getExtAttribValue(eas, extAttrName);
    }

    static String[][] getVariableExtendedAttributeNameValuePairs(SharkTransaction t, String procId, String variableId) throws Exception {
        XMLCollectionElement dfOrFp = SharkUtilities.getXPDLVariable(t, procId, variableId, false);
        if (dfOrFp instanceof FormalParameter) {
            return new String[0][];
        }
        ExtendedAttributes eas = (ExtendedAttributes)dfOrFp.get("ExtendedAttributes");
        return SharkUtilities.getExtAttribNameValues(eas);
    }

    static String[] getVariableExtendedAttributeNames(SharkTransaction t, String procId, String variableId) throws Exception {
        XMLCollectionElement dfOrFp = SharkUtilities.getXPDLVariable(t, procId, variableId, false);
        if (dfOrFp instanceof FormalParameter) {
            throw new Exception("There is no variable " + variableId + " in the process " + procId);
        }
        ExtendedAttributes eas = (ExtendedAttributes)dfOrFp.get("ExtendedAttributes");
        return SharkUtilities.getExtAttribNames(eas);
    }

    static String getVariableExtendedAttributeValue(SharkTransaction t, String procId, String variableId, String extAttrName) throws Exception {
        XMLCollectionElement dfOrFp = SharkUtilities.getXPDLVariable(t, procId, variableId, false);
        if (dfOrFp instanceof FormalParameter) {
            throw new Exception("There is no variable " + variableId + " in the process " + procId);
        }
        ExtendedAttributes eas = (ExtendedAttributes)dfOrFp.get("ExtendedAttributes");
        return SharkUtilities.getExtAttribValue(eas, extAttrName);
    }

    static String[][] getParticipantExtendedAttributeNameValuePairs(SharkTransaction t, String pkgId, String pDefId, String participantId) throws Exception {
        ExtendedAttributes eas = SharkUtilities.getParticipant(t, pkgId, pDefId, participantId).getExtendedAttributes();
        return SharkUtilities.getExtAttribNameValues(eas);
    }

    static String[] getParticipantExtendedAttributeNames(SharkTransaction t, String pkgId, String pDefId, String participantId) throws Exception {
        ExtendedAttributes eas = SharkUtilities.getParticipant(t, pkgId, pDefId, participantId).getExtendedAttributes();
        return SharkUtilities.getExtAttribNames(eas);
    }

    static String getParticipantExtendedAttributeValue(SharkTransaction t, String pkgId, String pDefId, String participantId, String extAttrName) throws Exception {
        ExtendedAttributes eas = SharkUtilities.getParticipant(t, pkgId, pDefId, participantId).getExtendedAttributes();
        return SharkUtilities.getExtAttribValue(eas, extAttrName);
    }

    static String[][] getApplicationExtendedAttributeNameValuePairs(SharkTransaction t, String pkgId, String pDefId, String applicationId) throws Exception {
        ExtendedAttributes eas = SharkUtilities.getApplication(t, pkgId, pDefId, applicationId).getExtendedAttributes();
        return SharkUtilities.getExtAttribNameValues(eas);
    }

    static String[] getApplicationExtendedAttributeNames(SharkTransaction t, String pkgId, String pDefId, String applicationId) throws Exception {
        ExtendedAttributes eas = SharkUtilities.getApplication(t, pkgId, pDefId, applicationId).getExtendedAttributes();
        return SharkUtilities.getExtAttribNames(eas);
    }

    static String getApplicationExtendedAttributeValue(SharkTransaction t, String pkgId, String pDefId, String applicationId, String extAttrName) throws Exception {
        ExtendedAttributes eas = SharkUtilities.getApplication(t, pkgId, pDefId, applicationId).getExtendedAttributes();
        return SharkUtilities.getExtAttribValue(eas, extAttrName);
    }

    private static String[][] getExtAttribNameValues(ExtendedAttributes eas) {
        String[][] eaNVP = new String[eas.size()][2];
        Iterator it = eas.toElements().iterator();
        int i = 0;
        while (it.hasNext()) {
            ExtendedAttribute ea = (ExtendedAttribute)it.next();
            eaNVP[i][0] = ea.getName();
            eaNVP[i][1] = ea.getVValue();
            ++i;
        }
        return eaNVP;
    }

    private static String[] getExtAttribNames(ExtendedAttributes eas) {
        String[] eaNs = new String[eas.size()];
        Iterator it = eas.toElements().iterator();
        int i = 0;
        while (it.hasNext()) {
            ExtendedAttribute ea = (ExtendedAttribute)it.next();
            eaNs[i++] = ea.getName();
        }
        return eaNs;
    }

    private static String getExtAttribValue(ExtendedAttributes eas, String extAttrName) throws Exception {
        ExtendedAttribute ea = eas.getFirstExtendedAttributeForName(extAttrName);
        if (ea == null) {
            throw new Exception("There is no ext. attr. with name " + extAttrName);
        }
        return ea.getVValue();
    }

    static String getDefVariableName(SharkTransaction t, String mgrName, String variableId) throws Exception {
        XMLCollectionElement dfOrFp = SharkUtilities.getXPDLVariable(t, mgrName, variableId, true);
        if (dfOrFp instanceof DataField) {
            return dfOrFp.get("Name").toValue();
        }
        return variableId;
    }

    static String getDefVariableDescription(SharkTransaction t, String mgrName, String variableId) throws Exception {
        return SharkUtilities.getXPDLVariable(t, mgrName, variableId, true).get("Description").toValue();
    }

    static String getDefVariableJavaClassName(SharkTransaction t, String mgrName, String variableId) throws Exception {
        return SharkUtilities.getJavaClass(SharkUtilities.getXPDLVariable(t, mgrName, variableId, true)).getName();
    }

    static String getVariableName(SharkTransaction t, String procId, String variableId) throws Exception {
        XMLCollectionElement dfOrFp = SharkUtilities.getXPDLVariable(t, procId, variableId, false);
        if (dfOrFp instanceof DataField) {
            return dfOrFp.get("Name").toValue();
        }
        return variableId;
    }

    static String getVariableDescription(SharkTransaction t, String procId, String variableId) throws Exception {
        return SharkUtilities.getXPDLVariable(t, procId, variableId, false).get("Description").toValue();
    }

    static String getVariableJavaClassName(SharkTransaction t, String procId, String variableId) throws Exception {
        return SharkUtilities.getJavaClass(SharkUtilities.getXPDLVariable(t, procId, variableId, false)).getName();
    }

    private static XMLCollectionElement getXPDLVariable(SharkTransaction t, String procIdOrMgrName, String variableId, boolean isManager) throws Exception {
        WorkflowProcess wp = null;
        if (isManager) {
            WfProcessMgrInternal mgr = SharkUtilities.getProcessMgr(t, procIdOrMgrName);
            wp = SharkUtilities.getWorkflowProcess(mgr.package_id(t), mgr.version(t), mgr.process_definition_id(t));
        } else {
            WfProcessInternal proc = SharkUtilities.getProcess(t, procIdOrMgrName);
            wp = SharkUtilities.getWorkflowProcess(proc.package_id(t), proc.manager_version(t), proc.process_definition_id(t));
        }
        DataField df = wp.getDataField(variableId);
        if (df == null) {
            df = XMLUtil.getPackage((XMLElement)wp).getDataField(variableId);
        }
        if (df == null) {
            FormalParameter fp = wp.getFormalParameter(variableId);
            if (fp == null) {
                String msg = "process ";
                if (isManager) {
                    msg = "process manager ";
                }
                throw new Exception("There is no variable " + variableId + " for the " + msg + procIdOrMgrName);
            }
            return fp;
        }
        return df;
    }

    static String getParticipantName(SharkTransaction t, String pkgId, String pDefId, String participantId) throws Exception {
        return SharkUtilities.getParticipant(t, pkgId, pDefId, participantId).getName();
    }

    static Participant getParticipant(SharkTransaction t, String pkgId, String pDefId, String participantId) throws Exception {
        Package pkg = SharkUtilities.getPackage(pkgId, SharkUtilities.getCurrentPkgVersion(pkgId, false));
        Participant p = null;
        if (pkg == null) {
            throw new Exception("There is no package with Id=" + pkgId);
        }
        if (pDefId == null) {
            p = pkg.getParticipant(participantId);
        } else {
            WorkflowProcess wp = pkg.getWorkflowProcess(pDefId);
            if (wp == null) {
                throw new Exception("There is no process definition with Id=" + pDefId);
            }
            p = wp.getParticipant(participantId);
        }
        if (p == null) {
            throw new Exception("There is no participant with Id=" + participantId + " in pkg " + pkgId);
        }
        return p;
    }

    static String getApplicationName(SharkTransaction t, String pkgId, String pDefId, String applicationId) throws Exception {
        return SharkUtilities.getApplication(t, pkgId, pDefId, applicationId).getName();
    }

    static Application getApplication(SharkTransaction t, String pkgId, String pDefId, String applicationId) throws Exception {
        Package pkg = SharkUtilities.getPackage(pkgId, SharkUtilities.getCurrentPkgVersion(pkgId, false));
        Application a = null;
        if (pkg == null) {
            throw new Exception("There is no package with Id=" + pkgId);
        }
        if (pDefId == null) {
            a = pkg.getApplication(applicationId);
        } else {
            WorkflowProcess wp = pkg.getWorkflowProcess(pDefId);
            if (wp == null) {
                throw new Exception("There is no process definition with Id=" + pDefId);
            }
            a = wp.getApplication(applicationId);
        }
        if (a == null) {
            throw new Exception("There is no application with Id=" + applicationId + " in pkg " + pkgId);
        }
        return a;
    }

    public static synchronized boolean synchronizeXPDLCache(RepositoryTransaction t) throws BaseException {
        boolean hasChanges = false;
        SharkEngineManager.getInstance().getCallbackUtilities().info("SharkUtilities -> synchronizing XPDL cache");
        HashMap<String, String> newCurrentVersions = new HashMap<String, String>();
        XMLInterface xmlInterface = SharkEngineManager.getInstance().getXMLInterface();
        XMLInterfaceForJDK13 xpdlHandler = new XMLInterfaceForJDK13();
        xpdlHandler.setValidation(false);
        xpdlHandler.synchronizePackages(xmlInterface);
        RepositoryPersistenceManager repMgr = SharkEngineManager.getInstance().getRepositoryPersistenceManager();
        try {
            String pkgIdWithVersionAndClassVersion;
            String pkgVer;
            long version = Version.getVersion();
            HashSet enginePkgIds = new HashSet(xpdlHandler.getAllPackageIds());
            HashSet<String> enginePkgIdsWithVersionAndClassVersion = new HashSet<String>();
            Iterator prep = enginePkgIds.iterator();
            while (prep.hasNext()) {
                String epid = (String)prep.next();
                Collection c = xpdlHandler.getAllPackageVersions(epid);
                Iterator prepc = c.iterator();
                while (prepc.hasNext()) {
                    String epidWithVersion = SharkUtilities.createPkgIdWithVersionAndClassVersion(epid, (String)prepc.next(), version);
                    enginePkgIdsWithVersionAndClassVersion.add(epidWithVersion);
                }
            }
            HashSet<String> reposPkgIdsWithVersionAndClassVersion = new HashSet<String>();
            HashSet allPkgIds = new HashSet(repMgr.getExistingXPDLIds(t));
            Iterator it = allPkgIds.iterator();
            while (it.hasNext()) {
                String pkgId = (String)it.next();
                HashSet pkgVers = new HashSet(repMgr.getXPDLVersions(t, pkgId));
                HashSet<String> pkgVersAndClassVers = new HashSet<String>();
                Iterator pv = pkgVers.iterator();
                while (pv.hasNext()) {
                    pkgVer = (String)pv.next();
                    pkgVersAndClassVers.add(SharkUtilities.createPkgVersionAndClassVersion(pkgVer, repMgr.getSerializedXPDLObjectVersion(t, pkgId, pkgVer)));
                }
                newCurrentVersions.put(pkgId, repMgr.getCurrentVersion(t, pkgId));
                Iterator it2 = pkgVersAndClassVers.iterator();
                while (it2.hasNext()) {
                    String pkgVerAndClassVer = (String)it2.next();
                    String pkgIdWithVersionAndClassVersion2 = SharkUtilities.createPkgIdWithVersionAndClassVersion(pkgId, pkgVerAndClassVer);
                    reposPkgIdsWithVersionAndClassVersion.add(pkgIdWithVersionAndClassVersion2);
                }
            }
            HashSet pkgsToLoad = new HashSet(reposPkgIdsWithVersionAndClassVersion);
            pkgsToLoad.removeAll(enginePkgIdsWithVersionAndClassVersion);
            HashSet pkgsToUnload = new HashSet(enginePkgIdsWithVersionAndClassVersion);
            pkgsToUnload.removeAll(reposPkgIdsWithVersionAndClassVersion);
            it = pkgsToUnload.iterator();
            while (it.hasNext()) {
                pkgIdWithVersionAndClassVersion = (String)it.next();
                xpdlHandler.closePackageVersion(SharkUtilities.getPkgId(pkgIdWithVersionAndClassVersion), SharkUtilities.getPkgVersion(pkgIdWithVersionAndClassVersion));
            }
            it = pkgsToLoad.iterator();
            while (it.hasNext()) {
                pkgIdWithVersionAndClassVersion = (String)it.next();
                String pkgId = SharkUtilities.getPkgId(pkgIdWithVersionAndClassVersion);
                if (SharkUtilities.restorePackage(t, (XMLInterface)xpdlHandler, pkgId, pkgVer = SharkUtilities.getPkgVersion(pkgIdWithVersionAndClassVersion)) != null) continue;
                throw new BaseException("Problems while restoring packages!");
            }
            if (pkgsToLoad.size() > 0 || pkgsToUnload.size() > 0) {
                hasChanges = true;
            }
            xmlInterface.synchronizePackages((XMLInterface)xpdlHandler);
            currentPkgVersions = newCurrentVersions;
            xpdlHandler.closeAllPackages();
            xpdlHandler = null;
            return hasChanges;
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    static void restorePackages() throws BaseException {
        RepositoryTransaction t = null;
        try {
            t = SharkUtilities.createRepositoryTransaction();
            SharkUtilities.synchronizeXPDLCache(t);
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
        finally {
            SharkUtilities.releaseRepositoryTransaction(t);
        }
    }

    static Package restorePackage(RepositoryTransaction t, XMLInterface xmlInterface, String pkgId, String pkgVersion) throws Exception {
        RepositoryPersistenceManager repM = SharkEngineManager.getInstance().getRepositoryPersistenceManager();
        long version = Version.getVersion();
        long repVersion = repM.getSerializedXPDLObjectVersion(t, pkgId, pkgVersion);
        Package pkg = null;
        if (version == repVersion) {
            pkg = xmlInterface.openPackageFromStream(repM.getSerializedXPDLObject(t, pkgId, pkgVersion), false);
        } else {
            byte[] contXPDL = repM.getXPDL(t, pkgId, pkgVersion);
            pkg = xmlInterface.openPackageFromStream(contXPDL, true);
            List epIds = repM.getReferredXPDLIds(t, pkgId, pkgVersion);
            ArrayList eps = pkg.getExternalPackages().toElements();
            for (int i = 0; i < eps.size(); ++i) {
                ExternalPackage ep = (ExternalPackage)eps.get(i);
                pkg.addExternalPackageMapping(ep.getHref(), (String)epIds.get(i));
            }
            pkg.setInternalVersion(pkgVersion);
            pkg.setReadOnly(true);
            byte[] cont = XMLUtil.serialize((Object)pkg);
            repM.updateXPDL(t, pkgId, pkgVersion, contXPDL, cont, version);
        }
        pkg.initCaches();
        return pkg;
    }

    static void clearProcessCache() throws RootException {
        CacheMgr cmgr = SharkEngineManager.getInstance().getCacheManager();
        if (cmgr != null) {
            ProcessCache pc = cmgr.getProcessCache();
            int size = pc.getSize();
            pc.setSize(0);
            pc.setSize(size);
        }
    }

    public static final String createProcessMgrKey(String pkgId, String pkgVer, String pDefId) {
        return pkgId + "#" + pkgVer + "#" + pDefId;
    }

    public static final String getProcessMgrPkgId(String mgrName) {
        String[] tokens = MiscUtilities.tokenize((String)mgrName, (String)"#");
        return tokens[0];
    }

    public static final String getProcessMgrVersion(String mgrName) {
        String[] tokens = MiscUtilities.tokenize((String)mgrName, (String)"#");
        return tokens[1];
    }

    public static final String getProcessMgrProcDefId(String mgrName) {
        String[] tokens = MiscUtilities.tokenize((String)mgrName, (String)"#");
        return tokens[2];
    }

    public static final String createAssignmentKey(String actId, String resUname) {
        return actId + "#" + resUname;
    }

    public static final String getAssignmentActivityId(String assId) {
        String[] tokens = MiscUtilities.tokenize((String)assId, (String)"#");
        return tokens[0];
    }

    public static final String getAssignmentUsername(String assId) {
        String[] tokens = MiscUtilities.tokenize((String)assId, (String)"#");
        return tokens[1];
    }

    private static final String createPkgIdWithVersionAndClassVersion(String pkgId, String pkgVersion, long pkgClassVersion) {
        return pkgId + "_" + pkgVersion + "_" + pkgClassVersion;
    }

    private static final String createPkgIdWithVersionAndClassVersion(String pkgId, String pkgVersionAndClassVersion) {
        return pkgId + "_" + pkgVersionAndClassVersion;
    }

    private static final String createPkgVersionAndClassVersion(String pkgVersion, long pkgClassVersion) {
        return pkgVersion + "_" + pkgClassVersion;
    }

    private static final String getPkgId(String pkgIdWithVersionAndClassVersion) {
        String[] tokens = MiscUtilities.tokenize((String)pkgIdWithVersionAndClassVersion, (String)"_");
        return pkgIdWithVersionAndClassVersion.substring(0, pkgIdWithVersionAndClassVersion.length() - tokens[tokens.length - 1].length() - tokens[tokens.length - 2].length() - 2);
    }

    private static final String getPkgVersion(String pkgIdWithVersion) {
        String[] tokens = MiscUtilities.tokenize((String)pkgIdWithVersion, (String)"_");
        return tokens[tokens.length - 2];
    }

    private static final String getPkgVersion2(String versionAndClassVersion) {
        String[] tokens = MiscUtilities.tokenize((String)versionAndClassVersion, (String)"_");
        return tokens[0];
    }

    static String getCurrentPkgVersion(String pkgId, boolean fromCache) throws BaseException {
        String curVer = null;
        if (fromCache) {
            curVer = (String)currentPkgVersions.get(pkgId);
        }
        if (curVer != null) {
            return curVer;
        }
        RepositoryTransaction rt = null;
        try {
            rt = SharkUtilities.createRepositoryTransaction();
            curVer = SharkEngineManager.getInstance().getRepositoryPersistenceManager().getCurrentVersion(rt, pkgId);
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
        finally {
            SharkUtilities.releaseRepositoryTransaction(rt);
        }
        return curVer;
    }

    static String getScriptType(String pkgId, String pkgVer) throws BaseException {
        Package pkg = SharkUtilities.getPackage(pkgId, pkgVer);
        String scriptType = pkg.getScript().getType();
        return scriptType;
    }

    static String getNextId(String idName) {
        try {
            return SharkEngineManager.getInstance().getInstancePersistenceManager().getNextId(idName);
        }
        catch (PersistenceException pe) {
            throw new RootError("Fatal error: couldn't allocate an Id!", (Throwable)pe);
        }
    }

    static String extractExceptionName(ToolAgentGeneralException tage) {
        Throwable cause;
        String causeClassName = "";
        if (tage != null && (cause = tage.getCause()) != null) {
            causeClassName = cause.getClass().getName();
        }
        return causeClassName;
    }

    public static WorkflowProcess getWorkflowProcess(XMLElement el, String procDefId) throws BaseException {
        WorkflowProcess wp;
        block1: {
            String pkgId;
            Package extPkg;
            Package pkg = XMLUtil.getPackage((XMLElement)el);
            wp = pkg.getWorkflowProcess(procDefId);
            if (wp != null) break block1;
            Iterator it = XMLUtil.getAllExternalPackageIds((XMLInterface)SharkEngineManager.getInstance().getXMLInterface(), (Package)pkg).iterator();
            while (it.hasNext() && (wp = (extPkg = SharkUtilities.getPackage(pkgId = (String)it.next(), null)).getWorkflowProcess(procDefId)) == null) {
            }
        }
        return wp;
    }

    public static Application getApplication(XMLElement el, String appId) throws BaseException {
        Application app;
        block1: {
            String pkgId;
            Package extPkg;
            Package pkg;
            app = null;
            WorkflowProcess wp = XMLUtil.getWorkflowProcess((XMLElement)el);
            app = wp.getApplication(appId);
            if (app != null || (app = (pkg = XMLUtil.getPackage((XMLElement)wp)).getApplication(appId)) != null) break block1;
            Iterator it = XMLUtil.getAllExternalPackageIds((XMLInterface)SharkEngineManager.getInstance().getXMLInterface(), (Package)pkg).iterator();
            while (it.hasNext() && (app = (extPkg = SharkUtilities.getPackage(pkgId = (String)it.next(), null)).getApplication(appId)) == null) {
            }
        }
        return app;
    }

    public static Participant getParticipant(XMLElement el, String partId) throws BaseException {
        Participant p;
        block1: {
            String pkgId;
            Package extPkg;
            Package pkg;
            p = null;
            WorkflowProcess wp = XMLUtil.getWorkflowProcess((XMLElement)el);
            p = wp.getParticipant(partId);
            if (p != null || (p = (pkg = XMLUtil.getPackage((XMLElement)wp)).getParticipant(partId)) != null) break block1;
            Iterator it = XMLUtil.getAllExternalPackageIds((XMLInterface)SharkEngineManager.getInstance().getXMLInterface(), (Package)pkg).iterator();
            while (it.hasNext() && (p = (extPkg = SharkUtilities.getPackage(pkgId = (String)it.next(), null)).getParticipant(partId)) == null) {
            }
        }
        return p;
    }

    public static XMLCollectionElement getVariable(XMLElement el, String varId) throws BaseException {
        Object dfOrFP = null;
        WorkflowProcess wp = XMLUtil.getWorkflowProcess((XMLElement)el);
        Map m = wp.getAllVariables();
        return (XMLCollectionElement)m.get(varId);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ArrayList vsList = new ArrayList();
        validActivityStates.put("closed.aborted", vsList);
        validActivityStates.put("closed.completed", vsList);
        validActivityStates.put("closed.terminated", vsList);
        vsList = new ArrayList(SharkConstants.possibleActivityStates);
        vsList.remove("open.running");
        validActivityStates.put("open.running", vsList);
        vsList = new ArrayList(SharkConstants.possibleActivityStates);
        vsList.remove("open.not_running.not_started");
        vsList.remove("closed.completed");
        validActivityStates.put("open.not_running.not_started", vsList);
        vsList = new ArrayList(SharkConstants.possibleActivityStates);
        vsList.remove("open.not_running.suspended");
        vsList.remove("closed.completed");
        validActivityStates.put("open.not_running.suspended", vsList);
        validProcessStates = new HashMap();
        vsList = new ArrayList();
        validProcessStates.put("closed.aborted", vsList);
        validProcessStates.put("closed.completed", vsList);
        validProcessStates.put("closed.terminated", vsList);
        vsList = new ArrayList(SharkConstants.possibleProcessStates);
        vsList.remove("open.running");
        vsList.remove("open.not_running.not_started");
        validProcessStates.put("open.running", vsList);
        vsList = new ArrayList(SharkConstants.possibleProcessStates);
        vsList.remove("open.not_running.not_started");
        vsList.remove("open.not_running.suspended");
        vsList.remove("closed.completed");
        validProcessStates.put("open.not_running.not_started", vsList);
        vsList = new ArrayList(SharkConstants.possibleProcessStates);
        vsList.remove("open.not_running.suspended");
        vsList.remove("closed.completed");
        validProcessStates.put("open.not_running.suspended", vsList);
        EXTERNAL_PACKAGES_REPOSITORY = SharkUtilities.getRepository("EXTERNAL_PACKAGES_REPOSITORY");
        nextConnectionKey = 1;
        loggedUsers = new SequencedHashMap();
        currentPkgVersions = new HashMap();
        packageFileFilter = new PackageFileFilter();
    }
}

