/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.TransactionException;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfmodel.CannotAcceptSuspended;
import org.enhydra.shark.api.client.wfmodel.InvalidData;
import org.enhydra.shark.api.client.wfmodel.UpdateNotAllowed;
import org.enhydra.shark.api.client.wfmodel.WfAssignment;
import org.enhydra.shark.api.client.wfmodel.WfProcessIterator;
import org.enhydra.shark.api.client.wfmodel.WfProcessMgr;
import org.enhydra.shark.api.client.wfservice.ConnectFailed;
import org.enhydra.shark.api.client.wfservice.ExecutionAdministration;
import org.enhydra.shark.api.client.wfservice.NotConnected;
import org.enhydra.shark.api.client.wfservice.PackageAdministration;
import org.enhydra.shark.api.client.wfservice.RepositoryMgr;
import org.enhydra.shark.api.client.wfservice.SharkConnection;
import org.enhydra.shark.api.client.wfservice.UserGroupAdministration;

public class JSPClientUtilities {
    private static boolean _debug_ = false;
    private static boolean sharkConfigured = false;
    private static String userName = "qq";
    private static String pwd = "lele";
    private static String engineName = "SharkExampleJSP";
    private static String EXT_ATT_NAME = "pageContent";

    public static void init(String realPath) {
        if (_debug_) {
            System.err.println("#_init_#");
        }
        if (!sharkConfigured) {
            Properties p = new Properties();
            try {
                if (!realPath.endsWith("\\")) {
                    realPath = realPath + "\\";
                }
                realPath = JSPClientUtilities.replaceAll(realPath, "\\", "/");
                p.load(new FileInputStream(realPath + "conf/Shark.conf"));
                Iterator<Object> it = p.keySet().iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    String value = p.getProperty(key);
                    if (0 > value.indexOf("@@")) continue;
                    if (_debug_) {
                        System.err.print("key is " + key + ", old value is" + value);
                    }
                    value = JSPClientUtilities.replaceAll(value, "@@/", realPath);
                    p.setProperty(key, value);
                    if (!_debug_) continue;
                    System.err.println(", new value is" + value);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            p.setProperty("enginename", engineName);
            Shark.configure((Properties)p);
            sharkConfigured = true;
        }
        JSPClientUtilities.user();
    }

    private static void user() {
        String groupName = "idle";
        UserGroupAdministration uga = Shark.getInstance().getAdminInterface().getUserGroupAdministration();
        try {
            if (!uga.doesGroupExist(groupName)) {
                uga.createGroup(groupName, "test group");
            }
            if (!uga.doesUserExist(userName)) {
                uga.createUser(groupName, userName, pwd, "Jane", "Doe", "test@together.at");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String packageLoad(String xpdlName) throws BaseException {
        RepositoryMgr rm;
        String pkgId;
        PackageAdministration pa;
        if (_debug_) {
            System.err.println("#_packageLoad_#");
        }
        if (!(pa = Shark.getInstance().getAdminInterface().getPackageAdministration()).isPackageOpened(pkgId = (rm = Shark.getInstance().getRepositoryManager()).getPackageId(xpdlName))) {
            try {
                pa.openPackage(xpdlName);
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new BaseException(e);
            }
        }
        return rm.getPackageId(xpdlName);
    }

    public static void processStart(String mgrName) throws BaseException {
        if (_debug_) {
            System.err.println("#_processStartName_#");
        }
        SharkConnection sConn = null;
        sConn = Shark.getInstance().getSharkConnection();
        try {
            String pkgId = Shark.getInstance().getAdminInterface().getAdminMisc().getProcessMgrPkgId(mgrName);
            String pDefId = Shark.getInstance().getAdminInterface().getAdminMisc().getProcessMgrProcDefId(mgrName);
            if (!JSPClientUtilities.isProcessRunning(pkgId, pDefId)) {
                sConn.connect(userName, pwd, engineName, null);
                sConn.createProcess(pkgId, pDefId).start();
                sConn.disconnect();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException((Throwable)e);
        }
    }

    public static void processStart(String mgrName, SharkConnection sConn) throws BaseException {
        if (_debug_) {
            System.err.println("#_processStartName_#");
        }
        try {
            String pkgId = Shark.getInstance().getAdminInterface().getAdminMisc().getProcessMgrPkgId(mgrName);
            String pDefId = Shark.getInstance().getAdminInterface().getAdminMisc().getProcessMgrProcDefId(mgrName);
            if (!JSPClientUtilities.isProcessRunning(pkgId, pDefId)) {
                sConn.createProcess(pkgId, pDefId).start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException((Throwable)e);
        }
    }

    public static void processStart(String pkgId, String pDefId) throws BaseException {
        if (_debug_) {
            System.err.println("#_processStartIds_#");
        }
        SharkConnection sConn = null;
        sConn = Shark.getInstance().getSharkConnection();
        try {
            if (!JSPClientUtilities.isProcessRunning(pkgId, pDefId)) {
                sConn.connect(userName, pwd, engineName, null);
                sConn.createProcess(pkgId, pDefId).start();
                sConn.disconnect();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException((Throwable)e);
        }
    }

    public static String extAttribute(String procId, String actId) throws BaseException {
        return Shark.getInstance().getAdminInterface().getAdminMisc().getActivitiesExtendedAttributeValue(procId, actId, EXT_ATT_NAME);
    }

    public static boolean isProcessRunning(String pkgId, String pDefId) throws BaseException {
        System.err.println("#_isProcessRunning_# (" + pkgId + ", " + pDefId + ")");
        ExecutionAdministration ea = Shark.getInstance().getAdminInterface().getExecutionAdministration();
        try {
            ea.connect(userName, pwd, engineName, null);
            WfProcessMgr pMgr = ea.getProcessMgr(pkgId, pDefId);
            WfProcessIterator pit = pMgr.get_iterator_process();
            pit.set_query_expression("state.equals(\"open.running\")");
            if (_debug_) {
                System.err.println("#_" + pit.how_many() + "_#");
                System.err.println("#_" + pit.get_next_n_sequence(0).length + "_#");
            }
            boolean bl = 0 < pit.get_next_n_sequence(0).length;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException((Throwable)e);
        }
        finally {
            try {
                ea.disconnect();
            }
            catch (Exception e) {}
        }
    }

    public static void activityComplete(SharkConnection sConn, String activityId) throws BaseException {
        block5: {
            try {
                if (null == activityId) break block5;
                try {
                    WfAssignment a = JSPClientUtilities.getAssignment(sConn, activityId);
                    if (!JSPClientUtilities.isMine(sConn, a)) {
                        JSPClientUtilities.assignmentAccept(sConn, a);
                    }
                    a.activity().complete();
                }
                catch (Exception e) {
                    throw new BaseException((Throwable)e);
                }
            }
            catch (BaseException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isMine(SharkConnection sConn, String activityId) throws NotConnected, BaseException {
        WfAssignment a = JSPClientUtilities.getAssignment(sConn, activityId);
        return JSPClientUtilities.isMine(sConn, a);
    }

    public static boolean isMine(SharkConnection sConn, WfAssignment a) throws NotConnected, BaseException {
        return a.get_accepted_status();
    }

    public static void assignmentAccept(SharkConnection sConn, String activityId) throws CannotAcceptSuspended, NotConnected, BaseException {
        JSPClientUtilities.assignmentAccept(sConn, JSPClientUtilities.getAssignment(sConn, activityId));
    }

    private static void assignmentAccept(SharkConnection sConn, WfAssignment a) throws CannotAcceptSuspended, NotConnected, BaseException {
        a.set_accepted_status(true);
    }

    public static WfAssignment getAssignment(SharkConnection sConn, String activityId) throws NotConnected, BaseException {
        try {
            WfAssignment[] ar = sConn.getResourceObject().get_sequence_work_item(0);
            for (int i = 0; i < ar.length; ++i) {
                if (!activityId.equals(ar[i].activity().key())) continue;
                return ar[i];
            }
            throw new BaseException("Activity:" + activityId + " not found in " + sConn.getResourceObject().resource_key() + "'s worklist");
        }
        catch (Exception e) {
            if (_debug_) {
                System.err.println("zvekseptsn");
            }
            e.printStackTrace();
            throw new BaseException((Throwable)e);
        }
    }

    public static SharkConnection connect() throws ConnectFailed, BaseException {
        if (_debug_) {
            System.err.println("#_connect_#");
        }
        SharkConnection sConn = Shark.getInstance().getSharkConnection();
        sConn.connect(userName, pwd, engineName, null);
        return sConn;
    }

    public static SharkConnection connect(String user, String passwd) throws ConnectFailed, BaseException {
        if (_debug_) {
            System.err.println("#_connect_#");
        }
        try {
            String groupName = "idle";
            UserGroupAdministration uga = Shark.getInstance().getAdminInterface().getUserGroupAdministration();
            if (!uga.doesGroupExist(groupName)) {
                uga.createGroup(groupName, "test group");
            }
            if (!uga.doesUserExist(user)) {
                uga.createUser(groupName, user, passwd, user, passwd, "test@together.at");
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        SharkConnection sConn = Shark.getInstance().getSharkConnection();
        sConn.connect(user, passwd, engineName, null);
        return sConn;
    }

    public static void disconnect(SharkConnection sConn) throws NotConnected, BaseException {
        if (_debug_) {
            System.err.println("#_disconnect_#");
        }
        sConn.disconnect();
    }

    public static String[] getAllUsers() throws BaseException {
        UserGroupAdministration uga = Shark.getInstance().getAdminInterface().getUserGroupAdministration();
        return uga.getAllUsers();
    }

    public static String getUserRealName(String uname) throws BaseException {
        UserGroupAdministration uga = Shark.getInstance().getAdminInterface().getUserGroupAdministration();
        return uga.getUserRealName(uname);
    }

    public static String getUserEMailAddress(String uname) throws BaseException {
        UserGroupAdministration uga = Shark.getInstance().getAdminInterface().getUserGroupAdministration();
        return uga.getUserEMailAddress(uname);
    }

    public static void variableSet(SharkConnection sConn, String activityId, String vName, String vValue) throws NotConnected, BaseException, UpdateNotAllowed, InvalidData {
        WfAssignment a = JSPClientUtilities.getAssignment(sConn, activityId);
        if (!JSPClientUtilities.isMine(sConn, a)) {
            throw new BaseException("I don't own activity " + activityId);
        }
        HashMap _m = new HashMap();
        Object c = a.activity().process_context().get(vName);
        c = c instanceof Long ? new Long(vValue) : (c instanceof Boolean ? Boolean.valueOf(vValue) : (c instanceof Double ? Double.valueOf(vValue) : vValue));
        _m.put(vName, c);
        a.activity().set_result(_m);
    }

    public static void s() {
        Object a = null;
        Map _m = null;
        try {
            SharkTransaction tr = Shark.getInstance().createTransaction();
            try {
                a.activity(tr).set_result(tr, _m);
                a.activity(tr).complete(tr);
                tr.commit();
            }
            catch (RootException e) {
                Shark.getInstance().emptyCaches(tr);
                Shark.getInstance().unlockProcesses(tr);
                tr.rollback();
            }
        }
        catch (TransactionException transactionException) {
            // empty catch block
        }
    }

    public static String[] xpdlsToLoad() {
        try {
            return Shark.getInstance().getRepositoryManager().getPackagePaths();
        }
        catch (BaseException e) {
            e.printStackTrace();
            return new String[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] processesToStart() {
        ExecutionAdministration ea = null;
        try {
            ea = Shark.getInstance().getAdminInterface().getExecutionAdministration();
            ea.connect(userName, pwd, engineName, null);
            WfProcessMgr[] a = ea.get_iterator_processmgr().get_next_n_sequence(0);
            String[] ret = new String[a.length];
            for (int i = 0; i < a.length; ++i) {
                String n = a[i].name();
                if (_debug_) {
                    System.err.println("processName " + n);
                }
                ret[i] = n;
            }
            String[] stringArray = ret;
            return stringArray;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                ea.disconnect();
            }
            catch (BaseException e) {
            }
            catch (NotConnected notConnected) {}
        }
        return new String[0];
    }

    private static String replaceAll(String input, String forReplace, String replaceWith) {
        if (input == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        boolean hasMore = true;
        while (hasMore) {
            int start = input.indexOf(forReplace);
            int end = start + forReplace.length();
            if (start != -1) {
                result.append(input.substring(0, start) + replaceWith);
                input = input.substring(end);
                continue;
            }
            hasMore = false;
            result.append(input);
        }
        if (result.toString().equals("")) {
            return input;
        }
        return result.toString();
    }
}

