/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.interoperability;

import java.net.InetAddress;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis.encoding.ser.DateDeserializer;
import org.apache.axis.types.URI;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfservice.AdminMisc;
import org.enhydra.shark.api.internal.interoperability.InteroperabilityException;
import org.enhydra.shark.api.internal.interoperability.WfEngineInteroperability;
import org.enhydra.shark.api.internal.working.CallbackUtilities;
import org.enhydra.shark.asap.AsapBindingUtilitiesImpl;
import org.enhydra.shark.asap.types.ChangeStateRq;
import org.enhydra.shark.asap.types.CreateInstanceRq;
import org.enhydra.shark.asap.types.Request;
import org.enhydra.shark.asap.types.YesNoIfError;
import org.enhydra.shark.asap.types.holders.ChangeStateRsHolder;
import org.enhydra.shark.asap.types.holders.CreateInstanceRsHolder;
import org.enhydra.shark.asap.types.holders.ResponseHolder;
import org.enhydra.shark.utilities.MiscUtilities;
import org.enhydra.shark.wfxml.SharkWebServiceLocator;

public class WfXMLInteroperabilityImpl
implements WfEngineInteroperability {
    protected SharkWebServiceLocator locator;
    protected String _meh;
    protected String namePrefix;
    protected String description;
    protected static String DEFAULT_DESCRIPTION = "Enhydra Shark engine [${1}]at address ${2} on behalf of activity ${3} in process instance ${4} made this request.";
    protected static final String PARAM_HOST = "Interoperability.Host";
    protected static final String PARAM_PORT = "Interoperability.Port";
    protected static final String PARAM_DEFAULT_PORT = "8080";
    public static final String EXTENDED_ATTRIBUTE_NAME_PM = "ParamMapping";
    public static final String EXTENDED_ATTRIBUTE_NAME_SL = "ForeignSchemaLocation";

    public void configure(CallbackUtilities cus) throws RootException {
        this.namePrefix = cus.getProperty("enginename") + "/";
        this.locator = new SharkWebServiceLocator();
        try {
            URI _me = new URI(this.locator.getasapObserverBindingAddress());
            _me.setHost(cus.getProperty(PARAM_HOST, InetAddress.getLocalHost().getCanonicalHostName()));
            _me.setPort(Integer.parseInt(cus.getProperty(PARAM_PORT, PARAM_DEFAULT_PORT)));
            this._meh = _me.toString();
            this.description = cus.getProperty("Interoperability.Description", DEFAULT_DESCRIPTION);
            this.description = MiscUtilities.replaceAll((String)this.description, (String)"${1}", (String)cus.getProperty("enginename"));
            this.description = MiscUtilities.replaceAll((String)this.description, (String)"${2}", (String)this._meh);
        }
        catch (Exception e) {
            throw new RootException((Throwable)e);
        }
    }

    public String start(SharkTransaction st, String remoteEngine, String processInstanceId, String workitemId, boolean isSynchronized, Map parameters) throws InteroperabilityException {
        try {
            Map _parameters = this.prepareInParams(st, processInstanceId, workitemId, parameters);
            URI _me = this.getURI(isSynchronized, processInstanceId, workitemId);
            String desc = MiscUtilities.replaceAll((String)this.description, (String)"${3}", (String)workitemId);
            desc = MiscUtilities.replaceAll((String)desc, (String)"${4}", (String)processInstanceId);
            CreateInstanceRsHolder response = new CreateInstanceRsHolder();
            AdminMisc a = Shark.getInstance().getAdminInterface().getAdminMisc();
            workitemId = Shark.getInstance().getAdminInterface().getAdminMisc().getAssignmentActivityId(processInstanceId, workitemId);
            String schemaLocation = a.getActivitiesExtendedAttributeValue(st, processInstanceId, workitemId, EXTENDED_ATTRIBUTE_NAME_SL);
            this.locator.getwfxmlFactoryBinding(new URL(remoteEngine)).createInstance(new Request(_me, new URI(remoteEngine), YesNoIfError.Yes, null), new CreateInstanceRq(true, _me, this.namePrefix + processInstanceId, workitemId, desc, AsapBindingUtilitiesImpl.getContextData((Map)_parameters, (String)schemaLocation)), new ResponseHolder(), response);
            return response.value.getInstanceKey().toString();
        }
        catch (Exception e) {
            throw new InteroperabilityException((Throwable)e);
        }
    }

    public void suspend(SharkTransaction st, String remoteInstanceUri, String processInstanceId, String workitemId) throws InteroperabilityException {
        this.changeState(remoteInstanceUri, processInstanceId, workitemId, "open.not_running.suspended");
    }

    public void resume(SharkTransaction st, String remoteInstanceUri, String processInstanceId, String workitemId) throws InteroperabilityException {
        this.changeState(remoteInstanceUri, processInstanceId, workitemId, "open.running");
    }

    public void terminate(SharkTransaction st, String remoteInstanceUri, String processInstanceId, String workitemId) throws InteroperabilityException {
        this.changeState(remoteInstanceUri, processInstanceId, workitemId, "closed.terminated");
    }

    public void abort(SharkTransaction st, String remoteInstanceUri, String processInstanceId, String workitemId) throws InteroperabilityException {
        this.changeState(remoteInstanceUri, processInstanceId, workitemId, "closed.aborted");
    }

    protected URI getURI(boolean isSynchronized, String processInstanceId, String workitemId) throws URI.MalformedURIException, BaseException {
        URI ret = new URI(this._meh);
        if (isSynchronized) {
            ret.setQueryString("procId=" + processInstanceId + "&actId=" + Shark.getInstance().getAdminInterface().getAdminMisc().getAssignmentActivityId(processInstanceId, workitemId));
        }
        return ret;
    }

    protected void changeState(String remoteInstanceUri, String processInstanceId, String workitemId, String requestedNewState) throws InteroperabilityException {
        try {
            URI _me = this.getURI(true, processInstanceId, workitemId);
            ChangeStateRsHolder response = new ChangeStateRsHolder();
            this.locator.getasapInstanceBinding(new URL(remoteInstanceUri)).changeState(new Request(_me, new URI(remoteInstanceUri), YesNoIfError.Yes, ""), new ChangeStateRq(AsapBindingUtilitiesImpl.parseState((String)requestedNewState)), new ResponseHolder(), response);
        }
        catch (Exception e) {
            throw new InteroperabilityException((Throwable)e);
        }
    }

    protected Map prepareInParams(SharkTransaction st, String processInstanceId, String workitemId, Map parameters) throws BaseException, InteroperabilityException {
        AdminMisc a = Shark.getInstance().getAdminInterface().getAdminMisc();
        workitemId = Shark.getInstance().getAdminInterface().getAdminMisc().getAssignmentActivityId(processInstanceId, workitemId);
        String extendedAttributes = a.getActivitiesExtendedAttributeValue(st, processInstanceId, workitemId, EXTENDED_ATTRIBUTE_NAME_PM);
        Map m = this.prepParamsMapping(extendedAttributes);
        Iterator it = m.keySet().iterator();
        while (it.hasNext()) {
            String localName = (String)it.next();
            String remoteName = (String)m.get(localName);
            if (!parameters.containsKey(localName)) continue;
            Object localValue = parameters.remove(localName);
            parameters.put(remoteName, localValue);
        }
        System.err.println("###" + processInstanceId + "\n#" + workitemId + "\n:" + extendedAttributes + ":");
        return parameters;
    }

    private Map prepParamsMapping(String extendedAttributes) throws InteroperabilityException {
        HashMap<String, String> ret = new HashMap<String, String>();
        String[] arr = MiscUtilities.tokenize((String)extendedAttributes, (String)";");
        for (int i = 0; i < arr.length; ++i) {
            int index = arr[i].indexOf(44);
            if (0 > index) {
                throw new InteroperabilityException("wrong contents of extended attribute ParamMapping=" + arr[i]);
            }
            String localName = arr[i].substring(0, index).trim();
            String remoteName = arr[i].substring(1 + index).trim();
            ret.put(remoteName, localName);
        }
        return ret;
    }

    public Map parseOutParams(SharkTransaction st, String processInstanceId, String workitemId, Map parameters, Map cSig) throws InteroperabilityException {
        String extendedAttributes = "";
        HashMap<String, String> ret = new HashMap<String, String>();
        try {
            AdminMisc a = Shark.getInstance().getAdminInterface().getAdminMisc();
            workitemId = Shark.getInstance().getAdminInterface().getAdminMisc().getAssignmentActivityId(processInstanceId, workitemId);
            extendedAttributes = a.getActivitiesExtendedAttributeValue(st, processInstanceId, workitemId, EXTENDED_ATTRIBUTE_NAME_PM);
        }
        catch (BaseException e) {
            throw new InteroperabilityException((Throwable)e);
        }
        Map m = this.prepParamsMapping(extendedAttributes);
        Iterator it = parameters.keySet().iterator();
        while (it.hasNext()) {
            String remoteName = it.next().toString();
            String localName = (String)m.get(remoteName);
            if (null == localName) {
                if (!cSig.containsKey(remoteName)) continue;
                localName = remoteName;
            }
            String stringRep = parameters.get(remoteName).toString();
            String localType = (String)cSig.get(localName);
            Object localValue = null;
            if (!"java.lang.String".equals(localType)) {
                if (null == stringRep) {
                    stringRep = "0";
                }
                if (null != localType) {
                    if (localType.equals("java.lang.Long")) {
                        localValue = new Long(stringRep);
                    } else if (localType.equals("java.lang.Boolean")) {
                        localValue = new Boolean(stringRep);
                    } else if (localType.equals("java.lang.Double")) {
                        localValue = new Double(stringRep);
                    } else if (localType.equals("java.util.Date")) {
                        try {
                            DateDeserializer a = new DateDeserializer(Class.forName(localType), new QName("http://www.w3.org/2001/XMLSchema", "date"));
                            localValue = a.makeValue(stringRep);
                        }
                        catch (Exception _) {
                            localValue = new Date(0L);
                        }
                    }
                }
            } else {
                localValue = stringRep;
                if (null == stringRep) {
                    localValue = "";
                }
            }
            ret.put(localName, (String)localValue);
        }
        System.err.println("###" + processInstanceId + "\n#" + workitemId + "\n:" + ret + ":");
        return ret;
    }
}

