/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.instancepersistence.data;

import com.lutris.appserver.server.sql.CachedDBTransaction;
import com.lutris.appserver.server.sql.CoreDO;
import com.lutris.appserver.server.sql.CoreDataStruct;
import com.lutris.appserver.server.sql.DBConnection;
import com.lutris.appserver.server.sql.DBQuery;
import com.lutris.appserver.server.sql.DBTransaction;
import com.lutris.appserver.server.sql.DatabaseManagerException;
import com.lutris.appserver.server.sql.ExtendedQuery;
import com.lutris.appserver.server.sql.ObjectId;
import com.lutris.appserver.server.sql.ObjectIdException;
import com.lutris.appserver.server.sql.Query;
import com.lutris.dods.builder.generator.dataobject.GenericDO;
import com.lutris.dods.builder.generator.query.DataObjectException;
import com.lutris.dods.builder.generator.query.NonUniqueQueryException;
import com.lutris.dods.builder.generator.query.QueryBuilder;
import com.lutris.dods.builder.generator.query.QueryException;
import java.io.PrintWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import org.enhydra.dods.DODS;
import org.enhydra.dods.cache.Condition;
import org.enhydra.dods.cache.DOShell;
import org.enhydra.dods.cache.DataStructCache;
import org.enhydra.dods.cache.QueryCache;
import org.enhydra.dods.cache.QueryCacheItem;
import org.enhydra.dods.cache.QueryResult;
import org.enhydra.dods.statistics.CacheStatistics;
import org.enhydra.shark.instancepersistence.data.ProcessDO;
import org.enhydra.shark.instancepersistence.data.ProcessDataStruct;
import org.enhydra.shark.instancepersistence.data.ProcessDefinitionDO;
import org.enhydra.shark.instancepersistence.data.ProcessDefinitionDataStruct;
import org.enhydra.shark.instancepersistence.data.ProcessStateDO;
import org.enhydra.shark.instancepersistence.data.ProcessStateDataStruct;

public class ProcessQuery
implements ExtendedQuery {
    private QueryBuilder builder;
    private String logicalDatabase;
    private ResultSet resultSet = null;
    private boolean uniqueInstance = false;
    private boolean loadData = false;
    private ProcessDO[] DOs = null;
    private int arrayIndex = -1;
    private boolean needToRun = true;
    private Vector cacheHits = null;
    private boolean isQueryByOId = false;
    private boolean hasNonOidCond = false;
    private boolean hitDb = false;
    private boolean userHitDb = false;
    private int maxDBrows = 0;
    private boolean orderRelevant = true;
    private QueryCacheItem queryItem = null;
    private String currentHandle = null;
    private HashMap refs = new HashMap();
    private int iCurrentFetchSize = -1;
    private int iCurrentQueryTimeout = 0;
    DBTransaction transaction = null;
    private int queryTimeLimit = 0;
    private boolean unique = false;
    private int readSkip = 0;
    private int databaseLimit = 0;
    private boolean databaseLimitExceeded = false;

    public ProcessQuery(DBTransaction dbTrans) {
        this.builder = new QueryBuilder("Processes", ProcessDO.columnsNameString);
        Integer tmpInt = ProcessDO.getConfigurationAdministration().getTableConfiguration().getQueryTimeLimit();
        this.queryTimeLimit = tmpInt != null ? tmpInt : 0;
        String dbName = null;
        dbName = dbTrans != null ? dbTrans.getDatabaseName() : ProcessDO.get_logicalDBName();
        try {
            this.transaction = dbTrans;
            String vendor = DODS.getDatabaseManager().logicalDatabaseType(dbName);
            if (vendor != null) {
                this.builder.setDatabaseVendor(vendor);
                this.logicalDatabase = dbName;
            } else {
                this.builder.setDatabaseVendor();
                this.logicalDatabase = DODS.getDatabaseManager().getDefaultDB();
            }
        }
        catch (Exception e) {
            this.builder.setDatabaseVendor();
            this.logicalDatabase = DODS.getDatabaseManager().getDefaultDB();
        }
        this.builder.setUserStringAppendWildcard(false);
        this.builder.setUserStringTrim(false);
        this.reset();
    }

    public String getLogicalDatabase() {
        return this.logicalDatabase;
    }

    public PreparedStatement getStatement() {
        return this.builder.getStatement();
    }

    public void setLogicalDatabase(String dbName) throws SQLException, DatabaseManagerException {
        String vendor = DODS.getDatabaseManager().logicalDatabaseType(dbName);
        if (vendor != null) {
            this.builder.setDatabaseVendor(vendor);
            this.logicalDatabase = dbName;
        } else {
            this.builder.setDatabaseVendor();
            this.logicalDatabase = DODS.getDatabaseManager().getDefaultDB();
        }
        this.reset();
    }

    public void setUnique(boolean newUnique) {
        this.unique = newUnique;
    }

    public boolean getUnique() {
        return this.unique;
    }

    public void setReadSkip(int newReadSkip) {
        this.readSkip = newReadSkip;
    }

    public int getReadSkip() {
        return this.readSkip;
    }

    public void setDatabaseLimit(int newLimit) {
        this.databaseLimit = newLimit;
    }

    public int getDatabaseLimit() {
        return this.databaseLimit;
    }

    public boolean getDatabaseLimitExceeded() {
        return this.databaseLimitExceeded;
    }

    public void hitDatabase() {
        this.userHitDb = true;
    }

    public void setUserStringWildcard(String newUserStringWildcard) {
        this.builder.setUserStringWildcard(newUserStringWildcard);
    }

    public void setUserStringSingleWildcard(String newUserStringSingleWildcard) {
        this.builder.setUserStringSingleWildcard(newUserStringSingleWildcard);
    }

    public void setUserStringSingleWildcardEscape(String newUserStringSingleWildcardEscape) {
        this.builder.setUserStringSingleWildcardEscape(newUserStringSingleWildcardEscape);
    }

    public void setUserStringWildcardEscape(String newUserStringWildcardEscape) {
        this.builder.setUserStringWildcardEscape(newUserStringWildcardEscape);
    }

    public void setUserStringAppendWildcard(boolean userStringAppendWildcard) {
        this.builder.setUserStringAppendWildcard(userStringAppendWildcard);
    }

    public void setUserStringTrim(boolean userStringTrim) {
        this.builder.setUserStringTrim(userStringTrim);
    }

    public String getUserStringWildcard() {
        return this.builder.getUserStringWildcard();
    }

    public String getUserStringSingleWildcard() {
        return this.builder.getUserStringSingleWildcard();
    }

    public String getUserStringSingleWildcardEscape() {
        return this.builder.getUserStringSingleWildcardEscape();
    }

    public String getUserStringWildcardEscape() {
        return this.builder.getUserStringWildcardEscape();
    }

    public boolean getUserStringAppendWildcard() {
        return this.builder.getUserStringAppendWildcard();
    }

    public boolean getUserStringTrim() {
        return this.builder.getUserStringTrim();
    }

    private void getQueryByOIds(Vector DOs, Date mainQueryStartTime) throws DataObjectException {
        if (DOs.size() == 0) {
            return;
        }
        ProcessDO DO = null;
        DOShell shell = null;
        ProcessQuery tmpQuery = null;
        Date startQueryTime = new Date();
        long queryTime = 0L;
        boolean queryTimeLimitError = false;
        for (int i = 0; i < DOs.size(); ++i) {
            shell = (DOShell)DOs.elementAt(i);
            tmpQuery = new ProcessQuery(this.transaction);
            try {
                tmpQuery.setQueryHandle(shell.handle);
                tmpQuery.requireUniqueInstance();
                DO = tmpQuery.getNextDO();
                Date currentQueryTime = new Date();
                long passedQueryTime = currentQueryTime.getTime() - mainQueryStartTime.getTime();
                if (this.queryTimeLimit > 0 && passedQueryTime > (long)this.queryTimeLimit) {
                    DODS.getLogChannel().write(4, "Froced QueryByOIds Query interrupt, query time limit exceeded (errID=30).");
                    DODS.getLogChannel().write(7, "Froced QueryByOIds Query interrupt, query time limit exceeded (errID=30)( QueryTimeLimit = " + this.queryTimeLimit + " : PassedQueryTime = " + passedQueryTime + " ) SQL = " + tmpQuery.getQueryBuilder().getSQLwithParms());
                    queryTimeLimitError = true;
                    throw new SQLException("Froced query interrupt in QueryByOIds (errID=30).");
                }
                if (null == DO) {
                    throw new DataObjectException("ProcessDO DO not found for id=" + shell.handle);
                }
            }
            catch (Exception e) {
                if (queryTimeLimitError) {
                    throw new DataObjectException(e.getMessage());
                }
                throw new DataObjectException("Duplicate ObjectId");
            }
            shell.dataObject = DO;
        }
        Date stopQueryTime = new Date();
        queryTime = stopQueryTime.getTime() - startQueryTime.getTime();
        ProcessDO.statistics.updateQueryByOIdAverageTime(new Long(queryTime).intValue(), DOs.size());
    }

    private void runQuery() throws DataObjectException, NonUniqueQueryException {
        this.needToRun = false;
        this.arrayIndex = -1;
        DBQuery dbQuery = null;
        Date startQueryTime = new Date();
        long queryTime = 0L;
        boolean readDOs = false;
        boolean canUseQueryCache = true;
        CacheStatistics stat = null;
        boolean resultsFromQCache = false;
        QueryCacheItem queryCachedItem = null;
        if (this.builder.isUnionTableJoin()) {
            throw new DataObjectException("Could not use 'UNION [ALL]' statement in query witch retrieve data object.");
        }
        if (this.transaction != null && this.transaction instanceof CachedDBTransaction) {
            if (((CachedDBTransaction)this.transaction).getAutoWrite()) {
                try {
                    this.transaction.write();
                }
                catch (SQLException sqle) {
                    sqle.printStackTrace();
                    throw new DataObjectException("Couldn't write transaction: " + sqle);
                }
            }
            ((CachedDBTransaction)this.transaction).dontAggregateDOModifications();
        }
        try {
            ProcessDO DO;
            QueryResult results = null;
            DOShell shell = null;
            if (this.isQueryByOId && !this.hasNonOidCond) {
                this.builder.setCurrentFetchSize(1);
                results = new QueryResult();
                if (this.currentHandle != null) {
                    ProcessDataStruct DS;
                    if (this.transaction != null && ProcessQuery._tr_(this.transaction).getTransactionCache() != null && !this.loadData && (DO = (ProcessDO)ProcessQuery._tr_(this.transaction).getTransactionCache().getDOByHandle(this.currentHandle)) != null) {
                        shell = new DOShell((GenericDO)DO);
                        results.DOs.add(shell);
                        resultsFromQCache = true;
                    }
                    if (!(resultsFromQCache || (DS = (ProcessDataStruct)ProcessDO.cache.getDataStructByHandle(this.currentHandle)) == null || DS.isEmpty && this.loadData)) {
                        ProcessDO DO2 = ProcessDO.ceInternal(DS.get_OId(), this.transaction);
                        shell = new DOShell((GenericDO)DO2);
                        results.DOs.add(shell);
                        resultsFromQCache = true;
                    }
                }
            } else if (ProcessDO.cache.isFull() && ProcessDO.isFullCacheNeeded && !this.hitDb && this.maxDBrows == 0 && this.databaseLimit == 0 && this.readSkip == 0 && !this.builder.isMultiTableJoin()) {
                resultsFromQCache = true;
            } else {
                if (ProcessDO.cache.getLevelOfCaching() == 2) {
                    if (this.builder.isMultiTableJoin()) {
                        stat = null;
                        stat = ProcessDO.statistics.getCacheStatistics(3);
                        if (stat != null) {
                            stat.incrementCacheAccessNum(1);
                        }
                    } else if (this.hitDb) {
                        stat = null;
                        stat = ProcessDO.statistics.getCacheStatistics(2);
                        if (stat != null) {
                            stat.incrementCacheAccessNum(1);
                        }
                    } else {
                        stat = null;
                        stat = ProcessDO.statistics.getCacheStatistics(1);
                        if (stat != null) {
                            stat.incrementCacheAccessNum(1);
                        }
                    }
                }
                if (this.transaction != null) {
                    boolean bl = canUseQueryCache = !this.transaction.preventCacheQueries();
                }
                if (ProcessDO.cache.getLevelOfCaching() == 2 && canUseQueryCache) {
                    String queryID = this.builder.getSQLwithParms();
                    int resNum = 0;
                    boolean evaluateNo = false;
                    queryCachedItem = this.builder.isMultiTableJoin() ? ((QueryCache)ProcessDO.cache).getMultiJoinQueryCacheItem(this.logicalDatabase, queryID) : (this.hitDb ? ((QueryCache)ProcessDO.cache).getComplexQueryCacheItem(this.logicalDatabase, queryID) : ((QueryCache)ProcessDO.cache).getSimpleQueryCacheItem(this.logicalDatabase, queryID));
                    this.queryItem.setQueryId(queryID);
                    if (queryCachedItem == null) {
                        if (this.builder.isMultiTableJoin()) {
                            ((QueryCache)ProcessDO.cache).addMultiJoinQuery(this.queryItem);
                        } else if (this.hitDb) {
                            ((QueryCache)ProcessDO.cache).addComplexQuery(this.queryItem);
                        } else {
                            ((QueryCache)ProcessDO.cache).addSimpleQuery(this.queryItem);
                        }
                    } else if (!this.isOrderRelevant() || !queryCachedItem.isModifiedQuery()) {
                        if (this.builder.isMultiTableJoin()) {
                            stat = null;
                            stat = ProcessDO.statistics.getCacheStatistics(3);
                            if (stat != null) {
                                stat.incrementCacheHitsNum(1);
                            }
                        } else if (this.hitDb) {
                            stat = null;
                            stat = ProcessDO.statistics.getCacheStatistics(2);
                            if (stat != null) {
                                stat.incrementCacheHitsNum(1);
                            }
                        } else {
                            stat = null;
                            stat = ProcessDO.statistics.getCacheStatistics(1);
                            if (stat != null) {
                                stat.incrementCacheHitsNum(1);
                            }
                        }
                        int limitOfRes = this.databaseLimit == 0 ? 0 : this.readSkip + this.databaseLimit + 1;
                        results = !this.unique ? (this.builder.isMultiTableJoin() ? ((QueryCache)ProcessDO.cache).getMultiJoinQueryResults(this.logicalDatabase, queryID, limitOfRes, this.maxDBrows) : (this.hitDb ? ((QueryCache)ProcessDO.cache).getComplexQueryResults(this.logicalDatabase, queryID, limitOfRes, this.maxDBrows) : ((QueryCache)ProcessDO.cache).getSimpleQueryResults(this.logicalDatabase, queryID, limitOfRes, this.maxDBrows))) : (this.builder.isMultiTableJoin() ? ((QueryCache)ProcessDO.cache).getMultiJoinQueryResults(this.logicalDatabase, queryID, limitOfRes, this.maxDBrows, true) : (this.hitDb ? ((QueryCache)ProcessDO.cache).getComplexQueryResults(this.logicalDatabase, queryID, limitOfRes, this.maxDBrows, true) : ((QueryCache)ProcessDO.cache).getSimpleQueryResults(this.logicalDatabase, queryID, limitOfRes, this.maxDBrows, true)));
                        if (results != null) {
                            resNum = results.DOs.size();
                            if (this.readSkip > 0) {
                                if (results.DOs.size() > this.readSkip) {
                                    for (int i = 0; i < this.readSkip; ++i) {
                                        results.DOs.remove(0);
                                    }
                                } else {
                                    results.DOs.clear();
                                }
                            }
                            results = this.getCachedResults(results);
                            if (this.databaseLimit != 0) {
                                if (resNum == this.readSkip + this.databaseLimit + 1) {
                                    --resNum;
                                    this.databaseLimitExceeded = true;
                                    results.DOs.remove(this.databaseLimit);
                                } else if (resNum == this.readSkip + this.databaseLimit && !queryCachedItem.isCompleteResult()) {
                                    this.databaseLimitExceeded = true;
                                }
                            }
                            if (this.databaseLimit != 0 && resNum == this.readSkip + this.databaseLimit || this.maxDBrows != 0 && resNum + results.skippedUnique == this.maxDBrows || queryCachedItem.isCompleteResult()) {
                                int lazyTime = ProcessDO.statistics.getQueryByOIdAverageTime() * results.lazy.size();
                                if (lazyTime <= queryCachedItem.getTime()) {
                                    resultsFromQCache = true;
                                    this.getQueryByOIds(results.lazy, startQueryTime);
                                } else {
                                    this.databaseLimitExceeded = false;
                                }
                            } else {
                                this.databaseLimitExceeded = false;
                            }
                        }
                    }
                }
            }
            if (this.userHitDb || !resultsFromQCache) {
                int maxExecuteTime;
                int iteration;
                dbQuery = ProcessDO.createQuery(this.transaction);
                if (this.uniqueInstance) {
                    this.builder.setCurrentFetchSize(1);
                }
                results = new QueryResult();
                int resultCount = 0;
                boolean bHasMoreResults = false;
                if ((ProcessDO.getConfigurationAdministration().getTableConfiguration().isLazyLoading() || this.isCaching()) && !this.builder.getPreventPrimaryKeySelect() && !this.loadData) {
                    this.builder.resetSelectedFields();
                    this.builder.setSelectClause("Processes." + ProcessDO.get_OIdColumnName() + ", Processes." + ProcessDO.get_versionColumnName());
                } else {
                    this.builder.setSelectClause(ProcessDO.columnsNameString);
                }
                dbQuery.query((Query)this);
                if (!this.unique) {
                    iteration = 0;
                    try {
                        while ((bHasMoreResults = this.resultSet.next()) && (this.databaseLimit == 0 || results.DOs.size() < this.databaseLimit)) {
                            ProcessDO newDO;
                            Date currentQueryTime = new Date();
                            long passedQueryTime = currentQueryTime.getTime() - startQueryTime.getTime();
                            if (this.queryTimeLimit > 0 && passedQueryTime > (long)this.queryTimeLimit) {
                                DODS.getLogChannel().write(4, "Froced query interrupt, query time limit exceeded (errID=10).");
                                DODS.getLogChannel().write(7, "Froced query interrupt, query time limit exceeded (errID=10)( QueryTimeLimit = " + this.queryTimeLimit + " : PassedQueryTime = " + passedQueryTime + " ) SQL = " + this.builder.getSQLwithParms());
                                throw new SQLException("Froced query interrupt (errID=10).");
                            }
                            if ((ProcessDO.getConfigurationAdministration().getTableConfiguration().isLazyLoading() || this.isCaching()) && !this.builder.getPreventPrimaryKeySelect() && !this.loadData) {
                                newDO = ProcessDO.ceInternal(new ObjectId(this.resultSet.getBigDecimal(CoreDO.get_OIdColumnName())), this.refs, this.transaction);
                                newDO.set_Version(this.resultSet.getInt(ProcessDO.get_versionColumnName()));
                            } else {
                                newDO = ProcessDO.ceInternal(this.resultSet, this.refs, this.transaction);
                            }
                            if (this.transaction == null && newDO != null && newDO.isTransactionCheck()) {
                                DODS.getLogChannel().write(4, "DO without transaction context is created : Database: " + newDO.get_OriginDatabase() + " ProcessDO class, oid: " + newDO.get_Handle() + ", version: " + newDO.get_Version() + " \n");
                                new Throwable().printStackTrace((PrintWriter)DODS.getLogChannel().getLogWriter(4));
                            }
                            if (this.queryItem != null) {
                                this.queryItem.add((CoreDataStruct)((ProcessDataStruct)newDO.originalData_get()));
                            }
                            if (!ProcessDO.getConfigurationAdministration().getTableConfiguration().isLazyLoading() && !this.isCaching() || this.builder.getPreventPrimaryKeySelect() || this.loadData) {
                                ProcessDataStruct newDS = ProcessDO.addToCache((ProcessDataStruct)newDO.originalData_get());
                            }
                            if (resultCount >= this.readSkip) {
                                shell = new DOShell((GenericDO)newDO);
                                results.DOs.add(shell);
                            }
                            ++resultCount;
                            ++iteration;
                        }
                    }
                    catch (SQLException e) {
                        DODS.getLogChannel().write(3, "(SQLError):(ReadingResultSet):(errID=50):(" + e.getMessage() + ")");
                        DODS.getLogChannel().write(7, "(SQLError):(ReadingResultSet):(errID=50):(element-at:" + iteration + ") sql = " + this.builder.getSQLwithParms());
                        throw e;
                    }
                }
                iteration = 0;
                HashSet<String> hsResult = new HashSet<String>(this.readSkip + this.databaseLimit);
                try {
                    while ((bHasMoreResults = this.resultSet.next()) && (this.databaseLimit == 0 || results.DOs.size() < this.databaseLimit)) {
                        ProcessDO newDO;
                        Date currentQueryTime = new Date();
                        long passedQueryTime = currentQueryTime.getTime() - startQueryTime.getTime();
                        if (this.queryTimeLimit > 0 && passedQueryTime > (long)this.queryTimeLimit) {
                            DODS.getLogChannel().write(4, "Froced query interrupt, query time limit exceeded (errID=20).");
                            DODS.getLogChannel().write(7, "Froced query interrupt, query time limit exceeded (errID=20)( QueryTimeLimit = " + this.queryTimeLimit + " : PassedQueryTime = " + passedQueryTime + " ) SQL = " + this.builder.getSQLwithParms());
                            throw new SQLException("Froced query interrupt (errID=20).");
                        }
                        if ((ProcessDO.getConfigurationAdministration().getTableConfiguration().isLazyLoading() || this.isCaching()) && !this.builder.getPreventPrimaryKeySelect() && !this.loadData) {
                            newDO = ProcessDO.ceInternal(new ObjectId(this.resultSet.getBigDecimal(CoreDO.get_OIdColumnName())), this.refs, this.transaction);
                            newDO.set_Version(this.resultSet.getInt(ProcessDO.get_versionColumnName()));
                        } else {
                            newDO = ProcessDO.ceInternal(this.resultSet, this.refs, this.transaction);
                        }
                        if (this.transaction == null && newDO != null && newDO.isTransactionCheck()) {
                            DODS.getLogChannel().write(4, "DO without transaction context is created : Database: " + newDO.get_OriginDatabase() + " ProcessDO class, oid: " + newDO.get_Handle() + ", version: " + newDO.get_Version() + " \n");
                            new Throwable().printStackTrace((PrintWriter)DODS.getLogChannel().getLogWriter(4));
                        }
                        if (this.queryItem != null) {
                            this.queryItem.add((CoreDataStruct)((ProcessDataStruct)newDO.originalData_get()));
                        }
                        if (!ProcessDO.getConfigurationAdministration().getTableConfiguration().isLazyLoading() && !this.isCaching() || this.builder.getPreventPrimaryKeySelect() || this.loadData) {
                            ProcessDataStruct newDS = ProcessDO.addToCache((ProcessDataStruct)newDO.originalData_get());
                        }
                        if (!hsResult.contains(newDO.get_Handle())) {
                            hsResult.add(newDO.get_Handle());
                            if (resultCount >= this.readSkip) {
                                shell = new DOShell((GenericDO)newDO);
                                results.DOs.add(shell);
                            }
                            ++resultCount;
                        }
                        ++iteration;
                    }
                }
                catch (SQLException e) {
                    DODS.getLogChannel().write(3, "(SQLError):(ReadingResultSet):(errID=40)(" + e.getMessage() + ")");
                    DODS.getLogChannel().write(7, "(SQLError):(ReadingResultSet):(errID=40):(element-at:" + iteration + ") sql = " + this.builder.getSQLwithParms());
                    throw e;
                }
                if (results.DOs.size() == this.databaseLimit && bHasMoreResults) {
                    this.resultSet.close();
                    this.databaseLimitExceeded = true;
                }
                if (this.maxDBrows > 0) {
                    if (!bHasMoreResults && this.databaseLimit > 0 && this.databaseLimit < this.maxDBrows) {
                        this.queryItem.setCompleteResult(true);
                    }
                } else if (!bHasMoreResults) {
                    this.queryItem.setCompleteResult(true);
                }
                Date stopQueryTime = new Date();
                queryTime = stopQueryTime.getTime() - startQueryTime.getTime();
                if (this.queryItem != null) {
                    this.queryItem.setTime(new Long(queryTime).intValue());
                    if (queryCachedItem != null) {
                        if (this.queryItem.isCompleteResult() || queryCachedItem.isModifiedQuery() && this.isOrderRelevant() || queryCachedItem.getResultNum() < this.queryItem.getResultNum()) {
                            if (this.builder.isMultiTableJoin()) {
                                ((QueryCache)ProcessDO.cache).addMultiJoinQuery(this.queryItem);
                            } else if (this.hitDb) {
                                ((QueryCache)ProcessDO.cache).addComplexQuery(this.queryItem);
                            } else {
                                ((QueryCache)ProcessDO.cache).addSimpleQuery(this.queryItem);
                            }
                        } else if (queryCachedItem.getResultNum() < this.readSkip + this.databaseLimit && queryCachedItem.getResultNum() < this.maxDBrows) {
                            queryCachedItem.setCompleteResult(true);
                        }
                        if (this.queryItem.getResultNum() < this.readSkip + this.databaseLimit && this.queryItem.getResultNum() < this.maxDBrows) {
                            this.queryItem.setCompleteResult(true);
                        }
                    }
                }
                if ((maxExecuteTime = ProcessDO.cache.getTableConfiguration().getMaxExecuteTime()) > 0 && queryTime > (long)maxExecuteTime) {
                    DODS.getLogChannel().write(4, "sql = " + this.builder.getSQLwithParms() + " execute time = " + queryTime + "max table execute time = " + maxExecuteTime);
                }
            } else if (ProcessDO.cache.isFull() && ProcessDO.isFullCacheNeeded && !this.hitDb && this.maxDBrows == 0 && this.databaseLimit == 0 && this.readSkip == 0 && !this.builder.isMultiTableJoin()) {
                results = new QueryResult();
                if (this.readSkip < this.cacheHits.size()) {
                    results.DOs = new Vector();
                    DO = null;
                    ProcessDataStruct DS = null;
                    String cachePrefix = this.getLogicalDatabase() + ".";
                    int resNumber = 0;
                    Vector<String> uniqueResults = new Vector<String>();
                    for (int i = 0; i < this.cacheHits.size(); ++i) {
                        boolean findInTransactionCache = false;
                        DS = (ProcessDataStruct)this.cacheHits.get(i);
                        if (this.transaction != null && ProcessQuery._tr_(this.transaction).getTransactionCache() != null && !this.loadData && (DO = (ProcessDO)ProcessQuery._tr_(this.transaction).getTransactionCache().getDOByHandle(cachePrefix + DS.get_Handle())) != null) {
                            findInTransactionCache = true;
                        }
                        if (!findInTransactionCache) {
                            DO = ProcessDO.ceInternal(DS.get_OId(), this.transaction);
                        }
                        if (this.unique) {
                            if (uniqueResults.contains(cachePrefix + DS.get_Handle())) continue;
                            uniqueResults.add(cachePrefix + DS.get_Handle());
                            results.DOs.add(DO);
                            ++resNumber;
                            continue;
                        }
                        results.DOs.add(DO);
                        ++resNumber;
                    }
                    readDOs = true;
                }
            }
            if (results != null) {
                if (results.DOs.size() > 1 && this.uniqueInstance) {
                    throw new NonUniqueQueryException("Too many\trows returned from database");
                }
                this.DOs = new ProcessDO[results.DOs.size()];
                if (readDOs) {
                    for (int i = 0; i < results.DOs.size(); ++i) {
                        this.DOs[i] = (ProcessDO)results.DOs.elementAt(i);
                    }
                } else {
                    for (int i = 0; i < results.DOs.size(); ++i) {
                        this.DOs[i] = (ProcessDO)((DOShell)results.DOs.elementAt((int)i)).dataObject;
                    }
                }
                this.arrayIndex = 0;
            } else {
                this.DOs = new ProcessDO[0];
            }
            if (this.isQueryByOId && !this.hasNonOidCond) {
                ProcessDO.statistics.incrementQueryByOIdNum();
                ProcessDO.statistics.updateQueryByOIdAverageTime(new Long(queryTime).intValue(), 1);
            } else {
                ProcessDO.statistics.incrementQueryNum();
                ProcessDO.statistics.updateQueryAverageTime(new Long(queryTime).intValue());
            }
        }
        catch (SQLException se) {
            if (null == se.getSQLState()) {
                throw new DataObjectException("Unknown SQLException", (Throwable)se);
            }
            if (se.getSQLState().startsWith("02") && se.getErrorCode() == 100) {
                throw new DataObjectException("Update or delete\tDO is out of synch", (Throwable)se);
            }
            if (se.getSQLState().equals("S1000") && se.getErrorCode() == -268) {
                throw new DataObjectException("Integrity constraint\tviolation", (Throwable)se);
            }
            throw new DataObjectException("Data Object\tError", (Throwable)se);
        }
        catch (ObjectIdException oe) {
            throw new DataObjectException("Object ID Error", (Throwable)oe);
        }
        catch (DatabaseManagerException de) {
            throw new DataObjectException("Database connection\tError", (Throwable)de);
        }
        finally {
            if (null != dbQuery) {
                dbQuery.release();
            }
        }
    }

    public void setMaxRows(int maxRows) throws DataObjectException, NonUniqueQueryException {
        this.maxDBrows = maxRows;
        this.builder.setMaxRows(maxRows);
    }

    public int getMaxRows() {
        return this.maxDBrows;
    }

    public boolean isOrderRelevant() {
        return this.orderRelevant;
    }

    public void setOrderRelevant(boolean newOrderRelevant) {
        this.orderRelevant = newOrderRelevant;
    }

    public QueryResult getCachedResults(QueryResult result) throws DataObjectException {
        Vector tempVec = result.DOs;
        if (tempVec == null) {
            return null;
        }
        result.DOs = new Vector();
        result.lazy = new Vector();
        DOShell shell = null;
        ProcessDO cacheDO = null;
        ProcessDataStruct cacheDS = null;
        String handle = "";
        String cachePrefix = this.getLogicalDatabase() + ".";
        for (int i = 0; i < tempVec.size(); ++i) {
            if (tempVec.get(i) == null) continue;
            cacheDO = null;
            cacheDS = null;
            handle = (String)tempVec.get(i);
            shell = new DOShell(handle);
            if (this.transaction != null && ProcessQuery._tr_(this.transaction).getTransactionCache() != null && !this.loadData) {
                try {
                    cacheDO = (ProcessDO)ProcessQuery._tr_(this.transaction).getTransactionCache().getDOByHandle(cachePrefix + handle);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (cacheDO == null && (cacheDS = (ProcessDataStruct)ProcessDO.cache.getDataStructByHandle(cachePrefix + handle)) != null) {
                try {
                    cacheDO = ProcessDO.ceInternal(cacheDS.get_OId(), this.transaction);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (cacheDO == null) {
                result.lazy.add(shell);
            } else {
                shell.dataObject = cacheDO;
            }
            result.DOs.add(shell);
        }
        return result;
    }

    public ProcessDO[] getDOArray() throws DataObjectException, NonUniqueQueryException {
        if (this.needToRun) {
            this.runQuery();
        }
        return this.DOs;
    }

    public ProcessDO getNextDO() throws DataObjectException, NonUniqueQueryException {
        if (this.needToRun) {
            this.runQuery();
        }
        if (null == this.DOs) {
            return null;
        }
        if (this.arrayIndex < this.DOs.length) {
            return this.DOs[this.arrayIndex++];
        }
        return null;
    }

    public void setQueryOId(ObjectId oid) {
        String handle = this.getLogicalDatabase() + "." + oid.toString();
        if (ProcessDO.cache.isFull() && ProcessDO.isFullCacheNeeded) {
            ProcessDataStruct DS = null;
            for (int i = 0; i < this.cacheHits.size(); ++i) {
                DS = (ProcessDataStruct)this.cacheHits.elementAt(i);
                String cacheHandle = null;
                try {
                    cacheHandle = DS.get_CacheHandle();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (cacheHandle == null || cacheHandle.equals(handle)) continue;
                this.cacheHits.removeElementAt(i--);
            }
        }
        if (this.isQueryByOId) {
            this.hasNonOidCond = true;
        } else {
            this.currentHandle = handle;
        }
        this.isQueryByOId = true;
        try {
            Condition cond = new Condition(15, (Object)handle, "=");
            this.queryItem.addCond(cond);
        }
        catch (Exception e) {
            DODS.getLogChannel().write(7, " ProcessQuery class\n : condition are not added");
        }
        this.builder.addWhere(ProcessDO.PrimaryKey, oid.toBigDecimal(), "=");
    }

    public void setQueryHandle(String handle) throws ObjectIdException {
        ObjectId oid = new ObjectId(handle);
        this.setQueryOId(oid);
    }

    public void requireUniqueInstance() {
        this.uniqueInstance = true;
    }

    public void setLoadData(boolean newValue) {
        this.loadData = newValue;
    }

    public boolean getLoadData() {
        if (this.loadData) {
            return true;
        }
        return ProcessDO.getConfigurationAdministration().getTableConfiguration().isLazyLoading() || this.isCaching();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (ProcessDO.cache.isFull() && ProcessDO.isFullCacheNeeded && ProcessDO.cache.getTableConfiguration().getFullCacheCountLimit() > 0 && ProcessDO.cache.getCacheAdministration(0).getCacheSize() > ProcessDO.cache.getTableConfiguration().getFullCacheCountLimit()) {
            ProcessDO.isFullCacheNeeded = false;
        }
        if (ProcessDO.cache.isFull() && ProcessDO.isFullCacheNeeded) {
            Map m = null;
            DataStructCache dataStructCache = ProcessDO.cache;
            synchronized (dataStructCache) {
                m = ProcessDO.cache.getCacheContent();
                this.cacheHits = m != null ? new Vector(m.values()) : new Vector();
            }
        }
        this.DOs = null;
        this.uniqueInstance = false;
        this.needToRun = true;
        this.isQueryByOId = false;
        this.hasNonOidCond = false;
        this.loadData = false;
        this.builder.reset();
        if (ProcessDO.cache.getLevelOfCaching() == 2) {
            this.queryItem = ((QueryCache)ProcessDO.cache).newQueryCacheItemInstance(this.logicalDatabase);
        }
    }

    private boolean exactFlag(boolean exact) {
        return exact;
    }

    public ResultSet executeQuery(DBConnection conn) throws SQLException {
        this.builder.setCurrentFetchSize(this.iCurrentFetchSize);
        this.builder.setCurrentQueryTimeout(this.iCurrentQueryTimeout);
        this.resultSet = this.builder.executeQuery(conn);
        return this.resultSet;
    }

    public Object next(ResultSet rs) throws SQLException, ObjectIdException {
        throw new ObjectIdException("next()\tshould not be used.\t Use getNextDO() instead.");
    }

    public String convertUserSearchValue(String userSearchValue) {
        return this.builder.convertUserSearchValue(userSearchValue);
    }

    public boolean containsWildcards(String dbSearchValue) {
        return this.builder.containsWildcards(dbSearchValue);
    }

    public int getCount() throws NonUniqueQueryException, DataObjectException, SQLException, DatabaseManagerException {
        int rowCount = 0;
        if (this.needToRun && this.databaseLimit == 0) {
            rowCount = this.selectCount();
        } else {
            if (this.needToRun) {
                this.runQuery();
            }
            rowCount = this.DOs.length;
        }
        return rowCount;
    }

    protected void setRefs(HashMap queryRefs) {
        this.refs = queryRefs;
    }

    public void set_CursorType(int resultSetType, int resultSetConcurrency) {
        this.builder.setCursorType(resultSetType, resultSetConcurrency);
    }

    public void set_FetchSize(int iCurrentFetchSizeIn) {
        this.iCurrentFetchSize = iCurrentFetchSizeIn;
    }

    public int get_FetchSize() {
        int n;
        if (this.iCurrentFetchSize < 0) {
            ProcessQuery processQuery = this;
            n = processQuery.builder.getDefaultFetchSize();
        } else {
            n = this.iCurrentFetchSize;
        }
        return n;
    }

    public int get_QueryTimeout() {
        return this.iCurrentQueryTimeout;
    }

    public void set_QueryTimeout(int iQueryTimeoutIn) {
        int n;
        if (this.iCurrentQueryTimeout < 0) {
            ProcessQuery processQuery = this;
            n = processQuery.builder.getDefaultQueryTimeout();
        } else {
            n = this.iCurrentQueryTimeout;
        }
        this.iCurrentQueryTimeout = n;
    }

    public int selectCount() throws SQLException, DatabaseManagerException {
        int rowCount = 0;
        String tempClause = this.builder.getSelectClause();
        this.builder.setSelectClause(" count(*) as \"counter\" ");
        DBQuery dbQuery = ProcessDO.createQuery(this.transaction);
        dbQuery.query((Query)this);
        this.resultSet.next();
        rowCount = this.resultSet.getInt("counter");
        dbQuery.release();
        this.builder.close();
        this.resultSet = null;
        this.builder.setSelectClause(tempClause);
        return rowCount;
    }

    private boolean isCaching() {
        double cachePercentage = ProcessDO.cache.getCachePercentage();
        double usedPercentage = 0.0;
        if (cachePercentage == -1.0) {
            return false;
        }
        if (cachePercentage == 0.0) {
            return true;
        }
        try {
            usedPercentage = ProcessDO.getConfigurationAdministration().getStatistics().getCacheStatistics(0).getUsedPercents();
        }
        catch (Exception ex) {
            return false;
        }
        return usedPercentage > ProcessDO.cache.getCachePercentage() * 100.0;
    }

    private static CachedDBTransaction _tr_(DBTransaction dbt) {
        return (CachedDBTransaction)dbt;
    }

    private String fixCaseSensitiveCondition(String cmp_op) {
        if (ProcessDO.getConfigurationAdministration().getTableConfiguration().isCaseSensitive()) {
            if (cmp_op.equals("%x%")) {
                return "%X%";
            }
            if (cmp_op.equals("x%")) {
                return "X%";
            }
            if (cmp_op.equals("%x")) {
                return "%X";
            }
            if (cmp_op.equals("%xxxx")) {
                return "=";
            }
            if (cmp_op.equals("x")) {
                return "X";
            }
            if (cmp_op.equals("u")) {
                return "U";
            }
        }
        return cmp_op;
    }

    public void setQueryId(String x, String cmp_op) throws DataObjectException, QueryException {
        String cachePrefix = this.getLogicalDatabase() + ".";
        this.hasNonOidCond = true;
        cmp_op = this.fixCaseSensitiveCondition(cmp_op);
        Condition cond = null;
        cond = new Condition(0, (Object)x, cmp_op);
        this.queryItem.addCond(cond);
        if (cmp_op.equals("x") || cmp_op.equals("X") || cmp_op.equals("U") || cmp_op.equals("u")) {
            this.hitDb = true;
        } else if (ProcessDO.cache.isFull() && ProcessDO.isFullCacheNeeded) {
            ProcessDO DO = null;
            ProcessDataStruct DS = null;
            for (int i = 0; i < this.cacheHits.size(); ++i) {
                try {
                    boolean findInTransactionCache = false;
                    DS = (ProcessDataStruct)this.cacheHits.elementAt(i);
                    if (this.transaction != null && ProcessQuery._tr_(this.transaction).getTransactionCache() != null && (DO = (ProcessDO)ProcessQuery._tr_(this.transaction).getTransactionCache().getDOByHandle(cachePrefix + DS.get_Handle())) != null) {
                        findInTransactionCache = true;
                    }
                    if (!findInTransactionCache) {
                        DO = ProcessDO.ceInternal(DS.get_OId(), this.transaction);
                    }
                }
                catch (Exception ex) {
                    System.out.println("Error in query member stuff");
                }
                String m = DO.getId();
                if (QueryBuilder.compare((Object)m, (Object)x, (String)cmp_op)) continue;
                try {
                    String cacheHandle = DO.get_CacheHandle();
                    this.cacheHits.removeElementAt(i--);
                    continue;
                }
                catch (DatabaseManagerException e) {
                    throw new DataObjectException("Error in loading data object's handle.");
                }
            }
        }
        this.builder.addWhere(ProcessDO.Id, x, cmp_op);
    }

    public void setQueryId(String x) throws DataObjectException, QueryException {
        this.setQueryId(x, "=");
    }

    public void addOrderById(boolean direction_flag) {
        this.hitDb = true;
        this.builder.addOrderByColumn("Id", direction_flag ? "ASC" : "DESC");
    }

    public void addOrderById() {
        this.hitDb = true;
        this.builder.addOrderByColumn("Id", "ASC");
    }

    public void setUserMatchId(String x) throws DataObjectException, QueryException {
        String y = this.convertUserSearchValue(x);
        this.setDBMatchId(y);
    }

    public void setDBMatchId(String x) throws DataObjectException, QueryException {
        if (this.containsWildcards(x) || this.builder.getUserStringAppendWildcard()) {
            this.builder.addMatchClause(ProcessDO.Id, x);
            this.hitDb = true;
        } else {
            this.setQueryId(x, "=");
        }
    }

    public void setQueryProcessDefinition(ProcessDefinitionDO x, String cmp_op) throws DataObjectException, QueryException {
        String cachePrefix = this.getLogicalDatabase() + ".";
        if (this.transaction != null && x != null && x.get_transaction() != null && !this.transaction.equals(x.get_transaction())) {
            throw new DataObjectException("Referenced DO doesn't belong the same transaction.");
        }
        if (this.refs == null) {
            this.refs = new HashMap();
        }
        if (x != null) {
            this.refs.put(cachePrefix + x.get_OId(), x);
        }
        this.hasNonOidCond = true;
        cmp_op = this.fixCaseSensitiveCondition(cmp_op);
        Condition cond = null;
        if (x != null && x instanceof CoreDO) {
            ProcessDefinitionDataStruct xDataStruct = x.get_DataStruct();
            cond = new Condition(1, (Object)xDataStruct, cmp_op);
        } else {
            cond = new Condition(1, (Object)x, cmp_op);
        }
        this.queryItem.addCond(cond);
        if (cmp_op.equals("x") || cmp_op.equals("X") || cmp_op.equals("U") || cmp_op.equals("u")) {
            this.hitDb = true;
        } else if (ProcessDO.cache.isFull() && ProcessDO.isFullCacheNeeded) {
            ProcessDO DO = null;
            ProcessDataStruct DS = null;
            for (int i = 0; i < this.cacheHits.size(); ++i) {
                try {
                    boolean findInTransactionCache = false;
                    DS = (ProcessDataStruct)this.cacheHits.elementAt(i);
                    if (this.transaction != null && ProcessQuery._tr_(this.transaction).getTransactionCache() != null && (DO = (ProcessDO)ProcessQuery._tr_(this.transaction).getTransactionCache().getDOByHandle(cachePrefix + DS.get_Handle())) != null) {
                        findInTransactionCache = true;
                    }
                    if (!findInTransactionCache) {
                        DO = ProcessDO.ceInternal(DS.get_OId(), this.transaction);
                    }
                }
                catch (Exception ex) {
                    System.out.println("Error in query member stuff");
                }
                ProcessDefinitionDO m = DO.getProcessDefinition();
                if (QueryBuilder.compare((Object)m, (Object)x, (String)cmp_op)) continue;
                try {
                    String cacheHandle = DO.get_CacheHandle();
                    this.cacheHits.removeElementAt(i--);
                    continue;
                }
                catch (DatabaseManagerException e) {
                    throw new DataObjectException("Error in loading data object's handle.");
                }
            }
        }
        this.builder.addWhere(ProcessDO.ProcessDefinition, (GenericDO)x, cmp_op);
    }

    public void setQueryProcessDefinition(ProcessDefinitionDO x) throws DataObjectException, QueryException {
        this.setQueryProcessDefinition(x, "=");
    }

    public void addOrderByProcessDefinition(boolean direction_flag) {
        this.hitDb = true;
        this.builder.addOrderByColumn("ProcessDefinition", direction_flag ? "ASC" : "DESC");
    }

    public void addOrderByProcessDefinition() {
        this.hitDb = true;
        this.builder.addOrderByColumn("ProcessDefinition", "ASC");
    }

    public void setQueryPDefName(String x, String cmp_op) throws DataObjectException, QueryException {
        String cachePrefix = this.getLogicalDatabase() + ".";
        this.hasNonOidCond = true;
        cmp_op = this.fixCaseSensitiveCondition(cmp_op);
        Condition cond = null;
        cond = new Condition(2, (Object)x, cmp_op);
        this.queryItem.addCond(cond);
        if (cmp_op.equals("x") || cmp_op.equals("X") || cmp_op.equals("U") || cmp_op.equals("u")) {
            this.hitDb = true;
        } else if (ProcessDO.cache.isFull() && ProcessDO.isFullCacheNeeded) {
            ProcessDO DO = null;
            ProcessDataStruct DS = null;
            for (int i = 0; i < this.cacheHits.size(); ++i) {
                try {
                    boolean findInTransactionCache = false;
                    DS = (ProcessDataStruct)this.cacheHits.elementAt(i);
                    if (this.transaction != null && ProcessQuery._tr_(this.transaction).getTransactionCache() != null && (DO = (ProcessDO)ProcessQuery._tr_(this.transaction).getTransactionCache().getDOByHandle(cachePrefix + DS.get_Handle())) != null) {
                        findInTransactionCache = true;
                    }
                    if (!findInTransactionCache) {
                        DO = ProcessDO.ceInternal(DS.get_OId(), this.transaction);
                    }
                }
                catch (Exception ex) {
                    System.out.println("Error in query member stuff");
                }
                String m = DO.getPDefName();
                if (QueryBuilder.compare((Object)m, (Object)x, (String)cmp_op)) continue;
                try {
                    String cacheHandle = DO.get_CacheHandle();
                    this.cacheHits.removeElementAt(i--);
                    continue;
                }
                catch (DatabaseManagerException e) {
                    throw new DataObjectException("Error in loading data object's handle.");
                }
            }
        }
        this.builder.addWhere(ProcessDO.PDefName, x, cmp_op);
    }

    public void setQueryPDefName(String x) throws DataObjectException, QueryException {
        this.setQueryPDefName(x, "=");
    }

    public void addOrderByPDefName(boolean direction_flag) {
        this.hitDb = true;
        this.builder.addOrderByColumn("PDefName", direction_flag ? "ASC" : "DESC");
    }

    public void addOrderByPDefName() {
        this.hitDb = true;
        this.builder.addOrderByColumn("PDefName", "ASC");
    }

    public void setUserMatchPDefName(String x) throws DataObjectException, QueryException {
        String y = this.convertUserSearchValue(x);
        this.setDBMatchPDefName(y);
    }

    public void setDBMatchPDefName(String x) throws DataObjectException, QueryException {
        if (this.containsWildcards(x) || this.builder.getUserStringAppendWildcard()) {
            this.builder.addMatchClause(ProcessDO.PDefName, x);
            this.hitDb = true;
        } else {
            this.setQueryPDefName(x, "=");
        }
    }

    public void setQueryActivityRequesterId(String x, String cmp_op) throws DataObjectException, QueryException {
        String cachePrefix = this.getLogicalDatabase() + ".";
        this.hasNonOidCond = true;
        cmp_op = this.fixCaseSensitiveCondition(cmp_op);
        Condition cond = null;
        cond = new Condition(3, (Object)x, cmp_op);
        this.queryItem.addCond(cond);
        if (cmp_op.equals("x") || cmp_op.equals("X") || cmp_op.equals("U") || cmp_op.equals("u")) {
            this.hitDb = true;
        } else if (ProcessDO.cache.isFull() && ProcessDO.isFullCacheNeeded) {
            ProcessDO DO = null;
            ProcessDataStruct DS = null;
            for (int i = 0; i < this.cacheHits.size(); ++i) {
                try {
                    boolean findInTransactionCache = false;
                    DS = (ProcessDataStruct)this.cacheHits.elementAt(i);
                    if (this.transaction != null && ProcessQuery._tr_(this.transaction).getTransactionCache() != null && (DO = (ProcessDO)ProcessQuery._tr_(this.transaction).getTransactionCache().getDOByHandle(cachePrefix + DS.get_Handle())) != null) {
                        findInTransactionCache = true;
                    }
                    if (!findInTransactionCache) {
                        DO = ProcessDO.ceInternal(DS.get_OId(), this.transaction);
                    }
                }
                catch (Exception ex) {
                    System.out.println("Error in query member stuff");
                }
                String m = DO.getActivityRequesterId();
                if (QueryBuilder.compare((Object)m, (Object)x, (String)cmp_op)) continue;
                try {
                    String cacheHandle = DO.get_CacheHandle();
                    this.cacheHits.removeElementAt(i--);
                    continue;
                }
                catch (DatabaseManagerException e) {
                    throw new DataObjectException("Error in loading data object's handle.");
                }
            }
        }
        this.builder.addWhere(ProcessDO.ActivityRequesterId, x, cmp_op);
    }

    public void setQueryActivityRequesterId(String x) throws DataObjectException, QueryException {
        this.setQueryActivityRequesterId(x, "=");
    }

    public void addOrderByActivityRequesterId(boolean direction_flag) {
        this.hitDb = true;
        this.builder.addOrderByColumn("ActivityRequesterId", direction_flag ? "ASC" : "DESC");
    }

    public void addOrderByActivityRequesterId() {
        this.hitDb = true;
        this.builder.addOrderByColumn("ActivityRequesterId", "ASC");
    }

    public void setUserMatchActivityRequesterId(String x) throws DataObjectException, QueryException {
        String y = this.convertUserSearchValue(x);
        this.setDBMatchActivityRequesterId(y);
    }

    public void setDBMatchActivityRequesterId(String x) throws DataObjectException, QueryException {
        if (this.containsWildcards(x) || this.builder.getUserStringAppendWildcard()) {
            this.builder.addMatchClause(ProcessDO.ActivityRequesterId, x);
            this.hitDb = true;
        } else {
            this.setQueryActivityRequesterId(x, "=");
        }
    }

    public void setQueryActivityRequesterProcessId(String x, String cmp_op) throws DataObjectException, QueryException {
        String cachePrefix = this.getLogicalDatabase() + ".";
        this.hasNonOidCond = true;
        cmp_op = this.fixCaseSensitiveCondition(cmp_op);
        Condition cond = null;
        cond = new Condition(4, (Object)x, cmp_op);
        this.queryItem.addCond(cond);
        if (cmp_op.equals("x") || cmp_op.equals("X") || cmp_op.equals("U") || cmp_op.equals("u")) {
            this.hitDb = true;
        } else if (ProcessDO.cache.isFull() && ProcessDO.isFullCacheNeeded) {
            ProcessDO DO = null;
            ProcessDataStruct DS = null;
            for (int i = 0; i < this.cacheHits.size(); ++i) {
                try {
                    boolean findInTransactionCache = false;
                    DS = (ProcessDataStruct)this.cacheHits.elementAt(i);
                    if (this.transaction != null && ProcessQuery._tr_(this.transaction).getTransactionCache() != null && (DO = (ProcessDO)ProcessQuery._tr_(this.transaction).getTransactionCache().getDOByHandle(cachePrefix + DS.get_Handle())) != null) {
                        findInTransactionCache = true;
                    }
                    if (!findInTransactionCache) {
                        DO = ProcessDO.ceInternal(DS.get_OId(), this.transaction);
                    }
                }
                catch (Exception ex) {
                    System.out.println("Error in query member stuff");
                }
                String m = DO.getActivityRequesterProcessId();
                if (QueryBuilder.compare((Object)m, (Object)x, (String)cmp_op)) continue;
                try {
                    String cacheHandle = DO.get_CacheHandle();
                    this.cacheHits.removeElementAt(i--);
                    continue;
                }
                catch (DatabaseManagerException e) {
                    throw new DataObjectException("Error in loading data object's handle.");
                }
            }
        }
        this.builder.addWhere(ProcessDO.ActivityRequesterProcessId, x, cmp_op);
    }

    public void setQueryActivityRequesterProcessId(String x) throws DataObjectException, QueryException {
        this.setQueryActivityRequesterProcessId(x, "=");
    }

    public void addOrderByActivityRequesterProcessId(boolean direction_flag) {
        this.hitDb = true;
        this.builder.addOrderByColumn("ActivityRequesterProcessId", direction_flag ? "ASC" : "DESC");
    }

    public void addOrderByActivityRequesterProcessId() {
        this.hitDb = true;
        this.builder.addOrderByColumn("ActivityRequesterProcessId", "ASC");
    }

    public void setUserMatchActivityRequesterProcessId(String x) throws DataObjectException, QueryException {
        String y = this.convertUserSearchValue(x);
        this.setDBMatchActivityRequesterProcessId(y);
    }

    public void setDBMatchActivityRequesterProcessId(String x) throws DataObjectException, QueryException {
        if (this.containsWildcards(x) || this.builder.getUserStringAppendWildcard()) {
            this.builder.addMatchClause(ProcessDO.ActivityRequesterProcessId, x);
            this.hitDb = true;
        } else {
            this.setQueryActivityRequesterProcessId(x, "=");
        }
    }

    public void setQueryResourceRequesterId(String x, String cmp_op) throws DataObjectException, QueryException {
        String cachePrefix = this.getLogicalDatabase() + ".";
        this.hasNonOidCond = true;
        cmp_op = this.fixCaseSensitiveCondition(cmp_op);
        Condition cond = null;
        cond = new Condition(5, (Object)x, cmp_op);
        this.queryItem.addCond(cond);
        if (cmp_op.equals("x") || cmp_op.equals("X") || cmp_op.equals("U") || cmp_op.equals("u")) {
            this.hitDb = true;
        } else if (ProcessDO.cache.isFull() && ProcessDO.isFullCacheNeeded) {
            ProcessDO DO = null;
            ProcessDataStruct DS = null;
            for (int i = 0; i < this.cacheHits.size(); ++i) {
                try {
                    boolean findInTransactionCache = false;
                    DS = (ProcessDataStruct)this.cacheHits.elementAt(i);
                    if (this.transaction != null && ProcessQuery._tr_(this.transaction).getTransactionCache() != null && (DO = (ProcessDO)ProcessQuery._tr_(this.transaction).getTransactionCache().getDOByHandle(cachePrefix + DS.get_Handle())) != null) {
                        findInTransactionCache = true;
                    }
                    if (!findInTransactionCache) {
                        DO = ProcessDO.ceInternal(DS.get_OId(), this.transaction);
                    }
                }
                catch (Exception ex) {
                    System.out.println("Error in query member stuff");
                }
                String m = DO.getResourceRequesterId();
                if (QueryBuilder.compare((Object)m, (Object)x, (String)cmp_op)) continue;
                try {
                    String cacheHandle = DO.get_CacheHandle();
                    this.cacheHits.removeElementAt(i--);
                    continue;
                }
                catch (DatabaseManagerException e) {
                    throw new DataObjectException("Error in loading data object's handle.");
                }
            }
        }
        this.builder.addWhere(ProcessDO.ResourceRequesterId, x, cmp_op);
    }

    public void setQueryResourceRequesterId(String x) throws DataObjectException, QueryException {
        this.setQueryResourceRequesterId(x, "=");
    }

    public void addOrderByResourceRequesterId(boolean direction_flag) {
        this.hitDb = true;
        this.builder.addOrderByColumn("ResourceRequesterId", direction_flag ? "ASC" : "DESC");
    }

    public void addOrderByResourceRequesterId() {
        this.hitDb = true;
        this.builder.addOrderByColumn("ResourceRequesterId", "ASC");
    }

    public void setUserMatchResourceRequesterId(String x) throws DataObjectException, QueryException {
        String y = this.convertUserSearchValue(x);
        this.setDBMatchResourceRequesterId(y);
    }

    public void setDBMatchResourceRequesterId(String x) throws DataObjectException, QueryException {
        if (this.containsWildcards(x) || this.builder.getUserStringAppendWildcard()) {
            this.builder.addMatchClause(ProcessDO.ResourceRequesterId, x);
            this.hitDb = true;
        } else {
            this.setQueryResourceRequesterId(x, "=");
        }
    }

    public void setQueryState(ProcessStateDO x, String cmp_op) throws DataObjectException, QueryException {
        String cachePrefix = this.getLogicalDatabase() + ".";
        if (this.transaction != null && x != null && x.get_transaction() != null && !this.transaction.equals(x.get_transaction())) {
            throw new DataObjectException("Referenced DO doesn't belong the same transaction.");
        }
        if (this.refs == null) {
            this.refs = new HashMap();
        }
        if (x != null) {
            this.refs.put(cachePrefix + x.get_OId(), x);
        }
        this.hasNonOidCond = true;
        cmp_op = this.fixCaseSensitiveCondition(cmp_op);
        Condition cond = null;
        if (x != null && x instanceof CoreDO) {
            ProcessStateDataStruct xDataStruct = x.get_DataStruct();
            cond = new Condition(7, (Object)xDataStruct, cmp_op);
        } else {
            cond = new Condition(7, (Object)x, cmp_op);
        }
        this.queryItem.addCond(cond);
        if (cmp_op.equals("x") || cmp_op.equals("X") || cmp_op.equals("U") || cmp_op.equals("u")) {
            this.hitDb = true;
        } else if (ProcessDO.cache.isFull() && ProcessDO.isFullCacheNeeded) {
            ProcessDO DO = null;
            ProcessDataStruct DS = null;
            for (int i = 0; i < this.cacheHits.size(); ++i) {
                try {
                    boolean findInTransactionCache = false;
                    DS = (ProcessDataStruct)this.cacheHits.elementAt(i);
                    if (this.transaction != null && ProcessQuery._tr_(this.transaction).getTransactionCache() != null && (DO = (ProcessDO)ProcessQuery._tr_(this.transaction).getTransactionCache().getDOByHandle(cachePrefix + DS.get_Handle())) != null) {
                        findInTransactionCache = true;
                    }
                    if (!findInTransactionCache) {
                        DO = ProcessDO.ceInternal(DS.get_OId(), this.transaction);
                    }
                }
                catch (Exception ex) {
                    System.out.println("Error in query member stuff");
                }
                ProcessStateDO m = DO.getState();
                if (QueryBuilder.compare((Object)m, (Object)x, (String)cmp_op)) continue;
                try {
                    String cacheHandle = DO.get_CacheHandle();
                    this.cacheHits.removeElementAt(i--);
                    continue;
                }
                catch (DatabaseManagerException e) {
                    throw new DataObjectException("Error in loading data object's handle.");
                }
            }
        }
        this.builder.addWhere(ProcessDO.State, (GenericDO)x, cmp_op);
    }

    public void setQueryState(ProcessStateDO x) throws DataObjectException, QueryException {
        this.setQueryState(x, "=");
    }

    public void addOrderByState(boolean direction_flag) {
        this.hitDb = true;
        this.builder.addOrderByColumn("State", direction_flag ? "ASC" : "DESC");
    }

    public void addOrderByState() {
        this.hitDb = true;
        this.builder.addOrderByColumn("State", "ASC");
    }

    public void setQueryPriority(short x, String cmp_op) throws DataObjectException, QueryException {
        String cachePrefix = this.getLogicalDatabase() + ".";
        this.hasNonOidCond = true;
        cmp_op = this.fixCaseSensitiveCondition(cmp_op);
        Condition cond = null;
        cond = new Condition(8, (double)x, cmp_op);
        this.queryItem.addCond(cond);
        if (cmp_op.equals("x") || cmp_op.equals("X") || cmp_op.equals("U") || cmp_op.equals("u")) {
            this.hitDb = true;
        } else if (ProcessDO.cache.isFull() && ProcessDO.isFullCacheNeeded) {
            ProcessDO DO = null;
            ProcessDataStruct DS = null;
            for (int i = 0; i < this.cacheHits.size(); ++i) {
                try {
                    boolean findInTransactionCache = false;
                    DS = (ProcessDataStruct)this.cacheHits.elementAt(i);
                    if (this.transaction != null && ProcessQuery._tr_(this.transaction).getTransactionCache() != null && (DO = (ProcessDO)ProcessQuery._tr_(this.transaction).getTransactionCache().getDOByHandle(cachePrefix + DS.get_Handle())) != null) {
                        findInTransactionCache = true;
                    }
                    if (!findInTransactionCache) {
                        DO = ProcessDO.ceInternal(DS.get_OId(), this.transaction);
                    }
                }
                catch (Exception ex) {
                    System.out.println("Error in query member stuff");
                }
                short m = DO.getPriority();
                if (QueryBuilder.compare((double)m, (double)x, (String)cmp_op)) continue;
                try {
                    String cacheHandle = DO.get_CacheHandle();
                    this.cacheHits.removeElementAt(i--);
                    continue;
                }
                catch (DatabaseManagerException e) {
                    throw new DataObjectException("Error in loading data object's handle.");
                }
            }
        }
        this.builder.addWhere(ProcessDO.Priority, (int)x, cmp_op);
    }

    public void setQueryPriority(short x) throws DataObjectException, QueryException {
        this.setQueryPriority(x, "=");
    }

    public void addOrderByPriority(boolean direction_flag) {
        this.hitDb = true;
        this.builder.addOrderByColumn("Priority", direction_flag ? "ASC" : "DESC");
    }

    public void addOrderByPriority() {
        this.hitDb = true;
        this.builder.addOrderByColumn("Priority", "ASC");
    }

    public void setQueryName(String x, String cmp_op) throws DataObjectException, QueryException {
        String cachePrefix = this.getLogicalDatabase() + ".";
        this.hasNonOidCond = true;
        cmp_op = this.fixCaseSensitiveCondition(cmp_op);
        Condition cond = null;
        cond = new Condition(9, (Object)x, cmp_op);
        this.queryItem.addCond(cond);
        if (cmp_op.equals("x") || cmp_op.equals("X") || cmp_op.equals("U") || cmp_op.equals("u")) {
            this.hitDb = true;
        } else if (ProcessDO.cache.isFull() && ProcessDO.isFullCacheNeeded) {
            ProcessDO DO = null;
            ProcessDataStruct DS = null;
            for (int i = 0; i < this.cacheHits.size(); ++i) {
                try {
                    boolean findInTransactionCache = false;
                    DS = (ProcessDataStruct)this.cacheHits.elementAt(i);
                    if (this.transaction != null && ProcessQuery._tr_(this.transaction).getTransactionCache() != null && (DO = (ProcessDO)ProcessQuery._tr_(this.transaction).getTransactionCache().getDOByHandle(cachePrefix + DS.get_Handle())) != null) {
                        findInTransactionCache = true;
                    }
                    if (!findInTransactionCache) {
                        DO = ProcessDO.ceInternal(DS.get_OId(), this.transaction);
                    }
                }
                catch (Exception ex) {
                    System.out.println("Error in query member stuff");
                }
                String m = DO.getName();
                if (QueryBuilder.compare((Object)m, (Object)x, (String)cmp_op)) continue;
                try {
                    String cacheHandle = DO.get_CacheHandle();
                    this.cacheHits.removeElementAt(i--);
                    continue;
                }
                catch (DatabaseManagerException e) {
                    throw new DataObjectException("Error in loading data object's handle.");
                }
            }
        }
        this.builder.addWhere(ProcessDO.Name, x, cmp_op);
    }

    public void setQueryName(String x) throws DataObjectException, QueryException {
        this.setQueryName(x, "=");
    }

    public void addOrderByName(boolean direction_flag) {
        this.hitDb = true;
        this.builder.addOrderByColumn("Name", direction_flag ? "ASC" : "DESC");
    }

    public void addOrderByName() {
        this.hitDb = true;
        this.builder.addOrderByColumn("Name", "ASC");
    }

    public void setUserMatchName(String x) throws DataObjectException, QueryException {
        String y = this.convertUserSearchValue(x);
        this.setDBMatchName(y);
    }

    public void setDBMatchName(String x) throws DataObjectException, QueryException {
        if (this.containsWildcards(x) || this.builder.getUserStringAppendWildcard()) {
            this.builder.addMatchClause(ProcessDO.Name, x);
            this.hitDb = true;
        } else {
            this.setQueryName(x, "=");
        }
    }

    public void setQueryCreated(long x, String cmp_op) throws DataObjectException, QueryException {
        String cachePrefix = this.getLogicalDatabase() + ".";
        this.hasNonOidCond = true;
        cmp_op = this.fixCaseSensitiveCondition(cmp_op);
        Condition cond = null;
        cond = new Condition(10, (double)x, cmp_op);
        this.queryItem.addCond(cond);
        if (cmp_op.equals("x") || cmp_op.equals("X") || cmp_op.equals("U") || cmp_op.equals("u")) {
            this.hitDb = true;
        } else if (ProcessDO.cache.isFull() && ProcessDO.isFullCacheNeeded) {
            ProcessDO DO = null;
            ProcessDataStruct DS = null;
            for (int i = 0; i < this.cacheHits.size(); ++i) {
                try {
                    boolean findInTransactionCache = false;
                    DS = (ProcessDataStruct)this.cacheHits.elementAt(i);
                    if (this.transaction != null && ProcessQuery._tr_(this.transaction).getTransactionCache() != null && (DO = (ProcessDO)ProcessQuery._tr_(this.transaction).getTransactionCache().getDOByHandle(cachePrefix + DS.get_Handle())) != null) {
                        findInTransactionCache = true;
                    }
                    if (!findInTransactionCache) {
                        DO = ProcessDO.ceInternal(DS.get_OId(), this.transaction);
                    }
                }
                catch (Exception ex) {
                    System.out.println("Error in query member stuff");
                }
                long m = DO.getCreated();
                if (QueryBuilder.compare((double)m, (double)x, (String)cmp_op)) continue;
                try {
                    String cacheHandle = DO.get_CacheHandle();
                    this.cacheHits.removeElementAt(i--);
                    continue;
                }
                catch (DatabaseManagerException e) {
                    throw new DataObjectException("Error in loading data object's handle.");
                }
            }
        }
        this.builder.addWhere(ProcessDO.Created, x, cmp_op);
    }

    public void setQueryCreated(long x) throws DataObjectException, QueryException {
        this.setQueryCreated(x, "=");
    }

    public void addOrderByCreated(boolean direction_flag) {
        this.hitDb = true;
        this.builder.addOrderByColumn("Created", direction_flag ? "ASC" : "DESC");
    }

    public void addOrderByCreated() {
        this.hitDb = true;
        this.builder.addOrderByColumn("Created", "ASC");
    }

    public void setQueryStarted(long x, String cmp_op) throws DataObjectException, QueryException {
        String cachePrefix = this.getLogicalDatabase() + ".";
        this.hasNonOidCond = true;
        cmp_op = this.fixCaseSensitiveCondition(cmp_op);
        Condition cond = null;
        cond = new Condition(11, (double)x, cmp_op);
        this.queryItem.addCond(cond);
        if (cmp_op.equals("x") || cmp_op.equals("X") || cmp_op.equals("U") || cmp_op.equals("u")) {
            this.hitDb = true;
        } else if (ProcessDO.cache.isFull() && ProcessDO.isFullCacheNeeded) {
            ProcessDO DO = null;
            ProcessDataStruct DS = null;
            for (int i = 0; i < this.cacheHits.size(); ++i) {
                try {
                    boolean findInTransactionCache = false;
                    DS = (ProcessDataStruct)this.cacheHits.elementAt(i);
                    if (this.transaction != null && ProcessQuery._tr_(this.transaction).getTransactionCache() != null && (DO = (ProcessDO)ProcessQuery._tr_(this.transaction).getTransactionCache().getDOByHandle(cachePrefix + DS.get_Handle())) != null) {
                        findInTransactionCache = true;
                    }
                    if (!findInTransactionCache) {
                        DO = ProcessDO.ceInternal(DS.get_OId(), this.transaction);
                    }
                }
                catch (Exception ex) {
                    System.out.println("Error in query member stuff");
                }
                long m = DO.getStarted();
                if (QueryBuilder.compare((double)m, (double)x, (String)cmp_op)) continue;
                try {
                    String cacheHandle = DO.get_CacheHandle();
                    this.cacheHits.removeElementAt(i--);
                    continue;
                }
                catch (DatabaseManagerException e) {
                    throw new DataObjectException("Error in loading data object's handle.");
                }
            }
        }
        this.builder.addWhere(ProcessDO.Started, x, cmp_op);
    }

    public void setQueryStarted(long x) throws DataObjectException, QueryException {
        this.setQueryStarted(x, "=");
    }

    public void addOrderByStarted(boolean direction_flag) {
        this.hitDb = true;
        this.builder.addOrderByColumn("Started", direction_flag ? "ASC" : "DESC");
    }

    public void addOrderByStarted() {
        this.hitDb = true;
        this.builder.addOrderByColumn("Started", "ASC");
    }

    public void setQueryLastStateTime(long x, String cmp_op) throws DataObjectException, QueryException {
        String cachePrefix = this.getLogicalDatabase() + ".";
        this.hasNonOidCond = true;
        cmp_op = this.fixCaseSensitiveCondition(cmp_op);
        Condition cond = null;
        cond = new Condition(12, (double)x, cmp_op);
        this.queryItem.addCond(cond);
        if (cmp_op.equals("x") || cmp_op.equals("X") || cmp_op.equals("U") || cmp_op.equals("u")) {
            this.hitDb = true;
        } else if (ProcessDO.cache.isFull() && ProcessDO.isFullCacheNeeded) {
            ProcessDO DO = null;
            ProcessDataStruct DS = null;
            for (int i = 0; i < this.cacheHits.size(); ++i) {
                try {
                    boolean findInTransactionCache = false;
                    DS = (ProcessDataStruct)this.cacheHits.elementAt(i);
                    if (this.transaction != null && ProcessQuery._tr_(this.transaction).getTransactionCache() != null && (DO = (ProcessDO)ProcessQuery._tr_(this.transaction).getTransactionCache().getDOByHandle(cachePrefix + DS.get_Handle())) != null) {
                        findInTransactionCache = true;
                    }
                    if (!findInTransactionCache) {
                        DO = ProcessDO.ceInternal(DS.get_OId(), this.transaction);
                    }
                }
                catch (Exception ex) {
                    System.out.println("Error in query member stuff");
                }
                long m = DO.getLastStateTime();
                if (QueryBuilder.compare((double)m, (double)x, (String)cmp_op)) continue;
                try {
                    String cacheHandle = DO.get_CacheHandle();
                    this.cacheHits.removeElementAt(i--);
                    continue;
                }
                catch (DatabaseManagerException e) {
                    throw new DataObjectException("Error in loading data object's handle.");
                }
            }
        }
        this.builder.addWhere(ProcessDO.LastStateTime, x, cmp_op);
    }

    public void setQueryLastStateTime(long x) throws DataObjectException, QueryException {
        this.setQueryLastStateTime(x, "=");
    }

    public void addOrderByLastStateTime(boolean direction_flag) {
        this.hitDb = true;
        this.builder.addOrderByColumn("LastStateTime", direction_flag ? "ASC" : "DESC");
    }

    public void addOrderByLastStateTime() {
        this.hitDb = true;
        this.builder.addOrderByColumn("LastStateTime", "ASC");
    }

    public void setQueryLimitTime(long x, String cmp_op) throws DataObjectException, QueryException {
        String cachePrefix = this.getLogicalDatabase() + ".";
        this.hasNonOidCond = true;
        cmp_op = this.fixCaseSensitiveCondition(cmp_op);
        Condition cond = null;
        cond = new Condition(13, (double)x, cmp_op);
        this.queryItem.addCond(cond);
        if (cmp_op.equals("x") || cmp_op.equals("X") || cmp_op.equals("U") || cmp_op.equals("u")) {
            this.hitDb = true;
        } else if (ProcessDO.cache.isFull() && ProcessDO.isFullCacheNeeded) {
            ProcessDO DO = null;
            ProcessDataStruct DS = null;
            for (int i = 0; i < this.cacheHits.size(); ++i) {
                try {
                    boolean findInTransactionCache = false;
                    DS = (ProcessDataStruct)this.cacheHits.elementAt(i);
                    if (this.transaction != null && ProcessQuery._tr_(this.transaction).getTransactionCache() != null && (DO = (ProcessDO)ProcessQuery._tr_(this.transaction).getTransactionCache().getDOByHandle(cachePrefix + DS.get_Handle())) != null) {
                        findInTransactionCache = true;
                    }
                    if (!findInTransactionCache) {
                        DO = ProcessDO.ceInternal(DS.get_OId(), this.transaction);
                    }
                }
                catch (Exception ex) {
                    System.out.println("Error in query member stuff");
                }
                long m = DO.getLimitTime();
                if (QueryBuilder.compare((double)m, (double)x, (String)cmp_op)) continue;
                try {
                    String cacheHandle = DO.get_CacheHandle();
                    this.cacheHits.removeElementAt(i--);
                    continue;
                }
                catch (DatabaseManagerException e) {
                    throw new DataObjectException("Error in loading data object's handle.");
                }
            }
        }
        this.builder.addWhere(ProcessDO.LimitTime, x, cmp_op);
    }

    public void setQueryLimitTime(long x) throws DataObjectException, QueryException {
        this.setQueryLimitTime(x, "=");
    }

    public void addOrderByLimitTime(boolean direction_flag) {
        this.hitDb = true;
        this.builder.addOrderByColumn("LimitTime", direction_flag ? "ASC" : "DESC");
    }

    public void addOrderByLimitTime() {
        this.hitDb = true;
        this.builder.addOrderByColumn("LimitTime", "ASC");
    }

    public void setQueryDescription(String x, String cmp_op) throws DataObjectException, QueryException {
        String cachePrefix = this.getLogicalDatabase() + ".";
        this.hasNonOidCond = true;
        cmp_op = this.fixCaseSensitiveCondition(cmp_op);
        Condition cond = null;
        cond = new Condition(14, (Object)x, cmp_op);
        this.queryItem.addCond(cond);
        if (cmp_op.equals("x") || cmp_op.equals("X") || cmp_op.equals("U") || cmp_op.equals("u")) {
            this.hitDb = true;
        } else if (ProcessDO.cache.isFull() && ProcessDO.isFullCacheNeeded) {
            ProcessDO DO = null;
            ProcessDataStruct DS = null;
            for (int i = 0; i < this.cacheHits.size(); ++i) {
                try {
                    boolean findInTransactionCache = false;
                    DS = (ProcessDataStruct)this.cacheHits.elementAt(i);
                    if (this.transaction != null && ProcessQuery._tr_(this.transaction).getTransactionCache() != null && (DO = (ProcessDO)ProcessQuery._tr_(this.transaction).getTransactionCache().getDOByHandle(cachePrefix + DS.get_Handle())) != null) {
                        findInTransactionCache = true;
                    }
                    if (!findInTransactionCache) {
                        DO = ProcessDO.ceInternal(DS.get_OId(), this.transaction);
                    }
                }
                catch (Exception ex) {
                    System.out.println("Error in query member stuff");
                }
                String m = DO.getDescription();
                if (QueryBuilder.compare((Object)m, (Object)x, (String)cmp_op)) continue;
                try {
                    String cacheHandle = DO.get_CacheHandle();
                    this.cacheHits.removeElementAt(i--);
                    continue;
                }
                catch (DatabaseManagerException e) {
                    throw new DataObjectException("Error in loading data object's handle.");
                }
            }
        }
        this.builder.addWhere(ProcessDO.Description, x, cmp_op);
    }

    public void setQueryDescription(String x) throws DataObjectException, QueryException {
        this.setQueryDescription(x, "=");
    }

    public void addOrderByDescription(boolean direction_flag) {
        this.hitDb = true;
        this.builder.addOrderByColumn("Description", direction_flag ? "ASC" : "DESC");
    }

    public void addOrderByDescription() {
        this.hitDb = true;
        this.builder.addOrderByColumn("Description", "ASC");
    }

    public void setUserMatchDescription(String x) throws DataObjectException, QueryException {
        String y = this.convertUserSearchValue(x);
        this.setDBMatchDescription(y);
    }

    public void setDBMatchDescription(String x) throws DataObjectException, QueryException {
        if (this.containsWildcards(x) || this.builder.getUserStringAppendWildcard()) {
            this.builder.addMatchClause(ProcessDO.Description, x);
            this.hitDb = true;
        } else {
            this.setQueryDescription(x, "=");
        }
    }

    public QueryBuilder getQueryBuilder() {
        this.hitDb = true;
        return this.builder;
    }

    public void or() {
        this.hitDb = true;
        this.builder.addWhereOr();
    }

    public void openParen() {
        this.hitDb = true;
        this.builder.addWhereOpenParen();
    }

    public void closeParen() {
        this.hitDb = true;
        this.builder.addWhereCloseParen();
    }
}

