/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.eventaudit;

import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.internal.eventaudit.AssignmentEventAuditPersistenceInterface;
import org.enhydra.shark.api.internal.eventaudit.CreateProcessEventAuditPersistenceInterface;
import org.enhydra.shark.api.internal.eventaudit.DataEventAuditPersistenceInterface;
import org.enhydra.shark.api.internal.eventaudit.EventAuditException;
import org.enhydra.shark.api.internal.eventaudit.EventAuditManagerInterface;
import org.enhydra.shark.api.internal.eventaudit.StateEventAuditPersistenceInterface;
import org.enhydra.shark.api.internal.working.CallbackUtilities;
import org.enhydra.shark.utilities.MiscUtilities;

public class SMTPEventAuditManager
implements EventAuditManagerInterface {
    private boolean DEBUG;
    private boolean enable_email;
    private CallbackUtilities cus;
    private EventAuditManagerInterface other;
    private static final String _PARAM_PREFIX = "SMTPEventAuditManager";
    private static final String _PARAM_OTHER_MGR = ".OtherClassName";
    private static final String _PARAM_OTHER_MGR_DEFAULT = "org.enhydra.shark.eventaudit.DODSEventAuditManager";
    private static final String _PARAM_DEBUG = ".Debug";
    private static final String _PARAM_ENABLE = ".Enable";
    private static final String _PARAM_SERVER_ADDR = ".Server";
    private static final String _PARAM_SERVER_PORT = ".Port";
    private static final String _PARAM_AUTH = ".Auth";
    protected static final String _PARAM_PASSWD = ".Passwd";
    private static final String _PARAM_SOURCE = ".Source";
    private static final String _PARAM_MESSAGE_TEMPLATE = ".Message";
    private static final String _PARAM_SUBJECT_TEMPLATE = ".Subject";
    private String _subject;
    private String _message;

    public void configure(CallbackUtilities cus) throws RootException {
        try {
            this.other = (EventAuditManagerInterface)Class.forName(cus.getProperty("SMTPEventAuditManager.OtherClassName", _PARAM_OTHER_MGR_DEFAULT)).newInstance();
            this.other.configure(cus);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.DEBUG = Boolean.valueOf(cus.getProperty("SMTPEventAuditManager.Debug", "false"));
        this.enable_email = Boolean.valueOf(cus.getProperty("SMTPEventAuditManager.Enable", "false"));
        this._subject = cus.getProperty("SMTPEventAuditManager.Subject", "New task: {activity}");
        this._message = cus.getProperty("SMTPEventAuditManager.Message", "Dear {person},\n\nyou have a new task!\n\nname: {activity}\nworkflow: {process}\nworkflow id: {definition}");
        this.cus = cus;
        if (this.DEBUG) {
            System.err.println("SMTPEventAuditManager configured");
        }
    }

    private void sendEmail(String text_msg, String subject, String destination_address) throws RootException {
        try {
            Session session;
            Properties props = new Properties();
            props.put("mail.smtp.host", this.cus.getProperty("SMTPEventAuditManager.Server"));
            props.put("mail.smtp.port", this.cus.getProperty("SMTPEventAuditManager.Port"));
            final String auth = this.cus.getProperty("SMTPEventAuditManager.Auth");
            if (auth.equals("")) {
                session = Session.getInstance((Properties)props);
            } else {
                props.put("mail.smtp.user", auth);
                props.put("mail.smtp.auth", "true");
                session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                    public PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(auth, SMTPEventAuditManager.this.cus.getProperty("SMTPEventAuditManager.Passwd"));
                    }
                });
            }
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(this.cus.getProperty("SMTPEventAuditManager.Source")));
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(destination_address));
            message.setSubject(subject);
            message.setContent((Object)text_msg, "text/plain");
            Transport.send((Message)message);
        }
        catch (Exception e) {
            if (this.DEBUG) {
                e.printStackTrace();
            }
            throw new EventAuditException((Throwable)e);
        }
    }

    public void persist(AssignmentEventAuditPersistenceInterface assea, SharkTransaction ti) throws EventAuditException {
        block3: {
            this.other.persist(assea, ti);
            if (this.enable_email) {
                try {
                    String login = assea.getNewResourceUsername();
                    String person = Shark.getInstance().getAdminInterface().getUserGroupAdministration().getUserRealName(login);
                    String email = Shark.getInstance().getAdminInterface().getUserGroupAdministration().getUserEMailAddress(login);
                    String subject = this.parse(this._subject, person, assea.getActivityName(), assea.getProcessName(), assea.getProcessDefinitionId());
                    String msg = this.parse(this._message, person, assea.getActivityName(), assea.getProcessName(), assea.getProcessDefinitionId());
                    this.sendEmail(msg, subject, email);
                }
                catch (Exception e) {
                    System.err.println(e);
                    if (!this.DEBUG) break block3;
                    e.printStackTrace();
                }
            }
        }
    }

    private String parse(String template, String person, String activity, String process, String definition) {
        String ret = template;
        if (-1 != template.indexOf("{person}")) {
            ret = MiscUtilities.replaceAll((String)ret, (String)"{person}", (String)person);
        }
        if (-1 != template.indexOf("{activity}")) {
            ret = MiscUtilities.replaceAll((String)ret, (String)"{activity}", (String)activity);
        }
        if (-1 != template.indexOf("{process}")) {
            ret = MiscUtilities.replaceAll((String)ret, (String)"{process}", (String)process);
        }
        if (-1 != template.indexOf("{definition}")) {
            ret = MiscUtilities.replaceAll((String)ret, (String)"{definition}", (String)definition);
        }
        return ret;
    }

    public void persist(CreateProcessEventAuditPersistenceInterface cpea, SharkTransaction ti) throws EventAuditException {
        this.other.persist(cpea, ti);
    }

    public void persist(DataEventAuditPersistenceInterface dea, SharkTransaction ti) throws EventAuditException {
        this.other.persist(dea, ti);
    }

    public void persist(StateEventAuditPersistenceInterface sea, SharkTransaction ti) throws EventAuditException {
        this.other.persist(sea, ti);
    }

    public boolean restore(AssignmentEventAuditPersistenceInterface assea, SharkTransaction ti) throws EventAuditException {
        return this.other.restore(assea, ti);
    }

    public boolean restore(CreateProcessEventAuditPersistenceInterface cpea, SharkTransaction ti) throws EventAuditException {
        return this.other.restore(cpea, ti);
    }

    public boolean restore(DataEventAuditPersistenceInterface dea, SharkTransaction ti) throws EventAuditException {
        return this.other.restore(dea, ti);
    }

    public boolean restore(StateEventAuditPersistenceInterface sea, SharkTransaction ti) throws EventAuditException {
        return this.other.restore(sea, ti);
    }

    public List restoreProcessHistory(String procId, SharkTransaction ti) throws EventAuditException {
        return this.other.restoreProcessHistory(procId, ti);
    }

    public List restoreActivityHistory(String procId, String actId, SharkTransaction ti) throws EventAuditException {
        return this.other.restoreActivityHistory(procId, actId, ti);
    }

    public void delete(AssignmentEventAuditPersistenceInterface assea, SharkTransaction ti) throws EventAuditException {
        this.other.delete(assea, ti);
    }

    public void delete(CreateProcessEventAuditPersistenceInterface cpea, SharkTransaction ti) throws EventAuditException {
        this.other.delete(cpea, ti);
    }

    public void delete(DataEventAuditPersistenceInterface dea, SharkTransaction ti) throws EventAuditException {
        this.other.delete(dea, ti);
    }

    public void delete(StateEventAuditPersistenceInterface sea, SharkTransaction ti) throws EventAuditException {
        this.other.delete(sea, ti);
    }

    public AssignmentEventAuditPersistenceInterface createAssignmentEventAudit() {
        return this.other.createAssignmentEventAudit();
    }

    public CreateProcessEventAuditPersistenceInterface createCreateProcessEventAudit() {
        return this.other.createCreateProcessEventAudit();
    }

    public DataEventAuditPersistenceInterface createDataEventAudit() {
        return this.other.createDataEventAudit();
    }

    public StateEventAuditPersistenceInterface createStateEventAudit() {
        return this.other.createStateEventAudit();
    }

    public String getNextId(String idName) throws EventAuditException {
        return this.other.getNextId(idName);
    }
}

