/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.caching;

import java.util.ArrayList;
import java.util.List;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.internal.caching.ResourceCache;
import org.enhydra.shark.api.internal.working.CallbackUtilities;
import org.enhydra.shark.api.internal.working.WfResourceInternal;
import org.enhydra.shark.utilities.LRUMap;

public class LRUResourceCache
implements ResourceCache {
    private final int defaultCacheSize = 100;
    protected LRUMap cache;

    public void configure(CallbackUtilities cus) throws RootException {
        cus.getProperties();
        String resCacheSize = cus.getProperty("LRUResourceCache.Size");
        try {
            int cacheSize = Integer.parseInt(resCacheSize.trim());
            this.cache = new LRUMap(cacheSize);
        }
        catch (Exception ex) {
            this.cache = new LRUMap(100);
        }
        cus.info("Resource Cache configured - max. size is " + this.cache.getMaximumSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String username, WfResourceInternal res) throws RootException {
        LRUResourceCache lRUResourceCache = this;
        synchronized (lRUResourceCache) {
            this.cache.put((Object)username, (Object)res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String username) throws RootException {
        LRUResourceCache lRUResourceCache = this;
        synchronized (lRUResourceCache) {
            this.cache.remove((Object)username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized WfResourceInternal get(String username) throws RootException {
        WfResourceInternal res = null;
        LRUResourceCache lRUResourceCache = this;
        synchronized (lRUResourceCache) {
            res = (WfResourceInternal)this.cache.get((Object)username);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAll() throws RootException {
        if (this.cache.size() > 0) {
            LRUResourceCache lRUResourceCache = this;
            synchronized (lRUResourceCache) {
                return new ArrayList(this.cache.values());
            }
        }
        return new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSize(int size) throws RootException {
        if (size < 0) {
            throw new RootException("Can't set negative resource cache size");
        }
        LRUResourceCache lRUResourceCache = this;
        synchronized (lRUResourceCache) {
            this.cache.setMaximumSize(size);
        }
    }

    public int getSize() throws RootException {
        return this.cache.getMaximumSize();
    }

    public int howManyEntries() throws RootException {
        return this.cache.size();
    }
}

