/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.StringReader;
import java.nio.channels.FileLock;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xerces.parsers.DOMParser;
import org.enhydra.jawe.xml.ParsingErrors;
import org.enhydra.jawe.xml.XMLInterface;
import org.enhydra.jawe.xml.XMLUtil;
import org.enhydra.jawe.xml.XPDLEntityResolver;
import org.enhydra.jawe.xml.elements.ExternalPackage;
import org.enhydra.jawe.xml.elements.ExternalPackages;
import org.enhydra.jawe.xml.elements.Package;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class XML
implements XMLInterface {
    private LinkedHashMap idToPackage = new LinkedHashMap();
    private LinkedHashMap xmlFileToPackage = new LinkedHashMap();
    private LinkedHashMap pkgIdToFileContent = new LinkedHashMap();
    private LinkedHashMap packageToParentDirectory = new LinkedHashMap();
    private Map fileLocks = new HashMap();
    private Map rndAccessFiles = new HashMap();
    private String mainPackageReference;
    private boolean fileLocking = true;
    private Map parsingErrorMessages = new HashMap();
    private boolean isValidationON = true;

    public void setValidation(boolean isActive) {
        this.isValidationON = isActive;
    }

    public void setFileLockingStatus(boolean status) {
        this.fileLocking = status;
    }

    public void clearParserErrorMessages() {
        this.parsingErrorMessages.clear();
    }

    public void register(Package pkg) {
        this.idToPackage.put(pkg.get("Id").toString(), pkg);
    }

    public void registerPackageFilename(String filename, Package pkg) {
        String pkgId = pkg.get("Id").toString();
        Iterator it = this.xmlFileToPackage.entrySet().iterator();
        String uToRem = this.getAbsoluteFilePath(pkg);
        if (uToRem != null) {
            this.xmlFileToPackage.remove(uToRem);
        }
        try {
            FileLock fl = (FileLock)this.fileLocks.remove(pkg);
            fl.release();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            RandomAccessFile raf = (RandomAccessFile)this.rndAccessFiles.remove(pkg);
            raf.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        String cp = XMLUtil.getCanonicalPath((String)filename, (boolean)false);
        this.xmlFileToPackage.put(cp, pkg);
        File f = new File(cp);
        try {
            RandomAccessFile raf = new RandomAccessFile(f, "rw");
            this.rndAccessFiles.put(pkg, raf);
            if (this.fileLocking) {
                FileLock fl = raf.getChannel().tryLock();
                if (fl != null) {
                    this.fileLocks.put(pkg, fl);
                } else {
                    System.out.println("Can't lock");
                }
            }
        }
        catch (IOException ex) {
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.packageToParentDirectory.put(pkg, f.getParentFile().getCanonicalPath());
        }
        catch (Exception ex) {
            this.packageToParentDirectory.put(pkg, f.getParentFile().getAbsolutePath());
        }
    }

    public boolean isPackageOpened(String pkgId) {
        return this.idToPackage.containsKey(pkgId);
    }

    public void putPkgIdToFileContentMapping(String pkgId, String fileContent) {
        this.pkgIdToFileContent.put(pkgId, fileContent);
    }

    public String getPackageFileContent(String pkgId) {
        return (String)this.pkgIdToFileContent.get(pkgId);
    }

    public Package getPackageById(String pkgId) {
        return (Package)this.idToPackage.get(pkgId);
    }

    public Package getPackageByFilename(String filename) {
        filename = XMLUtil.getCanonicalPath((String)filename, (boolean)false);
        return (Package)this.xmlFileToPackage.get(filename);
    }

    public RandomAccessFile getRaf(Package pkg) {
        return (RandomAccessFile)this.rndAccessFiles.get(pkg);
    }

    public Package getExternalPackageByRelativeFilePath(String relativePathToExtPkg, Package rootPkg) {
        File f = new File(relativePathToExtPkg);
        if (!f.isAbsolute()) {
            f = new File(this.getParentDirectory(rootPkg) + File.separator + relativePathToExtPkg);
        }
        if (f.exists()) {
            return this.getPackageByFilename(f.getAbsolutePath());
        }
        return null;
    }

    public String getAbsoluteFilePath(Package pkg) {
        Iterator it = this.xmlFileToPackage.entrySet().iterator();
        String fullPath = null;
        while (it.hasNext()) {
            Map.Entry me = it.next();
            String u = (String)me.getKey();
            Package p = (Package)me.getValue();
            if (!p.equals(pkg)) continue;
            fullPath = u;
            break;
        }
        return fullPath;
    }

    public Collection getAllPackages() {
        return this.idToPackage.values();
    }

    public Collection getAllPackageIds() {
        return this.idToPackage.keySet();
    }

    public Collection getAllPackageFilenames() {
        return this.xmlFileToPackage.keySet();
    }

    public boolean doesPackageFileExists(String xmlFile) {
        return new File(xmlFile).exists() || this.getPackageFileContent(xmlFile) != null;
    }

    public String getParentDirectory(Package pkg) {
        return (String)this.packageToParentDirectory.get(pkg);
    }

    public Package openPackage(String pkgReference, boolean openFromStream) {
        Package p;
        this.parsingErrorMessages.clear();
        if (!openFromStream) {
            this.mainPackageReference = pkgReference;
        }
        HashSet pre = new HashSet(this.getAllPackages());
        Package pkg = this.openDocument(pkgReference, openFromStream);
        HashSet post = new HashSet(this.getAllPackages());
        post.removeAll(pre);
        Iterator newPackages = post.iterator();
        while (newPackages.hasNext()) {
            p = (Package)newPackages.next();
            this.appendAllExternalPackagesForPackage(p);
        }
        newPackages = post.iterator();
        while (newPackages.hasNext()) {
            p = (Package)newPackages.next();
            p.afterImporting();
        }
        if (pkg != null && !openFromStream) {
            System.setProperty("user.dir", this.getParentDirectory(pkg));
        }
        return pkg;
    }

    public void printDebug() {
        System.out.println("idToPackage=" + this.idToPackage);
        System.out.println("xmlFileToPackage=" + this.xmlFileToPackage);
        System.out.println("pkgIdToFileContent=" + this.pkgIdToFileContent);
        System.out.println("packageToWorkingDirectory=" + this.packageToParentDirectory);
        System.out.println("fileLocks=" + this.fileLocks);
        System.out.println("rndAccessFiles=" + this.rndAccessFiles);
    }

    private Package openDocument(String pkgReference, boolean openFromStream) {
        File f;
        Package pkg;
        block22: {
            pkg = null;
            f = null;
            String oldP = pkgReference;
            if (!openFromStream) {
                if ((pkgReference = XMLUtil.getCanonicalPath((String)pkgReference, (boolean)false)) == null) {
                    HashSet<String> fem = new HashSet<String>();
                    fem.add("File does not exist");
                    this.parsingErrorMessages.put(oldP, fem);
                    return null;
                }
                f = new File(pkgReference);
                try {
                    System.setProperty("user.dir", f.getParentFile().getCanonicalPath());
                }
                catch (Exception ex) {
                    System.setProperty("user.dir", f.getParentFile().getAbsolutePath());
                }
            }
            if (this.xmlFileToPackage.containsKey(pkgReference)) {
                return this.getPackageByFilename(pkgReference);
            }
            if (openFromStream && this.idToPackage.containsKey(pkgReference)) {
                return this.getPackageById(pkgReference);
            }
            if (!openFromStream) {
                pkg = this.parseDocument(pkgReference, true);
                try {
                    FileLock fl;
                    RandomAccessFile raf;
                    if (oldP.equals(this.mainPackageReference)) {
                        raf = new RandomAccessFile(f, "rw");
                        this.rndAccessFiles.put(pkg, raf);
                        if (!this.fileLocking) break block22;
                        fl = raf.getChannel().tryLock();
                        if (fl != null) {
                            this.fileLocks.put(pkg, fl);
                            break block22;
                        }
                        HashSet<String> errorMessages = new HashSet<String>();
                        errorMessages.add(XMLUtil.getLanguageDependentString((String)"ErrorTheFileIsLocked"));
                        this.parsingErrorMessages.put(pkgReference, errorMessages);
                        return null;
                    }
                    raf = new RandomAccessFile(f, "r");
                    this.rndAccessFiles.put(pkg, raf);
                    if (!this.fileLocking) break block22;
                    fl = raf.getChannel().tryLock(0L, Long.MAX_VALUE, true);
                    if (fl != null) {
                        this.fileLocks.put(pkg, fl);
                        break block22;
                    }
                    HashSet<String> errorMessages = new HashSet<String>();
                    errorMessages.add(XMLUtil.getLanguageDependentString((String)"ErrorTheFileIsLocked"));
                    this.parsingErrorMessages.put(pkgReference, errorMessages);
                    return null;
                }
                catch (Exception ex) {}
            } else {
                pkg = this.parseDocument(this.getPackageFileContent(pkgReference), false);
            }
        }
        if (pkg != null) {
            String pkgId = pkg.get("Id").toString();
            if (this.idToPackage.containsKey(pkgId)) {
                if (!openFromStream && this.xmlFileToPackage.containsKey(pkgReference) || openFromStream && this.getPackageFileContent(pkgReference) != null) {
                    return this.getPackageById(pkgId);
                }
                return null;
            }
            this.idToPackage.put(pkgId, pkg);
            if (!openFromStream) {
                this.xmlFileToPackage.put(pkgReference, pkg);
                try {
                    this.packageToParentDirectory.put(pkg, f.getParentFile().getCanonicalPath());
                }
                catch (Exception ex) {
                    this.packageToParentDirectory.put(pkg, f.getParentFile().getAbsolutePath());
                }
            }
            Iterator eps = ((ExternalPackages)pkg.get("ExternalPackages")).toCollection().iterator();
            while (eps.hasNext()) {
                Package extPkg;
                String pathToExtPackage = ((ExternalPackage)eps.next()).get("href").toString();
                if (!openFromStream) {
                    System.setProperty("user.dir", this.packageToParentDirectory.get(pkg).toString());
                }
                if ((extPkg = this.openDocument(pathToExtPackage, openFromStream)) == null) continue;
                pkg.addExternalPackage(extPkg);
            }
        } else {
            System.err.println("Problems with opening file " + pkgReference);
        }
        return pkg;
    }

    private void appendAllExternalPackagesForPackage(Package m) {
        Stack s = new Stack();
        s.addAll(m.getAllExternalPackages());
        HashSet result = new HashSet();
        while (!s.isEmpty()) {
            Package tmp = (Package)s.pop();
            Iterator extPkgs = tmp.getAllExternalPackages().iterator();
            while (extPkgs.hasNext()) {
                Object nextP = extPkgs.next();
                if (m.getAllExternalPackages().contains(nextP) || s.contains(nextP) || nextP == m) continue;
                s.add(nextP);
                m.addExternalPackage((Package)nextP);
            }
        }
    }

    public Package parseDocument(String toParse, boolean isFile) {
        Package pkg = null;
        DOMParser parser = new DOMParser();
        try {
            parser.setFeature("http://apache.org/xml/features/continue-after-fatal-error", true);
            ParsingErrors pErrors = new ParsingErrors();
            parser.setErrorHandler((ErrorHandler)pErrors);
            if (this.isValidationON) {
                parser.setEntityResolver((EntityResolver)new XPDLEntityResolver());
                parser.setFeature("http://xml.org/sax/features/validation", true);
                parser.setFeature("http://apache.org/xml/features/validation/schema", true);
            }
            if (isFile) {
                File f = new File(toParse);
                if (!f.exists()) {
                    f = new File(f.getCanonicalPath());
                }
                parser.parse(new InputSource(new FileInputStream(f)));
            } else {
                parser.parse(new InputSource(new StringReader(toParse)));
            }
            Document document = parser.getDocument();
            Set errorMessages = pErrors.getErrorMessages();
            if (errorMessages.size() > 0) {
                if (isFile) {
                    this.parsingErrorMessages.put(toParse, errorMessages);
                } else {
                    this.parsingErrorMessages.put("", errorMessages);
                }
            }
            if (document != null) {
                pkg = new Package((XMLInterface)this);
                pkg.fromXML((Node)document.getDocumentElement());
            }
        }
        catch (Exception ex) {
            System.err.println("Fatal error while parsing document");
            HashSet<String> fem = new HashSet<String>();
            fem.add("Fatal error while parsing document");
            if (isFile) {
                this.parsingErrorMessages.put(toParse, fem);
            } else {
                this.parsingErrorMessages.put("", fem);
            }
            return null;
        }
        return pkg;
    }

    public Map getParsingErrorMessages() {
        return this.parsingErrorMessages;
    }

    public void closePackage(String pkgId) {
        Package toRemove = (Package)this.idToPackage.remove(pkgId);
        if (toRemove != null) {
            Iterator it = this.xmlFileToPackage.entrySet().iterator();
            Object keyToRemove = null;
            while (it.hasNext()) {
                Map.Entry me = it.next();
                Object key = me.getKey();
                Object val = me.getValue();
                if (!val.equals(toRemove)) continue;
                keyToRemove = key;
                break;
            }
            if (keyToRemove != null) {
                this.xmlFileToPackage.remove(keyToRemove);
            }
            this.packageToParentDirectory.remove(toRemove);
            RandomAccessFile raf = (RandomAccessFile)this.rndAccessFiles.remove(toRemove);
            try {
                raf.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            FileLock fl = (FileLock)this.fileLocks.remove(toRemove);
            try {
                fl.release();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.pkgIdToFileContent.remove(pkgId);
    }

    public void closeAllPackages() {
        this.idToPackage.clear();
        this.xmlFileToPackage.clear();
        this.packageToParentDirectory.clear();
        this.pkgIdToFileContent.clear();
        Iterator it = this.rndAccessFiles.values().iterator();
        while (it.hasNext()) {
            RandomAccessFile raf = (RandomAccessFile)it.next();
            try {
                raf.close();
            }
            catch (Exception exception) {}
        }
        this.rndAccessFiles.clear();
        this.unlockAllFiles();
    }

    public void unlockAllFiles() {
        Iterator it = this.fileLocks.values().iterator();
        while (it.hasNext()) {
            FileLock fl = (FileLock)it.next();
            try {
                fl.release();
            }
            catch (Exception exception) {}
        }
        this.fileLocks.clear();
    }

    public void lockAllFiles() {
        if (!this.fileLocking) {
            return;
        }
        Iterator it = this.rndAccessFiles.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            Package pkg = (Package)me.getKey();
            RandomAccessFile raf = (RandomAccessFile)me.getValue();
            try {
                FileLock fl;
                if (pkg.equals(this.mainPackageReference)) {
                    fl = raf.getChannel().tryLock();
                    if (fl == null) continue;
                    this.fileLocks.put(pkg, fl);
                    continue;
                }
                fl = raf.getChannel().tryLock(0L, Long.MAX_VALUE, true);
                if (fl == null) continue;
                this.fileLocks.put(pkg, fl);
            }
            catch (Exception ex) {}
        }
    }

    public String getIDFromFile(String xmlFile) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            DocumentBuilder parser = factory.newDocumentBuilder();
            Document document = null;
            try {
                File f = new File(xmlFile);
                if (!f.exists()) {
                    f = new File(f.getCanonicalPath());
                }
                document = parser.parse(new InputSource(new FileInputStream(f)));
            }
            catch (Exception ex) {
                document = parser.parse(new InputSource(new StringReader(this.getPackageFileContent(xmlFile))));
            }
            return XMLUtil.getID((Node)document.getDocumentElement());
        }
        catch (Exception ex) {
            return "";
        }
    }
}

