/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.wfxml;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.enhydra.jawe.JaWE;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.wfxml.DefInfos;
import org.enhydra.jawe.wfxml.WfXMLComboPanel;
import org.enhydra.jawe.wfxml.WfXMLConnector;
import org.enhydra.jawe.xml.XMLButton;
import org.enhydra.jawe.xml.XMLCollection;
import org.enhydra.jawe.xml.XMLComplexElement;
import org.enhydra.jawe.xml.XMLElement;
import org.enhydra.jawe.xml.XMLUtil;
import org.enhydra.jawe.xml.panels.XMLPanel;
import org.enhydra.jawe.xml.panels.XMLTablePanel;

public class WfXMLPanel
extends XMLPanel {
    XMLTablePanel lstPanel;
    WfXMLComboPanel cboPanel;

    public WfXMLPanel(XMLCollection myOwner) {
        super((XMLElement)myOwner, 1, "", XMLPanel.BOX_LAYOUT, true, false);
        this.cboPanel = new WfXMLComboPanel((XMLElement)myOwner);
        this.lstPanel = new XMLTablePanel(myOwner, myOwner.toLabel(), false, true, false, false, false);
        this.add((Component)((Object)this.cboPanel));
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        this.add((Component)this.lstPanel);
        this.setPreferredSize(new Dimension(850, 500));
        XMLButton buttonConnect = this.cboPanel.getConnectButton();
        final JComboBox jcb = this.cboPanel.getComboBox();
        buttonConnect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String selected = (String)jcb.getSelectedItem();
                DefInfos dis = (DefInfos)WfXMLPanel.this.getOwner();
                if (selected != null) {
                    try {
                        List l = WfXMLConnector.wfxmlListDefinitions(new URL(selected), dis);
                        WfXMLPanel.this.cleanTable();
                        for (int i = 0; i < l.size(); ++i) {
                            WfXMLPanel.this.addElement((XMLElement)l.get(i));
                        }
                        JaWE.getInstance().message(ResourceManager.getLanguageDependentString("InformationWfXMLSuccessfullyConnectedToRegistryService") + " " + selected, 1);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        JaWE.getInstance().message(ResourceManager.getLanguageDependentString("ErrorWfXMLProblemsWhileGettingDefinitionListForRegistry") + " " + selected + " !", 0);
                    }
                } else {
                    WfXMLPanel.this.complainLoudly("WarningEmptySelectionToEditOrDelete");
                }
            }
        });
    }

    public XMLPanel getControlledPanel() {
        return this.lstPanel;
    }

    public WfXMLComboPanel getComboPanel() {
        return this.cboPanel;
    }

    public void complainLoudly(String message) {
        JOptionPane.showMessageDialog(this.getDialog(), XMLUtil.getLanguageDependentString((String)message), XMLUtil.getLanguageDependentString((String)"Title"), 2);
    }

    public void cleanTable() {
        ((XMLCollection)this.getOwner()).clear();
        JTable t = this.lstPanel.getTable();
        DefaultTableModel dtm = (DefaultTableModel)t.getModel();
        int rc = dtm.getRowCount();
        for (int i = rc - 1; i >= 0; --i) {
            dtm.removeRow(i);
        }
    }

    public void addElement(XMLElement e) {
        XMLCollection owncol = (XMLCollection)this.getOwner();
        int rowpos = owncol.size();
        owncol.add(e);
        JTable t = this.lstPanel.getTable();
        DefaultTableModel dtm = (DefaultTableModel)t.getModel();
        Vector<String> v = null;
        if (e instanceof XMLComplexElement) {
            v = new Vector(((XMLComplexElement)e).toComplexTypeValues());
        } else {
            v = new Vector<String>();
            v.add(e.toString());
        }
        v.add(0, (String)e);
        dtm.insertRow(rowpos, v);
        try {
            t.setRowSelectionInterval(rowpos, rowpos);
        }
        catch (Exception ex) {
            // empty catch block
        }
        t.requestFocus();
    }

    public XMLElement getSelectedElement() {
        return this.lstPanel.getSelectedElement();
    }

    public Object getSelectedItem() {
        Object si = this.cboPanel.getComboBox().getSelectedItem();
        System.out.println("Si=" + si);
        return si;
    }
}

