/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.wfxml;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.List;
import javax.swing.Box;
import org.enhydra.jawe.JaWE;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.wfxml.DefInfos;
import org.enhydra.jawe.wfxml.WfXMLConnector;
import org.enhydra.jawe.wfxml.WfXMLPanel;
import org.enhydra.jawe.xml.XMLButton;
import org.enhydra.jawe.xml.XMLCollection;
import org.enhydra.jawe.xml.XMLComplexElement;
import org.enhydra.jawe.xml.XMLElement;
import org.enhydra.jawe.xml.XMLUtil;
import org.enhydra.jawe.xml.panels.XMLControlPanel;
import org.w3c.dom.Node;

public class WfXMLControlPanel
extends XMLControlPanel {
    public WfXMLControlPanel(XMLCollection myOwner, final WfXMLPanel cont, String title, boolean isVertical, boolean hasBorder) {
        super(myOwner, title, isVertical, hasBorder);
        this.controlledPanel = cont.getControlledPanel();
        String d = XMLUtil.getLanguageDependentString((String)"DownloadKey");
        String up = XMLUtil.getLanguageDependentString((String)"UploadKey");
        String u = XMLUtil.getLanguageDependentString((String)"UpdateKey");
        Dimension dim = this.getPreferredDimension(new String[]{d, u, up});
        XMLButton buttonDownload = new XMLButton(d, "Download", dim);
        XMLButton buttonUpload = new XMLButton(up, "Upload", dim);
        XMLButton buttonUpdate = new XMLButton(u, "Update", dim);
        this.add(Box.createHorizontalGlue());
        this.add((Component)buttonDownload);
        this.add(Box.createRigidArea(new Dimension(10, 0)));
        this.add((Component)buttonUpload);
        this.add(Box.createRigidArea(new Dimension(10, 0)));
        this.add((Component)buttonUpdate);
        this.add(Box.createRigidArea(new Dimension(10, 0)));
        this.add(Box.createRigidArea(new Dimension(0, 25)));
        this.add(Box.createHorizontalGlue());
        buttonDownload.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String selected = ((XMLComplexElement)cont.getSelectedElement()).get("DefinitionKey").toString();
                if (selected != null) {
                    try {
                        Node n = WfXMLConnector.wfxmlGetDefinition(new URL(selected));
                        String pkgCnt = WfXMLConnector.node2String(n);
                        String pkgId = XMLUtil.getID((Node)n);
                        JaWE.getInstance().openPackageFromStream(pkgId, pkgCnt);
                        JaWE.getInstance().message(pkgId + " - " + ResourceManager.getLanguageDependentString("InformationWfXMLXPDLIsSucessfullyDownloaded"), 1);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        JaWE.getInstance().message(ResourceManager.getLanguageDependentString("ErrorWfXMLProblemsWhileDownloadingXPDL") + " " + selected + " !", 0);
                    }
                } else {
                    cont.complainLoudly("WarningEmptySelectionToEditOrDelete");
                }
            }
        });
        buttonUpload.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String pkgId = JaWE.getInstance().getRealXMLPackage().get("Id").toString();
                String selected = (String)cont.getSelectedItem();
                if (selected != null && pkgId != null && !pkgId.trim().equals("")) {
                    try {
                        String pkgContent = WfXMLConnector.xpdlToString();
                        WfXMLConnector.wfxmlNewDefinition2(new URL(selected), pkgContent);
                        JaWE.getInstance().message(pkgId + " - " + ResourceManager.getLanguageDependentString("InformationWfXMLXPDLIsSucessfullyUploaded"), 1);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        JaWE.getInstance().message(ResourceManager.getLanguageDependentString("ErrorWfXMLProblemsWhileUploadingXPDL") + " " + selected + " !", 0);
                        return;
                    }
                    try {
                        DefInfos dis = (DefInfos)WfXMLControlPanel.this.getOwner();
                        List l = WfXMLConnector.wfxmlListDefinitions(new URL(selected), dis);
                        cont.cleanTable();
                        for (int i = 0; i < l.size(); ++i) {
                            cont.addElement((XMLElement)l.get(i));
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        JaWE.getInstance().message(ResourceManager.getLanguageDependentString("ErrorWfXMLProblemsWhileGettingDefinitionListForRegistry") + " " + selected + " !", 0);
                    }
                } else {
                    cont.complainLoudly("WarningEmptySelectionToEditOrDelete");
                }
            }
        });
        buttonUpdate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String pkgId = JaWE.getInstance().getRealXMLPackage().get("Id").toString();
                if (cont.getSelectedElement() != null && pkgId != null && !pkgId.trim().equals("")) {
                    String selected = ((XMLComplexElement)cont.getSelectedElement()).get("DefinitionKey").toString();
                    try {
                        String pkgContent = WfXMLConnector.xpdlToString();
                        WfXMLConnector.wfxmlSetDefinition2(new URL(selected), pkgContent);
                        JaWE.getInstance().message(pkgId + " - " + ResourceManager.getLanguageDependentString("InformationWfXMLXPDLIsSucessfullyUpdated"), 1);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        JaWE.getInstance().message(ResourceManager.getLanguageDependentString("ErrorWfXMLProblemsWhileUpdatingXPDL") + " " + selected + " !", 0);
                        return;
                    }
                    try {
                        selected = (String)cont.getSelectedItem();
                        DefInfos dis = (DefInfos)WfXMLControlPanel.this.getOwner();
                        cont.cleanTable();
                        List l = WfXMLConnector.wfxmlListDefinitions(new URL(selected), dis);
                        for (int i = 0; i < l.size(); ++i) {
                            cont.addElement((XMLElement)l.get(i));
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        JaWE.getInstance().message(ResourceManager.getLanguageDependentString("ErrorWfXMLProblemsWhileGettingDefinitionListForRegistry") + " " + selected + " !", 0);
                    }
                } else {
                    cont.complainLoudly("WarningEmptySelectionToEditOrDelete");
                }
            }
        });
    }
}

