/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.wfxml;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.enhydra.jawe.JaWEConstants;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.xml.XMLButton;
import org.enhydra.jawe.xml.XMLElement;
import org.enhydra.jawe.xml.XMLUtil;
import org.enhydra.jawe.xml.panels.XMLComboPanel;
import org.enhydra.jawe.xml.panels.XMLPanel;

public class WfXMLComboPanel
extends XMLComboPanel {
    private static final int MAX_URL_HISTORY_SIZE = 16;
    private static String URL_HISTORY_FILE_PATH;
    private static ArrayList urls;
    private Dimension comboBoxDimension = new Dimension(350, 20);
    private XMLButton buttonConnect;

    public WfXMLComboPanel(XMLElement myOwner) {
        super(myOwner, null, XMLPanel.BOX_LAYOUT, false, true);
        ((JLabel)this.getComponent(1)).setText(ResourceManager.getLanguageDependentString("RegistryServiceURL") + ": ");
        if (URL_HISTORY_FILE_PATH == null) {
            URL_HISTORY_FILE_PATH = JaWEConstants.JAWE_USER_HOME + "/.rurls";
            File extR = new File(URL_HISTORY_FILE_PATH);
            if (extR.exists()) {
                urls = (ArrayList)this.readFile(URL_HISTORY_FILE_PATH);
            }
            if (urls == null) {
                urls = new ArrayList();
            }
        }
        final JComboBox jcb = super.getComboBox();
        for (int i = 0; i < urls.size(); ++i) {
            jcb.addItem(urls.get(i));
        }
        if (urls.size() > 0) {
            jcb.setSelectedIndex(0);
        }
        jcb.setPreferredSize(this.comboBoxDimension);
        String s = XMLUtil.getLanguageDependentString((String)"ConnectKey");
        double w = 0.0;
        try {
            w = this.getFontMetrics(this.getFont()).stringWidth(s);
        }
        catch (Exception ex) {
            // empty catch block
        }
        double h = this.getFontMetrics(this.getFont()).getHeight();
        w += 25.0;
        if (w < 30.0) {
            w = 30.0;
        }
        Dimension dim = new Dimension((int)w, (int)h);
        this.buttonConnect = new XMLButton(s, "Connect", dim);
        this.buttonConnect.setAlignmentX(0.0f);
        this.buttonConnect.setAlignmentY(1.0f);
        this.add(Box.createRigidArea(new Dimension(10, 0)));
        this.add((Component)this.buttonConnect);
        this.buttonConnect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String selected = (String)jcb.getSelectedItem();
                if (selected != null) {
                    WfXMLComboPanel.this.addItemToCombo(selected);
                }
            }
        });
    }

    public XMLButton getConnectButton() {
        return this.buttonConnect;
    }

    public void setElements() {
    }

    private void addItemToCombo(String url) {
        if (url == null || url.trim().length() == 0) {
            return;
        }
        JComboBox jcb = this.getComboBox();
        for (int i = 0; i < jcb.getItemCount(); ++i) {
            if (!jcb.getItemAt(i).toString().equals(url)) continue;
            jcb.removeItemAt(i);
            jcb.insertItemAt(url, 0);
            jcb.setSelectedIndex(0);
            urls.remove(i);
            urls.add(0, url);
            this.writeFile(urls, URL_HISTORY_FILE_PATH);
            return;
        }
        jcb.insertItemAt(url, 0);
        urls.add(0, url);
        if (jcb.getItemCount() > 16) {
            jcb.removeItemAt(16);
            urls.remove(16);
        }
        jcb.setSelectedIndex(0);
        this.writeFile(urls, URL_HISTORY_FILE_PATH);
    }

    private void writeFile(Object obj, String fName) {
        try {
            FileOutputStream fos = new FileOutputStream(fName);
            ObjectOutputStream oout = new ObjectOutputStream(fos);
            oout.writeObject(obj);
            oout.flush();
            oout.close();
            ((OutputStream)fos).close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private Object readFile(String fName) {
        try {
            FileInputStream fis = new FileInputStream(fName);
            ObjectInputStream oin = new ObjectInputStream(fis);
            Object obj = oin.readObject();
            oin.close();
            return obj;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

