/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.misc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.Utils;
import org.enhydra.jawe.graph.End;
import org.enhydra.jawe.graph.Start;
import org.enhydra.jawe.xml.XMLCollectionElement;
import org.enhydra.jawe.xml.XMLComplexElement;
import org.enhydra.jawe.xml.XMLElement;
import org.enhydra.jawe.xml.elements.Activity;
import org.enhydra.jawe.xml.elements.Package;
import org.enhydra.jawe.xml.elements.WorkflowProcess;

public class ValidationErrorDisplay
extends JDialog {
    private boolean stopped = false;

    public ValidationErrorDisplay(Map parsingErrors, Map connectionErrors, List basicGraphConformanceErrors, Map graphConformanceErrors, Map logicErrors, JFrame parentFrame, String title, boolean controlsVisible) {
        super(parentFrame, title, true);
        this.showDialog(parsingErrors, connectionErrors, basicGraphConformanceErrors, graphConformanceErrors, logicErrors, parentFrame, controlsVisible);
    }

    public ValidationErrorDisplay(Map parsingErrors, Map connectionErrors, List basicGraphConformanceErrors, Map graphConformanceErrors, Map logicErrors, JDialog parentDialog, String title, boolean controlsVisible) {
        super(parentDialog, title, true);
        this.showDialog(parsingErrors, connectionErrors, basicGraphConformanceErrors, graphConformanceErrors, logicErrors, parentDialog, controlsVisible);
    }

    protected void showDialog(Map parsingErrors, Map connectionErrors, List basicGraphConformanceErrors, Map graphConformanceErrors, Map logicErrors, Window parentWindow, boolean controlsVisible) {
        JEditorPane text = new JEditorPane("text/html", this.processErrors(parsingErrors, connectionErrors, basicGraphConformanceErrors, graphConformanceErrors, logicErrors));
        text.setEditable(false);
        text.getCaret().setDot(0);
        JScrollPane sp = new JScrollPane(text);
        sp.setVerticalScrollBarPolicy(20);
        sp.setHorizontalScrollBarPolicy(30);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(sp);
        if (controlsVisible) {
            JPanel buttonPanel = new JPanel();
            buttonPanel.setAlignmentX(0.0f);
            buttonPanel.setAlignmentY(0.0f);
            JButton buttonProceed = new JButton(ResourceManager.getLanguageDependentString("ProceedKey"));
            URL u = ResourceManager.getResource("ProceedImage");
            if (u != null) {
                buttonProceed.setIcon(new ImageIcon(u));
            }
            JButton buttonStop = new JButton(ResourceManager.getLanguageDependentString("StopKey"));
            u = ResourceManager.getResource("StopImage");
            if (u != null) {
                buttonStop.setIcon(new ImageIcon(u));
            }
            buttonPanel.add(buttonProceed);
            buttonPanel.add(buttonStop);
            Container cp = this.getContentPane();
            cp.setLayout(new BorderLayout());
            cp.add((Component)sp, "Center");
            cp.add((Component)buttonPanel, "South");
            buttonProceed.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    ValidationErrorDisplay.this.stopped = false;
                    ValidationErrorDisplay.this.dispose();
                }
            });
            buttonStop.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    ValidationErrorDisplay.this.stopped = true;
                    ValidationErrorDisplay.this.dispose();
                }
            });
            buttonProceed.setDefaultCapable(true);
            this.getRootPane().setDefaultButton(buttonProceed);
        }
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0, false), "Cancel");
        this.getRootPane().getActionMap().put("Cancel", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ValidationErrorDisplay.this.dispose();
            }
        });
        Utils.center(this, 100, 150);
        this.show();
    }

    protected String processErrors(Map parsingErrors, Map connectionErrors, List basicGraphConformanceErrors, Map graphConformanceErrors, Map logicErrors) {
        String msg;
        Object obj;
        String msg2;
        Map.Entry me;
        Iterator it;
        String subtitle;
        String errMsg = "<html>";
        if (this.getParent() instanceof JFrame) {
            subtitle = ResourceManager.getLanguageDependentString("XPDLSchemaKey");
            errMsg = errMsg + "<font size=6 face=\"sans-serif\" color=\"green\"><b><i><u>" + subtitle + "</u></i></b></font><br><br>";
            if (parsingErrors != null) {
                it = parsingErrors.entrySet().iterator();
                while (it.hasNext()) {
                    me = it.next();
                    String pkgFile = (String)me.getKey();
                    Set errorsForPkg = (Set)me.getValue();
                    if (pkgFile.length() > 0) {
                        errMsg = errMsg + "<font size=5 face=\"sans-serif\" color=\"blue\"><b><i><u>" + pkgFile + "</u></i></b></font><br><br>";
                    }
                    errMsg = errMsg + "<font size=4 face=\"sans-serif\" color=\"#FF0000\"><i>";
                    Iterator it2 = errorsForPkg.iterator();
                    while (it2.hasNext()) {
                        String msg3 = it2.next().toString();
                        errMsg = errMsg + msg3 + "<br>";
                    }
                    errMsg = errMsg + "</i></font><br><br>";
                }
            }
            if (parsingErrors == null || parsingErrors.size() == 0) {
                msg2 = ResourceManager.getLanguageDependentString("MessageThereAreNoXPDLSchemaValidationErrors");
                errMsg = errMsg + "<br><font size=4 face=\"sans-serif\" color=\"#0033CC\">" + msg2 + "</font><br><br>";
            }
        }
        subtitle = ResourceManager.getLanguageDependentString("ConnectionsKey");
        errMsg = errMsg + "<font size=6 face=\"sans-serif\" color=\"green\"><b><i><u>" + subtitle + "</u></i></b></font><br><br>";
        if (connectionErrors != null) {
            it = connectionErrors.entrySet().iterator();
            while (it.hasNext()) {
                me = it.next();
                obj = me.getKey();
                msg = me.getValue().toString();
                errMsg = errMsg + "<font size=4 face=\"sans-serif\" color=\"#0033CC\">";
                errMsg = this.appendErrorMessage(obj, errMsg);
                errMsg = errMsg + "<blockquote>";
                errMsg = errMsg + "<font size=\"4\" face=\"sans-serif\">";
                errMsg = errMsg + "<em>" + msg + "</em><br>";
                errMsg = errMsg + "</font></p></blockquote>";
            }
        }
        if (connectionErrors == null || connectionErrors.size() == 0) {
            msg2 = ResourceManager.getLanguageDependentString("MessageAllElementsAreProperlyConnected");
            errMsg = errMsg + "<br><font size=4 face=\"sans-serif\" color=\"#0033CC\">" + msg2 + "</font><br><br>";
        }
        subtitle = ResourceManager.getLanguageDependentString("GraphConformanceKey");
        errMsg = errMsg + "<font size=6 face=\"sans-serif\" color=\"green\"><b><i><u>" + subtitle + "</u></i></b></font><br>";
        if (basicGraphConformanceErrors != null) {
            it = basicGraphConformanceErrors.iterator();
            while (it.hasNext()) {
                String msg4 = (String)((Object)it.next());
                errMsg = errMsg + "<font size=4 face=\"sans-serif\" color=\"#FF0000\">" + msg4 + "</font>";
                errMsg = errMsg + "<br>";
            }
        }
        if (graphConformanceErrors != null && graphConformanceErrors.size() > 0) {
            errMsg = basicGraphConformanceErrors != null && basicGraphConformanceErrors.size() > 0 ? errMsg + "<br><br>" : errMsg + "<br>";
        }
        if (graphConformanceErrors != null) {
            it = graphConformanceErrors.entrySet().iterator();
            while (it.hasNext()) {
                me = it.next();
                obj = me.getKey();
                msg = me.getValue().toString();
                errMsg = errMsg + "<font size=4 face=\"sans-serif\" color=\"#0033CC\">";
                errMsg = this.appendErrorMessage(obj, errMsg);
                errMsg = errMsg + "<blockquote>";
                errMsg = errMsg + "<font size=\"4\" face=\"sans-serif\">";
                errMsg = errMsg + "<em>" + msg + "</em><br>";
                errMsg = errMsg + "</font></p></blockquote>";
            }
        }
        if (!(basicGraphConformanceErrors != null && basicGraphConformanceErrors.size() != 0 || graphConformanceErrors != null && graphConformanceErrors.size() != 0)) {
            msg2 = this.getParent() instanceof JFrame ? ResourceManager.getLanguageDependentString("MessagePackageGraphsConformsToTheGivenGraphConformanceClass") : ResourceManager.getLanguageDependentString("MessageProcessGraphConformsToTheGivenGraphConformanceClass");
            errMsg = errMsg + "<br><font size=4 face=\"sans-serif\" color=\"#0033CC\">" + msg2 + "</font><br><br>";
        }
        if (basicGraphConformanceErrors != null && basicGraphConformanceErrors.size() > 0 && (graphConformanceErrors == null || graphConformanceErrors.size() == 0)) {
            errMsg = errMsg + "<br>";
        }
        subtitle = ResourceManager.getLanguageDependentString("LogicKey");
        errMsg = errMsg + "<font size=6 face=\"sans-serif\" color=\"green\"><b><i><u>" + subtitle + "</u></i></b></font><br><br>";
        if (logicErrors != null) {
            it = logicErrors.entrySet().iterator();
            while (it.hasNext()) {
                me = it.next();
                obj = me.getKey();
                msg = me.getValue().toString();
                errMsg = errMsg + "<font size=4 face=\"sans-serif\" color=\"#0033CC\">";
                errMsg = this.appendErrorMessage(obj, errMsg);
                errMsg = errMsg + "<blockquote>";
                errMsg = errMsg + "<font size=\"4\" face=\"sans-serif\">";
                errMsg = errMsg + "<em>" + msg + "</em><br>";
                errMsg = errMsg + "</font></p></blockquote>";
            }
        }
        if (logicErrors == null || logicErrors.size() == 0) {
            msg2 = ResourceManager.getLanguageDependentString("MessageThereAreNoLogicErrors");
            errMsg = errMsg + "<br><font size=4 face=\"sans-serif\" color=\"#0033CC\">" + msg2 + "</font><br><br>";
        }
        if ((connectionErrors != null && connectionErrors.size() > 0 || graphConformanceErrors != null && graphConformanceErrors.size() > 0) && this.getParent() instanceof JDialog) {
            errMsg = errMsg + "<br><br>";
            errMsg = errMsg + "<font size=\"4\" face=\"sans-serif\"><strong><em>" + ResourceManager.getLanguageDependentString("MessageAllInvalidGraphObjectsWillBeSelectedAfterExitingDialog") + "</strong></em></font>";
        }
        errMsg = errMsg + "</html>";
        return errMsg;
    }

    private String appendErrorMessage(Object obj, String errMsg) {
        if (obj instanceof XMLCollectionElement || obj instanceof Package) {
            XMLComplexElement xmlCe = (XMLComplexElement)obj;
            if (obj instanceof WorkflowProcess) {
                if (this.getParent() instanceof JDialog) {
                    return errMsg;
                }
                errMsg = errMsg + "<u><strong>" + ResourceManager.getLanguageDependentString("ProcessKey") + ":</strong></u> </font>";
            } else {
                Activity act;
                errMsg = obj instanceof Activity ? ((act = (Activity)obj).getSubflow() != null ? errMsg + "<u><strong>" + ResourceManager.getLanguageDependentString("SubFlowKey") + ":</strong></u> </font>" : (act.getBlockActivity() != null ? errMsg + "<u><strong>" + ResourceManager.getLanguageDependentString("BlockActivityKey") + ":</strong></u> </font>" : (act.getTools() != null ? errMsg + "<u><strong>" + ResourceManager.getLanguageDependentString("GenericKey") + ":</strong></u> </font>" : errMsg + "<u><strong>" + ResourceManager.getLanguageDependentString("RouteKey") + ":</strong></u> </font>"))) : errMsg + "<u><strong>" + ((XMLElement)obj).toLabel() + ":</strong></u> </font>";
            }
            try {
                errMsg = errMsg + "<font size=\"4\" face=\"sans-serif\">" + ResourceManager.getLanguageDependentString("IdKey") + "= <font color=\"#FF0000\">" + xmlCe.get("Id") + "</font>, ";
                errMsg = errMsg + ResourceManager.getLanguageDependentString("NameKey") + "= <font color=\"#FF0000\">" + xmlCe.get("Name").toString() + "</font></font>";
            }
            catch (Exception ex) {}
        } else if (obj instanceof XMLElement) {
            errMsg = errMsg + "<u><strong>" + ((XMLElement)obj).toLabel() + ":</strong></u> </font>";
        } else if (obj instanceof Start || obj instanceof End) {
            org.enhydra.jawe.graph.Activity sOrE = (org.enhydra.jawe.graph.Activity)obj;
            if (obj instanceof Start) {
                errMsg = errMsg + "<u><strong>" + ResourceManager.getLanguageDependentString("StartKey") + ":</strong></u> </font>";
            } else if (obj instanceof End) {
                errMsg = errMsg + "<u><strong>" + ResourceManager.getLanguageDependentString("EndKey") + ":</strong></u> </font>";
            }
        }
        return errMsg;
    }

    public boolean hasBeenStoped() {
        return this.stopped;
    }
}

