/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.misc;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.enhydra.jawe.BarFactory;
import org.enhydra.jawe.JaWE;
import org.enhydra.jawe.JaWEConfig;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.TextPreview;
import org.enhydra.jawe.TextTreeModel;
import org.enhydra.jawe.Utils;
import org.enhydra.jawe.xml.XMLElement;
import org.enhydra.jawe.xml.XMLElementDialog;
import org.enhydra.jawe.xml.XMLUtil;
import org.enhydra.jawe.xml.elements.Package;
import org.enhydra.jawe.xml.panels.XMLPanel;

public class TextTreePanel
extends XMLPanel {
    private TreeModel treeModel;
    private final JTree jtree;
    private TextPreview textPreview;
    static /* synthetic */ Class class$org$enhydra$jawe$actions$EditProperties;

    public TextTreePanel(Package myOwner, TextPreview txPreview, String title) {
        super((XMLElement)myOwner, 2, title, XMLPanel.BOX_LAYOUT, true, true);
        this.textPreview = txPreview;
        this.treeModel = new TextTreeModel((XMLElement)myOwner);
        this.jtree = new JTree(this.treeModel){

            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.jtree.getSelectionModel().setSelectionMode(1);
        this.jtree.setRootVisible(true);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setBackground(Utils.getColor(JaWEConfig.getInstance().getBackgroundColor()));
        renderer.setBackgroundNonSelectionColor(Utils.getColor(JaWEConfig.getInstance().getBackgroundColor()));
        this.jtree.setCellRenderer(renderer);
        this.jtree.setBackground(Utils.getColor(JaWEConfig.getInstance().getBackgroundColor()));
        this.jtree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)TextTreePanel.this.jtree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                XMLElement element = (XMLElement)node.getUserObject();
                TextTreePanel.this.textPreview.display(element);
            }
        });
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                if (SwingUtilities.isRightMouseButton(me)) {
                    int x = me.getX();
                    int y = me.getY();
                    JPopupMenu popup = new JPopupMenu();
                    JMenuItem menuItem1 = BarFactory.createMenuItem(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$EditProperties == null ? (class$org$enhydra$jawe$actions$EditProperties = TextTreePanel.class$("org.enhydra.jawe.actions.EditProperties")) : class$org$enhydra$jawe$actions$EditProperties));
                    menuItem1.addActionListener(new ShowPropertyDialogActionListener(TextTreePanel.this.jtree, x, y, TextTreePanel.this.textPreview));
                    JMenuItem menuItem2 = BarFactory.createMenuItem("ExpandAll");
                    menuItem2.addActionListener(new ExpandAllActionListener(TextTreePanel.this.jtree, x, y));
                    JMenuItem menuItem3 = BarFactory.createMenuItem("CollapseAll");
                    menuItem3.addActionListener(new CollapseAllActionListener(TextTreePanel.this.jtree, x, y));
                    popup.add(menuItem1);
                    popup.add(menuItem2);
                    popup.add(menuItem3);
                    popup.show(TextTreePanel.this.jtree, me.getX(), me.getY());
                }
            }
        };
        this.jtree.addMouseListener(mouseListener);
        this.jtree.addTreeExpansionListener(new JaWETreeExpansionListener(this.textPreview));
        JScrollPane allItemsPane = new JScrollPane();
        allItemsPane.setViewportView(this.jtree);
        allItemsPane.setBackground(Color.lightGray);
        allItemsPane.setPreferredSize(new Dimension(300, 300));
        this.add(allItemsPane);
    }

    public TreeModel getTreeModel() {
        return this.treeModel;
    }

    public JTree getTree() {
        return this.jtree;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class JaWETreeExpansionListener
    implements TreeExpansionListener {
        TextPreview textPreview;

        public JaWETreeExpansionListener(TextPreview textPreview) {
            this.textPreview = textPreview;
        }

        public void treeExpanded(TreeExpansionEvent e) {
            TreePath expandedPath = e.getPath();
            ((XMLElement)((DefaultMutableTreeNode)expandedPath.getLastPathComponent()).getUserObject()).setCollapsed(false);
        }

        public void treeCollapsed(TreeExpansionEvent e) {
            TreePath collapsedPath = e.getPath();
            ((XMLElement)((DefaultMutableTreeNode)collapsedPath.getLastPathComponent()).getUserObject()).setCollapsed(true);
        }
    }

    class CollapseAllActionListener
    implements ActionListener {
        JTree jtree;
        int x;
        int y;

        public CollapseAllActionListener(JTree jtree, int x, int y) {
            this.jtree = jtree;
            this.x = x;
            this.y = y;
        }

        public void actionPerformed(ActionEvent e) {
            XMLUtil.expandAll((JTree)this.jtree, (TreePath)this.jtree.getPathForLocation(this.x, this.y), (boolean)false);
        }
    }

    class ExpandAllActionListener
    implements ActionListener {
        JTree jtree;
        int x;
        int y;

        public ExpandAllActionListener(JTree jtree, int x, int y) {
            this.jtree = jtree;
            this.x = x;
            this.y = y;
        }

        public void actionPerformed(ActionEvent e) {
            XMLUtil.expandAll((JTree)this.jtree, (TreePath)this.jtree.getPathForLocation(this.x, this.y), (boolean)true);
        }
    }

    class ShowPropertyDialogActionListener
    implements ActionListener {
        JTree jtree;
        int x;
        int y;
        TextPreview textPreview;

        public ShowPropertyDialogActionListener(JTree jtree, int x, int y, TextPreview textPreview) {
            this.jtree = jtree;
            this.x = x;
            this.y = y;
            this.textPreview = textPreview;
        }

        public void actionPerformed(ActionEvent e) {
            this.showPropertyDialog(this.jtree, this.x, this.y);
            this.textPreview.refreshView();
        }

        private void showPropertyDialog(JTree jtree, int x, int y) {
            TreePath treePath = jtree.getPathForLocation(x, y);
            Object[] pathArray = treePath.getPath();
            DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)pathArray[pathArray.length - 1];
            XMLElementDialog d = new XMLElementDialog(JaWE.getInstance().getMainFrame(), ResourceManager.getLanguageDependentString("DialogProperties") + " - " + ((XMLElement)selectedNode.getUserObject()).toName());
            d.editXMLElement(((XMLElement)selectedNode.getUserObject()).getPanel(), true, false);
        }
    }
}

