/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.misc;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import org.enhydra.jawe.JaWE;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.WorkflowManager;
import org.enhydra.jawe.xml.XMLButton;
import org.enhydra.jawe.xml.XMLCollection;
import org.enhydra.jawe.xml.XMLUtil;
import org.enhydra.jawe.xml.elements.Participant;
import org.enhydra.jawe.xml.elements.Participants;
import org.enhydra.jawe.xml.panels.XMLControlPanel;
import org.enhydra.jawe.xml.panels.XMLTableControlPanel;

public class ShowHideButtonsPanel
extends XMLControlPanel {
    private WorkflowManager workflowManager;

    public ShowHideButtonsPanel(Participants myOwner, WorkflowManager wm, boolean isVertical) {
        super((XMLCollection)myOwner, "", isVertical, false);
        this.workflowManager = wm;
        String s = XMLUtil.getLanguageDependentString((String)"ShowKey");
        String h = XMLUtil.getLanguageDependentString((String)"HideKey");
        Dimension dim = this.getPreferredDimension(new String[]{s, h});
        XMLButton buttonShow = new XMLButton(s, "Show", dim);
        XMLButton buttonHide = new XMLButton(h, "Hide", dim);
        buttonShow.setEnabled(!myOwner.isReadOnly());
        buttonHide.setEnabled(!myOwner.isReadOnly());
        if (isVertical) {
            this.add(Box.createVerticalGlue());
        } else {
            this.add(Box.createHorizontalGlue());
        }
        this.add((Component)buttonShow);
        if (isVertical) {
            this.add(Box.createRigidArea(new Dimension(0, 5)));
        } else {
            this.add(Box.createRigidArea(new Dimension(5, 0)));
        }
        this.add((Component)buttonHide);
        if (isVertical) {
            this.add(Box.createVerticalGlue());
        } else {
            this.add(Box.createHorizontalGlue());
            this.add(Box.createRigidArea(new Dimension(0, 15)));
        }
        buttonShow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Participants pOwner = (Participants)ShowHideButtonsPanel.this.getOwner();
                XMLTableControlPanel tcp = (XMLTableControlPanel)pOwner.getControlPanel();
                Participant selectedParticipant = (Participant)tcp.getSelectedElement();
                if (selectedParticipant != null) {
                    Participants pps = (Participants)pOwner.getPackage().get("Participants");
                    if (!pOwner.isMine(selectedParticipant) && pOwner.getCollectionElement(selectedParticipant.getID()) != null || pOwner.isExternal(selectedParticipant) && pps.getCollectionElement(selectedParticipant.getID()) != null) {
                        JaWE.getInstance().message(ResourceManager.getLanguageDependentString("WarningCannotShowRedefinedParticipant"), 2);
                    } else {
                        ShowHideButtonsPanel.this.workflowManager.showNode(selectedParticipant);
                    }
                }
            }
        });
        buttonHide.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Participants pOwner = (Participants)ShowHideButtonsPanel.this.getOwner();
                XMLTableControlPanel tcp = (XMLTableControlPanel)pOwner.getControlPanel();
                Participant selectedParticipant = (Participant)tcp.getSelectedElement();
                if (selectedParticipant != null) {
                    ShowHideButtonsPanel.this.workflowManager.hideNode(selectedParticipant);
                }
            }
        });
    }
}

