/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.misc;

import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import org.enhydra.jawe.JaWEConfig;
import org.enhydra.jawe.PackageEditor;
import org.enhydra.jawe.Utils;
import org.enhydra.jawe.xml.XMLElement;
import org.enhydra.jawe.xml.elements.Package;
import org.enhydra.jawe.xml.panels.XMLPanel;

public class PackageTreePanel
extends XMLPanel {
    private static Dimension treeDimension = new Dimension(300, 300);
    private PackageEditor packageEditor;

    public PackageTreePanel(Package myOwner, PackageEditor pkgEditor, String title, boolean hasBorder) {
        super((XMLElement)myOwner, 2, title, XMLPanel.BOX_LAYOUT, true, hasBorder);
        this.packageEditor = pkgEditor;
        DefaultTreeModel model = myOwner.getTreeModel();
        final JTree allItems = new JTree(model){

            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        allItems.getSelectionModel().setSelectionMode(1);
        allItems.setRootVisible(true);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        allItems.setCellRenderer(renderer);
        JScrollPane allItemsPane = new JScrollPane();
        allItemsPane.setViewportView(allItems);
        allItemsPane.setPreferredSize(treeDimension);
        this.add(allItemsPane);
        this.add(Box.createVerticalGlue());
        allItems.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)allItems.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                Package pkg = (Package)node.getUserObject();
                PackageTreePanel.this.packageEditor.displayPackage(pkg);
            }
        });
        this.refreshPackageTreePanel();
    }

    public void refreshPackageTreePanel() {
        JTree jt = this.getTree();
        jt.setBackground(Utils.getColor(JaWEConfig.getInstance().getBackgroundColor()));
        DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)jt.getCellRenderer();
        dtcr.setBackground(Utils.getColor(JaWEConfig.getInstance().getBackgroundColor()));
        dtcr.setBackgroundNonSelectionColor(Utils.getColor(JaWEConfig.getInstance().getBackgroundColor()));
    }

    public JTree getTree() {
        JScrollPane jsp = (JScrollPane)this.getComponent(0);
        JViewport jvp = (JViewport)jsp.getComponent(0);
        JTree jt = (JTree)jvp.getComponent(0);
        return jt;
    }
}

