/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.misc;

import java.util.Locale;
import org.enhydra.jawe.ResourceManager;

public class PFLocale {
    private Locale loc;

    public static PFLocale createPFLocale(String pfExt) {
        PFLocale pel = null;
        try {
            pfExt = pfExt.trim();
            if (pfExt.equals("default")) {
                pel = new PFLocale();
            } else {
                boolean hasCountry;
                boolean bl = hasCountry = pfExt.length() > 2 && pfExt.substring(2, 3).equals("_");
                if (hasCountry) {
                    boolean hasVariant;
                    boolean bl2 = hasVariant = pfExt.length() > 5 && pfExt.substring(5, 6).equals("_");
                    if (hasVariant) {
                        pel = new PFLocale(pfExt.substring(0, 2), pfExt.substring(3, 5), pfExt.substring(6, pfExt.length()));
                    } else if (pfExt.length() == 5) {
                        pel = new PFLocale(pfExt.substring(0, 2), pfExt.substring(3, 5));
                    }
                } else if (pfExt.length() == 2) {
                    pel = new PFLocale(pfExt);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pel;
    }

    public PFLocale() {
        this.loc = ResourceManager.getDefaultLocale();
    }

    public PFLocale(Locale l) {
        this.loc = l;
    }

    public PFLocale(String lang) {
        this.loc = new Locale(lang);
    }

    public PFLocale(String lang, String country) {
        this.loc = new Locale(lang, country);
    }

    public PFLocale(String lang, String country, String variant) {
        this.loc = new Locale(lang, country, variant);
    }

    public String toString() {
        if (this.loc != ResourceManager.getDefaultLocale()) {
            return this.loc.getDisplayName(ResourceManager.getChoosenLocale());
        }
        return ResourceManager.getLanguageDependentString("EnglishDefaultKey");
    }

    public Locale getLocale() {
        return this.loc;
    }

    public String getLanguage() {
        return this.loc.getLanguage();
    }

    public String getCountry() {
        return this.loc.getCountry();
    }

    public String getVariant() {
        return this.loc.getVariant();
    }

    public String getLocaleString() {
        String locStr = "";
        if (this.loc == ResourceManager.getDefaultLocale()) {
            return "default";
        }
        locStr = this.loc.getLanguage();
        if (this.loc.getCountry().length() > 0) {
            locStr = locStr + "_" + this.loc.getCountry();
            if (this.loc.getVariant().length() > 0) {
                locStr = locStr + "_" + this.loc.getVariant();
            }
        }
        return locStr;
    }

    public boolean equals(Object pfLoc) {
        if (pfLoc instanceof PFLocale) {
            return this.loc.equals(((PFLocale)pfLoc).loc);
        }
        return false;
    }
}

