/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.ldap;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import org.enhydra.jawe.JaWE;
import org.enhydra.jawe.JaWEConfig;
import org.enhydra.jawe.PackageEditor;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.actions.ActionBase;
import org.enhydra.jawe.ldap.ExternalParticipants;
import org.enhydra.jawe.ldap.Security;
import org.enhydra.jawe.xml.XMLAttribute;
import org.enhydra.jawe.xml.XMLCollection;
import org.enhydra.jawe.xml.XMLElement;
import org.enhydra.jawe.xml.XMLElementDialog;
import org.enhydra.jawe.xml.elements.ExtendedAttribute;
import org.enhydra.jawe.xml.elements.ExtendedAttributes;
import org.enhydra.jawe.xml.elements.Participant;
import org.enhydra.jawe.xml.elements.ParticipantType;
import org.enhydra.jawe.xml.elements.Participants;
import org.enhydra.jawe.xml.panels.XMLComboPanel;
import org.enhydra.jawe.xml.panels.XMLPanel;

public class ImportExternalParticipants
extends ActionBase {
    private ExternalParticipants eps;
    private XMLAttribute idMapping = new XMLAttribute("ChooseAttributeNameForIdMapping", new String[]{"NoMapping", "uid", "userId"}, 0){

        public XMLPanel getPanel() {
            return new XMLComboPanel((XMLElement)this, null, XMLPanel.BOX_LAYOUT, false, true);
        }
    };

    public ImportExternalParticipants(PackageEditor editor) {
        super(editor);
    }

    public void actionPerformed(ActionEvent e) {
        PackageEditor pe = (PackageEditor)this.editor;
        if (!pe.isInitialized()) {
            pe.enterPackageID();
        }
        if (this.eps == null) {
            this.eps = new ExternalParticipants(pe.getXMLPackage());
        }
        XMLElementDialog d = new XMLElementDialog((JFrame)pe.getWindow(), ResourceManager.getLanguageDependentString("PackageKey") + " '" + pe.getXMLPackage().get("Id").toString() + "' - " + ResourceManager.getLanguageDependentString("ImportExternalParticipantsLabel"));
        d.editXMLElement(this.eps.getPanel(), true, false);
        if (!d.isCanceled()) {
            List allEntries = this.getEntries(this.eps);
            List selectedEntries = this.showDialog(this.editor.getWindow(), allEntries);
            if (selectedEntries.size() > 0) {
                this.createParticipants(selectedEntries);
            }
        }
    }

    private List getEntries(ExternalParticipants ep) {
        int ldapPort;
        ArrayList<SearchResult> entries = new ArrayList<SearchResult>();
        try {
            ldapPort = Integer.valueOf(ep.get("Port").toString());
        }
        catch (Exception ex) {
            System.err.println("Port invalid, using default port 389");
            ldapPort = 389;
        }
        int searchScope = ep.get("SearchScope").toValue().toString().equals("SCOPE_ONE") ? 1 : 2;
        boolean attributeOnly = false;
        String ldapHost = ep.get("Host").toString();
        String searchBase = ep.get("BaseDN").toString();
        String searchFilter = ep.get("ObjectClassFilter").toValue().toString().equals("AllListed") ? "(|(objectClass=organizationalUnit)(objectClass=organizationalRole)(objectClass=person)(objectClass=organizationalPerson)(objectClass=inetOrgPerson))" : "(objectClass=" + ep.get("ObjectClassFilter").toValue().toString() + ")";
        try {
            Properties env = new Properties();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.referral", "throw");
            env.put("java.naming.provider.url", "ldap://" + ldapHost + ":" + ldapPort);
            Security security = (Security)ep.get("Security");
            if (!security.get("Level").toValue().toString().equals("Anonymous")) {
                String ldapUser = security.get("UserDN").toString();
                String ldapPassword = security.get("Password").toString();
                env.put("java.naming.security.principal", ldapUser);
                env.put("java.naming.security.credentials", ldapPassword);
            }
            InitialDirContext ctx = new InitialDirContext(env);
            SearchControls constraints = new SearchControls();
            constraints.setSearchScope(searchScope);
            try {
                constraints.setCountLimit(JaWEConfig.getInstance().getLDAPCountLimit());
            }
            catch (Exception ex) {
                constraints.setCountLimit(0L);
            }
            try {
                constraints.setTimeLimit(JaWEConfig.getInstance().getLDAPTimeLimit());
            }
            catch (Exception ex) {
                constraints.setTimeLimit(0);
            }
            NamingEnumeration<SearchResult> results = ctx.search(searchBase, searchFilter, constraints);
            while (results.hasMore()) {
                SearchResult sr = results.next();
                entries.add(sr);
            }
            ctx.close();
        }
        catch (NamingException e) {
            if (e.getMessage().indexOf("Sizelimit Exceeded") != -1) {
                JaWE.getInstance().message(ResourceManager.getLanguageDependentString("ErrorLDAPSearchPartiallyFailedSizelimitExceeded"), 0);
            } else if (e.getMessage().indexOf("Timelimit Exceeded") != -1) {
                JaWE.getInstance().message(ResourceManager.getLanguageDependentString("ErrorLDAPSearchPartiallyFailedTimelimitExceeded"), 0);
            } else {
                JaWE.getInstance().message(ResourceManager.getLanguageDependentString("ErrorLDAPSearchFailed"), 0);
            }
            System.err.println("Search failed: " + e.getMessage());
        }
        catch (Exception e) {
            JaWE.getInstance().message(ResourceManager.getLanguageDependentString("ErrorLDAPSearchFailed"), 0);
            System.err.println("Non-naming error: " + e.getMessage());
        }
        return entries;
    }

    private List showDialog(Window parent, final List allEntries) {
        String title = ResourceManager.getLanguageDependentString("DialogLDAPEntries");
        final JDialog myDialog = parent instanceof JDialog ? new JDialog((JDialog)parent, title, true) : new JDialog((JFrame)parent, title, true);
        final XMLPanel idp = this.idMapping.getPanel();
        final ArrayList selectedEntries = new ArrayList();
        Dimension listFieldDimension = new Dimension(800, 500);
        JScrollPane scrollActivities = new JScrollPane();
        final JList<Object> entries = new JList<Object>(allEntries.toArray());
        scrollActivities.setViewportView(entries);
        scrollActivities.setPreferredSize(new Dimension(listFieldDimension));
        JPanel pm = new JPanel();
        Border emptyb = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        AbstractBorder inb = BorderFactory.createMatteBorder(1, 1, 1, 1, Color.darkGray);
        inb = BorderFactory.createTitledBorder(inb, ResourceManager.getLanguageDependentString("SelectActivityKey"));
        pm.setBorder(BorderFactory.createCompoundBorder(emptyb, inb));
        pm.setLayout(new BoxLayout(pm, 1));
        pm.add((Component)idp);
        pm.add(scrollActivities);
        JPanel btnPanel = new JPanel();
        JButton dialogImportAllButton = new JButton(ResourceManager.getLanguageDependentString("ImportAllKey"));
        URL u = ResourceManager.getResource("ImportAllImage");
        if (u != null) {
            dialogImportAllButton.setIcon(new ImageIcon(u));
        }
        dialogImportAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                idp.setElements();
                selectedEntries.addAll(allEntries);
                myDialog.dispose();
            }
        });
        btnPanel.add(dialogImportAllButton);
        JButton dialogImportSelectedButton = new JButton(ResourceManager.getLanguageDependentString("ImportSelectedKey"));
        u = ResourceManager.getResource("ImportSelectedImage");
        if (u != null) {
            dialogImportSelectedButton.setIcon(new ImageIcon(u));
        }
        dialogImportSelectedButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                idp.setElements();
                selectedEntries.addAll(Arrays.asList(entries.getSelectedValues()));
                myDialog.dispose();
            }
        });
        btnPanel.add(dialogImportSelectedButton);
        JButton dialogCancelButton = new JButton(ResourceManager.getLanguageDependentString("CancelKey"));
        u = ResourceManager.getResource("CancelImage");
        if (u != null) {
            dialogCancelButton.setIcon(new ImageIcon(u));
        }
        dialogCancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                myDialog.dispose();
            }
        });
        btnPanel.add(dialogCancelButton);
        Container cp = myDialog.getContentPane();
        cp.setLayout(new BorderLayout());
        cp.add((Component)pm, "Center");
        cp.add((Component)btnPanel, "South");
        myDialog.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0, false), "Cancel");
        myDialog.getRootPane().getActionMap().put("Cancel", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                myDialog.dispose();
            }
        });
        myDialog.pack();
        myDialog.setLocationRelativeTo(parent);
        myDialog.setResizable(true);
        myDialog.show();
        return selectedEntries;
    }

    private void createParticipants(List allEntries) {
        PackageEditor pe = (PackageEditor)this.editor;
        Participants ps = (Participants)pe.getXMLPackage().get("Participants");
        Iterator iter = allEntries.iterator();
        String mappingAttribute = this.idMapping.toValue().toString();
        while (iter.hasNext()) {
            String pType;
            String val;
            Participant p = (Participant)ps.generateNewElement();
            SearchResult nextEntry = (SearchResult)iter.next();
            Attributes attributes = nextEntry.getAttributes();
            String objectClass = null;
            NamingEnumeration<?> allObjClasses = null;
            try {
                allObjClasses = attributes.get("objectClass").getAll();
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (allObjClasses != null) {
                while (allObjClasses.hasMoreElements()) {
                    val = (String)allObjClasses.nextElement();
                    if (val.toLowerCase().endsWith("person")) {
                        objectClass = val;
                        break;
                    }
                    if (!val.equals("organizationalRole")) continue;
                    objectClass = val;
                    break;
                }
            }
            if (objectClass == null) {
                try {
                    allObjClasses = attributes.get("objectClass").getAll();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (allObjClasses != null) {
                    while (allObjClasses.hasMoreElements()) {
                        val = (String)allObjClasses.nextElement();
                        if (!val.equals("organizationalUnit")) continue;
                        objectClass = val;
                        break;
                    }
                }
            }
            if (objectClass == null) {
                try {
                    objectClass = (String)attributes.get("objectClass").get();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (objectClass == null) {
                objectClass = "organizationalRole";
            }
            String name = null;
            String description = null;
            try {
                description = (String)attributes.get("description").get();
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (objectClass.toLowerCase().endsWith("person")) {
                pType = ResourceManager.getLanguageDependentString("HUMANKey");
                try {
                    name = (String)attributes.get("cn").get();
                }
                catch (Exception ex) {}
            } else {
                pType = objectClass.equals("organizationalRole") ? ResourceManager.getLanguageDependentString("ROLEKey") : (objectClass.equals("organizationalUnit") ? ResourceManager.getLanguageDependentString("ORGANIZATIONAL_UNITKey") : ResourceManager.getLanguageDependentString("ROLEKey"));
            }
            if (name == null) {
                try {
                    int ind1 = nextEntry.getName().indexOf("=") + 1;
                    int ind2 = nextEntry.getName().indexOf(",");
                    if (ind2 == -1) {
                        ind2 = nextEntry.getName().length();
                    }
                    name = nextEntry.getName().substring(ind1, ind2);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            String id = p.getID();
            if (!mappingAttribute.equals("NoMapping")) {
                String userId = null;
                try {
                    userId = (String)attributes.get(mappingAttribute).get();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (userId != null && ps.getCollectionElement(userId) == null && XMLCollection.isIdValid((String)userId)) {
                    id = userId;
                }
            }
            p.set("Id", (Object)id);
            if (name != null) {
                p.set("Name", (Object)name);
            }
            ((ParticipantType)p.get("ParticipantType")).set("Type", (Object)pType);
            if (description != null) {
                p.set("Description", (Object)description);
            }
            ExtendedAttributes eas = (ExtendedAttributes)p.get("ExtendedAttributes");
            ExtendedAttribute ea = new ExtendedAttribute(eas);
            ea.set("Name", (Object)"DN");
            String eaVal = nextEntry.getName();
            ea.set("Value", (Object)eaVal);
            eas.add((XMLElement)ea);
            ps.add((XMLElement)p);
            JaWE.getInstance().setModified(true);
        }
    }

    public void refreshLabels() {
        if (this.eps != null) {
            this.eps.refreshLabelName();
        }
        this.idMapping.refreshLabelName();
    }
}

