/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.graph;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.enhydra.jawe.AbstractGraph;
import org.enhydra.jawe.JaWEGraphModel;
import org.enhydra.jawe.JaWEMarqueeHandler;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.graph.Activity;
import org.enhydra.jawe.graph.End;
import org.enhydra.jawe.graph.Start;
import org.enhydra.jawe.graph.Transition;
import org.enhydra.jawe.graph.TransitionRenderer;
import org.jgraph.JGraph;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphCell;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.PortView;

public class TransitionView
extends EdgeView {
    public TransitionView(Object cell, JGraph graph, CellMapper mapper) {
        super(cell, graph, mapper);
        renderer = new TransitionRenderer();
    }

    public CellHandle getHandle(GraphContext context) {
        return new TransitionHandle(this, context);
    }

    public void addPoint(Point popupPoint) {
        boolean bendable;
        boolean bl = bendable = this.graph.isBendable() && GraphConstants.isBendable((Map)this.getAttributes());
        if (bendable) {
            int index = -1;
            int s = this.graph.getHandleSize();
            Rectangle rect = new Rectangle(popupPoint.x - s, popupPoint.y - s, 2 * s, 2 * s);
            if (this.intersects(this.graph.getGraphics(), rect)) {
                Point point = (Point)this.graph.snap((Point2D)new Point(popupPoint));
                double min = Double.MAX_VALUE;
                double dist = 0.0;
                for (int i = 0; i < this.getPointCount() - 1; ++i) {
                    Point p1;
                    Point p = new Point((int)this.getPoint(i).getX(), (int)this.getPoint(i).getY());
                    dist = new Line2D.Double(p, p1 = new Point((int)this.getPoint(i + 1).getX(), (int)this.getPoint(i + 1).getY())).ptLineDistSq(point);
                    if (!(dist < min)) continue;
                    min = dist;
                    index = i + 1;
                }
                if (index != -1) {
                    this.addPoint(index, point);
                    HashMap<Object, Map> propertyMap = new HashMap<Object, Map>();
                    Map edgeMap = GraphConstants.cloneMap((Map)((GraphCell)this.cell).getAttributes());
                    GraphConstants.setPoints((Map)edgeMap, (List)this.points);
                    propertyMap.put(this.cell, edgeMap);
                    String undoMsg = ResourceManager.getLanguageDependentString("MessageAddingBreakPointAtTransition");
                    ((JaWEGraphModel)this.getModel()).insertAndEdit(null, propertyMap, null, null, null, undoMsg);
                }
            }
        }
    }

    public void addPointProgramatically(Point popupPoint, int index) {
        if (popupPoint == null) {
            return;
        }
        int s = this.graph.getHandleSize();
        if (index < 1) {
            index = 1;
        }
        if (index > this.getPointCount() - 1) {
            index = this.getPointCount() - 1;
        }
        try {
            this.addPoint(index, new Point(popupPoint));
            HashMap<Object, Map> propertyMap = new HashMap<Object, Map>();
            Map edgeMap = GraphConstants.cloneMap((Map)((GraphCell)this.cell).getAttributes());
            GraphConstants.setPoints((Map)edgeMap, (List)this.points);
            propertyMap.put(this.cell, edgeMap);
            String undoMsg = ResourceManager.getLanguageDependentString("MessageAddingBreakPointAtTransition");
            ((JaWEGraphModel)this.getModel()).insertAndEdit(null, propertyMap, null, null, null, undoMsg);
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public void removePoint(Point popupPoint) {
        boolean bendable;
        boolean bl = bendable = this.graph.isBendable() && GraphConstants.isBendable((Map)this.getAttributes());
        if (bendable) {
            int index = -1;
            int s = this.graph.getHandleSize();
            Rectangle rect = new Rectangle(popupPoint.x - s, popupPoint.y - s, 2 * s, 2 * s);
            if (this.intersects(this.graph.getGraphics(), rect)) {
                Point point = (Point)this.graph.snap((Point2D)new Point(popupPoint));
                double min = Double.MAX_VALUE;
                double dist = 0.0;
                for (int i = 0; i < this.getPointCount(); ++i) {
                    Point p = new Point((int)this.getPoint(i).getX(), (int)this.getPoint(i).getY());
                    dist = Math.sqrt(point.distanceSq(p));
                    if (!(dist < min)) continue;
                    min = dist;
                    index = i;
                }
                if (index != -1 && min <= (double)(s + 2) && index != 0 && index != this.getPointCount() - 1) {
                    this.removePoint(index);
                    HashMap<Object, Map> propertyMap = new HashMap<Object, Map>();
                    Map edgeMap = GraphConstants.cloneMap((Map)((GraphCell)this.cell).getAttributes());
                    GraphConstants.setPoints((Map)edgeMap, (List)this.points);
                    propertyMap.put(this.cell, edgeMap);
                    String undoMsg = ResourceManager.getLanguageDependentString("MessageRemovingBreakPointFromTransition");
                    ((JaWEGraphModel)this.getModel()).insertAndEdit(null, propertyMap, null, null, null, undoMsg);
                }
            }
        }
    }

    public boolean isAddPointEvent(MouseEvent event) {
        return false;
    }

    public boolean isRemovePointEvent(MouseEvent event) {
        return false;
    }

    public static class TransitionHandle
    extends EdgeView.EdgeHandle {
        public TransitionHandle(EdgeView edge, GraphContext ctx) {
            super(edge, ctx);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseReleased(MouseEvent e) {
            try {
                if (this.source || this.target) {
                    Transition tr = (Transition)this.edge.getCell();
                    PortView ss = (PortView)this.graph.getGraphLayoutCache().getMapping(tr.getSource(), false);
                    PortView tt = (PortView)this.graph.getGraphLayoutCache().getMapping(tr.getTarget(), false);
                    PortView pvs = (PortView)this.edge.getSource();
                    PortView pvt = (PortView)this.edge.getTarget();
                    Activity s1 = tr.getSourceActivity();
                    Activity t1 = tr.getTargetActivity();
                    Activity s2 = null;
                    try {
                        s2 = (Activity)((Object)((DefaultPort)pvs.getCell()).getParent());
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    Activity t2 = null;
                    try {
                        t2 = (Activity)((Object)((DefaultPort)pvt.getCell()).getParent());
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    if (s2 == null || t2 == null) {
                        this.clean(tr);
                        return;
                    }
                    if (ss != pvs || tt != pvt) {
                        JaWEMarqueeHandler jmh = (JaWEMarqueeHandler)this.graph.getMarqueeHandler();
                        org.enhydra.jawe.xml.elements.Transition uo = (org.enhydra.jawe.xml.elements.Transition)tr.getPropertyObject();
                        if (ss != pvs) {
                            boolean accept = !(s1 instanceof Start) && !(s2 instanceof Start) && !(t1 instanceof End) && jmh.acceptsSourceOrTarget(pvs, true, pvt, false);
                            System.out.println("accept-" + accept);
                            if (!accept) {
                                this.clean(tr);
                                return;
                            }
                            this.setChanges();
                            uo.setFrom(s2.getPropertyObject());
                            ((AbstractGraph)this.graph).getWorkflowManager().updateSplit(s2);
                            ((AbstractGraph)this.graph).getWorkflowManager().updateSplit(s1);
                        } else {
                            boolean accept;
                            boolean bl = accept = !(t1 instanceof End) && !(t2 instanceof End) && !(s1 instanceof Start) && jmh.acceptsSourceOrTarget(pvt, false, pvs, false);
                            if (!accept) {
                                this.clean(tr);
                                return;
                            }
                            this.setChanges();
                            uo.setTo(t2.getPropertyObject());
                            ((AbstractGraph)this.graph).getWorkflowManager().updateJoin(t2);
                            ((AbstractGraph)this.graph).getWorkflowManager().updateJoin(t1);
                        }
                        return;
                    }
                }
                this.setChanges();
            }
            finally {
                e.consume();
            }
        }

        private void setChanges() {
            ConnectionSet cs = this.createConnectionSet(this.edge, this.edge.getCell(), false);
            Map nested = GraphConstants.createAttributes((Object[])new CellView[]{this.edge}, null);
            this.graph.getGraphLayoutCache().edit(nested, cs, null, null);
        }

        private void clean(Transition tr) {
            Graphics g = this.graph.getGraphics();
            this.overlay(g);
            this.firstOverlayCall = true;
            this.graph.removeSelectionCell((Object)tr);
        }
    }
}

