/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import org.enhydra.jawe.JaWEConfig;
import org.enhydra.jawe.Utils;
import org.enhydra.jawe.graph.Transition;
import org.enhydra.jawe.xml.elements.Condition;
import org.jgraph.graph.EdgeRenderer;
import org.jgraph.graph.GraphConstants;

public class TransitionRenderer
extends EdgeRenderer {
    public void paint(Graphics g) {
        Transition tr = (Transition)this.view.getCell();
        this.lineWidth = tr.hasCondition() ? 3.0f : 1.0f;
        Color clr = Utils.getColor(JaWEConfig.getInstance().getTransitionColor());
        String ttype = tr.getType();
        if (ttype.equals(Condition.CONDITION_TYPE_DEFAULTEXCEPTION)) {
            clr = Utils.getColor(JaWEConfig.getInstance().getDefaultExceptionTransitionColor());
        } else if (ttype.equals(Condition.CONDITION_TYPE_EXCEPTION)) {
            clr = Utils.getColor(JaWEConfig.getInstance().getExceptionTransitionColor());
        } else if (ttype.equals(Condition.CONDITION_TYPE_OTHERWISE)) {
            clr = Utils.getColor(JaWEConfig.getInstance().getOtherwiseTransitionColor());
        }
        Shape edgeShape = this.view.getShape();
        if (edgeShape != null) {
            String label;
            Graphics2D g2 = (Graphics2D)g;
            int c = 0;
            int j = 0;
            g2.setStroke(new BasicStroke(this.lineWidth, c, j));
            this.translateGraphics(g);
            g.setColor(clr);
            if (this.view.beginShape != null) {
                if (this.beginFill) {
                    g2.fill(this.view.beginShape);
                }
                g2.draw(this.view.beginShape);
            }
            if (this.view.endShape != null) {
                if (this.endFill) {
                    g2.fill(this.view.endShape);
                }
                g2.draw(this.view.endShape);
            }
            if (this.lineDash != null) {
                g2.setStroke(new BasicStroke(this.lineWidth, c, j, 10.0f, this.lineDash, 0.0f));
            }
            if (this.view.lineShape != null) {
                g2.draw(this.view.lineShape);
            }
            if (this.selected) {
                g2.setStroke(GraphConstants.SELECTION_STROKE);
                g2.setColor(this.graph.getHighlightColor());
                if (this.view.beginShape != null) {
                    g2.draw(this.view.beginShape);
                }
                if (this.view.lineShape != null) {
                    g2.draw(this.view.lineShape);
                }
                if (this.view.endShape != null) {
                    g2.draw(this.view.endShape);
                }
            }
            if (this.graph.getEditingCell() != this.view.getCell() && (label = this.graph.convertValueToString((Object)this.view)) != null) {
                g2.setStroke(new BasicStroke(1.0f));
                g.setFont(this.getFont());
                this.paintLabel(g, label.toString());
            }
        }
    }
}

