/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import org.enhydra.jawe.JaWEConfig;
import org.enhydra.jawe.Utils;
import org.enhydra.jawe.graph.MultiLinedRenderer;
import org.jgraph.graph.GraphConstants;

public class ProcessRenderer
extends MultiLinedRenderer {
    private BasicStroke borderStroke = new BasicStroke(2.0f);
    protected static final int procW = JaWEConfig.getInstance().getProcessWidth();
    protected static final int procH = JaWEConfig.getInstance().getProcessHeight();
    protected static final int rrW = 54;
    protected static final int rrH = 42;
    protected static final int innerW = procW - 18;
    protected static final int innerH = procH - 14;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        Color fillCol = Utils.getColor(JaWEConfig.getInstance().getProcessColor());
        int b = this.borderWidth;
        Graphics2D g2 = (Graphics2D)g;
        Object AntiAlias = RenderingHints.VALUE_ANTIALIAS_ON;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, AntiAlias);
        Dimension d = this.getSize();
        boolean tmp = this.selected;
        Color gridC = this.graph.getGridColor();
        Color highlightC = this.graph.getHighlightColor();
        Color bckgC = fillCol;
        Color borderC = this.bordercolor;
        if (this.selected) {
            bckgC = Utils.getColor(JaWEConfig.getInstance().getSelectedActivityColor());
        }
        if (super.isOpaque()) {
            g.setColor(fillCol);
            g.fillRoundRect(b - 1, b - 1, d.width - b, d.height - b, 54, 42);
        }
        try {
            this.setBorder(null);
            this.setOpaque(false);
            this.selected = false;
            Graphics gl = g.create(9, 7, innerW, innerH);
            Rectangle labelRect = new Rectangle(new Dimension(innerW, innerH));
            super.setBounds(labelRect);
            this.graph.setGridColor(bckgC);
            this.graph.setHighlightColor(bckgC);
            super.paint(gl);
            this.setForeground(this.bordercolor);
            this.graph.setGridColor(gridC);
            this.graph.setHighlightColor(highlightC);
        }
        finally {
            this.selected = tmp;
        }
        if (this.bordercolor != null) {
            g.setColor(this.bordercolor);
            g2.setStroke(this.borderStroke);
            g.drawRoundRect(b - 1, b - 1, d.width - b, d.height - b, 54, 42);
        }
        if (this.selected) {
            g2.setStroke(GraphConstants.SELECTION_STROKE);
            g.setColor(this.graph.getHighlightColor());
            g.drawRoundRect(b - 1, b - 1, d.width - b, d.height - b, 54, 42);
        }
    }

    protected Color getFillColor() {
        return Utils.getColor(JaWEConfig.getInstance().getGenericActivityColor());
    }
}

