/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.graph;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Map;
import org.enhydra.jawe.JaWEConfig;
import org.enhydra.jawe.JaWEConstants;
import org.enhydra.jawe.Utils;
import org.enhydra.jawe.graph.Participant;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.VertexRenderer;

public class ParticipantRenderer
extends VertexRenderer {
    protected static final int participantNameWidth = JaWEConfig.getInstance().getParticipantNameWidth();

    public void paint(Graphics g) {
        String label = this.graph.convertValueToString(this.view.getCell());
        Graphics2D g2 = (Graphics2D)g;
        Dimension d = this.view.getBounds().getBounds().getSize();
        g2.setStroke(JaWEConstants.DEPARTMENT_STROKE);
        Color bordCol = Utils.getColor(JaWEConfig.getInstance().getParticipantBorderColor());
        g.setColor(bordCol);
        g.drawRect(0, 0, d.width - 1, d.height - 1);
        Participant p = (Participant)this.view.getCell();
        if (p.getUserObject() == org.enhydra.jawe.xml.elements.Participant.getFreeTextExpressionParticipant()) {
            g.setColor(Utils.getColor(JaWEConfig.getInstance().getFreeTextExpressionParticipantColor()));
            g.fillRect(1, 1, d.width - 3, d.height - 3);
            g.setColor(bordCol);
        } else {
            String pt = p.get("ParticipantType").toValue().toString();
            Color pc = pt.equals("RESOURCE_SET") ? Utils.getColor(JaWEConfig.getInstance().getResourceSetParticipantColor()) : (pt.equals("RESOURCE") ? Utils.getColor(JaWEConfig.getInstance().getResourceParticipantColor()) : (pt.equals("ROLE") ? Utils.getColor(JaWEConfig.getInstance().getRoleParticipantColor()) : (pt.equals("ORGANIZATIONAL_UNIT") ? Utils.getColor(JaWEConfig.getInstance().getOrganizationalUnitParticipantColor()) : (pt.equals("HUMAN") ? Utils.getColor(JaWEConfig.getInstance().getHumanParticipantColor()) : Utils.getColor(JaWEConfig.getInstance().getSystemParticipantColor())))));
            g.setColor(pc);
            g.fillRect(1, 1, participantNameWidth - 2, d.height - 3);
            g.setColor(bordCol);
        }
        g.drawLine(participantNameWidth, 0, participantNameWidth, d.height - 1);
        if (this.selected) {
            g2.setStroke(GraphConstants.SELECTION_STROKE);
            g.setColor(this.graph.getHighlightColor());
            g.drawRect(0, 0, d.width - 1, d.height - 1);
            g.drawLine(participantNameWidth, 0, participantNameWidth, d.height - 1);
        }
        if (label != null) {
            if (!this.selected) {
                g2.setStroke(JaWEConstants.DEPARTMENT_STROKE);
                g.setColor(Utils.getColor(JaWEConfig.getInstance().getParticipantTextColor()));
            }
            Font f = GraphConstants.getFont((Map)this.view.getAllAttributes());
            g2.setFont(f);
            int h = this.getFontMetrics(f).stringWidth(label);
            h = d.height / 2 + h / 2;
            g2.translate(participantNameWidth / 2, h);
            g2.rotate(Math.toRadians(-90.0));
            g2.drawString(label, 0, 0);
        }
    }
}

