/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.enhydra.jawe.JaWEConfig;
import org.jgraph.JGraph;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.VertexView;

public class MultiLinedRenderer
extends JTextArea
implements CellViewRenderer {
    protected transient JGraph graph;
    protected transient VertexView view;
    protected transient boolean hasFocus;
    protected transient boolean selected;
    protected transient boolean preview;
    protected transient boolean opaque;
    protected transient Color defaultForeground = UIManager.getColor("Tree.textForeground");
    protected transient Color defaultBackground = UIManager.getColor("Tree.textBackground");
    protected transient Color bordercolor;
    protected transient int borderWidth;
    transient boolean isDoubleBuffered = false;

    public MultiLinedRenderer() {
        this.setLineWrap(JaWEConfig.getInstance().getNameWrappingStatus());
        this.setWrapStyleWord(JaWEConfig.getInstance().getWrappingStyleWordStatus());
    }

    public Component getRendererComponent(JGraph graph, CellView view, boolean sel, boolean focus, boolean preview) {
        this.setLineWrap(JaWEConfig.getInstance().getNameWrappingStatus());
        this.setWrapStyleWord(JaWEConfig.getInstance().getWrappingStyleWordStatus());
        this.graph = graph;
        this.isDoubleBuffered = graph.isDoubleBuffered();
        if (view instanceof VertexView) {
            this.view = (VertexView)view;
            this.setText(view.getCell().toString());
            if (graph.getEditingCell() != view.getCell()) {
                String label = graph.convertValueToString((Object)view);
                if (label != null) {
                    this.setText(label.toString());
                } else {
                    this.setText(null);
                }
            } else {
                this.setText(null);
            }
            this.graph = graph;
            this.hasFocus = focus;
            this.selected = sel;
            this.preview = preview;
            Map attributes = view.getAllAttributes();
            this.installAttributes(graph, attributes);
            return this;
        }
        return null;
    }

    protected void installAttributes(JGraph graph, Map attributes) {
        this.setOpaque(GraphConstants.isOpaque((Map)attributes));
        Color foreground = GraphConstants.getForeground((Map)attributes);
        this.setForeground(foreground != null ? foreground : graph.getForeground());
        Color background = GraphConstants.getBackground((Map)attributes);
        this.setBackground(background != null ? background : graph.getBackground());
        Font font = GraphConstants.getFont((Map)attributes);
        this.setFont(font != null ? font : graph.getFont());
        Border border = GraphConstants.getBorder((Map)attributes);
        this.bordercolor = GraphConstants.getBorderColor((Map)attributes);
        if (border != null) {
            this.setBorder(border);
        } else if (this.bordercolor != null) {
            this.borderWidth = Math.max(1, Math.round(GraphConstants.getLineWidth((Map)attributes)));
            this.setBorder(BorderFactory.createLineBorder(this.bordercolor, this.borderWidth));
        }
    }
}

