/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.graph;

import java.util.Iterator;
import java.util.Set;
import org.enhydra.jawe.JaWEConfig;
import org.enhydra.jawe.ProcessEditor;
import org.enhydra.jawe.ProcessGraph;
import org.enhydra.jawe.Utils;
import org.enhydra.jawe.graph.BlockActivity;
import org.enhydra.jawe.graph.BlockActivityEditor;
import org.enhydra.jawe.xml.PackageValidator;
import org.enhydra.jawe.xml.XMLComplexElement;
import org.enhydra.jawe.xml.XMLElement;
import org.enhydra.jawe.xml.elements.Activity;
import org.enhydra.jawe.xml.elements.ActivitySet;
import org.enhydra.jawe.xml.elements.ActivitySets;
import org.enhydra.jawe.xml.elements.WorkflowProcess;
import org.jgraph.graph.GraphModel;

public class BlockActivityGraph
extends ProcessGraph {
    private BlockActivity myBlockActivity;

    public BlockActivityGraph() {
        this((GraphModel)null, (BlockActivityEditor)null);
    }

    public BlockActivityGraph(GraphModel model, BlockActivityEditor pe) {
        super(model, pe);
    }

    public void setMyBlockActivity(BlockActivity ba) {
        this.myBlockActivity = ba;
    }

    public BlockActivity getMyBlockActivity() {
        return this.myBlockActivity;
    }

    protected void updateXMLObjectsBeforeChecking() {
        Set blockActs = this.getWorkflowManager().getBlockActivities(true);
        blockActs.add(this.myBlockActivity);
        Iterator itBas = blockActs.iterator();
        while (itBas.hasNext()) {
            BlockActivity ba = (BlockActivity)itBas.next();
            ProcessEditor bwe = ba.getImplementationEditor();
            Activity bap = (Activity)ba.getUserObject();
            bap.setStartDescriptions(Utils.getStartDescriptions(bwe));
            bap.setEndDescriptions(Utils.getEndDescriptions(bwe));
        }
    }

    public boolean checkLogic(boolean fullCheck) {
        PackageValidator pv = new PackageValidator(this.getXMLPackage(), true, true, false, false, JaWEConfig.getInstance().getAllowUndefinedStartActivity(), JaWEConfig.getInstance().getAllowUndefinedEndActivity(), JaWEConfig.getInstance().getEncoding());
        boolean isLogical = pv.checkActivitySet((ActivitySet)this.getXPDLObject(), fullCheck);
        this.basicLogicError = pv.getBasicLogicError((XMLComplexElement)((ActivitySet)this.getXPDLObject()));
        this.logicErrors = pv.getLogicErrors((XMLComplexElement)((ActivitySet)this.getXPDLObject()));
        return isLogical;
    }

    public XMLElement getXPDLObject() {
        try {
            String ID = this.myBlockActivity.getBlockID();
            ActivitySet as = ((ActivitySets)((WorkflowProcess)this.xmlObject).get("ActivitySets")).getActivitySet(ID);
            return as;
        }
        catch (Exception ex) {
            return null;
        }
    }
}

