/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import org.enhydra.jawe.JaWEConfig;
import org.enhydra.jawe.Utils;
import org.enhydra.jawe.graph.Activity;
import org.enhydra.jawe.graph.MultiLinedRenderer;
import org.enhydra.jawe.xml.XMLUtil;
import org.jgraph.graph.GraphConstants;

public class ActivityRenderer
extends MultiLinedRenderer {
    private BasicStroke borderStroke = new BasicStroke(2.0f);
    protected static final int actW = JaWEConfig.getInstance().getActivityWidth();
    protected static final int actH = JaWEConfig.getInstance().getActivityHeight();
    protected static final int innerW = JaWEConfig.getInstance().getInnerActivityWidth();
    protected static final int innerH = JaWEConfig.getInstance().getInnerActivityHeight();
    protected static final int xOff = (actW - innerW) / 2;
    protected static final int yOff = (actH - innerH) / 2;

    public void paint(Graphics g) {
        Activity act = (Activity)this.view.getCell();
        Color fillColor = this.getFillColor();
        Color gridC = this.graph.getGridColor();
        Color highlightC = this.graph.getHighlightColor();
        Color bckgC = fillColor;
        Color borderC = this.bordercolor;
        if (this.selected) {
            bckgC = Utils.getColor(JaWEConfig.getInstance().getSelectedActivityColor());
        }
        super.setBackground(bckgC);
        int[] xo = new int[]{0, actW - 1, actW - 1, actW - 1, 0, 0};
        int[] yo = new int[]{0, 0, actH / 2, actH - 1, actH - 1, actH / 2};
        int[] xi = new int[]{1, actW - 2, actW - 2, actW - 2, 1, 1};
        int[] yi = new int[]{1, 1, actH / 2, actH - 2, actH - 2, actH / 2};
        if (XMLUtil.isANDTypeSplitOrJoin((org.enhydra.jawe.xml.elements.Activity)((org.enhydra.jawe.xml.elements.Activity)act.getPropertyObject()), (int)1)) {
            xo[5] = xOff - 3;
            xi[5] = xOff - 2;
        }
        if (XMLUtil.isANDTypeSplitOrJoin((org.enhydra.jawe.xml.elements.Activity)((org.enhydra.jawe.xml.elements.Activity)act.getPropertyObject()), (int)0)) {
            xo[1] = actW - xOff + 3;
            xo[3] = actW - xOff + 3;
            xi[1] = actW - xOff + 2;
            xi[3] = actW - xOff + 2;
        }
        int points = 6;
        g.setColor(bckgC);
        g.fillPolygon(xo, yo, points);
        g.setColor(this.bordercolor);
        ((Graphics2D)g).setStroke(this.borderStroke);
        g.drawPolygon(xi, yi, points);
        if (this.selected || this.hasFocus) {
            ((Graphics2D)g).setStroke(GraphConstants.SELECTION_STROKE);
            if (this.hasFocus) {
                g.setColor(this.graph.getGridColor());
            } else if (this.selected) {
                g.setColor(this.graph.getHighlightColor());
            }
            g.drawPolygon(xo, yo, points);
        }
        Graphics gl = g.create(xOff, yOff, innerW, innerH);
        Rectangle labelRect = new Rectangle(new Dimension(innerW, innerH));
        super.setBounds(labelRect);
        this.graph.setGridColor(bckgC);
        this.graph.setHighlightColor(bckgC);
        this.setBorder(BorderFactory.createLineBorder(bckgC, this.borderWidth));
        super.paint(gl);
        this.setBorder(BorderFactory.createLineBorder(this.bordercolor, this.borderWidth));
        this.setForeground(this.bordercolor);
        this.graph.setGridColor(gridC);
        this.graph.setHighlightColor(highlightC);
    }

    protected Color getFillColor() {
        Color c = Utils.getColor(JaWEConfig.getInstance().getGenericActivityColor());
        return ActivityRenderer.getFillColor(c, (Activity)this.view.getCell());
    }

    protected static Color getFillColor(Color defaultColor, Activity act) {
        if (!JaWEConfig.getInstance().getUseBubblesStatus()) {
            boolean isStartingAct = Utils.isStartingActivity(act);
            boolean isEndingAct = Utils.isEndingActivity(act);
            if (isStartingAct && isEndingAct) {
                return Utils.getColor(JaWEConfig.getInstance().getStartEndColor());
            }
            if (isStartingAct) {
                return Utils.getColor(JaWEConfig.getInstance().getStartColor());
            }
            if (isEndingAct) {
                return Utils.getColor(JaWEConfig.getInstance().getEndColor());
            }
        }
        return defaultColor;
    }
}

