/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.config;

import java.util.ArrayList;
import org.enhydra.jawe.config.BaseConfigPane;

public class ConfigElements {
    private String name;
    private ArrayList members;

    public ConfigElements(String name) {
        this.name = name;
        this.members = new ArrayList();
    }

    public String getName() {
        return this.name;
    }

    public void addOptionPane(BaseConfigPane pane) {
        if (this.members.indexOf(pane) != -1) {
            return;
        }
        this.members.add(pane);
    }

    public ArrayList getMembers() {
        return this.members;
    }

    public Object getMember(int index) {
        return index >= 0 && index < this.members.size() ? this.members.get(index) : null;
    }

    public int getMemberIndex(Object member) {
        return this.members.indexOf(member);
    }

    public int getMemberCount() {
        return this.members.size();
    }

    public void save() {
        for (int i = 0; i < this.members.size(); ++i) {
            Object elem = this.members.get(i);
            try {
                if (!(elem instanceof BaseConfigPane)) continue;
                ((BaseConfigPane)elem).save();
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void readConf() {
        for (int i = 0; i < this.members.size(); ++i) {
            Object elem = this.members.get(i);
            try {
                if (!(elem instanceof BaseConfigPane)) continue;
                ((BaseConfigPane)elem).readConf();
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void refreshLanguageDependentStrings() {
        for (int i = 0; i < this.members.size(); ++i) {
            Object elem = this.members.get(i);
            try {
                if (!(elem instanceof BaseConfigPane)) continue;
                ((BaseConfigPane)elem).refreshLanguageDependentStrings();
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

