/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.config;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.enhydra.jawe.JaWE;
import org.enhydra.jawe.JaWEConfig;
import org.enhydra.jawe.PackageEditor;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.Utils;
import org.enhydra.jawe.config.BaseConfigPane;
import org.enhydra.jawe.config.CfgColors;
import org.enhydra.jawe.config.CfgGeneral;
import org.enhydra.jawe.config.CfgLDAP;
import org.enhydra.jawe.config.CfgObjectSize;
import org.enhydra.jawe.config.CfgUI;
import org.enhydra.jawe.config.ConfigElements;

public class ConfigDialog
extends JDialog
implements ActionListener,
TreeSelectionListener {
    private static PackageEditor parent;
    private JTree paneTree;
    private OptionTreeModel treeModel;
    private ConfigElements jaweOptionsRoot;
    private static ConfigDialog optionsDialog;
    private String currPaneName;
    private JPanel cardPanel;
    private JPanel configsPanel;
    private JButton okButton;
    private JButton cancelButton;
    private JButton applyButton;
    private JButton restoreDefaultButton;
    static /* synthetic */ Class class$javax$swing$event$TreeModelListener;

    public static ConfigDialog getInstance() {
        if (optionsDialog == null) {
            parent = JaWE.getInstance().getPackageEditor();
            optionsDialog = new ConfigDialog((JFrame)parent.getWindow());
        }
        return optionsDialog;
    }

    public void showConfigDialog() {
        optionsDialog.refresh();
        optionsDialog.setVisible(true);
        SwingUtilities.updateComponentTreeUI(ConfigDialog.getInstance());
    }

    private void refresh() {
        ArrayList cfgPanes = this.jaweOptionsRoot.getMembers();
        for (int i = 0; i < cfgPanes.size(); ++i) {
            ((BaseConfigPane)cfgPanes.get(i)).readConf();
        }
    }

    private ConfigDialog(Frame owner) {
        super(owner, ResourceManager.getLanguageDependentString("ConfigTitleLabel"), true);
        this.getContentPane().setLayout(new BorderLayout());
        ((JPanel)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.cardPanel = new JPanel(new CardLayout());
        this.cardPanel.setBorder(BorderFactory.createLineBorder(Color.ORANGE));
        this.getContentPane().add((Component)this.cardPanel, "Center");
        this.treeModel = this.createJaWETreeModel();
        this.paneTree = new JTree(this.treeModel);
        this.paneTree.setCellRenderer(new PaneNameRenderer());
        this.paneTree.putClientProperty("JTree.lineStyle", "Angled");
        this.paneTree.setShowsRootHandles(true);
        this.getContentPane().add((Component)new JScrollPane(this.paneTree, 20, 30), "West");
        JPanel buttonsPanel = new JPanel();
        this.okButton = new JButton(ResourceManager.getLanguageDependentString("OKKey"), new ImageIcon(ResourceManager.getResource("OKImage")));
        this.okButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton = new JButton(ResourceManager.getLanguageDependentString("CancelKey"), new ImageIcon(ResourceManager.getResource("CancelImage")));
        this.cancelButton.addActionListener(this);
        this.applyButton = new JButton(ResourceManager.getLanguageDependentString("ApplyKey"), new ImageIcon(ResourceManager.getResource("ApplyImage")));
        this.applyButton.addActionListener(this);
        this.restoreDefaultButton = new JButton(ResourceManager.getLanguageDependentString("RestoreDefaultKey"), new ImageIcon(ResourceManager.getResource("RestoreDefaultImage")));
        this.restoreDefaultButton.addActionListener(this);
        buttonsPanel.add(this.okButton);
        buttonsPanel.add(this.cancelButton);
        buttonsPanel.add(this.applyButton);
        buttonsPanel.add(Box.createHorizontalStrut(10));
        buttonsPanel.add(this.restoreDefaultButton);
        this.getContentPane().add((Component)buttonsPanel, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ConfigDialog.this.cancel();
            }
        });
        TreePath jawePath = new TreePath(new Object[]{this.treeModel.getRoot(), this.jaweOptionsRoot.getMember(0)});
        this.paneTree.setSelectionPath(jawePath);
        this.paneTree.getSelectionModel().addTreeSelectionListener(this);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0, false), "Cancel");
        this.getRootPane().getActionMap().put("Cancel", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ConfigDialog.this.cancel();
            }
        });
        Utils.center(this, 100, 250);
    }

    private OptionTreeModel createJaWETreeModel() {
        this.jaweOptionsRoot = new ConfigElements("JaWEConfiguration");
        OptionTreeModel jaweTreeModel = new OptionTreeModel(this.jaweOptionsRoot);
        this.addOptionPane(new CfgGeneral("General"), this.jaweOptionsRoot);
        this.addOptionPane(new CfgUI("UI"), this.jaweOptionsRoot);
        this.addOptionPane(new CfgLDAP("LDAP"), this.jaweOptionsRoot);
        this.addOptionPane(new CfgColors("Color"), this.jaweOptionsRoot);
        this.addOptionPane(new CfgObjectSize("Size"), this.jaweOptionsRoot);
        return jaweTreeModel;
    }

    private void addOptionPane(BaseConfigPane child, ConfigElements parent) {
        String name = child.getName();
        this.configsPanel = new JPanel(new BorderLayout());
        this.configsPanel.add(child.getComponent(), "North");
        this.cardPanel.add((Component)new JScrollPane(this.configsPanel, 20, 30), name);
        parent.addOptionPane(child);
    }

    private void cancel() {
        optionsDialog.setVisible(false);
    }

    private void ok(boolean close) {
        OptionTreeModel m = (OptionTreeModel)this.paneTree.getModel();
        ((ConfigElements)m.getRoot()).save();
        this.applyChanges();
        if (close) {
            optionsDialog.setVisible(false);
        }
    }

    private void applyChanges() {
        OptionTreeModel m = (OptionTreeModel)this.paneTree.getModel();
        ((ConfigElements)m.getRoot()).readConf();
        PackageEditor pe = JaWE.getInstance().getPackageEditor();
        pe.refreshEditorConfiguration();
        SwingUtilities.updateComponentTreeUI(ConfigDialog.getInstance());
        JaWE.getInstance().getPackageEditor().getPackageTreePanel().refreshPackageTreePanel();
        JaWEConfig.getInstance().saveConf();
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton) {
            this.ok(true);
        } else if (source == this.cancelButton) {
            this.cancel();
        } else if (source == this.applyButton) {
            this.ok(false);
        } else if (source == this.restoreDefaultButton) {
            JaWEConfig.getInstance().restoreDefaultSettings();
            this.applyChanges();
        }
    }

    public void valueChanged(TreeSelectionEvent evt) {
        int i;
        TreePath path = evt.getPath();
        if (path == null || !(path.getLastPathComponent() instanceof BaseConfigPane)) {
            return;
        }
        Object[] nodes = path.getPath();
        int lastIdx = nodes.length - 1;
        this.currPaneName = null;
        int n = i = this.paneTree.isRootVisible() ? 0 : 1;
        while (i <= lastIdx) {
            if (nodes[i] instanceof BaseConfigPane) {
                this.currPaneName = ((BaseConfigPane)nodes[i]).getName();
            } else if (nodes[i] instanceof ConfigElements) {
                this.currPaneName = ((ConfigElements)nodes[i]).getName();
            }
            ++i;
        }
        ((CardLayout)this.cardPanel.getLayout()).show(this.cardPanel, this.currPaneName);
    }

    public void refreshLanguageDependentStrings() {
        this.setTitle(ResourceManager.getLanguageDependentString("ConfigTitleLabel"));
        this.okButton.setText(ResourceManager.getLanguageDependentString("OKKey"));
        this.cancelButton.setText(ResourceManager.getLanguageDependentString("CancelKey"));
        this.applyButton.setText(ResourceManager.getLanguageDependentString("ApplyKey"));
        this.restoreDefaultButton.setText(ResourceManager.getLanguageDependentString("RestoreDefaultKey"));
        OptionTreeModel m = (OptionTreeModel)this.paneTree.getModel();
        ((ConfigElements)m.getRoot()).refreshLanguageDependentStrings();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class OptionTreeModel
    implements TreeModel {
        private ConfigElements root;
        private EventListenerList listenerList = new EventListenerList();

        public OptionTreeModel(ConfigElements root) {
            this.root = root;
        }

        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        public Object getRoot() {
            return this.root;
        }

        public int getIndexOfChild(Object parent, Object child) {
            if (parent instanceof ConfigElements) {
                return ((ConfigElements)parent).getMemberIndex(child);
            }
            return -1;
        }

        public Object getChild(Object parent, int index) {
            if (parent instanceof ConfigElements) {
                return ((ConfigElements)parent).getMember(index);
            }
            return null;
        }

        public void removeTreeModelListener(TreeModelListener l) {
            this.listenerList.remove(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = ConfigDialog.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener, l);
        }

        public int getChildCount(Object parent) {
            if (parent instanceof ConfigElements) {
                return ((ConfigElements)parent).getMemberCount();
            }
            return 0;
        }

        public boolean isLeaf(Object node) {
            return node instanceof BaseConfigPane;
        }

        public void addTreeModelListener(TreeModelListener l) {
            this.listenerList.add(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = ConfigDialog.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener, l);
        }
    }

    class PaneNameRenderer
    extends JLabel
    implements TreeCellRenderer {
        private Border noFocusBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        private Border focusBorder = BorderFactory.createLineBorder(Color.ORANGE);
        private Font paneFont;
        private Font rootFont;

        public PaneNameRenderer() {
            this.setOpaque(true);
            this.paneFont = UIManager.getFont("Tree.font");
            this.rootFont = new Font(this.paneFont.getName(), this.paneFont.getStyle() | 1, this.paneFont.getSize() + 1);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (selected) {
                this.setBackground(UIManager.getColor("Tree.selectionBackground"));
                this.setForeground(UIManager.getColor("Tree.selectionForeground"));
            } else {
                this.setBackground(tree.getBackground());
                this.setForeground(tree.getForeground());
            }
            String name = null;
            if (value instanceof ConfigElements) {
                name = ((ConfigElements)value).getName();
                this.setFont(this.rootFont);
            } else if (value instanceof BaseConfigPane) {
                name = ((BaseConfigPane)value).getName();
                this.setFont(this.paneFont);
            }
            if (name == null) {
                this.setText(null);
            } else {
                String label = ResourceManager.getLanguageDependentString("Config." + name + ".Label");
                if (label == null) {
                    this.setText(name);
                } else {
                    this.setText(label);
                }
            }
            this.setBorder(hasFocus ? this.focusBorder : this.noFocusBorder);
            return this;
        }
    }
}

