/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.config;

import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.enhydra.jawe.JaWEConfig;
import org.enhydra.jawe.config.BaseConfigPane;

public class CfgUI
extends BaseConfigPane {
    private JComboBox looknFeel;
    private JCheckBox tooltipStatus;
    private JCheckBox gridStatus;
    private JCheckBox statusBarStatus;
    private JCheckBox nameWrappingStatus;
    private JCheckBox wrappingStyleWordStatus;
    private JTextField txtGridSize;
    private JTextField txtFontSize;
    private String[] lnfNames = new String[]{"Metal", "Motif", "Windows", "Native"};
    private String[] lnfClassNames = new String[]{"javax.swing.plaf.metal.MetalLookAndFeel", "com.sun.java.swing.plaf.motif.MotifLookAndFeel", "com.sun.java.swing.plaf.windows.WindowsLookAndFeel", ""};

    public CfgUI(String name) {
        super(name);
        this.looknFeel = new JComboBox<String>(this.lnfNames);
        this.addComponent("Config.UI.LnF.Label", this.looknFeel);
        this.tooltipStatus = new JCheckBox();
        this.addComponent("Config.UI.Tooltip.Label", this.tooltipStatus);
        this.nameWrappingStatus = new JCheckBox();
        this.addComponent("Config.UI.NameWrapping.Label", this.nameWrappingStatus);
        this.wrappingStyleWordStatus = new JCheckBox();
        this.addComponent("Config.UI.WrappingStyleWord.Label", this.wrappingStyleWordStatus);
        this.gridStatus = new JCheckBox();
        this.addComponent("Config.UI.Grid.Label", this.gridStatus);
        this.statusBarStatus = new JCheckBox();
        this.addComponent("Config.UI.StatusBar.Label", this.statusBarStatus);
        this.txtGridSize = new JTextField();
        this.addComponent("Config.UI.GridSize.Label", this.txtGridSize);
        this.txtFontSize = new JTextField();
        this.addComponent("Config.UI.FontSize.Label", this.txtFontSize);
        this.readConf();
    }

    public void readConf() {
        this.looknFeel.setSelectedItem(this.lfClassNameToName());
        this.tooltipStatus.setSelected(JaWEConfig.getInstance().getTooltipStatus());
        this.nameWrappingStatus.setSelected(JaWEConfig.getInstance().getNameWrappingStatus());
        this.wrappingStyleWordStatus.setSelected(JaWEConfig.getInstance().getWrappingStyleWordStatus());
        this.gridStatus.setSelected(JaWEConfig.getInstance().getGridStatus());
        this.statusBarStatus.setSelected(JaWEConfig.getInstance().getStatusBarStatus());
        this.txtGridSize.setText(Integer.toString(JaWEConfig.getInstance().getGridSize()));
        this.txtFontSize.setText(Float.toString(JaWEConfig.getInstance().getFontSize()));
    }

    public void save() {
        JaWEConfig.getInstance().setLookAndFeelClassName(this.lfNameToClassName());
        JaWEConfig.getInstance().setTooltipStatus(this.tooltipStatus.isSelected());
        JaWEConfig.getInstance().setNameWrappingStatus(this.nameWrappingStatus.isSelected());
        JaWEConfig.getInstance().setWrappingStyleWordStatus(this.wrappingStyleWordStatus.isSelected());
        JaWEConfig.getInstance().setGridStatus(this.gridStatus.isSelected());
        JaWEConfig.getInstance().setStatusBarStatus(this.statusBarStatus.isSelected());
        JaWEConfig.getInstance().setGridSize(Integer.parseInt(this.txtGridSize.getText()));
        JaWEConfig.getInstance().setFontSize(Float.parseFloat(this.txtFontSize.getText()));
    }

    private String lfClassNameToName() {
        String lnfClassName = JaWEConfig.getInstance().getLookAndFeelClassName();
        for (int i = 0; i < 4; ++i) {
            if (!this.lnfClassNames[i].equals(lnfClassName)) continue;
            return this.lnfNames[i];
        }
        return this.lnfNames[3];
    }

    private String lfNameToClassName() {
        String lnfName = this.looknFeel.getSelectedItem().toString();
        for (int i = 0; i < 4; ++i) {
            if (!this.lnfNames[i].equals(lnfName)) continue;
            return this.lnfClassNames[i];
        }
        return this.lnfClassNames[3];
    }

    public Component getComponent() {
        return this;
    }
}

