/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.config;

import java.awt.Component;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.enhydra.jawe.JaWEConfig;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.Utils;
import org.enhydra.jawe.config.BaseConfigPane;
import org.enhydra.jawe.misc.PFLocale;

public class CfgGeneral
extends BaseConfigPane {
    private JTextField txtRecentList;
    private JTextField txtEncoding;
    private JComboBox startingLocale;
    private JComboBox conformanceClass;
    private JCheckBox validationStatus;
    private JCheckBox useBubblesStatus;
    private JCheckBox allowUndefinedStart;
    private JCheckBox allowUndefinedEnd;
    private JCheckBox fileLockingStatus;
    private String[] confClasses = new String[]{"", "FULL_BLOCKED", "LOOP_BLOCKED", "NON_BLOCKED"};

    public CfgGeneral(String name) {
        super(name);
        this.validationStatus = new JCheckBox();
        this.addComponent("Config.General.Validation.Label", this.validationStatus);
        this.useBubblesStatus = new JCheckBox();
        this.addComponent("Config.General.UseBubbles.Label", this.useBubblesStatus);
        this.allowUndefinedStart = new JCheckBox();
        this.addComponent("Config.General.AllowUndefinedStartActivity.Label", this.allowUndefinedStart);
        this.allowUndefinedEnd = new JCheckBox();
        this.addComponent("Config.General.AllowUndefinedEndActivity.Label", this.allowUndefinedEnd);
        this.startingLocale = new JComboBox();
        this.refillStartingLanguageCombo();
        this.addComponent("Config.General.StartingLanguage.Label", this.startingLocale);
        this.conformanceClass = new JComboBox();
        this.refillConformanceClassCombo();
        boolean mccst = JaWEConfig.getInstance().getMandatoryConformanceClassSettingStatus();
        if (mccst) {
            this.addComponent("Config.General.MandatoryConformanceClass.Label", this.conformanceClass);
        } else {
            this.conformanceClass.setVisible(false);
        }
        this.txtRecentList = new JTextField();
        this.addComponent("Config.General.RecentFileListSize.Label", this.txtRecentList);
        this.txtEncoding = new JTextField();
        this.addComponent("Config.General.Encoding.Label", this.txtEncoding);
        this.fileLockingStatus = new JCheckBox();
        this.addComponent("Config.General.FileLocking.Label", this.fileLockingStatus);
        this.readConf();
    }

    public void readConf() {
        this.validationStatus.setSelected(JaWEConfig.getInstance().getValidationStatus());
        this.useBubblesStatus.setSelected(JaWEConfig.getInstance().getUseBubblesStatus());
        this.allowUndefinedStart.setSelected(JaWEConfig.getInstance().getAllowUndefinedStartActivity());
        this.allowUndefinedEnd.setSelected(JaWEConfig.getInstance().getAllowUndefinedEndActivity());
        this.startingLocale.setSelectedItem(PFLocale.createPFLocale(JaWEConfig.getInstance().getStartingLocale()));
        this.txtRecentList.setText(Integer.toString(JaWEConfig.getInstance().getRecentFileListSize()));
        this.txtEncoding.setText(JaWEConfig.getInstance().getEncoding());
        this.conformanceClass.setSelectedItem(ResourceManager.getLanguageDependentString(JaWEConfig.getInstance().getMandatoryConformanceClass() + "Key"));
        this.fileLockingStatus.setSelected(JaWEConfig.getInstance().getFileLockingStatus());
    }

    public void save() {
        JaWEConfig.getInstance().setValidationStatus(this.validationStatus.isSelected());
        JaWEConfig.getInstance().setUseBubblesStatus(this.useBubblesStatus.isSelected());
        JaWEConfig.getInstance().setAllowUndefinedStartActivity(this.allowUndefinedStart.isSelected());
        JaWEConfig.getInstance().setAllowUndefinedEndActivity(this.allowUndefinedEnd.isSelected());
        Object selSl = this.startingLocale.getSelectedItem();
        if (selSl instanceof PFLocale) {
            JaWEConfig.getInstance().setStartingLocale(((PFLocale)selSl).getLocaleString());
        } else {
            JaWEConfig.getInstance().setStartingLocale("");
        }
        JaWEConfig.getInstance().setRecentFileListSize(Integer.parseInt(this.txtRecentList.getText()));
        JaWEConfig.getInstance().setEncoding(this.txtEncoding.getText());
        int si = this.conformanceClass.getSelectedIndex();
        if (si == -1) {
            si = 0;
        }
        JaWEConfig.getInstance().setMandatoryConformanceClass(this.confClasses[si]);
        JaWEConfig.getInstance().setFileLockingStatus(this.fileLockingStatus.isSelected());
    }

    public Component getComponent() {
        return this;
    }

    public void refreshLanguageDependentStrings() {
        super.refreshLanguageDependentStrings();
        this.refillConformanceClassCombo();
        this.refillStartingLanguageCombo();
    }

    private void refillConformanceClassCombo() {
        this.conformanceClass.removeAllItems();
        this.conformanceClass.addItem("");
        for (int i = 1; i < 4; ++i) {
            this.conformanceClass.addItem(ResourceManager.getLanguageDependentString(this.confClasses[i] + "Key"));
        }
    }

    private void refillStartingLanguageCombo() {
        this.startingLocale.removeAllItems();
        this.startingLocale.addItem("");
        List pfs = Utils.findPropertyFiles();
        for (int i = 0; i < pfs.size(); ++i) {
            this.startingLocale.addItem(pfs.get(i));
        }
    }
}

