/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.config;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.enhydra.jawe.ResourceManager;

public class BaseConfigPane
extends JPanel {
    private String name;
    protected int y = 0;
    protected GridBagLayout gridBag;
    protected Map componentToPropertyFileEntry = new HashMap();

    public BaseConfigPane(String name) {
        this.name = name;
        this.gridBag = new GridBagLayout();
        this.setLayout(this.gridBag);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    public String getName() {
        return this.name;
    }

    public Component getComponent() {
        return this;
    }

    protected void addComponent(String cfEntry, Component comp) {
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridy = this.y++;
        cons.gridx = 0;
        cons.gridheight = 1;
        cons.gridwidth = 1;
        cons.weightx = 1.0;
        cons.anchor = 13;
        cons.fill = 2;
        String label = ResourceManager.getLanguageDependentString(cfEntry) + ": ";
        JLabel l = new JLabel(label, 4);
        this.componentToPropertyFileEntry.put(l, cfEntry);
        this.gridBag.setConstraints(l, cons);
        this.add(l);
        cons.gridx = 1;
        this.gridBag.setConstraints(comp, cons);
        this.add(comp);
    }

    public void save() {
    }

    public void readConf() {
    }

    public void refreshLanguageDependentStrings() {
        Iterator it = this.componentToPropertyFileEntry.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            Component c = (Component)me.getKey();
            String cfe = (String)me.getValue();
            ((JLabel)c).setText(ResourceManager.getLanguageDependentString(cfe) + ": ");
        }
    }
}

